package examples.jsf.action.impl;

import java.util.List;

import examples.jsf.action.EmployeeEditInitAction;
import examples.jsf.common.Constants;
import examples.jsf.dto.EmployeeDto;
import examples.jsf.logic.EmployeeLogic;

public class EmployeeEditInitActionImpl implements EmployeeEditInitAction {

	private EmployeeLogic employeeLogic;

	private Integer empno;
	
	private int processMode;
	
	private EmployeeDto employeeDto;
	
	private List departmentDtoList;

	public void setEmployeeLogic(EmployeeLogic employeeLogic) {
		this.employeeLogic = employeeLogic;
	}
	
	public void setEmpno(Integer empno) {
		this.empno = empno;
	}
	
	public void setProcessMode(int processMode) {
		this.processMode = processMode;
	}
	
	public int getProcessMode() {
		return processMode;
	}
	
	public EmployeeDto getEmployeeDto() {
		return employeeDto;
	}
	
	public List getDepartmentDtoList() {
		return departmentDtoList;
	}

	public String initialize() {
		departmentDtoList = employeeLogic.getAllDepartments();
		if (processMode == Constants.UPDATE_MODE) {
			employeeDto = employeeLogic.getEmployeeDto(empno);
		} else if (processMode == Constants.CREATE_MODE) {
			employeeDto = new EmployeeDto();
		}
		return null;
	}
	
}