/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.jsp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.jsf.exception.NoHttpSessionRuntimeException;
import org.seasar.jsf.exception.UndefinedScopeRuntimeException;
import org.seasar.jsf.jsp.BodyContentImpl;
import org.seasar.jsf.jsp.JspWriterImpl;
import org.seasar.jsf.jsp.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext {
    private static Logger logger;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private boolean needsSession;
    private String errorPageURL;
    private boolean autoFlush;
    private int bufferSize;
    private Map attributes = new HashMap();
    private ServletRequest request;
    private ServletResponse response;
    private HttpSession session;
    private boolean included;
    private JspWriter out;
    private Stack bodyContentStack = new Stack();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.jsp.PageContextImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL) throws IllegalStateException, IllegalArgumentException, IOException {
        this.initialize(servlet, request, response, errorPageURL, true, 8192, true);
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.request = request;
        this.response = response;
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        this.out = new JspWriterImpl(response, bufferSize, autoFlush);
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", request);
        this.setAttribute("javax.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.included = request.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public void release() {
        try {
            if (this.included) {
                ((JspWriterImpl)this.out).flushBuffer();
            } else {
                this.out.flush();
            }
        }
        catch (IOException ex) {
            logger.log((Throwable)ex);
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.session = null;
        this.out = null;
        this.attributes.clear();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new NoHttpSessionRuntimeException();
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new UndefinedScopeRuntimeException(scope);
    }

    public void setAttribute(String name, Object attribute) {
        this.attributes.put(name, attribute);
    }

    public void setAttribute(String name, Object o, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.put(name, o);
                break;
            }
            case 2: {
                this.request.setAttribute(name, o);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new NoHttpSessionRuntimeException();
                }
                this.session.setAttribute(name, o);
                break;
            }
            case 4: {
                this.context.setAttribute(name, o);
                break;
            }
            default: {
                throw new UndefinedScopeRuntimeException(scope);
            }
        }
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new NoHttpSessionRuntimeException();
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                throw new UndefinedScopeRuntimeException(scope);
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String name) {
        Object o = this.getAttribute(name);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null && (o = this.session.getAttribute(name)) != null) {
            return o;
        }
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return new EnumerationAdapter(this.attributes.keySet().iterator());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session != null) {
                    return this.session.getAttributeNames();
                }
                throw new NoHttpSessionRuntimeException();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new UndefinedScopeRuntimeException(scope);
    }

    public void removeAttribute(String name) {
        try {
            this.removeAttribute(name, 1);
            this.removeAttribute(name, 2);
            if (this.session != null) {
                this.removeAttribute(name, 3);
            }
            this.removeAttribute(name, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public Object getPage() {
        return this.servlet;
    }

    public void include(String relativePath) throws ServletException, IOException {
        this.include(relativePath, true);
    }

    public void include(String relativePath, boolean flush) throws ServletException, IOException {
        String resourcePath = this.getContextRelativePath(relativePath);
        RequestDispatcher rd = this.request.getRequestDispatcher(resourcePath);
        rd.include(this.request, (ServletResponse)new ServletResponseWrapperInclude(this.response, this.out));
    }

    protected String getContextRelativePath(String relativePath) {
        if (relativePath.startsWith("/")) {
            return relativePath;
        }
        if (!(this.request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest req = (HttpServletRequest)this.request;
        String uri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
        if (uri == null) {
            uri = req.getServletPath();
        }
        return String.valueOf(uri.substring(0, uri.lastIndexOf(47))) + '/' + relativePath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forward(String relativePath) throws ServletException, IOException {
        block9: {
            try {
                this.out.clear();
            }
            catch (IOException ex) {
                ise = new IllegalStateException(ex.toString());
                ise.initCause(ex);
                throw ise;
            }
            while (true) {
                if (!(this.response instanceof ServletResponseWrapperInclude)) {
                    path = this.getContextRelativePath(relativePath);
                    includeUri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
                    if (includeUri != null) {
                        this.request.removeAttribute("javax.servlet.include.servlet_path");
                    }
                    ** try [egrp 1[TRYBLOCK] [1 : 94->120)] { 
lbl16:
                    // 1 sources

                    break;
                }
                this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
            }
            {
                this.context.getRequestDispatcher(path).forward(this.request, this.response);
            }
lbl21:
            // 1 sources

            catch (Throwable var5_6) {
                var4_7 = null;
                if (includeUri != null) {
                    this.request.setAttribute("javax.servlet.include.servlet_path", (Object)includeUri);
                }
                this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
                throw var5_6;
            }
            {
                var4_8 = null;
                if (includeUri == null) break block9;
            }
            this.request.setAttribute("javax.servlet.include.servlet_path", (Object)includeUri);
        }
        this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
    }

    public BodyContent pushBody() {
        BodyContentImpl bodyContent = new BodyContentImpl(this.out);
        this.bodyContentStack.push(bodyContent);
        this.out = bodyContent;
        return bodyContent;
    }

    public JspWriter popBody() {
        this.out = ((BodyContent)this.bodyContentStack.pop()).getEnclosingWriter();
        return this.out;
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.request.setAttribute("javax.servlet.jsp.jspException", (Object)t);
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof JspException) {
                Throwable rootCause = ((JspException)t).getRootCause();
                if (rootCause != null) {
                    throw new ServletException(t.getMessage(), rootCause);
                }
                throw new ServletException(t);
            }
            throw new ServletException(t);
        }
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return null;
    }

    public VariableResolver getVariableResolver() {
        return null;
    }

    public boolean isNeedsSession() {
        return this.needsSession;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

