/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.interceptor;

import java.lang.reflect.Field;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.FieldUtil;
import org.seasar.jsf.util.BindingUtil;

public class ActionBindingInterceptor
extends AbstractInterceptor {
    public static final String EXPORT_SUFFIX = "_EXPORT";
    public static final String SESSION = "session";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object ret;
        Class targetClass = this.getTargetClass(invocation);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)targetClass);
        S2Container container = SingletonS2ContainerFactory.getContainer();
        this.importVariables(invocation.getThis(), container, beanDesc);
        try {
            ret = invocation.proceed();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.exportVariables(invocation.getThis(), container, beanDesc);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.exportVariables(invocation.getThis(), container, beanDesc);
            return ret;
        }
    }

    protected void importVariables(Object component, S2Container container, BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            Object var;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.hasWriteMethod() && (var = BindingUtil.getValue(container.getRequest(), pd.getPropertyName())) != null) {
                pd.setValue(component, var);
            }
            ++i;
        }
    }

    protected void exportVariables(Object component, S2Container container, BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            Object var;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.hasReadMethod() && (var = pd.getValue(component)) != null) {
                Field field;
                String value;
                boolean useSession = false;
                String fieldName = String.valueOf(pd.getPropertyName()) + EXPORT_SUFFIX;
                if (beanDesc.hasField(fieldName) && SESSION.equalsIgnoreCase(value = (String)FieldUtil.get((Field)(field = beanDesc.getField(fieldName)), null))) {
                    useSession = true;
                }
                if (useSession) {
                    container.getSession().setAttribute(pd.getPropertyName(), var);
                } else {
                    container.getRequest().setAttribute(pd.getPropertyName(), var);
                }
            }
            ++i;
        }
    }
}

