/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import net.sourceforge.myfaces.config.MyfacesConfig;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.util.JavascriptUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HtmlRendererUtils {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$HtmlRendererUtils == null ? (class$net$sourceforge$myfaces$renderkit$html$HtmlRendererUtils = HtmlRendererUtils.class$("net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils")) : class$net$sourceforge$myfaces$renderkit$html$HtmlRendererUtils));
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_link_hidden_";
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$HtmlRendererUtils;

    private HtmlRendererUtils() {
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        }
    }

    public static void decodeUISelectBoolean(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String reqValue = (String)paramMap.get(clientId);
            if (reqValue != null && (reqValue.equalsIgnoreCase("on") || reqValue.equalsIgnoreCase("yes") || reqValue.equalsIgnoreCase("true"))) {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.TRUE);
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
            }
        } else if (((EditableValueHolder)component).getSubmittedValue() == null) {
            if (component instanceof HtmlSelectBooleanCheckbox) {
                if (!((HtmlSelectBooleanCheckbox)component).isDisabled() && !((HtmlSelectBooleanCheckbox)component).isReadonly()) {
                    ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
                }
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
            }
        }
    }

    public static void decodeUISelectMany(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        if (paramValuesMap.containsKey(clientId = component.getClientId(facesContext))) {
            String[] reqValues = (String[])paramValuesMap.get(clientId);
            ((EditableValueHolder)component).setSubmittedValue((Object)reqValues);
        } else if (((EditableValueHolder)component).getSubmittedValue() == null) {
            if (component instanceof HtmlSelectManyCheckbox) {
                if (!((HtmlSelectManyCheckbox)component).isDisabled() && !((HtmlSelectManyCheckbox)component).isReadonly()) {
                    ((EditableValueHolder)component).setSubmittedValue((Object)EMPTY_STRING_ARRAY);
                }
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)EMPTY_STRING_ARRAY);
            }
        }
    }

    public static void decodeUISelectOne(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        }
    }

    public static void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, size, false);
    }

    public static void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, size, true);
    }

    public static void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, 1, false);
    }

    public static void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, 1, true);
    }

    private static void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany) throws IOException {
        boolean lookupSubmittedValue;
        Set<Object> lookupSet;
        Converter converter;
        List selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", (Object)"true", null);
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
            try {
                converter = RendererUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent);
            }
            catch (FacesException e) {
                log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
                converter = null;
            }
        } else {
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent);
            try {
                converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)((UISelectOne)uiComponent));
            }
            catch (FacesException e) {
                log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
                converter = null;
            }
        }
        if (size == 0) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (selectMany) {
            lookupSet = RendererUtils.getSubmittedValuesAsSet((UISelectMany)uiComponent);
            if (lookupSet != null) {
                lookupSubmittedValue = true;
            } else {
                lookupSubmittedValue = false;
                lookupSet = RendererUtils.getSelectedValuesAsSet((UISelectMany)uiComponent);
            }
        } else {
            Object submittedValue = ((UISelectOne)uiComponent).getSubmittedValue();
            if (submittedValue != null) {
                lookupSubmittedValue = true;
                lookupSet = Collections.singleton(submittedValue);
            } else {
                lookupSubmittedValue = false;
                lookupSet = Collections.singleton(((UISelectOne)uiComponent).getValue());
            }
        }
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, lookupSubmittedValue, selectItemList);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    private static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, boolean lookupSubmittedValue, List selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        HashSet lookup = new HashSet(lookupSet.size());
        Iterator iterator = lookupSet.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (converter == null) {
                lookup.add(o);
                continue;
            }
            if (o == null) {
                lookup.add(null);
                continue;
            }
            lookup.add(converter.getAsString(context, component, o));
        }
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", null);
                writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptions(context, component, converter, lookupSet, lookupSubmittedValue, Arrays.asList(selectItems));
                writer.endElement("optgroup");
                continue;
            }
            Object itemValue = selectItem.getValue();
            String itemStrValue = HtmlRendererUtils.getItemStringValue(context, component, converter, selectItem);
            writer.write("\t\t");
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)itemStrValue, null);
            if (lookupSubmittedValue && lookup.contains(itemStrValue) || !lookupSubmittedValue && lookup.contains(itemStrValue)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            if (selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.endElement("option");
        }
    }

    private static String getItemStringValue(FacesContext context, UIComponent component, Converter converter, SelectItem selectItem) {
        Object itemValue = selectItem.getValue();
        if (converter == null) {
            if (itemValue == null) {
                return "";
            }
            if (itemValue instanceof String) {
                return (String)itemValue;
            }
            throw new IllegalArgumentException("Item value of SelectItem with label " + selectItem.getLabel() + " is no String and parent component " + component.getClientId(context) + " does not have a Converter");
        }
        return converter.getAsString(context, component, itemValue);
    }

    public static void writePrettyLineSeparator(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(LINE_SEPARATOR);
        }
    }

    public static void writePrettyIndent(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(9);
        }
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, String componentProperty, String attrName, Object value) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            String htmlAttrName = attrName.equals("styleClass") ? "class" : attrName;
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        Object value = component.getAttributes().get(componentProperty);
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
    }

    public static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static boolean renderHTMLAttributeWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String attrName, Object value, boolean startElementWritten) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderHTMLAttributesWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean startElementWritten = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderOptionalEndElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean endElementNeeded = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            endElementNeeded = true;
            break;
        }
        if (endElementNeeded) {
            writer.endElement(elementName);
            return true;
        }
        return false;
    }

    public static void renderHiddenCommandFormParams(ResponseWriter writer, Set dummyFormParams) throws IOException {
        Iterator it = dummyFormParams.iterator();
        while (it.hasNext()) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", it.next(), null);
            writer.endElement("input");
        }
    }

    public static void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n<!--");
        writer.write("\nfunction ");
        writer.write(functionName);
        writer.write("() {");
        if (dummyFormParams != null) {
            writer.write("\n  var f = document.forms['");
            writer.write(formName);
            writer.write("'];");
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                writer.write("\n  f.elements['");
                writer.write((String)it.next());
                writer.write("'].value=null;");
            }
        }
        writer.write("\n  f.target=");
        if (formTarget == null || formTarget.length() == 0) {
            writer.write("'';");
        } else {
            writer.write("'");
            writer.write(formTarget);
            writer.write("';");
        }
        writer.write("\n}");
        writer.write("\n");
        writer.write(functionName);
        writer.write("();");
        writer.write("\n//-->\n");
        writer.endElement("script");
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }

    public static String getFormName(UIComponent component, FacesContext context) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((UIForm)parent).getClientId(context);
        }
        return "linkDummyForm";
    }

    public static String getHiddenCommandLinkFieldName(String formName) {
        return formName + ':' + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LinkParameter {
        private String _name;
        private Object _value;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }
    }
}

