/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import net.sourceforge.myfaces.renderkit._SharedRendererUtils;
import net.sourceforge.myfaces.util.HashMapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RendererUtils {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$RendererUtils == null ? (class$net$sourceforge$myfaces$renderkit$RendererUtils = RendererUtils.class$("net.sourceforge.myfaces.renderkit.RendererUtils")) : class$net$sourceforge$myfaces$renderkit$RendererUtils));
    public static final String SELECT_ITEM_LIST_ATTR = (class$net$sourceforge$myfaces$renderkit$RendererUtils == null ? (class$net$sourceforge$myfaces$renderkit$RendererUtils = RendererUtils.class$("net.sourceforge.myfaces.renderkit.RendererUtils")) : class$net$sourceforge$myfaces$renderkit$RendererUtils).getName() + ".LIST";
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$RendererUtils;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof String) {
                return (String)submittedValue;
            }
            throw new IllegalArgumentException("Expected submitted value of type String");
        }
        Object value = ((ValueHolder)component).getValue();
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            try {
                converter = facesContext.getApplication().createConverter(value.getClass());
            }
            catch (FacesException e) {
                log.error((Object)("No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ")."));
            }
        }
        if (converter == null) {
            if (value == null) {
                return "";
            }
            return value.toString();
        }
        return converter.getAsString(facesContext, component, value);
    }

    public static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == -128;
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == Short.MIN_VALUE;
            }
        }
        return false;
    }

    public static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) throws FacesException {
        return _SharedRendererUtils.findUIOutputConverter(facesContext, component);
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component) {
        Class<?> arrayComponentType;
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if ((class$java$util$List == null ? (class$java$util$List = RendererUtils.class$("java.util.List")) : class$java$util$List).isAssignableFrom(valueType)) {
            return null;
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = RendererUtils.class$("java.lang.String")) : class$java$lang$String).equals(arrayComponentType = valueType.getComponentType())) {
            return null;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = RendererUtils.class$("java.lang.Object")) : class$java$lang$Object).equals(arrayComponentType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.error((Object)("No Converter for type " + arrayComponentType.getName() + " found"), (Throwable)e);
            return null;
        }
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent is instanceof " + uiComponent.getClass().getName() + " and not of " + compClass.getName() + " as it should be");
        }
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RendererUtils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            RendererUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static List getSelectItemList(UISelectOne uiSelectOne) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectOne);
    }

    public static List getSelectItemList(UISelectMany uiSelectMany) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectMany);
    }

    private static List internalGetSelectItemList(UIComponent uiComponent) {
        ArrayList<Object> list = new ArrayList<Object>(uiComponent.getChildCount());
        Iterator children = uiComponent.getChildren().iterator();
        while (children.hasNext()) {
            Object value;
            UIComponent child = (UIComponent)children.next();
            if (child instanceof UISelectItem) {
                value = ((UISelectItem)child).getValue();
                if (value != null) {
                    if (!(value instanceof SelectItem)) {
                        FacesContext facesContext = FacesContext.getCurrentInstance();
                        throw new IllegalArgumentException("Value binding of UISelectItem with id " + child.getClientId(facesContext) + " does not reference an Object of type SelectItem");
                    }
                    list.add(value);
                    continue;
                }
                Object itemValue = ((UISelectItem)child).getItemValue();
                String label = ((UISelectItem)child).getItemLabel();
                String description = ((UISelectItem)child).getItemDescription();
                boolean disabled = ((UISelectItem)child).isItemDisabled();
                if (label == null) {
                    list.add(new SelectItem(itemValue, itemValue.toString(), description, disabled));
                    continue;
                }
                list.add(new SelectItem(itemValue, label, description, disabled));
                continue;
            }
            if (child instanceof UISelectItems) {
                value = ((UISelectItems)child).getValue();
                if (value instanceof SelectItem) {
                    list.add(value);
                    continue;
                }
                if (value instanceof SelectItem[]) {
                    for (int i = 0; i < ((SelectItem[])value).length; ++i) {
                        list.add(((SelectItem[])value)[i]);
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    Iterator it = ((Collection)value).iterator();
                    while (it.hasNext()) {
                        Object item = it.next();
                        if (!(item instanceof SelectItem)) {
                            FacesContext facesContext = FacesContext.getCurrentInstance();
                            throw new IllegalArgumentException("Collection referenced by UISelectItems with id " + child.getClientId(facesContext) + " does not contain Objects of type SelectItem");
                        }
                        list.add(item);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    Iterator it = ((Map)value).entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        list.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                    }
                    continue;
                }
                FacesContext facesContext = FacesContext.getCurrentInstance();
                throw new IllegalArgumentException("Value binding of UISelectItems with id " + child.getClientId(facesContext) + " does not reference an Object of type SelectItem, SelectItem[], Collection or Map but of type : " + (value == null ? null : value.getClass().getName()));
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            log.error((Object)("Invalid child with id " + child.getClientId(facesContext) + "of component with id : " + uiComponent.getClientId(facesContext) + " : must be UISelectItem or UISelectItems, is of type : " + (child == null ? "null" : child.getClass().getName())));
        }
        return list;
    }

    public static Set getSubmittedValuesAsSet(UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        try {
            return RendererUtils.internalSubmittedOrSelectedValuesAsSet(uiSelectMany, submittedValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Submitted value of UISelectMany component with id " + uiSelectMany.getClientId(FacesContext.getCurrentInstance()) + " is not of type Array or List");
        }
    }

    public static Set getSelectedValuesAsSet(UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        if (selectedValues == null) {
            return Collections.EMPTY_SET;
        }
        try {
            return RendererUtils.internalSubmittedOrSelectedValuesAsSet(uiSelectMany, selectedValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Value of UISelectMany component with id " + uiSelectMany.getClientId(FacesContext.getCurrentInstance()) + " is not of type Array or List");
        }
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(UISelectMany uiSelectMany, Object values) {
        if (values == null) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<Object> set = new HashSet<Object>(HashMapUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(ar[i]);
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(HashMapUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(Array.get(values, i));
            }
            return set;
        }
        if (values instanceof List) {
            List lst = (List)values;
            if (lst.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet set = new HashSet(HashMapUtils.calcCapacity(lst.size()));
            set.addAll(lst);
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component with id " + uiSelectMany.getClientId(FacesContext.getCurrentInstance()) + " is not of type Array or List");
    }

    public static Object getConvertedUIOutputValue(FacesContext facesContext, UIOutput output, Object submittedValue) throws ConverterException {
        Converter converter;
        if (!(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException((Throwable)e);
        }
        if (converter == null) {
            return submittedValue;
        }
        return converter.getAsObject(facesContext, (UIComponent)output, (String)submittedValue);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] expected");
        }
        return _SharedRendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, (String[])submittedValue);
    }

    public static boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
        Boolean b = (Boolean)component.getAttributes().get(attrName);
        return b != null ? b : defaultValue;
    }

    public static int getIntegerAttribute(UIComponent component, String attrName, int defaultValue) {
        Integer i = (Integer)component.getAttributes().get(attrName);
        return i != null ? i : defaultValue;
    }

    public static UIForm findParentForm(UIComponentBase comp) {
        for (UIComponent parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            return (UIForm)parent;
        }
        return null;
    }

    public static void copyHtmlInputTextAttributes(HtmlInputText src, HtmlInputText dest) {
        dest.setId(src.getId());
        dest.setImmediate(src.isImmediate());
        dest.setTransient(src.isTransient());
        dest.setAccesskey(src.getAccesskey());
        dest.setAlt(src.getAlt());
        dest.setConverter(src.getConverter());
        dest.setDir(src.getDir());
        dest.setDisabled(src.isDisabled());
        dest.setLang(src.getLang());
        dest.setLocalValueSet(src.isLocalValueSet());
        dest.setMaxlength(src.getMaxlength());
        dest.setOnblur(src.getOnblur());
        dest.setOnchange(src.getOnchange());
        dest.setOnclick(src.getOnclick());
        dest.setOndblclick(src.getOndblclick());
        dest.setOnfocus(src.getOnfocus());
        dest.setOnkeydown(src.getOnkeydown());
        dest.setOnkeypress(src.getOnkeypress());
        dest.setOnkeyup(src.getOnkeyup());
        dest.setOnmousedown(src.getOnmousedown());
        dest.setOnmousemove(src.getOnmousemove());
        dest.setOnmouseout(src.getOnmouseout());
        dest.setOnmouseover(src.getOnmouseover());
        dest.setOnmouseup(src.getOnmouseup());
        dest.setOnselect(src.getOnselect());
        dest.setReadonly(src.isReadonly());
        dest.setRendered(src.isRendered());
        dest.setRequired(src.isRequired());
        dest.setSize(src.getSize());
        dest.setStyle(src.getStyle());
        dest.setStyleClass(src.getStyleClass());
        dest.setTabindex(src.getTabindex());
        dest.setTitle(src.getTitle());
        dest.setValidator(src.getValidator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

