/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.component;

import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import net.sourceforge.myfaces.component.UserRoleAware;

public class UserRoleUtils {
    public static boolean isVisibleOnUserRole(UIComponent component) {
        String userRole = component instanceof UserRoleAware ? ((UserRoleAware)component).getVisibleOnUserRole() : (String)component.getAttributes().get("visibleOnUserRole");
        if (userRole == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringTokenizer st = new StringTokenizer(userRole, ",");
        while (st.hasMoreTokens()) {
            if (!facesContext.getExternalContext().isUserInRole(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnabledOnUserRole(UIComponent component) {
        String userRole = component instanceof UserRoleAware ? ((UserRoleAware)component).getEnabledOnUserRole() : (String)component.getAttributes().get("enabledOnUserRole");
        if (userRole == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringTokenizer st = new StringTokenizer(userRole, ",");
        while (st.hasMoreTokens()) {
            if (!facesContext.getExternalContext().isUserInRole(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }
}

