/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.sql.Date;
import org.hsqldb.store.BaseHashMap;

public class ValuePoolHashMap
extends BaseHashMap {
    public ValuePoolHashMap(int n, int n2, int n3) throws IllegalArgumentException {
        super(n, 1.0f, 3, 0);
        this.accessTable = new int[n];
        this.maxCapacity = n2;
        this.purgePolicy = n3;
    }

    public void resetCapacity(int n, int n2) throws IllegalArgumentException {
        if (this.hashIndex.elementCount > n) {
            int n3 = 128 + this.hashIndex.elementCount - n;
            if (n3 > this.hashIndex.elementCount) {
                n3 = this.hashIndex.elementCount;
            }
            this.clear(n3);
        }
        if (n < this.threshold) {
            this.rehash(n);
        }
        this.maxCapacity = n;
        this.purgePolicy = n2;
    }

    protected Integer getOrAddInteger(int n) {
        Integer n2;
        int n3 = this.hashIndex.getHashIndex(n);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        while (n4 >= 0) {
            n2 = (Integer)this.objectKeyTable[n4];
            if (n2 == n) {
                ++this.accessCount;
                return n2;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(n);
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        n2 = new Integer(n);
        this.objectKeyTable[n4] = n2;
        ++this.accessCount;
        return n2;
    }

    protected Long getOrAddLong(long l) {
        Long l2;
        int n = this.hashIndex.getHashIndex((int)(l ^ l >>> 32));
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            l2 = (Long)this.objectKeyTable[n2];
            if (l2 == l) {
                ++this.accessCount;
                return l2;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(l);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        l2 = new Long(l);
        this.objectKeyTable[n2] = l2;
        ++this.accessCount;
        return l2;
    }

    protected String getOrAddString(Object object) {
        String string;
        int n = this.hashIndex.getHashIndex(object.hashCode());
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            string = (String)this.objectKeyTable[n2];
            if (object.equals(string)) {
                ++this.accessCount;
                return string;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(object);
        }
        string = object.toString();
        n2 = this.hashIndex.linkNode(n, n3);
        this.objectKeyTable[n2] = string;
        ++this.accessCount;
        return string;
    }

    protected Date getOrAddDate(long l) {
        Date date;
        int n = (int)l ^ (int)(l >>> 32);
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            date = (Date)this.objectKeyTable[n3];
            if (date.getTime() == l) {
                ++this.accessCount;
                return date;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(l);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        date = new Date(l);
        this.objectKeyTable[n3] = date;
        ++this.accessCount;
        return date;
    }

    protected Double getOrAddDouble(long l) {
        Double d;
        int n = this.hashIndex.getHashIndex((int)(l ^ l >>> 32));
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            d = (Double)this.objectKeyTable[n2];
            if (Double.doubleToLongBits(d) == l) {
                ++this.accessCount;
                return d;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(l);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        d = new Double(Double.longBitsToDouble(l));
        this.objectKeyTable[n2] = d;
        ++this.accessCount;
        return d;
    }

    protected Object getOrAddObject(Object object) {
        int n = this.hashIndex.getHashIndex(object.hashCode());
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            Object object2 = this.objectKeyTable[n2];
            if (object2.equals(object)) {
                ++this.accessCount;
                return object2;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(object);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        this.objectKeyTable[n2] = object;
        ++this.accessCount;
        return object;
    }
}

