/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.seasar.jsf.component.UIElement;
import org.seasar.jsf.util.BindingUtil;
import org.seasar.jsf.util.RenderUtil;

public class HtmlElementRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!(component instanceof UIElement)) {
            throw new IllegalArgumentException("not UIElementNode");
        }
        String tagName = ((UIElement)component).getTagName();
        writer.startElement(tagName, component);
        this.renderAttributes(writer, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement(((UIElement)component).getTagName());
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        RenderUtil.encodeChildren(context, component);
    }

    protected void renderAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        UIElement elem = (UIElement)component;
        Map attrs = component.getAttributes();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (attrName.indexOf(46) > 0) continue;
            Object value = this.getValue(component, attrName);
            this.renderAttribute(writer, attrName, value, attrName);
        }
        String[] bindingPropertyNames = elem.getBindingPropertyNames();
        int i2 = 0;
        while (i2 < bindingPropertyNames.length) {
            String name = bindingPropertyNames[i2];
            Object value = BindingUtil.getBindingValue(component, name);
            this.renderAttribute(writer, name, value, name);
            ++i2;
        }
    }

    protected Object getValue(UIComponent component, String propertyName) {
        Object value = component.getAttributes().get(propertyName);
        if (value != null) {
            return value;
        }
        return BindingUtil.getBindingValue(component, propertyName);
    }

    protected void renderAttribute(ResponseWriter writer, String attributeName, Object value, String propertyName) throws IOException {
        if (value == null) {
            return;
        }
        if (attributeName.equalsIgnoreCase("styleClass")) {
            attributeName = "class";
        }
        writer.writeAttribute(attributeName, value, propertyName);
    }
}

