/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;

public class SLinkedList
implements Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    private transient Entry header_ = new Entry(null, null, null);
    private transient int size_ = 0;

    public SLinkedList() {
        Entry entry = this.header_;
        this.header_._previous = entry;
        this.header_._next = entry;
    }

    public Entry getFirstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header_._next;
    }

    public Object getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFirstEntry()._element;
    }

    public Entry getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header_._previous;
    }

    public Object getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLastEntry()._element;
    }

    public Object removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object first = this.header_._next._element;
        this.header_._next.remove();
        return first;
    }

    public Object removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object last = this.header_._previous._element;
        this.header_._previous.remove();
        return last;
    }

    public void addFirst(Object o) {
        this.header_._next.addBefore(o);
    }

    public void addLast(Object o) {
        this.header_.addBefore(o);
    }

    public void add(int index, Object element) {
        this.getEntry(index).addBefore(element);
    }

    public int size() {
        return this.size_;
    }

    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this.header_._next;
            while (e != this.header_) {
                if (e._element == null) {
                    e.remove();
                    return true;
                }
                e = e._next;
            }
        } else {
            Entry e = this.header_._next;
            while (e != this.header_) {
                if (o.equals(e._element)) {
                    e.remove();
                    return true;
                }
                e = e._next;
            }
        }
        return false;
    }

    public Object remove(int index) {
        Entry e = this.getEntry(index);
        e.remove();
        return e._element;
    }

    public void clear() {
        Entry entry = this.header_;
        this.header_._previous = entry;
        this.header_._next = entry;
        this.size_ = 0;
    }

    public Entry getEntry(int index) {
        if (index < 0 || index >= this.size_) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size_);
        }
        Entry e = this.header_;
        if (index < this.size_ / 2) {
            int i = 0;
            while (i <= index) {
                e = e._next;
                ++i;
            }
        } else {
            int i = this.size_;
            while (i > index) {
                e = e._previous;
                --i;
            }
        }
        return e;
    }

    public Object get(int index) {
        return this.getEntry(index)._element;
    }

    public Object set(int index, Object element) {
        Entry e = this.getEntry(index);
        Object oldVal = e._element;
        e._element = element;
        return oldVal;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.header_._next;
            while (e != this.header_) {
                if (e._element == null) {
                    return index;
                }
                ++index;
                e = e._next;
            }
        } else {
            Entry e = this.header_._next;
            while (e != this.header_) {
                if (o.equals(e._element)) {
                    return index;
                }
                ++index;
                e = e._next;
            }
        }
        return -1;
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeInt(this.size_);
        Entry e = this.header_._next;
        while (e != this.header_) {
            s.writeObject(e._element);
            e = e._next;
        }
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        Entry entry = this.header_ = new Entry(null, null, null);
        this.header_._previous = entry;
        this.header_._next = entry;
        int i = 0;
        while (i < size) {
            this.addLast(s.readObject());
            ++i;
        }
    }

    public Object clone() {
        SLinkedList copy = new SLinkedList();
        Entry e = this.header_._next;
        while (e != this.header_) {
            copy.addLast(e._element);
            e = e._next;
        }
        return copy;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size_];
        int i = 0;
        Entry e = this.header_._next;
        while (e != this.header_) {
            result[i++] = e._element;
            e = e._next;
        }
        return result;
    }

    public final class Entry {
        private Object _element;
        private Entry _next;
        private Entry _previous;

        Entry(Object element, Entry next, Entry previous) {
            this._element = element;
            this._next = next;
            this._previous = previous;
        }

        public Object getElement() {
            return this._element;
        }

        public Entry getNext() {
            if (this._next != SLinkedList.this.header_) {
                return this._next;
            }
            return null;
        }

        public Entry getPrevious() {
            if (this._previous != SLinkedList.this.header_) {
                return this._previous;
            }
            return null;
        }

        public void remove() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            SLinkedList sLinkedList = SLinkedList.this;
            sLinkedList.size_ = sLinkedList.size_ - 1;
        }

        public Entry addBefore(Object o) {
            Entry newEntry;
            this._previous._next = newEntry = new Entry(o, this, this._previous);
            this._previous = newEntry;
            SLinkedList sLinkedList = SLinkedList.this;
            sLinkedList.size_ = sLinkedList.size_ + 1;
            return newEntry;
        }
    }
}

