/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta.xa;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    static final long serialVersionUID = 1L;
    private static final int FORMAT_ID = 4360;
    private static final byte[] INITIAL_BRANCH_ID = XidImpl.convert64bytes(new byte[0]);
    private static final String GLOBAL_ID_BASE = String.valueOf(System.currentTimeMillis()) + "/";
    private static int nextId_ = 0;
    private int hashCode_;
    private byte[] globalId_;
    private byte[] branchId_;

    public XidImpl() {
        this.hashCode_ = XidImpl.getNextId();
        this.globalId_ = this.createGlobalId();
        this.branchId_ = INITIAL_BRANCH_ID;
    }

    public XidImpl(Xid xid, int branchId) {
        this.hashCode_ = xid.hashCode();
        this.globalId_ = xid.getGlobalTransactionId();
        this.branchId_ = XidImpl.convert64bytes(Integer.toString(branchId).getBytes());
    }

    private byte[] createGlobalId() {
        return XidImpl.convert64bytes((String.valueOf(GLOBAL_ID_BASE) + Integer.toString(this.hashCode_)).getBytes());
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId_.clone();
    }

    public byte[] getBranchQualifier() {
        return (byte[])this.branchId_.clone();
    }

    public int getFormatId() {
        return 4360;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)obj;
        if (this.hashCode_ != other.hashCode_) {
            return false;
        }
        if (this.globalId_.length != other.globalId_.length || this.branchId_.length != other.branchId_.length) {
            return false;
        }
        int i = 0;
        while (i < this.globalId_.length) {
            if (this.globalId_[i] != other.globalId_[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.branchId_.length) {
            if (this.branchId_[i] != other.branchId_[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode_;
    }

    public String toString() {
        return "[FormatId=4360, GlobalId=" + new String(this.globalId_).trim() + ", BranchId=" + new String(this.branchId_).trim() + "]";
    }

    private static byte[] convert64bytes(byte[] bytes) {
        byte[] new64bytes = new byte[64];
        System.arraycopy(bytes, 0, new64bytes, 0, bytes.length);
        return new64bytes;
    }

    private static synchronized int getNextId() {
        return nextId_++;
    }
}

