/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.seasar.extension.dbcp.DBXAResource;
import org.seasar.extension.jta.xa.DefaultXAResource;
import org.seasar.framework.exception.SXAException;

public class DBXAResourceImpl
extends DefaultXAResource
implements DBXAResource {
    private Connection connection_;

    public DBXAResourceImpl(Connection connection) {
        this.connection_ = connection;
    }

    public Connection getConnection() {
        return this.connection_;
    }

    protected void doBegin(Xid xid) throws XAException {
        try {
            if (this.connection_.getAutoCommit()) {
                this.connection_.setAutoCommit(false);
            }
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }

    protected void doCommit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.connection_.commit();
            this.connection_.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }

    protected int doPrepare(Xid xid) throws XAException {
        try {
            if (this.connection_.isClosed()) {
                return 3;
            }
            return 0;
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }

    protected void doRollback(Xid xid) throws XAException {
        try {
            this.connection_.rollback();
            this.connection_.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }
}

