/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlCheckboxRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$HtmlCheckboxRendererBase == null ? (class$net$sourceforge$myfaces$renderkit$html$HtmlCheckboxRendererBase = HtmlCheckboxRendererBase.class$("net.sourceforge.myfaces.renderkit.html.HtmlCheckboxRendererBase")) : class$net$sourceforge$myfaces$renderkit$html$HtmlCheckboxRendererBase));
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String EXTERNAL_TRUE_VALUE = "true";
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$HtmlCheckboxRendererBase;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectBoolean) {
            this.renderCheckbox(facesContext, uiComponent, EXTERNAL_TRUE_VALUE, null, ((UISelectBoolean)uiComponent).isSelected(), true);
        } else if (uiComponent instanceof UISelectMany) {
            this.renderCheckboxList(facesContext, (UISelectMany)uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        Converter converter;
        String layout = this.getLayout(selectMany);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = selectMany.getClientId(facesContext);
        writer.startElement("table", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.writeAttribute("id", (Object)clientId, null);
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectMany);
        }
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, selectMany);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + selectMany.getClientId(facesContext)));
            converter = null;
        }
        Set lookupSet = RendererUtils.getSelectedValuesAsSet(selectMany);
        Iterator it = RendererUtils.getSelectItemList(selectMany).iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            Object itemValue = selectItem.getValue();
            String itemStrValue = converter == null ? itemValue.toString() : converter.getAsString(facesContext, (UIComponent)selectMany, itemValue);
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.startElement("label", (UIComponent)selectMany);
            this.renderCheckbox(facesContext, (UIComponent)selectMany, itemStrValue, selectItem.getLabel(), lookupSet.contains(itemValue), false);
            writer.endElement("label");
            writer.endElement("td");
            if (!pageDirectionLayout) continue;
            writer.endElement("tr");
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UISelectMany selectMany) {
        if (selectMany instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)selectMany).getLayout();
        }
        return (String)selectMany.getAttributes().get("layout");
    }

    protected void renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean checked, boolean renderId) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.writeText((Object)"", null);
        if (label != null && label.length() > 0) {
            writer.write("&nbsp;");
            writer.writeText((Object)label, null);
        }
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectBooleanCheckbox) {
            return ((HtmlSelectBooleanCheckbox)uiComponent).isDisabled();
        }
        if (uiComponent instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectBoolean) {
            HtmlRendererUtils.decodeUISelectBoolean(facesContext, uiComponent);
        } else if (uiComponent instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectBoolean) {
            return submittedValue;
        }
        if (uiComponent instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)uiComponent, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

