/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.tree.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sourceforge.myfaces.custom.tree.HtmlTree;
import net.sourceforge.myfaces.custom.tree.HtmlTreeImageCommandLink;
import net.sourceforge.myfaces.custom.tree.HtmlTreeNode;
import net.sourceforge.myfaces.custom.tree.IconProvider;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlTreeRenderer
extends HtmlRenderer {
    private static final Integer ZERO = new Integer(0);
    static /* synthetic */ Class class$net$sourceforge$myfaces$custom$tree$HtmlTree;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, class$net$sourceforge$myfaces$custom$tree$HtmlTree == null ? (class$net$sourceforge$myfaces$custom$tree$HtmlTree = HtmlTreeRenderer.class$("net.sourceforge.myfaces.custom.tree.HtmlTree")) : class$net$sourceforge$myfaces$custom$tree$HtmlTree);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlTree tree = (HtmlTree)component;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)tree, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.writeAttribute("border", (Object)ZERO, null);
        writer.writeAttribute("cellspacing", (Object)ZERO, null);
        writer.writeAttribute("cellpadding", (Object)ZERO, null);
        int maxLevel = tree.getRootNode().getMaxChildLevel();
        ArrayList<HtmlTreeNode> childNodes = new ArrayList<HtmlTreeNode>(1);
        childNodes.add(tree.getRootNode());
        this.renderChildren(facesContext, writer, tree, childNodes, maxLevel, tree.getIconProvider());
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("table");
        super.encodeEnd(facesContext, component);
    }

    protected void renderChildren(FacesContext facesContext, ResponseWriter writer, HtmlTree tree, List children, int maxLevel, IconProvider iconProvider) throws IOException {
        String iconClass = tree.getIconClass();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)it.next());
            if (!child.isRendered()) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", null);
            int[] layout = child.getLayout();
            for (int i = 0; i < layout.length - 1; ++i) {
                int state = layout[i];
                writer.startElement("td", null);
                String url = this.getLayoutImage(tree, state);
                if (url != null && url.length() > 0) {
                    String src;
                    writer.startElement("img", (UIComponent)child);
                    if (url.startsWith("/")) {
                        String path = facesContext.getExternalContext().getRequestContextPath();
                        src = path + url;
                    } else {
                        src = url;
                    }
                    src = facesContext.getExternalContext().encodeResourceURL(src);
                    writer.writeAttribute("src", (Object)src, null);
                    writer.writeAttribute("border", (Object)ZERO, null);
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)child, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
                    writer.endElement("img");
                }
                writer.endElement("td");
            }
            writer.startElement("td", null);
            int state = layout[layout.length - 1];
            String url = this.getLayoutImage(tree, state);
            if (state == 20 || state == 21 || state == 23 || state == 22) {
                this.writeImageElement(url, facesContext, writer, child);
            } else {
                HtmlTreeImageCommandLink expandCollapse = child.getExpandCollapseCommand(facesContext);
                expandCollapse.setImage(this.getLayoutImage(tree, layout[layout.length - 1]));
                expandCollapse.encodeBegin(facesContext);
                expandCollapse.encodeEnd(facesContext);
            }
            writer.endElement("td");
            int labelColSpan = maxLevel - child.getLevel() + 1;
            url = iconProvider != null ? iconProvider.getIconUrl(child.getUserObject(), child.getChildCount(), child.isLeaf(facesContext)) : (!child.isLeaf(facesContext) ? "images/tree/folder.gif" : null);
            if (url != null && url.length() > 0) {
                writer.startElement("td", null);
                if (iconClass != null) {
                    writer.writeAttribute("class", (Object)iconClass, null);
                }
                this.writeImageElement(url, facesContext, writer, child);
                writer.endElement("td");
            } else {
                ++labelColSpan;
            }
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)new Integer(labelColSpan), null);
            if (child.isSelected() && tree.getSelectedNodeClass() != null) {
                writer.writeAttribute("class", (Object)tree.getSelectedNodeClass(), null);
            } else if (!child.isSelected() && tree.getNodeClass() != null) {
                writer.writeAttribute("class", (Object)tree.getNodeClass(), null);
            }
            child.encodeBegin(facesContext);
            child.encodeEnd(facesContext);
            writer.endElement("td");
            writer.endElement("tr");
            if (child.getChildCount() <= 0) continue;
            this.renderChildren(facesContext, writer, tree, child.getChildren(), maxLevel, iconProvider);
        }
    }

    private void writeImageElement(String url, FacesContext facesContext, ResponseWriter writer, HtmlTreeNode child) throws IOException {
        writer.startElement("img", (UIComponent)child);
        String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
        writer.writeAttribute("src", (Object)src, null);
        writer.writeAttribute("border", (Object)ZERO, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)child, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    protected String getLayoutImage(HtmlTree tree, int state) {
        switch (state) {
            case 0: {
                return tree.getIconNodeOpenMiddle();
            }
            case 1: {
                return tree.getIconNodeOpenFirst();
            }
            case 2: {
                return tree.getIconNodeOpenLast();
            }
            case 3: {
                return tree.getIconNodeOpen();
            }
            case 10: {
                return tree.getIconNodeCloseMiddle();
            }
            case 11: {
                return tree.getIconNodeCloseFirst();
            }
            case 12: {
                return tree.getIconNodeCloseLast();
            }
            case 13: {
                return tree.getIconNodeClose();
            }
            case 20: {
                return tree.getIconChildMiddle();
            }
            case 21: {
                return tree.getIconChildFirst();
            }
            case 22: {
                return tree.getIconChildLast();
            }
            case 23: {
                return tree.getIconChild();
            }
            case 30: {
                return tree.getIconLine();
            }
            case 40: {
                return tree.getIconNoline();
            }
        }
        return tree.getIconNoline();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

