/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.tree;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import net.sourceforge.myfaces.component.html.ext.HtmlPanelGroup;
import net.sourceforge.myfaces.custom.tree.HtmlTreeNode;
import net.sourceforge.myfaces.custom.tree.IconProvider;
import net.sourceforge.myfaces.custom.tree.event.TreeSelectionEvent;
import net.sourceforge.myfaces.custom.tree.event.TreeSelectionListener;
import net.sourceforge.myfaces.custom.tree.model.TreeModel;
import net.sourceforge.myfaces.custom.tree.model.TreeModelEvent;
import net.sourceforge.myfaces.custom.tree.model.TreeModelListener;
import net.sourceforge.myfaces.custom.tree.model.TreePath;

public class HtmlTree
extends HtmlPanelGroup
implements TreeModelListener {
    public static final int DEFAULT_EXPIRE_LISTENERS = 28800000;
    private static final String FACET_ROOTNODE = "rootNode";
    private static final String PREVIOUS_VIEW_ROOT = (class$net$sourceforge$myfaces$custom$tree$HtmlTree == null ? (class$net$sourceforge$myfaces$custom$tree$HtmlTree = HtmlTree.class$("net.sourceforge.myfaces.custom.tree.HtmlTree")) : class$net$sourceforge$myfaces$custom$tree$HtmlTree).getName() + ".PREVIOUS_VIEW_ROOT";
    private static final int EVENT_CHANGED = 0;
    private static final int EVENT_INSERTED = 1;
    private static final int EVENT_REMOVED = 2;
    private static final int EVENT_STRUCTURE_CHANGED = 3;
    private static int counter = 0;
    private IconProvider iconProvider;
    private boolean itemStatesRestored = false;
    private String styleClass;
    private String nodeClass;
    private String selectedNodeClass;
    private String iconClass;
    private String iconLine = "images/tree/line.gif";
    private String iconNoline = "images/tree/noline.gif";
    private String iconChild = "images/tree/noline.gif";
    private String iconChildFirst = "images/tree/line_first.gif";
    private String iconChildMiddle = "images/tree/line_middle.gif";
    private String iconChildLast = "images/tree/line_last.gif";
    private String iconNodeOpen = "images/tree/node_open.gif";
    private String iconNodeOpenFirst = "images/tree/node_open_first.gif";
    private String iconNodeOpenMiddle = "images/tree/node_open_middle.gif";
    private String iconNodeOpenLast = "images/tree/node_open_last.gif";
    private String iconNodeClose = "images/tree/node_close.gif";
    private String iconNodeCloseFirst = "images/tree/node_close_first.gif";
    private String iconNodeCloseMiddle = "images/tree/node_close_middle.gif";
    private String iconNodeCloseLast = "images/tree/node_close_last.gif";
    private int uniqueIdCounter = 0;
    private int[] selectedPath;
    private int internalId = counter++;
    private long expireListeners = 28800000L;
    static /* synthetic */ Class class$net$sourceforge$myfaces$custom$tree$HtmlTree;

    public TreeModel getModel(FacesContext context) {
        TreeModel model;
        ValueBinding binding = this.getValueBinding("model");
        if (binding != null && (model = (TreeModel)binding.getValue(context)) != null) {
            return model;
        }
        return null;
    }

    public String createUniqueId(FacesContext context) {
        return this.getClientId(context) + "_node_" + this.uniqueIdCounter++;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.addFacesListener(listener);
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public void setIconProvider(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public String getIconLine() {
        return this.iconLine;
    }

    public void setIconLine(String iconLine) {
        this.iconLine = iconLine;
    }

    public String getIconNoline() {
        return this.iconNoline;
    }

    public void setIconNoline(String iconNoline) {
        this.iconNoline = iconNoline;
    }

    public String getIconChild() {
        return this.iconChild;
    }

    public void setIconChild(String iconChild) {
        this.iconChild = iconChild;
    }

    public String getIconChildFirst() {
        return this.iconChildFirst;
    }

    public void setIconChildFirst(String iconChildFirst) {
        this.iconChildFirst = iconChildFirst;
    }

    public String getIconChildMiddle() {
        return this.iconChildMiddle;
    }

    public void setIconChildMiddle(String iconChildMiddle) {
        this.iconChildMiddle = iconChildMiddle;
    }

    public String getIconChildLast() {
        return this.iconChildLast;
    }

    public void setIconChildLast(String iconChildLast) {
        this.iconChildLast = iconChildLast;
    }

    public String getIconNodeOpen() {
        return this.iconNodeOpen;
    }

    public void setIconNodeOpen(String iconNodeOpen) {
        this.iconNodeOpen = iconNodeOpen;
    }

    public String getIconNodeOpenFirst() {
        return this.iconNodeOpenFirst;
    }

    public void setIconNodeOpenFirst(String iconNodeOpenFirst) {
        this.iconNodeOpenFirst = iconNodeOpenFirst;
    }

    public String getIconNodeOpenMiddle() {
        return this.iconNodeOpenMiddle;
    }

    public void setIconNodeOpenMiddle(String iconNodeOpenMiddle) {
        this.iconNodeOpenMiddle = iconNodeOpenMiddle;
    }

    public String getIconNodeOpenLast() {
        return this.iconNodeOpenLast;
    }

    public void setIconNodeOpenLast(String iconNodeOpenLast) {
        this.iconNodeOpenLast = iconNodeOpenLast;
    }

    public String getIconNodeClose() {
        return this.iconNodeClose;
    }

    public void setIconNodeClose(String iconNodeClose) {
        this.iconNodeClose = iconNodeClose;
    }

    public String getIconNodeCloseFirst() {
        return this.iconNodeCloseFirst;
    }

    public void setIconNodeCloseFirst(String iconNodeCloseFirst) {
        this.iconNodeCloseFirst = iconNodeCloseFirst;
    }

    public String getIconNodeCloseMiddle() {
        return this.iconNodeCloseMiddle;
    }

    public void setIconNodeCloseMiddle(String iconNodeCloseMiddle) {
        this.iconNodeCloseMiddle = iconNodeCloseMiddle;
    }

    public String getIconNodeCloseLast() {
        return this.iconNodeCloseLast;
    }

    public void setIconNodeCloseLast(String iconNodeCloseLast) {
        this.iconNodeCloseLast = iconNodeCloseLast;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getNodeClass() {
        return this.nodeClass;
    }

    public void setNodeClass(String nodeClass) {
        this.nodeClass = nodeClass;
    }

    public String getSelectedNodeClass() {
        return this.selectedNodeClass;
    }

    public void setSelectedNodeClass(String selectedNodeClass) {
        this.selectedNodeClass = selectedNodeClass;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    public long getExpireListeners() {
        return this.expireListeners;
    }

    public void setExpireListeners(long expireListeners) {
        this.expireListeners = expireListeners;
    }

    public String getFamily() {
        return "net.sourceforge.myfaces.HtmlTree";
    }

    public void expandPath(TreePath path, FacesContext context) {
        TreeModel model = this.getModel(context);
        if (path != null && model != null && !model.isLeaf(path.getLastPathComponent())) {
            int[] translatedPath = HtmlTreeNode.translatePath(path, this.getModel(context));
            HtmlTreeNode rootNode = this.getRootNode();
            if (rootNode == null) {
                this.createRootNode(context);
                rootNode = this.getRootNode();
            }
            if (!rootNode.isExpanded()) {
                rootNode.setExpanded(true);
            }
            rootNode.expandPath(translatedPath, 0);
        }
    }

    public void collapsePath(TreePath path, FacesContext context) {
        HtmlTreeNode node = this.findNode(path, context);
        if (node != null) {
            node.setExpanded(false);
        }
    }

    public boolean isExpanded(TreePath path, FacesContext context) {
        if (path == null) {
            return false;
        }
        return this.findNode(path, context) != null;
    }

    private HtmlTreeNode findNode(TreePath path, FacesContext context) {
        HtmlTreeNode node = this.getRootNode();
        int[] translatedPath = HtmlTreeNode.translatePath(path, this.getModel(context));
        for (int i = 0; i < translatedPath.length; ++i) {
            if (!node.isExpanded()) {
                return null;
            }
            int index = translatedPath[i];
            node = (HtmlTreeNode)((Object)node.getChildren().get(index));
        }
        return node;
    }

    public TreePath getSelectionPath() {
        if (this.selectedPath == null) {
            return null;
        }
        return HtmlTreeNode.translatePath(this.selectedPath, this.getModel(FacesContext.getCurrentInstance()));
    }

    public void selectionChanged(HtmlTreeNode node) {
        TreePath oldPath = null;
        if (this.selectedPath != null) {
            oldPath = HtmlTreeNode.translatePath(this.selectedPath, this.getModel(FacesContext.getCurrentInstance()));
        }
        this.selectedPath = node.getTranslatedPath();
        if (node.isSelected()) {
            this.queueEvent(new TreeSelectionEvent((UIComponent)this, oldPath, node.getPath()));
        } else {
            this.queueEvent(new TreeSelectionEvent((UIComponent)this, oldPath, null));
        }
    }

    private void createRootNode(FacesContext context) {
        TreeModel model = this.getModel(context);
        Object root = model.getRoot();
        HtmlTreeNode node = (HtmlTreeNode)context.getApplication().createComponent("net.sourceforge.myfaces.HtmlTreeNode");
        String id = this.createUniqueId(context);
        node.setId(id);
        node.setPath(new TreePath(new Object[]{root}));
        node.setUserObject(root);
        node.setLayout(new int[]{13});
        this.getFacets().put(FACET_ROOTNODE, node);
    }

    public HtmlTreeNode getRootNode() {
        return (HtmlTreeNode)this.getFacet(FACET_ROOTNODE);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.iconChild, this.iconChildFirst, this.iconChildLast, this.iconLine, this.iconNodeClose, this.iconNodeCloseFirst, this.iconNodeCloseLast, this.iconNodeCloseMiddle, this.iconNodeOpen, this.iconNodeOpenFirst, this.iconNodeOpenLast, this.iconNodeOpenMiddle, this.iconNoline, this.styleClass, this.nodeClass, this.selectedNodeClass, new Integer(this.uniqueIdCounter), this.selectedPath, this.iconClass, new Integer(this.internalId), new Long(this.expireListeners)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.iconChild = (String)values[1];
        this.iconChildFirst = (String)values[2];
        this.iconChildLast = (String)values[3];
        this.iconLine = (String)values[4];
        this.iconNodeClose = (String)values[5];
        this.iconNodeCloseFirst = (String)values[6];
        this.iconNodeCloseLast = (String)values[7];
        this.iconNodeCloseMiddle = (String)values[8];
        this.iconNodeOpen = (String)values[9];
        this.iconNodeOpenFirst = (String)values[10];
        this.iconNodeOpenLast = (String)values[11];
        this.iconNodeOpenMiddle = (String)values[12];
        this.iconNoline = (String)values[13];
        this.styleClass = (String)values[14];
        this.nodeClass = (String)values[15];
        this.selectedNodeClass = (String)values[16];
        this.uniqueIdCounter = (Integer)values[17];
        this.selectedPath = (int[])values[18];
        this.iconClass = (String)values[19];
        this.internalId = (Integer)values[20];
        this.expireListeners = (Long)values[21];
        this.addToModelListeners();
    }

    public void decode(FacesContext context) {
        super.decode(context);
        context.getExternalContext().getRequestMap().put(PREVIOUS_VIEW_ROOT, context.getViewRoot());
        this.itemStatesRestored = true;
    }

    public void processDecodes(FacesContext context) {
        this.addToModelListeners();
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        this.addToModelListeners();
        super.processValidators(context);
    }

    public void processUpdates(FacesContext context) {
        this.addToModelListeners();
        super.processUpdates(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIViewRoot previousRoot;
        this.addToModelListeners();
        this.processModelEvents();
        HtmlTreeNode node = this.getRootNode();
        if (node == null) {
            this.createRootNode(context);
        }
        if (!this.itemStatesRestored && (previousRoot = (UIViewRoot)context.getExternalContext().getRequestMap().get(PREVIOUS_VIEW_ROOT)) != null) {
            this.restoreItemStates(context, previousRoot);
        }
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public void restoreItemStates(FacesContext facesContext, UIViewRoot previousRoot) {
        HtmlTree previousTree = (HtmlTree)previousRoot.findComponent(this.getClientId(facesContext));
        if (previousTree != null) {
            HtmlTreeNode node = previousTree.getRootNode();
            if (node != null) {
                this.getRootNode().restoreItemState(node);
            }
            this.selectedPath = previousTree.selectedPath;
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenChanged(e.getChildIndices(), context);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenAdded(e.getChildIndices(), context);
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenRemoved(e.getChildIndices());
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        if (this.isExpanded(path, context = FacesContext.getCurrentInstance())) {
            this.collapsePath(path, context);
            this.expandPath(path, context);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HtmlTree)) {
            return false;
        }
        HtmlTree other = (HtmlTree)obj;
        return other.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getClientId(FacesContext.getCurrentInstance()).hashCode();
    }

    public void addToModelListeners() {
        Collection listeners = this.getModel(FacesContext.getCurrentInstance()).getTreeModelListeners();
        long currentTime = System.currentTimeMillis();
        boolean found = false;
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ModelListener listener = (ModelListener)iterator.next();
            if (listener.getId() == this.internalId) {
                found = true;
                continue;
            }
            if (currentTime - listener.getLastAccessTime() <= this.expireListeners) continue;
            iterator.remove();
        }
        if (!found) {
            listeners.add(new ModelListener(this.internalId));
        }
    }

    private void processModelEvents() {
        Collection listeners = this.getModel(FacesContext.getCurrentInstance()).getTreeModelListeners();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ModelListener listener = (ModelListener)iterator.next();
            if (listener.getId() != this.internalId) continue;
            Iterator events = listener.getEvents().iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                event.process(this);
                events.remove();
            }
            break block0;
        }
    }

    public void collapseAll() {
        HtmlTreeNode root = this.getRootNode();
        FacesContext context = FacesContext.getCurrentInstance();
        this.collapsePath(root.getPath(), context);
        for (int i = 0; i < root.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)root.getChildren().get(i));
            this.collapsePath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.collapseChildren(context, child);
        }
    }

    private void collapseChildren(FacesContext context, HtmlTreeNode parent) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)parent.getChildren().get(i));
            this.collapsePath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.collapseChildren(context, child);
        }
    }

    public void expandAll() {
        HtmlTreeNode root = this.getRootNode();
        FacesContext context = FacesContext.getCurrentInstance();
        this.expandPath(root.getPath(), context);
        for (int i = 0; i < root.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)root.getChildren().get(i));
            this.expandPath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.expandChildren(context, child);
        }
    }

    private void expandChildren(FacesContext context, HtmlTreeNode parent) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)parent.getChildren().get(i));
            this.expandPath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.expandChildren(context, child);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Event {
        private int kind;
        private TreeModelEvent event;

        public Event(int kind, TreeModelEvent event) {
            this.kind = kind;
            this.event = event;
        }

        public void process(HtmlTree tree) {
            switch (this.kind) {
                case 0: {
                    tree.treeNodesChanged(this.event);
                    break;
                }
                case 1: {
                    tree.treeNodesInserted(this.event);
                    break;
                }
                case 2: {
                    tree.treeNodesRemoved(this.event);
                    break;
                }
                case 3: {
                    tree.treeStructureChanged(this.event);
                }
            }
        }
    }

    private static class ModelListener
    implements TreeModelListener {
        private long lastAccessTime = System.currentTimeMillis();
        private LinkedList events = new LinkedList();
        int id;

        public ModelListener(int id) {
            this.id = id;
        }

        public List getEvents() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.events;
        }

        public int getId() {
            return this.id;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.events.addLast(new Event(0, e));
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.events.addLast(new Event(1, e));
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.events.addLast(new Event(2, e));
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.events.addLast(new Event(3, e));
        }
    }
}

