/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ognl.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ObjectArrayPool {
    private IntHashMap pools;

    public final IntHashMap getSizePools() {
        return this.pools;
    }

    public final synchronized SizePool getSizePool(int arraySize) {
        SizePool result = (SizePool)this.pools.get(arraySize);
        if (result == null) {
            result = new SizePool(arraySize);
            this.pools.put(arraySize, (Object)result);
        }
        return result;
    }

    public final synchronized Object[] create(int arraySize) {
        return this.getSizePool(arraySize).create();
    }

    public final synchronized Object[] create(Object singleton) {
        Object[] result = this.create(1);
        result[0] = singleton;
        return result;
    }

    public final synchronized Object[] create(Object object1, Object object2) {
        Object[] result = this.create(2);
        result[0] = object1;
        result[1] = object2;
        return result;
    }

    public final synchronized Object[] create(Object object1, Object object2, Object object3) {
        Object[] result = this.create(3);
        result[0] = object1;
        result[1] = object2;
        result[2] = object3;
        return result;
    }

    public final synchronized Object[] create(Object object1, Object object2, Object object3, Object object4) {
        Object[] result = this.create(4);
        result[0] = object1;
        result[1] = object2;
        result[2] = object3;
        result[3] = object4;
        return result;
    }

    public final synchronized Object[] create(Object object1, Object object2, Object object3, Object object4, Object object5) {
        Object[] result = this.create(5);
        result[0] = object1;
        result[1] = object2;
        result[2] = object3;
        result[3] = object4;
        result[4] = object5;
        return result;
    }

    public final synchronized void recycle(Object[] value) {
        if (value != null) {
            this.getSizePool(value.length).recycle(value);
        }
    }

    private final /* synthetic */ void this() {
        this.pools = new IntHashMap(23);
    }

    public ObjectArrayPool() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SizePool {
        private List arrays;
        private int arraySize;
        private int size;
        private int created;
        private int recovered;
        private int recycled;

        public int getArraySize() {
            return this.arraySize;
        }

        public Object[] create() {
            Object[] result;
            if (this.size > 0) {
                result = (Object[])this.arrays.remove(this.size - 1);
                --this.size;
                ++this.recovered;
            } else {
                result = new Object[this.arraySize];
                ++this.created;
            }
            return result;
        }

        public synchronized void recycle(Object[] value) {
            if (value != null) {
                if (value.length != this.arraySize) {
                    throw new IllegalArgumentException("recycled array size " + value.length + " inappropriate for pool array size " + this.arraySize);
                }
                Arrays.fill(value, null);
                this.arrays.add(value);
                ++this.size;
                ++this.recycled;
            } else {
                throw new IllegalArgumentException("cannot recycle null object");
            }
        }

        public int getSize() {
            return this.size;
        }

        public int getCreatedCount() {
            return this.created;
        }

        public int getRecoveredCount() {
            return this.recovered;
        }

        public int getRecycledCount() {
            return this.recycled;
        }

        private final /* synthetic */ void this() {
            this.arrays = new ArrayList();
            this.created = 0;
            this.recovered = 0;
            this.recycled = 0;
        }

        public SizePool(int arraySize) {
            this(arraySize, 0);
        }

        public SizePool(int arraySize, int initialSize) {
            this.this();
            this.arraySize = arraySize;
            int i = 0;
            while (i < initialSize) {
                this.arrays.add(new Object[arraySize]);
                ++i;
            }
            this.created = this.size = initialSize;
        }
    }
}

