/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.unit;

import java.sql.DatabaseMetaData;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.PropertyDesc;

public class S2DaoBeanReader
implements DataReader {
    private DataSet dataSet_ = new DataSetImpl();
    private DataTable table_ = this.dataSet_.addTable("S2DaoBean");

    protected S2DaoBeanReader() {
    }

    public S2DaoBeanReader(Object bean, DatabaseMetaData dbMetaData) {
        Dbms dbms = DbmsManager.getDbms(dbMetaData);
        BeanMetaDataImpl beanMetaData = new BeanMetaDataImpl(bean.getClass(), dbMetaData, dbms);
        this.setupColumns(beanMetaData);
        this.setupRow(beanMetaData, bean);
    }

    protected void setupColumns(BeanMetaData beanMetaData) {
        int i = 0;
        while (i < beanMetaData.getPropertyTypeSize()) {
            PropertyType pt = beanMetaData.getPropertyType(i);
            Class propertyType = pt.getPropertyDesc().getPropertyType();
            this.table_.addColumn(pt.getColumnName(), ColumnTypes.getColumnType((Class)propertyType));
            ++i;
        }
        i = 0;
        while (i < beanMetaData.getRelationPropertyTypeSize()) {
            RelationPropertyType rpt = beanMetaData.getRelationPropertyType(i);
            int j = 0;
            while (j < rpt.getBeanMetaData().getPropertyTypeSize()) {
                PropertyType pt = rpt.getBeanMetaData().getPropertyType(j);
                String columnName = String.valueOf(pt.getColumnName()) + "_" + rpt.getRelationNo();
                Class propertyType = pt.getPropertyDesc().getPropertyType();
                this.table_.addColumn(columnName, ColumnTypes.getColumnType((Class)propertyType));
                ++j;
            }
            ++i;
        }
    }

    protected void setupRow(BeanMetaData beanMetaData, Object bean) {
        DataRow row = this.table_.addRow();
        int i = 0;
        while (i < beanMetaData.getPropertyTypeSize()) {
            PropertyType pt = beanMetaData.getPropertyType(i);
            PropertyDesc pd = pt.getPropertyDesc();
            Object value = pd.getValue(bean);
            ColumnType ct = ColumnTypes.getColumnType((Class)pd.getPropertyType());
            row.setValue(pt.getColumnName(), ct.convert(value, null));
            ++i;
        }
        i = 0;
        while (i < beanMetaData.getRelationPropertyTypeSize()) {
            RelationPropertyType rpt = beanMetaData.getRelationPropertyType(i);
            Object relationBean = rpt.getPropertyDesc().getValue(bean);
            if (relationBean != null) {
                int j = 0;
                while (j < rpt.getBeanMetaData().getPropertyTypeSize()) {
                    PropertyType pt = rpt.getBeanMetaData().getPropertyType(j);
                    String columnName = String.valueOf(pt.getColumnName()) + "_" + rpt.getRelationNo();
                    PropertyDesc pd = pt.getPropertyDesc();
                    Object value = pd.getValue(relationBean);
                    ColumnType ct = ColumnTypes.getColumnType((Class)pd.getPropertyType());
                    row.setValue(columnName, ct.convert(value, null));
                    ++j;
                }
            }
            ++i;
        }
        row.setState(RowStates.UNCHANGED);
    }

    public DataSet read() {
        return this.dataSet_;
    }
}

