/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.io.PrintWriter;
import java.io.Serializable;
import ognl.Evaluation;
import ognl.EvaluationPool;
import ognl.InappropriateExpressionException;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlParserTreeConstants;
import ognl.OgnlRuntime;

public abstract class SimpleNode
implements Node,
Serializable {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected OgnlParser parser;
    private boolean constantValueCalculated;
    private boolean hasConstantValue;
    private Object constantValue;

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        int n = 0;
        if (this.children != null) {
            n = this.children.length;
        }
        return n;
    }

    public String toString() {
        return OgnlParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + OgnlParserTreeConstants.jjtNodeName[this.id] + ' ' + this.toString();
    }

    public void dump(PrintWriter writer, String prefix) {
        writer.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(writer, prefix + "  ");
                }
                ++i;
            }
        }
    }

    public int getIndexInParent() {
        int result = -1;
        if (this.parent != null) {
            int icount = this.parent.jjtGetNumChildren();
            int i = 0;
            while (i < icount) {
                if (this.parent.jjtGetChild(i) == this) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public Node getNextSibling() {
        int icount;
        Node result = null;
        int i = this.getIndexInParent();
        if (i >= 0 && i < (icount = this.parent.jjtGetNumChildren())) {
            result = this.parent.jjtGetChild(i + 1);
        }
        return result;
    }

    private static final String getDepthString(int depth) {
        StringBuffer result = new StringBuffer("");
        while (depth > 0) {
            --depth;
            result.append("  ");
        }
        return new String(result);
    }

    protected Object evaluateGetValueBody(OgnlContext context, Object source) throws OgnlException {
        if (source != null) {
            context.setCurrentObject(source);
        }
        context.setCurrentNode(this);
        if (!this.constantValueCalculated) {
            this.constantValueCalculated = true;
            this.hasConstantValue = this.isConstant(context);
            if (this.hasConstantValue) {
                this.constantValue = this.getValueBody(context, source);
            }
        }
        return this.hasConstantValue ? this.constantValue : this.getValueBody(context, source);
    }

    protected void evaluateSetValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        if (target != null) {
            context.setCurrentObject(target);
        }
        context.setCurrentNode(this);
        this.setValueBody(context, target, value);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getValue(OgnlContext context, Object source) throws OgnlException {
        if (!context.getTraceEvaluations()) {
            return this.evaluateGetValueBody(context, source);
        }
        EvaluationPool pool = OgnlRuntime.getEvaluationPool();
        Object result = null;
        Exception evalException = null;
        Evaluation evaluation = pool.create(this, source);
        context.pushEvaluation(evaluation);
        try {
            try {
                result = this.evaluateGetValueBody(context, source);
            }
            catch (OgnlException ex) {
                evalException = ex;
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Evaluation eval = context.popEvaluation();
            eval.setResult(result);
            if (evalException != null) {
                eval.setException(evalException);
            }
            if (evalException == null && context.getRootEvaluation() == null && !context.getKeepLastEvaluation()) {
                pool.recycleAll(eval);
            }
            throw throwable;
        }
        {
            Object var8_11 = null;
            Evaluation eval = context.popEvaluation();
            eval.setResult(result);
            if (evalException != null) {
                eval.setException(evalException);
            }
            if (evalException == null && context.getRootEvaluation() == null && !context.getKeepLastEvaluation()) {
                pool.recycleAll(eval);
            }
            return result;
        }
    }

    protected abstract Object getValueBody(OgnlContext var1, Object var2) throws OgnlException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setValue(OgnlContext context, Object target, Object value) throws OgnlException {
        if (!context.getTraceEvaluations()) {
            this.evaluateSetValueBody(context, target, value);
            return;
        }
        EvaluationPool pool = OgnlRuntime.getEvaluationPool();
        Exception evalException = null;
        Evaluation evaluation = pool.create(this, target, true);
        context.pushEvaluation(evaluation);
        try {
            try {
                this.evaluateSetValueBody(context, target, value);
            }
            catch (OgnlException ex) {
                evalException = ex;
                ex.setEvaluation(evaluation);
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Evaluation eval = context.popEvaluation();
            if (evalException != null) {
                eval.setException(evalException);
            }
            if (evalException != null) throw throwable;
            if (context.getRootEvaluation() != null) throw throwable;
            if (context.getKeepLastEvaluation()) throw throwable;
            pool.recycleAll(eval);
            throw throwable;
        }
        {
            Object var8_11 = null;
            Evaluation eval = context.popEvaluation();
            if (evalException != null) {
                eval.setException(evalException);
            }
            if (evalException != null) return;
            if (context.getRootEvaluation() != null) return;
            if (context.getKeepLastEvaluation()) return;
            pool.recycleAll(eval);
            return;
        }
    }

    protected void setValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        throw new InappropriateExpressionException(this);
    }

    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isConstant(OgnlContext context) throws OgnlException {
        return this.isNodeConstant(context);
    }

    public boolean isNodeSimpleProperty(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isSimpleProperty(OgnlContext context) throws OgnlException {
        return this.isNodeSimpleProperty(context);
    }

    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        return this.isSimpleProperty(context);
    }

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += this.children[i].jjtGetNumChildren();
            } else {
                ++newSize;
            }
            ++i;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            int i2 = 0;
            while (i2 < this.children.length) {
                Node c = this.children[i2];
                if (c.getClass() == this.getClass()) {
                    int k = 0;
                    while (k < c.jjtGetNumChildren()) {
                        newChildren[j++] = c.jjtGetChild(k);
                        ++k;
                    }
                } else {
                    newChildren[j++] = c;
                }
                ++i2;
            }
            if (j != newSize) {
                throw new Error("Assertion error: " + j + " != " + newSize);
            }
            this.children = newChildren;
        }
    }

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(OgnlParser p, int i) {
        this(i);
        this.parser = p;
    }
}

