/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.hsqldb.lib.java.javaSystem;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.GridSwing;
import org.hsqldb.util.TableSorter;
import org.hsqldb.util.Transfer;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener {
    static final String NL = System.getProperty("line.separator");
    static int iMaxRecent = 24;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    TableModel tableModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    int iResult;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    JFrame fMain;
    static boolean bMustExit;
    String ifHuge = "";
    JToolBar jtoolbar;
    Cursor fMainCursor;
    Cursor txtCommandCursor;
    Cursor txtResultCursor;
    private static final Cursor waitCursor;
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;
    static Thread runningThread;

    public void init() {
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        try {
            databaseManagerSwing.connect(ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword));
            databaseManagerSwing.insertTestData();
            databaseManagerSwing.refreshTree();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        boolean bl = false;
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toLowerCase();
            ++i;
            if (string.equals("-driver")) {
                defDriver = stringArray[i];
                bl = true;
                continue;
            }
            if (string.equals("-url")) {
                defURL = stringArray[i];
                bl = true;
                continue;
            }
            if (string.equals("-user")) {
                defUser = stringArray[i];
                bl = true;
                continue;
            }
            if (string.equals("-password")) {
                defPassword = stringArray[i];
                bl = true;
                continue;
            }
            if (string.equals("-dir")) {
                defDirectory = stringArray[i];
                continue;
            }
            if (string.equals("-script")) {
                defScript = stringArray[i];
                continue;
            }
            if (string.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            DatabaseManagerSwing.showUsage();
            return;
        }
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        Connection connection = null;
        try {
            connection = bl ? ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword) : ConnectionDialogSwing.createConnection(databaseManagerSwing.fMain, "Connect");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection == null) {
            return;
        }
        databaseManagerSwing.connect(connection);
    }

    public void connect(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.cConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
            this.refreshTree();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [-options]\nwhere options include:\n    -driver <classname>  jdbc driver class\n    -url <name>          jdbc url\n    -user <name>         username used for connection\n    -password <password> password for this user\n    -dir <path>          default directory\n    -script <file>       reads from script file\n    -noexit              do not call system.exit()");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.refreshTree();
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            this.refreshTree();
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void setMustExit(boolean bl) {
        bMustExit = bl;
    }

    public void main() {
        this.fMain = new JFrame("HSQL Database Manager");
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        this.fMain.setIconImage(CommonSwing.getIcon());
        this.fMain.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(jMenuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text"};
        this.addMenu(jMenuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "EEXECUTE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", stringArray3);
        this.mRecent = new JMenu("Recent");
        jMenuBar.add(this.mRecent);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(jMenuBar, "Options", stringArray4);
        String[] stringArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        this.addMenu(jMenuBar, "Tools", stringArray5);
        this.fMain.setJMenuBar(jMenuBar);
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        if (dimension.width >= 640) {
            this.fMain.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(dimension);
        }
        this.fMain.show();
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.ifHuge = DatabaseManagerCommon.readFile(defScript);
            if (4096 <= this.ifHuge.length()) {
                stringBuffer.append("This huge file cannot be edited. Please execute\n");
                this.txtCommand.setText(stringBuffer.toString());
            } else {
                this.txtCommand.setText(this.ifHuge);
            }
        }
        this.txtCommand.requestFocus();
    }

    private void addMenu(JMenuBar jMenuBar, String string, String[] stringArray) {
        JMenu jMenu = new JMenu(string);
        this.addMenuItems(jMenu, stringArray);
        jMenuBar.add(jMenu);
    }

    private void addMenuItems(JMenu jMenu, String[] stringArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--")) {
                jMenu.addSeparator();
                continue;
            }
            if (stringArray[i].equals("---")) {
                if (dimension.width >= 640) {
                    jMenu.addSeparator();
                    continue;
                }
                return;
            }
            JMenuItem jMenuItem = new JMenuItem(stringArray[i].substring(1));
            char c = stringArray[i].charAt(0);
            if (c != '-') {
                KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 2);
                jMenuItem.setAccelerator(keyStroke);
            }
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string.equals("Exit")) {
            this.windowClosing(null);
        } else if (string.equals("Transfer")) {
            Transfer.work(null);
        } else if (string.equals("Dump")) {
            Transfer.work(new String[]{"-d"});
        } else if (string.equals("Restore")) {
            Transfer.work(new String[]{"-r"});
        } else if (string.equals("Logging on")) {
            javaSystem.setLogToSystem(true);
        } else if (string.equals("Logging off")) {
            javaSystem.setLogToSystem(false);
        } else if (string.equals("Refresh Tree")) {
            this.refreshTree();
        } else if (string.startsWith("#")) {
            int n = Integer.parseInt(string.substring(1));
            this.txtCommand.setText(this.sRecent[n]);
        } else if (string.equals("Connect...")) {
            this.connect(ConnectionDialogSwing.createConnection(this.fMain, "Connect"));
            this.refreshTree();
        } else if (string.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add((Component)this.gScrollPane, "Center");
            this.pResult.doLayout();
            this.gResult.fireTableChanged(null);
            this.pResult.repaint();
        } else if (string.equals("Open Script...")) {
            File file;
            int n;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Open Script...");
            if (defDirectory != null) {
                jFileChooser.setCurrentDirectory(new File(defDirectory));
            }
            if ((n = jFileChooser.showOpenDialog(this.fMain)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                this.ifHuge = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                if (4096 <= this.ifHuge.length()) {
                    stringBuffer.append("This huge file cannot be edited. Please execute\n");
                    this.txtCommand.setText(stringBuffer.toString());
                } else {
                    this.txtCommand.setText(this.ifHuge);
                }
            }
        } else if (string.equals("Save Script...")) {
            File file;
            int n;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Save Script");
            if (defDirectory != null) {
                jFileChooser.setCurrentDirectory(new File(defDirectory));
            }
            if ((n = jFileChooser.showSaveDialog(this.fMain)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
            }
        } else if (string.equals("Save Result...")) {
            File file;
            int n;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Save Result...");
            if (defDirectory != null) {
                jFileChooser.setCurrentDirectory(new File(defDirectory));
            }
            if ((n = jFileChooser.showSaveDialog(this.fMain)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.showResultInText();
                DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
            }
        } else if (string.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add((Component)this.txtResultScroll, "Center");
            this.pResult.doLayout();
            this.showResultInText();
            this.pResult.repaint();
        } else if (string.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Insert test data")) {
            this.insertTestData();
        } else if (string.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("SELECT")) {
            this.showHelp(DatabaseManagerCommon.selectHelp);
        } else if (string.equals("INSERT")) {
            this.showHelp(DatabaseManagerCommon.insertHelp);
        } else if (string.equals("UPDATE")) {
            this.showHelp(DatabaseManagerCommon.updateHelp);
        } else if (string.equals("DELETE")) {
            this.showHelp(DatabaseManagerCommon.deleteHelp);
        } else if (string.equals("EXECUTE")) {
            this.execute();
        } else if (string.equals("CREATE TABLE")) {
            this.showHelp(DatabaseManagerCommon.createTableHelp);
        } else if (string.equals("DROP TABLE")) {
            this.showHelp(DatabaseManagerCommon.dropTableHelp);
        } else if (string.equals("CREATE INDEX")) {
            this.showHelp(DatabaseManagerCommon.createIndexHelp);
        } else if (string.equals("DROP INDEX")) {
            this.showHelp(DatabaseManagerCommon.dropIndexHelp);
        } else if (string.equals("CHECKPOINT")) {
            this.showHelp(DatabaseManagerCommon.checkpointHelp);
        } else if (string.equals("SCRIPT")) {
            this.showHelp(DatabaseManagerCommon.scriptHelp);
        } else if (string.equals("SHUTDOWN")) {
            this.showHelp(DatabaseManagerCommon.shutdownHelp);
        } else if (string.equals("SET")) {
            this.showHelp(DatabaseManagerCommon.setHelp);
        } else if (string.equals("Test Script")) {
            this.showHelp(DatabaseManagerCommon.testHelp);
        }
    }

    private void showHelp(String[] stringArray) {
        this.txtCommand.setText(stringArray[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(stringArray[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(stringArray[0].length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    private void clear() {
        this.ifHuge = "";
        this.txtCommand.setText(this.ifHuge);
    }

    private void execute() {
        if (runningThread != null && runningThread.isAlive()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        runningThread = new ExecuteThread();
        runningThread.start();
    }

    public void setWaiting(boolean bl) {
        if (bl) {
            if (this.fMainCursor == null) {
                this.fMainCursor = this.fMain.getCursor();
                this.txtCommandCursor = this.txtCommand.getCursor();
                this.txtResultCursor = this.txtResult.getCursor();
            }
            this.fMain.setCursor(waitCursor);
            this.txtCommand.setCursor(waitCursor);
            this.txtResult.setCursor(waitCursor);
        } else {
            this.fMain.setCursor(this.fMainCursor);
            this.txtCommand.setCursor(this.txtCommandCursor);
            this.txtResult.setCursor(this.txtResultCursor);
        }
    }

    private void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            Object[] objectArray = new String[]{"Result"};
            this.gResult.setHead(objectArray);
            objectArray[0] = "(empty)";
            this.gResult.addRow(objectArray);
            return;
        }
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            Object[] objectArray = new Object[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSetMetaData.getColumnLabel(n);
            }
            this.gResult.setHead(objectArray);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    objectArray[n - 1] = resultSet.getObject(n);
                    if (!resultSet.wasNull()) continue;
                    objectArray[n - 1] = null;
                }
                this.gResult.addRow(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void testPerformance() {
        int n;
        String string = this.txtCommand.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 10) continue;
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        Object[] objectArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(objectArray);
        n = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!string.equals("")) {
            String string2;
            int n2 = string.indexOf(59);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            objectArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = DatabaseManagerCommon.testStatement(this.sStatement, string2, n);
                l += l2;
                objectArray[0] = "" + l2;
                objectArray[1] = "" + n;
                objectArray[3] = "";
            }
            catch (SQLException sQLException) {
                objectArray[1] = "n/a";
                objectArray[0] = "n/a";
                objectArray[3] = sQLException.toString();
            }
            this.gResult.addRow(objectArray);
            System.out.println(l2 + " ms : " + string2);
        }
        objectArray[0] = "" + l;
        objectArray[1] = "total";
        objectArray[2] = "";
        this.gResult.addRow(objectArray);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    private void showResultInText() {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        Object[] objectArray2 = this.gResult.getHead();
        int n4 = objectArray2.length;
        int[] nArray = new int[n4];
        Vector vector = this.gResult.getData();
        int n5 = vector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = objectArray2[n3].toString().length();
        }
        for (n3 = 0; n3 < n5; ++n3) {
            objectArray = (Object[])vector.elementAt(n3);
            for (n2 = 0; n2 < n4; ++n2) {
                n = objectArray[n2].toString().length();
                if (n <= nArray[n2]) continue;
                nArray[n2] = n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(objectArray2[n2]);
            for (n = objectArray2[n2].toString().length(); n <= nArray[n2]; ++n) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(NL);
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < nArray[n2]; ++n) {
                stringBuffer.append('-');
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append(NL);
        for (n2 = 0; n2 < n5; ++n2) {
            objectArray = (Object[])vector.elementAt(n2);
            for (n = 0; n < n4; ++n) {
                stringBuffer.append(objectArray[n]);
                for (int i = objectArray[n].toString().length(); i <= nArray[n]; ++i) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(NL);
        }
        stringBuffer.append(NL + n5 + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!string.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("#" + this.iRecent);
        jMenuItem.addActionListener(this);
        this.mRecent.insert(jMenuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, jPanel, this.pResult);
        jPanel.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(5, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(20, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        jPanel.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        TableSorter tableSorter = new TableSorter(this.gResult);
        this.tableModel = tableSorter;
        this.gResultTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.gResultTable.getTableHeader());
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.gResultTable.setAutoResizeMode(0);
        this.gResult.setJTable(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tScrollPane.setPreferredSize(new Dimension(120, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(360, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.doLayout();
        this.fMain.pack();
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    protected void refreshTree() {
        String[] stringArray;
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            stringArray = (String[])this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent((MutableTreeNode)stringArray);
            stringArray.removeAllChildren();
            stringArray.removeFromParent();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        try {
            this.rootNode.setUserObject(this.dMeta.getURL());
            stringArray = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
            ResultSet resultSet = this.dMeta.getTables(null, null, null, stringArray);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(3));
                vector2.addElement(resultSet.getString(5));
            }
            resultSet.close();
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                Object object;
                Object object2;
                String string2 = (String)vector.elementAt(i);
                DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode(string2, this.rootNode);
                ResultSet resultSet2 = this.dMeta.getColumns(null, null, string2, null);
                String string3 = (String)vector2.elementAt(i);
                if (string3 != null && !string3.trim().equals("")) {
                    this.makeNode(string3, defaultMutableTreeNode);
                }
                while (resultSet2.next()) {
                    object2 = resultSet2.getString(4);
                    object = this.makeNode(object2, defaultMutableTreeNode);
                    string = resultSet2.getString(6);
                    this.makeNode("Type: " + string, (MutableTreeNode)object);
                    boolean bl = resultSet2.getInt(11) != 0;
                    this.makeNode("Nullable: " + bl, (MutableTreeNode)object);
                }
                resultSet2.close();
                object2 = this.makeNode("Indices", defaultMutableTreeNode);
                object = this.dMeta.getIndexInfo(null, null, string2, false, false);
                string = null;
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                while (object.next()) {
                    boolean bl = object.getBoolean(4);
                    String string4 = object.getString(6);
                    if (string == null || !string.equals(string4)) {
                        defaultMutableTreeNode2 = this.makeNode(string4, (MutableTreeNode)object2);
                        this.makeNode("Unique: " + !bl, defaultMutableTreeNode2);
                        string = string4;
                    }
                    this.makeNode(object.getString(9), defaultMutableTreeNode2);
                }
                object.close();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JButton jButton = new JButton("Clear SQL Statement");
        jButton.setToolTipText("Clear SQL Statement");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.clear();
            }
        });
        JButton jButton2 = new JButton("Execute SQL Statement");
        jButton2.setToolTipText("Execute SQL Statement");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.execute();
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jButton.setAlignmentY(0.5f);
        jButton.setAlignmentX(0.5f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setAlignmentX(0.5f);
        return jToolBar;
    }

    static {
        waitCursor = new Cursor(3);
        defDriver = "org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:.";
        defUser = "sa";
        defPassword = "";
        runningThread = null;
    }

    private class ExecuteThread
    extends Thread {
        private ExecuteThread() {
        }

        public void run() {
            DatabaseManagerSwing.this.setWaiting(true);
            DatabaseManagerSwing.this.gResult.clear();
            String string = null;
            string = 4096 <= DatabaseManagerSwing.this.ifHuge.length() ? DatabaseManagerSwing.this.ifHuge : DatabaseManagerSwing.this.txtCommand.getText();
            if (string.startsWith("-->>>TEST<<<--")) {
                DatabaseManagerSwing.this.testPerformance();
                return;
            }
            Object[] objectArray = new String[1];
            try {
                DatabaseManagerSwing.this.lTime = System.currentTimeMillis();
                DatabaseManagerSwing.this.sStatement.execute(string);
                int n = DatabaseManagerSwing.this.sStatement.getUpdateCount();
                if (n == -1) {
                    DatabaseManagerSwing.this.formatResultSet(DatabaseManagerSwing.this.sStatement.getResultSet());
                } else {
                    objectArray[0] = "update count";
                    DatabaseManagerSwing.this.gResult.setHead(objectArray);
                    objectArray[0] = "" + n;
                    DatabaseManagerSwing.this.gResult.addRow(objectArray);
                }
                DatabaseManagerSwing.this.lTime = System.currentTimeMillis() - DatabaseManagerSwing.this.lTime;
                DatabaseManagerSwing.this.addToRecent(DatabaseManagerSwing.this.txtCommand.getText());
            }
            catch (SQLException sQLException) {
                DatabaseManagerSwing.this.lTime = System.currentTimeMillis() - DatabaseManagerSwing.this.lTime;
                objectArray[0] = "SQL Error";
                DatabaseManagerSwing.this.gResult.setHead(objectArray);
                String string2 = sQLException.getMessage();
                string2 = string2 + " / Error Code: " + sQLException.getErrorCode();
                string2 = string2 + " / State: " + sQLException.getSQLState();
                objectArray[0] = string2;
                DatabaseManagerSwing.this.gResult.addRow(objectArray);
            }
            SwingUtilities.invokeLater(new Thread(){

                public void run() {
                    DatabaseManagerSwing.this.updateResult();
                    ((ExecuteThread)this).DatabaseManagerSwing.this.gResult.fireTableChanged(null);
                    System.gc();
                    DatabaseManagerSwing.this.setWaiting(false);
                }
            });
        }
    }
}

