/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.PropertyTypeUtil;

public class DataRowReloadResultSetHandler
implements ResultSetHandler {
    private DataRow row_;
    private DataRow newRow_;

    public DataRowReloadResultSetHandler(DataRow row, DataRow newRow) {
        this.row_ = row;
        this.newRow_ = newRow;
    }

    public DataRow getRow() {
        return this.row_;
    }

    public DataRow getNewRow() {
        return this.newRow_;
    }

    public Object handle(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        PropertyType[] propertyTypes = PropertyTypeUtil.createPropertyTypes(rsmd);
        if (rs.next()) {
            this.reload(rs, propertyTypes);
        }
        return this.newRow_;
    }

    private void reload(ResultSet rs, PropertyType[] propertyTypes) throws SQLException {
        int i = 0;
        while (i < propertyTypes.length) {
            Object value = propertyTypes[i].getValueType().getValue(rs, i + 1);
            this.newRow_.setValue(propertyTypes[i].getPropertyName(), value);
            ++i;
        }
        this.newRow_.setState(RowStates.UNCHANGED);
    }
}

