package test.org.seasar.dao.impl;

import java.util.List;

import org.seasar.dao.DaoMetaData;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.InsertAutoStaticCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.extension.unit.S2TestCase;

/**
 * @author higa
 *  
 */
public class DaoMetaDataImplTest extends S2TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * 
	 * @param arg0
	 */
	public DaoMetaDataImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DaoMetaDataImplTest.class);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public void testSelectBeanList() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd
				.getSqlCommand("getAllEmployees");
		assertNotNull("1", cmd);
		assertEquals("2", "SELECT * FROM emp", cmd.getSql());
		BeanListMetaDataResultSetHandler rsh = (BeanListMetaDataResultSetHandler) cmd
				.getResultSetHandler();
		assertEquals("3", Employee.class, rsh.getBeanMetaData().getBeanClass());
	}
	
	public void testSelectBeanArray() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd
				.getSqlCommand("getAllEmployeeArray");
		assertNotNull("1", cmd);
		BeanArrayMetaDataResultSetHandler rsh = (BeanArrayMetaDataResultSetHandler) cmd
				.getResultSetHandler();
		assertEquals("2", Employee.class, rsh.getBeanMetaData().getBeanClass());
	}

	public void testSelectBean() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd
				.getSqlCommand("getEmployee");
		assertNotNull("1", cmd);
		assertEquals("2", BeanMetaDataResultSetHandler.class, cmd
				.getResultSetHandler().getClass());
		assertEquals("3", "empno", cmd.getArgNames()[0]);
	}

	public void testSelectObject() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd
				.getSqlCommand("getCount");
		assertNotNull("1", cmd);
		assertEquals("2", ObjectResultSetHandler.class, cmd
				.getResultSetHandler().getClass());
		assertEquals("3", "SELECT COUNT(*) FROM emp", cmd.getSql());
	}

	public void testUpdate() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		UpdateDynamicCommand cmd = (UpdateDynamicCommand) dmd
				.getSqlCommand("update");
		assertNotNull("1", cmd);
		assertEquals("2", "employee", cmd.getArgNames()[0]);
	}

	public void testInsertAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		InsertAutoStaticCommand cmd = (InsertAutoStaticCommand) dmd
				.getSqlCommand("insert");
		assertNotNull("1", cmd);
	}

	public void testUpdateAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		assertNotNull("1", dmd.getSqlCommand("update"));
	}

	public void testDeleteAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		assertNotNull("1", dmd.getSqlCommand("delete"));
	}

	public void testIllegalAutoUpdateMethod() throws Exception {
		try {
			new DaoMetaDataImpl(IllegalEmployeeAutoDao.class, getDataSource(), BasicResultSetFactory.INSTANCE);
			fail("1");
		} catch (IllegalSignatureRuntimeException ex) {
			System.out.println(ex.getSignature());
			System.out.println(ex);
		}
	}

	public void testSelectAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd
				.getSqlCommand("getEmployeeByDeptno");
		System.out.println(cmd.getSql());
	}

	public void testInsertBatchAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		InsertBatchAutoStaticCommand cmd = (InsertBatchAutoStaticCommand) dmd
				.getSqlCommand("insertBatch");
		assertNotNull("1", cmd);
	}

	public void testUpdateBatchAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		UpdateBatchAutoStaticCommand cmd = (UpdateBatchAutoStaticCommand) dmd
				.getSqlCommand("updateBatch");
		assertNotNull("1", cmd);
	}

	public void testDeleteBatchAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		DeleteBatchAutoStaticCommand cmd = (DeleteBatchAutoStaticCommand) dmd
				.getSqlCommand("deleteBatch");
		assertNotNull("1", cmd);
	}

	public void testCreateFindCommand() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd.createFindCommand(null);
		List employees = (List) cmd.execute(null);
		System.out.println(employees);
		assertTrue("1", employees.size() > 0);
	}

	public void testCreateFindCommand2() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd.createFindCommand("empno = ?");
		List employees = (List) cmd.execute(new Object[] { new Integer(7788) });
		System.out.println(employees);
		assertEquals("1", 1, employees.size());
	}

	public void testCreateFindCommand3() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd.createFindCommand("select * from emp");
		List employees = (List) cmd.execute(null);
		System.out.println(employees);
		assertTrue("1", employees.size() > 0);
	}

	public void testCreateFindCommand4() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd.createFindCommand("order by empno");
		List employees = (List) cmd.execute(null);
		System.out.println(employees);
		assertTrue("1", employees.size() > 0);
	}

	public void testCreateFindBeanCommand() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd.createFindBeanCommand("empno = ?");
		Employee employee = (Employee) cmd.execute(new Object[] { new Integer(
				7788) });
		System.out.println(employee);
		assertNotNull("1", employee);
	}

	public void testCreateObjectBeanCommand() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd
				.createFindObjectCommand("select count(*) from emp");
		Integer count = (Integer) cmd.execute(null);
		assertEquals("1", 14, count.intValue());
	}

	public void testSelectAutoByQuery() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SqlCommand cmd = (SqlCommand) dmd.getSqlCommand("getEmployeesBySal");
		List employees = (List) cmd.execute(new Object[] { new Integer(0),
				new Integer(1000) });
		System.out.println(employees);
		assertEquals("1", 2, employees.size());
	}
	
	public void testRelation() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(Employee2Dao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);

		SqlCommand cmd = dmd.getSqlCommand("getAllEmployees");
		List emps = (List) cmd.execute(null);
		System.out.println(emps);
		assertTrue("1", emps.size() > 0);
	}
	
	public void testGetDaoInterface() throws Exception {
		assertEquals("1", EmployeeDao.class, DaoMetaDataImpl.getDaoInterface(EmployeeDao.class));
		assertEquals("2", EmployeeDao.class, DaoMetaDataImpl.getDaoInterface(EmployeeDaoImpl.class));
	}
	
	public void testAutoSelectSqlByDto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd
				.getSqlCommand("getEmployeesBySearchCondition");
		assertNotNull("1", cmd);
		System.out.println(cmd.getSql());
		EmployeeSearchCondition dto = new EmployeeSearchCondition();
		dto.setDname("RESEARCH");
		List employees = (List) cmd.execute(new Object[]{dto});
		assertTrue("2", employees.size() > 0);
	}
}