package org.seasar.dao.interceptors;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

/**
 * @author higa
 *  
 */
public class S2DaoInterceptor extends AbstractInterceptor {

	private DaoMetaDataFactory daoMetaDataFactory_;

	public S2DaoInterceptor(DaoMetaDataFactory daoMetaDataFactory) {
		daoMetaDataFactory_ = daoMetaDataFactory;
	}

	/**
	 * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Method method = invocation.getMethod();
		if (!MethodUtil.isAbstract(method)) {
			return invocation.proceed();
		}
		Class targetClass = getTargetClass(invocation);
		Class daoInterface = DaoMetaDataImpl.getDaoInterface(targetClass);
		DaoMetaData dmd = daoMetaDataFactory_.getDaoMetaData(daoInterface);
		SqlCommand cmd = dmd.getSqlCommand(method.getName());
		return cmd.execute(invocation.getArguments());
	}
}