/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.ResourceUtil;

public final class DbmsManager {
    private static Map dbmses_ = new HashMap();

    static {
        Properties dbmsClassNames = ResourceUtil.getProperties((String)"dbms.properties");
        Iterator<Object> i = dbmsClassNames.keySet().iterator();
        while (i.hasNext()) {
            String productName = (String)i.next();
            Dbms dbms = (Dbms)ClassUtil.newInstance((String)dbmsClassNames.getProperty(productName));
            dbmses_.put(productName, dbms);
        }
    }

    private DbmsManager() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dbms getDbms(DataSource dataSource) {
        Dbms dbms = null;
        Connection con = DataSourceUtil.getConnection((DataSource)dataSource);
        try {
            DatabaseMetaData dmd = ConnectionUtil.getMetaData((Connection)con);
            dbms = DbmsManager.getDbms(DatabaseMetaDataUtil.getDatabaseProductName((DatabaseMetaData)dmd));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ConnectionUtil.close((Connection)con);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ConnectionUtil.close((Connection)con);
        return dbms;
    }

    public static Dbms getDbms(String productName) {
        Dbms dbms = (Dbms)dbmses_.get(productName);
        if (dbms == null) {
            dbms = (Dbms)dbmses_.get("");
        }
        return dbms;
    }
}

