/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview;

import java.io.File;
import java.io.IOException;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

/**
 * Cleanup temp files
 * 
 * @author Yu Tang
 */
public class TempFileCleaner {

    private static final String LOG_FILE_NAME = "FilePreviewTempFiles.log";
    private static final File logFile;

    private TempFileCleaner() { /* not allow instanciation. static only. */ }

    static {
        logFile = new File(StaticUtils.getConfigDir(), LOG_FILE_NAME);
    }
    
    public static void cleanup() {
        // load temp file list from log file
        String[] list = readTempFileList().split("\\n");
        String content = "";

        // try to delete them
        for (String path: list) {
            if (! path.isEmpty()) {
                File f = new File(path);
                if (f.isFile()) {
                    if (! f.delete()) {
                        f.deleteOnExit();
                        content += path + "\n";
                    }
                }
            }
        }

        // save back to log file or delete log if empty
        writeTempFileList(content);
    }

    public static void addToList(String[] filePaths) {
        // load temp file list from log file
        String list = readTempFileList();
        
        // add the file to the list
        for (String path: filePaths)
            list += path + "\n";

        // save back to log file or delete log if empty
        writeTempFileList(list);
    }

    // 末尾改行付きのリストを返します。
    private static String readTempFileList() {
        String ret = "";
        if (logFile.isFile()) {
            try {
                ret = FileUtil.readTextFile(logFile);
                if (!ret.isEmpty() && !ret.endsWith("\n"))
                    ret += "\n";
            } catch (IOException ex) {
                Log.log(ex);
            }            
        }
        return ret;
    }

    private static void writeTempFileList(final String content) {
        if (content.isEmpty()) {
            if (logFile.isFile())
                logFile.delete();
        } else {
            try {
                FileUtil.writeTextFile(logFile, content);
            } catch (IOException ex) {
                Log.log(ex);
            }            
        }
    }
}
