package jp.unsf.ics.soft.jig;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SizedConcurrentLinkedQueue<E> extends ConcurrentLinkedQueue<E> {
	private static final long serialVersionUID = 1446489790904782819L;
	private int limitSize;
	public SizedConcurrentLinkedQueue(int limitSize){
		super();
		this.limitSize = limitSize;
	}
	@Override
	public boolean add(E e){
		boolean ret = super.add(e);
		while(super.size() > this.limitSize){
			super.poll();
		}
		return ret;
	}
	
	@SuppressWarnings("unchecked")
	public E get(int index){
		if(super.size() < (index+1)) return null;
		return (E)(super.toArray()[super.size() - 1 - index]); // tɓ邽
	}
}
