package jp.unsf.ics.soft.jig;

import static java.lang.Math.abs;
import static java.lang.Math.acos;
import static java.lang.Math.cos;
import static java.lang.Math.sin;

import java.util.Calendar;
import java.util.Locale;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.view.View;

public class LocationTestActivity extends Activity implements LocationListener {

	int calcInterval = 1;
	int measureInterval = 1;
	volatile Location nowLoc = null;
	int ave[] = { 30, 45, 60, 90, 120 };
	SizedConcurrentLinkedQueue<Location> listLoc = new SizedConcurrentLinkedQueue<Location>(ave[ave.length - 1] / measureInterval + 5);
	private LocationManager gpsLocationManager;
	private LocationManager netLocationManager;
	//static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);

	MainApplication app;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d("LocationTestActivity.onCreate", "create1");
		
		super.onCreate(savedInstanceState);

		// Ôߏɏ
		app = (MainApplication) this.getApplication();
		setContentView(R.layout.main);

		// 2dNh~
		if (!app.getFirstTicket(this)) {
			finish();
			return;
		}
		
		Log.d("LocationTestActivity.onCreate", "create2");
		
		// GPSNETWORK̈ʒuvoC_̍쐬ƒI擾˗
		gpsLocationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
		netLocationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
		if (gpsLocationManager != null) {
			gpsLocationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, measureInterval * 1000 * 0, 1, this);
		}else{
			Log.w("LocationTestActivity.onCreate", "gpsLocationManager is NULL.");
		}
		if (netLocationManager != null) {
			netLocationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, measureInterval * 1000 * 0, 1, this);
		}else{
			Log.w("LocationTestActivity.onCreate", "netLocationManager is NULL.");
		}

		// ʃXbhśAYɎ~߂Ȃ邩烏VbgI[Ŏs
		if (app.getOneShotTicket(this.getClass().getName() + "@THREAD")) {
			new Handler().postDelayed(calcFunc, 1);
			new Handler().postDelayed(measureFunc, 1);
		} else {
			Log.e("LocationTestActivity.onCreate", "Cannot run thread. Need rerun.");
		}
	}

	@Override
	public void onDestroy() {
		// ʒuvoC_ɒI擾x~̂m点𑗂
		if (gpsLocationManager != null) {
			gpsLocationManager.removeUpdates(this);
		}
		if (netLocationManager != null) {
			netLocationManager.removeUpdates(this);
		}
		Log.d("LocationTestActivity.onDestroy","destroy");
		
		// 2dNh~
		app.disposeTicket(this);
		
		super.onDestroy();
	}

	@Override
	protected void onResume() {
		super.onResume();
	}

	@Override
	protected void onPause() {
		// gтX[v悤Ał͈ʒu擾pēd͏B
		super.onPause();
	}


	@Override
	public void onLocationChanged(Location location) {
		//if(nowLoc!=null) Log.d("LocationTestActivity.onLocationChanged:nowLoc", nowLoc.toString());
		//Log.d("LocationTestActivity.onLocationChanged:location", location.toString());
		synchronized (app.sync_) { // location.getTime()ÂłAonchangȅ񂪍ŐVƑ
			// Ԃ񂱂AGPSNETWORKǂǂM邩̊́B
			if (nowLoc == null
					|| (location.getAccuracy() < getDistance(location, nowLoc) 
							|| ((-0.5 < (location.getTime() - nowLoc.getTime())) && (location.getAccuracy() <= nowLoc.getAccuracy())) 
							|| ((0.0 <= (location.getTime() - nowLoc.getTime())) && location.getProvider().equals(nowLoc.getProvider())))) {
				nowLoc = location;
				Log.d("LocationTestActivity.onLocationChanged", "kakikae!");
			}
		}
		//Log.d("LocationTestActivity.onLocationChanged:nowLoc", nowLoc.toString());
	}

	@Override
	public void onProviderDisabled(String provider) {
		//superȂ
	}

	@Override
	public void onProviderEnabled(String provider) {
		//superȂ
	}

	@Override
	public void onStatusChanged(String provider, int status, Bundle extras) { 
		switch (status) {
			case LocationProvider.AVAILABLE:
				break;
			case LocationProvider.OUT_OF_SERVICE:
				break;
			case LocationProvider.TEMPORARILY_UNAVAILABLE:
				break;
		}
	}


	// IɌvZAʒm̈ɕ\XbhB[sƎ~܂ȂB
	private final Runnable calcFunc = new Runnable() {
		@Override
		public void run() {
			//Log.d("calcFunc", "run");
			synchronized(app.sync_){
				String text = "";
				String text2 = "";
				boolean existAvedata = false;
				for (int i : ave) { // ϑx擾ԊuŁAߋ̑ʌʂ𓾂
					text += "/" + i;
					Location loc = listLoc.get(i / measureInterval);
					if (loc != null) {
						existAvedata = true;
						text2 += "/" + String.format(Locale.getDefault(), "%03.1f", getKmph(nowLoc, loc, i));
					} else {
						text2 += "/" + "-.-";
					}
				}
				if(existAvedata){
					text = text.substring(1) + "sec:" + text2.substring(1) + " km/h";
				} else if (nowLoc != null) { // ܂ʌʂ\ɂ܂ĂȂA݂̑ʌʂ͂
					text = "Speed: " + String.format(Locale.getDefault(), "%03.1f km/h", nowLoc.getSpeed());
				} else {
					text = "vc"; // 1onChangeȂꍇB
				}
				String nowProvider = nowLoc == null ? "---" : nowLoc.getProvider();
				setIntent("ϑx", "Average speed (" + nowProvider.toUpperCase(Locale.US) + ")", text, false);// ʒm̈\
			}
			new Handler().postDelayed(calcFunc, calcInterval * 1000); // ēxo^
		}
	};

	// IɈʒui[XbhB[sƎ~܂ȂB
	// calcFuncƕs邽ߔr͐TdɁB
	private final Runnable measureFunc = new Runnable() {
		@Override
		public void run() {
			//Log.d("measureFunc", "run");
			synchronized(app.sync_){
				if (nowLoc != null) { // measureInterval̍ŐVɂ炸AŐVf[^𗘗p
					listLoc.add(nowLoc);
				}
			}
			new Handler().postDelayed(measureFunc, measureInterval * 1000); // ēxo^
		}
	};

	
	Intent intent = null;
	PendingIntent contentIntent = null;
	Bitmap largeIcon = null;
	NotificationCompat.Builder builder = null;
	NotificationManager manager = null;
	
	protected void setIntent(String ticker, String title, String text, boolean notification) {
		synchronized(this){
			if(intent == null){ // 1񂾂쐬
				intent = new Intent(LocationTestActivity.this, LocationTestActivity.class);
				//contentIntent = PendingIntent.getBroadcast(LocationTestActivity.this, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);
				contentIntent = PendingIntent.getActivity(LocationTestActivity.this, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);
				largeIcon = BitmapFactory.decodeResource(getResources(), R.drawable.ic_launcher); // AhChRcd@Nł̂낤I
				 builder = new NotificationCompat.Builder(getApplicationContext());
				 manager = (NotificationManager) getSystemService(Service.NOTIFICATION_SERVICE);
			}
		}
		builder.setContentIntent(contentIntent);
		builder.setTicker(ticker);
		builder.setSmallIcon(R.drawable.ic_launcher);
		builder.setContentTitle(title);
		builder.setContentText(text);
		builder.setLargeIcon(largeIcon);
		builder.setWhen(0); // tƍXV, 0ŕ\\
		builder.setOngoing(true);
		if (notification) { // uU[邹
			builder.setDefaults(Notification.DEFAULT_SOUND | Notification.DEFAULT_VIBRATE | Notification.DEFAULT_LIGHTS);
		}
		builder.setAutoCancel(false);// ^bvĂȂ
		manager.notify(0, builder.build());
	}
	
	// Q_Ԃ̑xijvZBvZ̎ԊԊuLocation𗘗pB
	protected double getKmph(Location l1, Location l2) {
		return  getKmph(l1, l2, abs(l1.getTime() - l2.getTime()) / 1000.0);
	}

	// Q_Ԃ̑xijvZBvZ̎ԊԊu͕bŎw肷B
	protected double getKmph(Location l1, Location l2, double interval) {
		if (interval == 0.0) {
			return 0.0;
		} else {
			return getDistance(l1, l2) * 60.0 * 60.0 / interval / 1000.0;
		}
	}
	
	// Q_Ԃ̋nkɉČvZBn͊ŚBPʂm
	private static double getDistance(Location l1, Location l2) {
		double theta = l1.getLongitude() - l2.getLongitude();
		double dist = rad2deg(acos(sin(deg2rad(l1.getLatitude())) * sin(deg2rad(l2.getLatitude())) + cos(deg2rad(l1.getLatitude())) * cos(deg2rad(l2.getLatitude())) * cos(deg2rad(theta)))) * 60 * 1.1515 * 1.609344;
		return dist * 1000.0;
	}

	// WAxɁB
	private static double rad2deg(double radian) {
		return radian * (180f / Math.PI);
	}

	// xWAɁB
	private static double deg2rad(double degrees) {
		return degrees * (Math.PI / 180f);
	}
	
	/*
	// fobOp
	private String getString(Location loc){
		StringBuilder sb = new StringBuilder();
		sb.append(":");
		sb.append(loc.getProvider());
		sb.append(",");
		sb.append(":");
		sb.append(String.format(Locale.US, "%03.8f", loc.getLatitude()));
		sb.append(",");
		sb.append("o:");
		sb.append(String.format(Locale.US, "%03.8f", loc.getLongitude()));
		sb.append(",");
		sb.append(":");
		sb.append(String.format(Locale.US, "%03.2f", loc.getAccuracy()));
		sb.append(",");
		sb.append(":");
		sb.append(sdf.format(loc.getTime()));
		return sb.toString();
	}
	*/

	public void onClick(View v) {
		switch(v.getId()){
			case R.id.imageView1:
				break;
			case R.id.textView1: // Easter egg
				View imageVeew1 = this.getWindow().getDecorView().findViewById(R.id.imageView1);
				if(imageVeew1.getVisibility() == View.VISIBLE) imageVeew1.setVisibility(View.INVISIBLE); 
				else imageVeew1.setVisibility(View.VISIBLE);
				break;
			default:
				break;
		}  
	}
}