#include<stdio.h>
#include<zlib.h>

#define IN_BUF_SIZE 65536
#define OUT_BUF_SIZE 65536

static unsigned char in_buf[IN_BUF_SIZE];
static unsigned char out_buf[OUT_BUF_SIZE];

static void usage(char *command) {

    fprintf(stderr, "%s [-option] output_file input_file ...\n", command);
    return;
}
 
static void parse_option(char *option) {
    return;
}

static int read_input(unsigned char *in_buf, size_t in_buf_size, 
    FILE *in_fp, size_t *in_data_size) {

    size_t data_size;

    data_size = fread(in_buf, sizeof(unsigned char), in_buf_size, in_fp);
    if (data_size != in_buf_size) {
        if ((feof(in_fp) == 0) || (ferror(in_fp) != 0)) {
            fprintf(stderr, "error: fread()\n");
            return -1;
        }
    }
    (*in_data_size) = data_size; 
    return 0;
}

static int write_output(unsigned char *out_buf, 
    size_t out_data_size, FILE *out_fp) {

    size_t data_size;

    data_size = fwrite(out_buf, sizeof(unsigned char), 
        out_data_size, out_fp);
    if (data_size != out_data_size) {
        fprintf(stderr, "error: fwrite()\n");
        return -1;
    }
    return 0;
}

static int deflate_no_flush(z_stream *stream, FILE *in_fp, FILE *out_fp) {

    int zlib_ret, ret = 0, is_finish = 0;
    size_t in_data_size; 

    stream->next_out = out_buf;
    stream->avail_out = OUT_BUF_SIZE;
    stream->next_in = in_buf;
    stream->avail_in = 0;

    for(; (is_finish == 0);) {
        zlib_ret = deflate(stream, Z_NO_FLUSH);
        switch(zlib_ret) {
        case Z_OK:
            break;
        case Z_BUF_ERROR:
            if (stream->avail_out == 0) {
                ret = write_output(out_buf, OUT_BUF_SIZE, out_fp);
                if (ret != 0) {
                    goto err;
                }
                printf("success: write_output() %dbytes\n", OUT_BUF_SIZE);
                stream->next_out = out_buf;
                stream->avail_out = OUT_BUF_SIZE;
            }
            else if (stream->avail_in == 0) {
                ret = read_input(in_buf, IN_BUF_SIZE, 
                    in_fp, &in_data_size);
                if (ret != 0) {
                    goto err;
                }
                if (in_data_size == 0) {
                    is_finish = 1;
                }
                stream->next_in = in_buf;
                stream->avail_in = in_data_size;
            }
            else {
                fprintf(stderr, "error: deflate()\n");
                ret = -1;
                goto err;
            }
            break;
        default:
            fprintf(stderr, "error: deflate() zlib_ret=%d\n", zlib_ret);
            ret = -1;
            goto err;
        }
    }

err:
    return ret;
}

static int deflate_finish(z_stream *stream, FILE *out_fp) {

    int zlib_ret, ret = 0, is_finish = 0;

    for(; (is_finish == 0);) {
        zlib_ret = deflate(stream, Z_FINISH);
        switch(zlib_ret) {
        case Z_STREAM_END:
            ret = write_output(out_buf, 
                (OUT_BUF_SIZE - stream->avail_out), out_fp);
            if (ret != 0) {
                goto err;
            }
            printf("success: write_output() %dbytes\n", 
                (OUT_BUF_SIZE - stream->avail_out));
            is_finish = 1;
            break;
        case Z_BUF_ERROR:
            if (stream->avail_out == 0) {
                ret = write_output(out_buf, OUT_BUF_SIZE, out_fp);
                if (ret != 0) {
                    goto err;
                }
                printf("success: write_output() %dbytes\n", 
                    OUT_BUF_SIZE);
                stream->next_out = out_buf;
                stream->avail_out = OUT_BUF_SIZE;
            }
            else {
                fprintf(stderr, "error: deflate()\n");
                ret = -1;
                goto err;
            }
            break;
        default:
            fprintf(stderr, "error: deflate() zlib_ret=%d\n", zlib_ret);
            ret = -1;
            goto err;
        }
    }

err:
    return ret;
}

int main(int argc, char *argv[]) {

    int ret = 0, zlib_ret;
    z_stream stream;
    char *in_file, *out_file;
    FILE *in_fp = NULL, *out_fp = NULL;
    int argv_index;

    if (argc < 2) {
        usage(argv[0]);
        ret = -1;
        goto err;
    }

    argv_index = 1;
    if (argv[argv_index][0] == '-') {
        parse_option(&argv[argv_index][1]);
        argv_index++;
    }

    if (argc < argv_index + 2) {
        usage(argv[0]);
        ret = -1;
        goto err;
    }

    stream.zalloc = Z_NULL;
    stream.zfree = Z_NULL;
    zlib_ret = deflateInit(&stream, Z_DEFAULT_COMPRESSION);
    if (zlib_ret != Z_OK) {
        fprintf(stderr, "error: deflateInit() ret=%d\n", ret);
        ret = -1;
        goto err;
    }
    printf("success: deflateInit()\n");

    out_file = argv[argv_index];
    argv_index++;
    out_fp = fopen(out_file, "wb");
    if (out_fp == NULL) {
        fprintf(stderr, "error: fopen()\n");
        ret = -1;
        goto err;
    }
    in_file = argv[argv_index];
    argv_index++;
    in_fp = fopen(in_file, "rb");
    if (in_fp == NULL) {
        fprintf(stderr, "error: fopen()\n");
        ret = -1;
        goto err;
    }

    ret = deflate_no_flush(&stream, in_fp, out_fp);
    if (ret != 0) {
        goto err;
    }

    ret = deflate_finish(&stream, out_fp);
    if (ret != 0) {
        goto err;
    }

    zlib_ret = deflateEnd(&stream);
    if (zlib_ret != Z_OK) {
        fprintf(stderr, "error: deflateEnd() ret=%d\n", ret);
        ret = -1;
        goto err;
    }
    printf("success: deflateEnd()\n");

err:
    if (in_fp != NULL) {
        fclose(in_fp);
        in_fp = NULL;
    }
    if (out_fp != NULL) {
        fclose(out_fp);
        out_fp = NULL;
    }
    return ret;
}

