/*
 * Ȥ줿ƥȤ鸡Ԥ
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <anthy/filemap.h>
#include <anthy/textdict.h>
#include "dic_main.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif

#include "anthy/settings.h"		/* Patched by G-HAL, Tue,28 Oct,2008 */
#include "anthy/filemap.h"
#include "anthy/textdict.h"
#include "dic_main.h"
#endif

struct textdict {
  char *fn;
  char *ptr;
  struct filemapping *mapping;
};

struct textdict *
anthy_textdict_open(const char *fn, int create)
{
  struct textdict *td = (struct textdict*) malloc(sizeof(struct textdict));
  if (!td) {
    return NULL;
  }
  td->fn = strdup(fn);
  if (!td->fn) {
    free(td);
    return NULL;
  }
  td->mapping = NULL;
  return td;
}


static void
unmap(struct textdict *td)
{
  if (td->mapping) {
    anthy_munmap(td->mapping);
    td->mapping = NULL;
  }
}

void
anthy_textdict_close(struct textdict *td)
{
  if (!td) {
    return ;
  }
  unmap(td);
  free(td->fn);
  free(td);
}

static int
update_mapping(struct textdict *td)
{
  if (td->mapping) {
    anthy_munmap(td->mapping);
  }
  td->mapping = anthy_mmap(td->fn, 1);
  if (!td->mapping) {
    td->ptr = NULL;
    return 1;
  }
  td->ptr = (char*) anthy_mmap_address(td->mapping);
  return 0;
}

static int
expand_file(struct textdict *td, int len)
{
  FILE *fp;
  char buf[256];
  int c;
 #if 0		/* Patched by G-HAL, Tue,28 Oct,2008, Tue,17 May,2011 */
  fp = fopen(td->fn, "a+");
  if (!fp) {
    return -1;
  }
 #else
  const int fd_flags = (O_WRONLY | O_APPEND | O_CREAT | O_EXLOCK);
  const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
  const int fd = open( td->fn, fd_flags, fd_mode );
  if (fd < 0) {
    return -1;
  }
  fp = fdopen( fd, "a" );
  if (NULL == fp) {
    close( fd );
    return -1;
  }
 #endif
  memset(buf, '\n', 256);
  c = 1;
  if (len > 256) {
    c *= fwrite(buf, 256, len / 256, fp);
  }
  if (len % 256) {
    c *= fwrite(buf, len % 256, 1, fp);
  }
  fclose(fp);
  if (c == 0) {
    return -1;
  }
  return 0;
}

void
anthy_textdict_scan(struct textdict *td, int offset, void *ptr,
		    int (*fun)(struct textdict * td, int offset, const char *sc, int (*gang_scan)(void *p, int offset, const char *key, const char *n)))
{
  FILE *fp;
  char buf[1024];
  if (!td) {
    return ;
  }
  fp = fopen(td->fn, "r");
  if (!fp) {
    return ;
  }
  if (fseek(fp, offset, SEEK_SET)) {
    fclose(fp);
    return ;
  }
  while (fgets(buf, 1024, fp)) {
    char *p = strchr(buf, ' ');
    int len, r;
    len = strlen(buf);
    offset += len;
   #if 0	/* Patched by G-HAL, Wed,07 Oct,2009 */
    buf[len - 1] = 0;
   #else
    if ((0 < len) && (len < (sizeof(buf)/sizeof(buf[0])))) {
      switch (buf[len - 1]) {
      case '\r':
      case '\n':
	buf[len - 1] = '\0';
	break;
      }
    } else {
      buf[0] = '\0';
    }
   #endif
    if (!p) {
      continue;
    }
    *p = 0;
    p++;
    while (*p == ' ') {
      p++;
    }
    /* call it */
    r = fun(ptr, offset, buf, p);
    if (r) {
      break;
    }
  }
  fclose(fp);
}

int
anthy_textdict_delete_line(struct textdict *td, int offset)
{
  FILE *fp;
  char buf[1024];
  int len, size;
  fp = fopen(td->fn, "r");
  if (!fp) {
    return -1;
  }
  if (fseek(fp, offset, SEEK_SET)) {
    fclose(fp);
    return -1;
  }
  if (!fgets(buf, 1024, fp)) {
    fclose(fp);
    return -1;
  }
  len = strlen(buf);
  fclose(fp);
  update_mapping(td);
  if (!td->mapping) {
    return -1;
  }
  size = anthy_mmap_size(td->mapping);
  memmove(&td->ptr[offset], &td->ptr[offset+len], size - offset - len);
  unmap(td);
  if (size - len == 0) {
    unlink(td->fn);
    return 0;
  }
  truncate(td->fn, size - len);
  return 0;
}

int
anthy_textdict_insert_line(struct textdict *td, int offset,
			   const char *line)
{
  int len = strlen(line);
  int size;
  if (!td) {
    return -1;
  }
  if (expand_file(td, len)) {
    return -1;
  }
  update_mapping(td);
  size = anthy_mmap_size(td->mapping);
  memmove(&td->ptr[offset+len], &td->ptr[offset], size - offset - len);
  memcpy(&td->ptr[offset], line, len);
  return 0;
}
/* vim:ts=8 sw=2 nomodified:
 */
