/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ؽǡ
 *@date		Wed,27 Aug,2008 - Fri,29 Aug,2008
 *@date		Mon,13 Oct,2008
 *@date		Fri,17 Oct,2008
 *@date		Wed,22 Oct,2008 - Thu,23 Oct,2008
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 *@note
 *		record.c ưPatched by G-HAL
 */
#ifndef _record_sub_h_included_
#define _record_sub_h_included_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include "anthy/settings.h"
#include "anthy/xstr.h"
#include "anthy/alloc.h"
#include "src-worddic/dic_main.h"

#ifdef __cplusplus
extern "C" {
#endif


enum val_type {
	RT_EMPTY,
	RT_VAL,
	RT_INT64,				/* Patched by G-HAL, Wed,22 Oct,2008 */
	RT_XSTR,
	RT_XSTRP
};

/*  */
struct record_val {
	enum val_type type;
	union {
		xstr str;
		int val;
		xstr* strp;
		int64_t	int64;		/* Patched by G-HAL, Wed,22 Oct,2008 */
	} u;
};

/*  */
struct record_row {
	xstr key;
	int nr_vals;
	struct record_val *vals;
	size_t max_nr_vals;	/* Patched by G-HAL, Mon,13 Oct,2008 */
};

/* trie node */
struct trie_node {
	struct trie_node *l;
	struct trie_node *r;
	int bit;
	struct record_row row;
	struct trie_node *lru_prev, *lru_next; /* ξü롼 */
	int dirty; /* LRU Τ used, sused ӥå */
	anthy_time_t	timestamp;	/* ޴Υ Patched by G-HAL, Fri,22 Aug,2008, Sun,19 Oct,2008 */
	int		frequency;	/* ޴Υ Patched by G-HAL, Fri,22 Aug,2008 */
};

/* trie treeroot */
struct trie_root {
	struct trie_node root;
	allocator node_ator;
	size_t default_nr_num;			/* Patched by G-HAL, Fri,17 Oct,2008 */
};

#define LRU_USED  UINT8_C(0x01)
#define LRU_SUSED UINT8_C(0x02)
#define PROTECT   UINT8_C(0x04) /* ʬ񤭽Ф˻Ȥ(LRUȤϴطʤ)
*   ʬ񤭽ФǤϡե˽񤭽Ф
*   ե¾ΥץϿ
*   ɤ߹ࡣˤäơ줫ɲä
*   ȤΡɤäΤɤ
*/
/*
* LRU:
*   USED:  ǻȤ줿
*   SUSED: ¸줿 used ӥå
*
* LRUꥹȾǤϡ USED ɬꥹƬ¤Ǥ뤬 SUSED 
* ե饰ʤΥΡɤȺߤƤǽ롣
*
* nĤĤ褦˻ꤵ줿ư
*    1. used > n
*        LRU ꥹȤƬ n ܰʹߤä
*    2. used + sused > n
*        used -> Ĥ
*        sused -> sused ե饰
*        ʳ -> ä
*    3. ʳ
*        ƻĤ
* ե˽񤭽Фˡ used || sused -> sused Ȥƽ񤭽Ф
*/


/**  */
struct record_section {
	/* const char *name; */		/* Patched by G-HAL, Fri,17 Oct,2008 */
	enum ANTHY_SECTIONS_ section;	/* Patched by G-HAL, Fri,17 Oct,2008 */
	size_t default_nr_num;			/* Patched by G-HAL, Fri,17 Oct,2008 */
	size_t inc_nr_num;				/* Patched by G-HAL, Thu,23 Oct,2008 */
	struct trie_root cols;
	struct record_section *next;
	int lru_nr_used, lru_nr_sused; /* LRU  */
};

/** ǡ١ */
struct record_stat {
	struct record_section section_list; /* sectionΥꥹ*/
	struct record_section *cur_section;
	struct trie_root xstrs; /* xstr  intern 뤿 trie */
	struct trie_node *cur_row;
	int row_dirty; /* cur_row ¸ɬפ뤫 */
	int encoding;
	/**/
	int is_anon;
	const char *id;         /* ѡʥƥid */
	char *base_fn; /* ܥե Хѥ */
	char *basebin_fn; /* ܥեʥХʥ Хѥ, Patched by G-HAL, Thu,16 Oct,2008 */
	char *journal_fn; /* ʬե Хѥ */
	/**/
  #if defined(HAVE_FSEEKO)
	off_t baserecord_size;	/* ܥե礭 Patched by G-HAL, Fri,29 Aug,2008 */
  #else
	long baserecord_size;	/* ܥե礭 Patched by G-HAL, Fri,29 Aug,2008, Wed,13 Oct,2010 */
  #endif
	time_t base_timestamp; /* ܥեΥॹ */
	int last_update;  /* ʬեκǸɤ */
	time_t journal_timestamp; /* ʬեΥॹ */
};



static void init_trie_root( struct trie_root* const n );
static int trie_key_nth_bit( xstr* const key, int n );
static int trie_key_cmp( xstr* const k1, xstr* const k2 );
#if 0	/* Patched by G-HAL, Fri,17 Oct,2008 */
static void trie_row_init( struct record_row* const rc );
#else
static void trie_row_init( struct record_row* const rc, size_t nr_num );
#endif
static void trie_row_free( struct record_row* const rc );
static int trie_remove( struct trie_root* const root, xstr* const key, int* const nr_used, int* const nr_sused );
static struct trie_node* trie_first( struct trie_root* const root );
static struct trie_node* trie_next( struct trie_root* const root, struct trie_node* const cur );
static void free_val_contents( struct record_val* const v );
static void trie_remove_all( struct trie_root* const root, int* const nr_used, int* const nr_sused );
static void free_section( struct record_stat* const r, struct record_section* const rs );

static void lock_record( const struct record_stat* const rs );
static void unlock_record( const struct record_stat* const rs );


#ifdef __cplusplus
}
#endif



void init_trie_root( struct trie_root* const root )
{
	struct trie_node* n;
	root->node_ator = anthy_create_allocator(sizeof(struct trie_node), NULL);
	root->default_nr_num = 0;	/* Patched by G-HAL, Fri,17 Oct,2008 */
	n = &root->root;
	n->l = n;
	n->r = n;
	n->bit = 0;
	n->lru_next = n;
	n->lru_prev = n;
	n->dirty = 0;
	trie_row_init( &(n->row), 0);	/* Patched by G-HAL, Fri,17 Oct,2008 */
	n->row.vals = NULL;		/* Patched by G-HAL, Thu,16 Oct,2008 */
	n->row.key.len = -1;
	n->timestamp = 0;		/* Patched by G-HAL, Fri,22 Aug,2008 */
	n->frequency = 0;		/* Patched by G-HAL, Fri,22 Aug,2008 */
	return;
}


/*
 * bit0: 0
 * bit1: headΥ0
 * bit2: ʸΥӥå0
 * bit3: ʸΥӥå1
 *   ...
 * ʸĹۤ0
 */
int trie_key_nth_bit( xstr* const key, int n )
{
	switch (n) {
	case 0:
		return 0;
	case 1:
		return key->len + 1; /* key->len == -1 ? 0 : non-zero */
	default:
		{
			int pos;
			n -= 2;
			pos = n / (sizeof(xchar) << 3);
			if (pos >= key->len) {
				return 0;
			}
			return key->str[pos] & (1 << (n % (sizeof(xchar) << 3)));
		}
	}
}


int trie_key_cmp( xstr* const k1, xstr* const k2 )
{
	if (k1->len == -1 || k2->len == -1) {
		return k1->len - k2->len;
	}
	return anthy_xstrcmp(k1, k2);
}


/*
 * Ρɤ򸫤ĤȺ
 * trie_row_freeƤӡޤǡʬfree
 *
 * ǡȥΡɤ롣
 * оݤΥǡϺоݤΥΡɤ˳ǼƤȤ
 * ¤ʤȤա
 * 1. оݤդĥΡɤ˺оݤդޤޤƤȤ
 *  оݤΥΡɤϡҤؤλޤΤΤޤƤϤƻ
 * 2. оݤդĥΡɤ˺оݤդޤޤƤȤ
 *  1. ˲äơоݤդĥΡɤ򻦤ơ˺
 *  оݤΥΡɤоݤդĥΡɤΰ֤˰ư
 */
int trie_remove( struct trie_root* const root, xstr* const key, int* const nr_used, int* const nr_sused )
{
	struct trie_node *p;
	struct trie_node *q;
	struct trie_node **pp = NULL; /* gcc  warning  */
	struct trie_node **qq;
	p = &root->root;
	qq = &p->l;
	q = *qq;
	while (p->bit < q->bit) {
		pp = qq;
		p = q;
		qq = trie_key_nth_bit(key,p->bit) ? &p->r : &p->l;
		q = *qq;
	}
	if (trie_key_cmp(&q->row.key, key) != 0) {
		return 0;
	}
	if (p != q) {
		/* case 2. */
		struct trie_node *r;
		struct trie_node *s;
		r = &root->root;
		s = r->l;
		while (s != q) {
			r = s;
			s = trie_key_nth_bit(key, r->bit) ? r->r : r->l;
		}
		*pp = (p->r == q) ? p->l : p->r;
		p->l = q->l;
		p->r = q->r;
		p->bit = q->bit;
		if (trie_key_nth_bit(key, r->bit)) {
			r->r = p;
		} else {
			r->l = p;
		}
		p = q;
	} else {
		*pp = (p->r == q) ? p->l : p->r;
	}
	p->lru_prev->lru_next = p->lru_next;
	p->lru_next->lru_prev = p->lru_prev;
	if (p->dirty == LRU_USED) {
		(*nr_used)--;
	} else if (p->dirty == LRU_SUSED) {
		(*nr_sused)--;
	}
	trie_row_free(&p->row);
	anthy_sfree(root->node_ator, p);
	return 1;
}


/* headʳΥΡɤʤ 0 ֤ */
struct trie_node* trie_first( struct trie_root* const root )
{
	return (root->root.lru_next == &root->root) ? NULL : root->root.lru_next;
}


/* ΥΡɤʤ 0 ֤ */
struct trie_node* trie_next( struct trie_root* const root, struct trie_node* const cur )
{
	return (cur->lru_next == &root->root) ? 0 : cur->lru_next;
}


void free_val_contents( struct record_val* const v )
{
	switch (v->type) {
	case RT_XSTR:
		anthy_free_xstr_str(&v->u.str);
		break;
	case RT_XSTRP:
	case RT_VAL:
	case RT_INT64:		/* Patched by G-HAL, Wed,22 Oct,2008 */
	case RT_EMPTY:
	default:
		break;
	}
	return;
}


/*
 * headʳƤΥΡɤ
 * trie_row_freeƤӡޤǡʬfree
 */
void trie_remove_all( struct trie_root* const root, int* const nr_used, int* const nr_sused )
{
	struct trie_node* p;
	for (p = root->root.lru_next; p != &root->root; p = p->lru_next) {
		trie_row_free(&p->row);
	}
	anthy_free_allocator(root->node_ator);
	init_trie_root(root);
	*nr_used = 0;
	*nr_sused = 0;
	return;
}


#if 0		/* Patched by G-HAL, Fri,17 Oct,2008 */
void trie_row_init( struct record_row* const rc )
{
	rc->nr_vals = 0;
	rc->vals = NULL;
	return;
}
#else
void trie_row_init( struct record_row* const rc, size_t nr_num )
{
	rc->nr_vals = 0;
	rc->max_nr_vals = nr_num;
	if (0 < nr_num) {
		rc->vals = (struct record_val*) malloc( sizeof(struct record_val) * nr_num );
	} else {
		rc->vals = NULL;
	}
	return;
}
#endif


void trie_row_free( struct record_row* const rc )
{
	int i;
	for (i = 0; i < rc->nr_vals; i++) {
		free_val_contents(rc->vals + i);
	}
	free(rc->vals);
  #if 0
	rc->nr_vals = 0;		/* Patched by G-HAL, Mon,13 Oct,2008 */
	rc->vals = NULL;		/* Patched by G-HAL, Mon,13 Oct,2008 */
	rc->max_nr_vals = 0;		/* Patched by G-HAL, Mon,13 Oct,2008 */
  #endif
	free(rc->key.str);
	return;
}


/* 륻ΥǡƲ */
void free_section( struct record_stat* const r, struct record_section* const rs )
{
	struct record_section *s;
	trie_remove_all(&rs->cols, &rs->lru_nr_used, &rs->lru_nr_sused);
	if (r->cur_section == rs) {
		r->cur_row = NULL;
		r->cur_section = NULL;
	}
	for (s = &r->section_list; s && s->next; s = s->next) {
		if (s->next == rs) {
			s->next = s->next->next;
		}
	}
  #if 0		/* Patched by G-HAL, Fri,17 Oct,2008 */
	if (rs->name){
		free((void *)rs->name);
	}
  #endif
	free(rs);
	return;
}



static void lock_record( const struct record_stat* const rs )
{
	if (rs->is_anon) {
		return;
	}
	anthy_priv_dic_lock();
	return;
}

static void unlock_record( const struct record_stat* const rs )
{
	if (rs->is_anon) {
		return;
	}
	anthy_priv_dic_unlock();
	return;
}

#endif /* _record_sub_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
