/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ؽǡ
 *@date		Tue,14 Jul,2009 - Wed,15 Jul,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_CTYPE_H)
# include <ctype.h>
#endif

#include "anthy/record.h"
#include "src-worddic/dic_personality.h"
#include "src-worddic/record_sub.inc"	/* extern ̾Τξͤ򤱤١record_sub.c ˤʤä */
#include "src-worddic/record_adjustment.h"



/** ؽǡ᤹
 *@param				timestamp				ʹߤ
 *
 *@attention
 *		ȴǡlast-record2 ˵ϿƤʬޤǤ᤻ʤ
 *
 *@comment
 *	Patched by G-HAL
 *		Tue,14 Jul,2009
 *		Tue,17 May,2011
 */
void anthy_revert_record( anthy_time_t basis_timestamp )
{
	struct record_stat* const	rst = anthy_current_record;
	if (basis_timestamp <= 0) {
		return;
	}
	if (rst) {
		int		need_reload = 0;
		if (rst->is_anon) {
			return;
		}
		lock_record( rst );
		{
			const int fd_flags = (O_RDWR | O_APPEND | O_CREAT | O_EXLOCK);
			const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
			char	buf[BUFSIZ];

			const int	fd = open( rst->journal_fn, fd_flags, fd_mode );
			if (fd < 0) {
				return;
			}
			FILE* const fp = fdopen( fd, "a+" );
			if (NULL == fp) {
				close( fd );
				return;
			}

			while (!feof(fp)) {
			  #if defined(HAVE_FSEEKO)
				const off_t	last_pos = ftello( fp );
			  #else
				const long	last_pos = ftell( fp );
			  #endif
				const char*	ptr = fgets( buf, sizeof(buf), fp );
				if (NULL == ptr) {
					break;
				} else {
					int			token_head = 1;
					int			in_escape  = 0;
					int			in_quote   = 0;
					for (; '\x0' != (*ptr); ++ptr) {
						if (in_escape) {
							in_escape = 0;
							continue;
						}
						switch (*ptr) {
						case '\x0':
						case '\n':
							goto OUT;
						case '\\':
							in_escape = 1;
							break;
						case '\"':
							in_quote = !in_quote;
							break;
						case ' ':
						case '\t':
						case '\r':
							if (in_quote) {
								token_head = 0;
								break;
							}
							token_head = 1;
							break;
						default:
							if (!token_head) {
								break;
							}
							token_head = 0;
							switch (toupper(*ptr)) {
							case 'T':
								{	const anthy_time_t	timestamp = atoll(ptr + 1);
									if (basis_timestamp < timestamp) {
										ftruncate( fd, last_pos );
										need_reload = 1;
										goto FIN;
									}
								}
								goto OUT;
							default:
								break;
							}
							break;
						}
					}
				  OUT:
					;
				}
			}
		  FIN:

			fclose(fp);
		}
		unlock_record( rst );
		if (need_reload) {
			rst->base_timestamp    = 0;
			rst->journal_timestamp = 0;
			rst->last_update = 0;
			anthy_reload_record();
		}
	}
	return;
}
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
