#ifndef _dic_main_h_included_
#define _dic_main_h_included_

#if 0		/* Patched by G-HAL */
#include <anthy/dic.h>
#include <anthy/word_dic.h>
#include <anthy/wtype.h>
#include <anthy/xstr.h>
#else
#include "anthy/dic.h"
#include "anthy/word_dic.h"
#include "anthy/wtype.h"
#include "anthy/xstr.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* ٤Ф٤Ψ */
#define FREQ_RATIO 8


/* dic_main.c */
extern int anthy_init_dic_cache(void);
/* extern struct seq_ent *anthy_cache_get_seq_ent(xstr *x, int is_reverse); */	/* Patched by G-HAL, Fri,17 Oct,2008 */


/* word_dic.c */
/* 񸡺Υ˻Ѥʬʸ */
struct gang_elm {
  char *key;
  xstr xs;
  union {
    /* ʥΤunionˤƤ */
    int idx;
    struct gang_elm *next;
  } tmp;
};
extern struct seq_ent *anthy_cache_get_seq_ent(xstr *xs, int is_reverse);
extern struct seq_ent *anthy_validate_seq_ent(struct seq_ent *seq, xstr *xs,
				       int is_reverse);


/* word_lookup.c */
extern void anthy_init_word_dic(void);
extern struct word_dic* anthy_create_word_dic(void);
extern void anthy_release_word_dic(struct word_dic *wdic);
extern void anthy_gang_fill_seq_ent(struct word_dic *wdic,
			     struct gang_elm **array, int nr,
			     int is_reverse);


/* use_dic.c */
extern void anthy_init_use_dic(void);
extern void anthy_quit_use_dic(void);
extern int anthy_word_dic_search_word_relation_key( struct word_dic* const wdic, int key );	/* Patched by G-HAL, Mon,12 Oct,2009 */
extern int anthy_word_dic_check_word_relation(struct word_dic *wdic,
				       int from, int to);

extern struct dic_session *anthy_create_session(void);
extern int anthy_get_current_session_mask(void);

/* mem_dic.c */
extern void anthy_init_mem_dic(void);
extern void anthy_quit_mem_dic(void);
extern struct mem_dic *anthy_create_mem_dic(void);
extern void anthy_release_mem_dic(struct mem_dic *d);
/* node ʤк */
extern struct seq_ent *anthy_mem_dic_alloc_seq_ent_by_xstr(struct mem_dic *md,
						    xstr *xs, int is_reverse);
/* node ʤкʤ */
extern struct seq_ent *anthy_mem_dic_find_seq_ent_by_xstr(struct mem_dic *md,
						   xstr *xs, int is_reverse);
/**/
extern void anthy_mem_dic_push_back_dic_ent(struct seq_ent *se, int is_compound,
				     xstr *xs, wtype_t wt,
				     const char *wt_name, int freq,
				     int feature);
extern void anthy_mem_dic_release_seq_ent(struct mem_dic *md, xstr *xs, int is_reverse);


/* priv_dic.c */
extern void anthy_init_private_dic(const char *id);
extern void anthy_copy_words_from_private_dic(struct seq_ent *seq, xstr *xs,
				       int is_reverse);
extern void anthy_release_private_dic(void);
extern void anthy_check_user_dir(void);
extern void anthy_priv_dic_lock(void);
extern void anthy_priv_dic_unlock(void);
extern void anthy_priv_dic_update(void);
struct word_line {
  char wt[10];
  int freq;
  const char *word;
};
extern int anthy_parse_word_line(const char *line, struct word_line *res);
struct textdict;
extern void anthy_ask_scan(void (*request_scan)(struct textdict *td, void *arg),
		    void *arg);


#ifdef __cplusplus
}
#endif

#endif /* _dic_main_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
