/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	metawordmetaword
 *@date		Thu,29 Jan,2009
 *@date		Sun,12 Apr,2009 - Mon,13 Apr,2009
 *@date		Fri,01 May,2009
 *@date		Tue,19 May,2009 - Wed,20 May,2009
 *@date		Sun,07 Jun,2009
 *@date		Wed,30 Jun,2010
 *@date		Mon,09 Aug,2010
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@date		Fri,07 Oct,2011
 *@author	Copyright(C)2008-2011 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#include "anthy/settings.h"
#include "anthy/anthy.h"
#include "anthy/logger.h"
#include "src-splitter/metaword.h"
#include "src-worddic/dic_ent.h"



/** mw->wl  cand_arg ʬʸȤƻäƤ뤫ݤȽꤹ
 *@param[in]		cand_arg			ӴʸѴ
 *@param[in]		mw					оݤ mw
 *@param[in]		yomi_all			оݤΤߤʡϤߤʡmwʬޤ
 *@param[in,out]	cmped_cand_len		ȽꤷĹ߷סѴ
 *@param[in]		part_num			٤ mw->wl->part ΰֹ
 *@param			have_mw2			ꤷ mw ³ mw (1)(0)
 *@retval			0					
 *@retval			1					
 *
 *	Patches by G-HAL
 *		Sun,12 Apr,2009 - Mon,13 Apr,2009
 *		Wed,20 May,2009
 *		Wed,30 Jun,2010
 *		Mon,09 Aug,2010
 *		Fri,07 Oct,2011
 *
 *@note
 *	Ǥ Anthy ߷פǤϡ
 *	ʸڤλǤ϶ŪѴʤͤˤʤäƤ롣
 *	ʤ餳δؿǤϡmw ŪѴ䤬
 *	cand ޤफɤȽꤹ٤ˡ
 *	虜虜ѴʤФʤʤ
 *
 *@attention
 *	wl ʣѥʸġ
 *	Τɤ줫ѥǤפп֤
 */
static int mwwl_is_match_xstr( const xstr* const cand_arg, const struct meta_word* const mw, const xchar* const yomi_all, int* const cmped_cand_len, int part_num, int have_mw2 )
{
  #if defined(DEBUG)
	assert( NULL != cand_arg );
	assert( NULL != mw );
	assert( NULL != yomi_all );
	assert( NULL != cmped_cand_len );
  #endif

	if (mw->nr_parts <= part_num) {
		if (cand_arg->len <= 0) {
			return 1;
		} else {
			return have_mw2 ? 1 : 0;
		}
	}

	{
		const struct part_info* const part = &(mw->wl->part[part_num]);
		const struct seq_ent* const s = part->seq;
		xstr cand;
		xstr tmp1;
		xstr tmp2;
		if (part->len <= 0) {
			return mwwl_is_match_xstr( cand_arg, mw, yomi_all, cmped_cand_len, part_num + 1, have_mw2 );
		}
		if (s) {
		  #if 0		/* Patched by G-HAL, Fri,07 Oct,2011 */
			const wtype_t wt = anthy_get_wtype_with_ct( part->wt, CT_NONE );
		  #else
			wtype_t wt;
			anthy_get_wtype_with_ct( &wt, part->wt, CT_NONE );
		  #endif
			int j;
			for (j = 0; j < s->nr_dic_ents; ++j) {
				const struct dic_ent* const	de = s->dic_ents[j];
				if (!anthy_wtype_include(wt, de->type)) {
					continue;
				}
				tmp1 = *cand_arg;
				tmp2 = de->str;
				if (tmp1.len <= tmp2.len) {
					tmp2.len = tmp1.len;
				} else {
					tmp1.len = tmp2.len;
				}
				if (0 == anthy_xstrcmp( &tmp1, &tmp2 )) {
					int tmp_len = tmp2.len;
					cand.len = cand_arg->len - tmp2.len;
					cand.str = cand_arg->str + tmp2.len;
					if (mwwl_is_match_xstr( &cand, mw, yomi_all, &tmp_len, part_num + 1, have_mw2 )) {
						*cmped_cand_len += tmp_len;
						return 1;
					}
				}
			}
		} else {
			tmp1 = *cand_arg;
			tmp2.len = part->len;
			tmp2.str = (xchar*)(&(yomi_all[part->from]));
			if (tmp1.len <= tmp2.len) {
				tmp2.len = tmp1.len;
			} else {
				tmp1.len = tmp2.len;
			}
			if (0 == anthy_xstrcmp( &tmp1, &tmp2 )) {
				int tmp_len = tmp2.len;
				cand.len = cand_arg->len - tmp2.len;
				cand.str = cand_arg->str + tmp2.len;
				if (mwwl_is_match_xstr( &cand, mw, yomi_all, &tmp_len, part_num + 1, have_mw2 )) {
					*cmped_cand_len += tmp_len;
					return 1;
				}
			}
		}
	}
	return 0;
}


/** mw  cand ʬʸȤƻäƤ뤫ݤȽꤹ
 *@param[in]		cand_arg			ӴʸѴ
 *@param[in]		yomi_arg			Ӵʸʤߤʡ
 *@param[in]		mw					оݤ mw
 *@param[in]		yomi_all			оݤΤߤʡϤߤʡmwʬޤ
 *@param[in,out]	cmped_cand_len		ȽꤷĹ߷סѴ
 *@param			have_mw2			ꤷ mw ³ mw (1)(0)
 *@retval			0					
 *@retval			1					
 *
 *	Patches by G-HAL
 *		Thu,29 Jan,2009
 *		Sun,12 Apr,2009 - Mon,13 Apr,2009
 *		Fri,01 May,2009
 *		Tue,19 May,2009 - Wed,20 May,2009
 *		Mon,09 Aug,2010
 *
 *@attention
 *	mw ʣѥʸľ礬롣
 *	ξϡɤ줫ѥǤפп֤
 *	ɤ߲̾ΰȽϹԤʤ
 */
static int mw_is_match_xstr( const xstr* const cand_arg, const xstr* const yomi_arg, const struct meta_word* const mw, const xchar* const yomi_all, int* const cmped_cand_len, int have_mw2 )
{
  #if defined(DEBUG)
	assert( NULL != cand_arg );
	assert( NULL != yomi_arg );
	assert( NULL != mw );
	assert( NULL != yomi_all );
	assert( NULL != cmped_cand_len );
  #endif

	if ((0 < mw->cand_hint.len) && mw->cand_hint.str) {
		xstr	dst = mw->cand_hint;
		if (cand_arg->len <= dst.len) {
			dst.len = cand_arg->len;
		}
		if (0 != anthy_xstrcmp( cand_arg, &dst )) {
			return 0;
		}
		*cmped_cand_len += dst.len;
		return 1;

	} else {
		xstr	cand     = *cand_arg;
		int		yomi_len = yomi_arg->len;
		xstr	dst_yomi = { .len = mw->len, .str = (&(yomi_all[mw->from])), };
		if (mw->wl && (0 < mw->wl->len)) {
			yomi_len     -= mw->wl->len;
			dst_yomi.len -= mw->wl->len;
			dst_yomi.str += mw->wl->len;
			if (0 < dst_yomi.len) {
				if (yomi_len <= dst_yomi.len) {
					if (0 < yomi_len) {
						xstr	tmp = { .len = yomi_len, .str = (cand.str + (cand.len - yomi_len)), };
						if (0 != anthy_xstrncmp( &tmp, &dst_yomi, yomi_len )) {
							return 0;
						}
						*cmped_cand_len += yomi_len;
						cand.len     -= yomi_len;
						cand.str     += 0;
					}
				} else {
					char	buf[256];
					anthy_snputxstr(buf, _number_(buf)-1, &cand, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
					anthy_log( 1, "***BUG*** mw_is_match_xstr():mw->wl yomi_len:%d, dst_yomi.len:%d, cand:'%s'\n",
							  yomi_len, dst_yomi.len, buf );
					return 0;
				}
			}
			{	int tmp_len = 0;
				if (!mwwl_is_match_xstr( &cand, mw, yomi_all, &tmp_len, 0, have_mw2 )) {
					return 0;
				}
				*cmped_cand_len += tmp_len;
				return 1;
			}
		} else {
			xstr	src_yomi = *yomi_arg;
			int		cur_have_mw2 = 0;
			if (mw->mw1) {
				yomi_len     -= mw->mw1->len;
				dst_yomi.len -= mw->mw1->len;
				dst_yomi.str += mw->mw1->len;
			}
			if (mw->mw2) {
				yomi_len     -= mw->mw2->len;
				dst_yomi.len -= mw->mw2->len;
				dst_yomi.str += mw->mw2->len;
				cur_have_mw2 = 1;
			}
			if (0 < dst_yomi.len) {
				if (yomi_len <= dst_yomi.len) {
					if (0 < yomi_len) {
						xstr	tmp = { .len = yomi_len, .str = (cand.str + (cand.len - yomi_len)), };
						if (0 != anthy_xstrncmp( &tmp, &dst_yomi, yomi_len )) {
							return 0;
						}
						*cmped_cand_len += yomi_len;
						cand.len     -= yomi_len;
						cand.str     += 0;
						src_yomi.len -= yomi_len;
						src_yomi.str += 0;
					}
				} else {
					char	buf[256];
					anthy_snputxstr(buf, _number_(buf)-1, &cand, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
					anthy_log( 1, "***BUG*** mw_is_match_xstr():mw->mw yomi_len:%d, dst_yomi.len:%d, cand:'%s'\n",
							  yomi_len, dst_yomi.len, buf );
					return 0;
				}
			}
			if (mw->mw1) {
				int tmp_len = 0;
				if (!mw_is_match_xstr( &cand, &src_yomi, mw->mw1, yomi_all, &tmp_len, cur_have_mw2 )) {
					return 0;
				}
				*cmped_cand_len += tmp_len;
				cand.len -= tmp_len;
				cand.str += tmp_len;
				src_yomi.len -= mw->mw1->len;
				src_yomi.str += mw->mw1->len;
			}
			if (mw->mw2) {
				int tmp_len = 0;
				if (!mw_is_match_xstr( &cand, &src_yomi, mw->mw2, yomi_all, &tmp_len, 0 )) {
					return 0;
				}
				*cmped_cand_len += tmp_len;
			}
			return 1;
		}
	}
}


/** mwѴˤ mw0ѴˤʬʸȤƻäƤ뤫ݤȽꤹ
 *@param[in]		yomi_all		ʸϤߤʡmwʬޤ
 *@param[in]		mw0				Ӵ mw
 *@param[in]		mw				оݤ mw
 *@retval			0				
 *@retval			1				
 *
 *	Patches by G-HAL
 *		Wed,20 May,2009
 *
 *@attention
 *	mw ʣѥʸľ礬롣
 *	ξϡɤ줫ѥǤפп֤
 *	ɤ߲̾ΰȽϹԤʤ
 */
int mw_is_match( const xchar* const yomi_all, const struct meta_word* const mw0, const struct meta_word* const mw )
{
	if ((NULL == yomi_all) || (NULL == mw0) || (NULL == mw)) {
		return 0;
	}
	if (mw->len < mw0->len) {
		return 0;
	}
	{	int			cmped_cand_len = 0;
		const xstr	yomi = { .len = mw0->len, .str = (&(yomi_all[mw0->from])), };
		const int	ret = mw_is_match_xstr( &(mw0->cand_hint), &yomi, mw, yomi_all, &cmped_cand_len, 0 );
		if (!ret || (cmped_cand_len < mw0->cand_hint.len)) {
			return 0;
		}
	}
	return 1;
}

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
