/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ʸڤꥢ르ꥺࡧʬ
 *@date		Wed,05 Nov,2008
 *@date		Sun,16 Nov,2008
 *@date		Tue,18 Nov,2008
 *@date		Thu,20 Nov,2008
 *@date		Mon,05 Jan,2009
 *@date		Sat,17 Jan,2009
 *@date		Mon,19 Jan,2009
 *@date		Sat,24 Jan,2009, Thu,29 Jan,2009
 *@date		Sun,08 Feb,2009 - Mon,09 Feb,2009
 *@date		Wed,25 Feb,2009
 *@date		Fri,06 Mar,2009
 *@date		Sat,18 Apr,2009
 *@date		Fri,01 May,2009
 *@date		Sat,14 Nov,2009 - Sun,15 Nov,2009
 *@date		Tue,17 Nov,2009
 *@date		Fri,27 Nov,2009
 *@date		Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */

#ifndef	_lattice_h_included_
#define	_lattice_h_included_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif

#include "anthy/xstr.h"
#include "anthy/splitter.h"
#include "src-splitter/wordborder.h"
#include "anthy/ordering.h"

#ifdef __cplusplus
extern "C" {
#endif


/** metaword ͥټ
 *
 *@note
 *		ʸڤͥȽ
 */
enum splitkind_of_metaword {
	SPLITKIND_OCHAIRE_MIDDLE,				/**< OCHAIREؽΡɡʸ */
	SPLITKIND_OCHAIREwoD_MIDDLE,			/**< °̵OCHAIREؽΡɡʸ */
	SPLITKIND_OCHAIREwoI_MIDDLE,			/**< Ω̵OCHAIREؽΡɡʸ */
	SPLITKIND_OCHAIREwoIwoD_MIDDLE,			/**< Ω졦°̵OCHAIREؽΡɡʸ */
	SPLITKIND_OCHAIRE_HEAD,					/**< OCHAIREؽΡɡƬʸ */
	SPLITKIND_OCHAIREwoD_HEAD,				/**< °̵OCHAIREؽΡɡƬʸ */
	SPLITKIND_OCHAIRE_TAIL,					/**< OCHAIREؽΡɡǸʸ */
	SPLITKIND_OCHAIRE_SINGLE,				/**< OCHAIREؽΡɡƬǤĺǸ */
	SPLITKIND_OCHAIREwoI_TAIL,				/**< Ω̵OCHAIREؽΡɡǸʸ */
	SPLITKIND_OCHAIREwoD_TAIL,				/**< °̵OCHAIREؽΡɡǸʸ */
	SPLITKIND_OCHAIREwoIwoD_TAIL,			/**< Ω졦°̵OCHAIREؽΡɡǸʸ */
	SPLITKIND_OCHAIREwoD_SINGLE,			/**< °̵OCHAIREؽΡɡƬǤĺǸ */
	SPLITKIND_CANDHISTORY,					/**< CAND_HISTORYؽΡ */
	SPLITKIND_DEFAULT,						/**< ƥ༭񤫤Ρɡ¾ */
	SPLITKIND_COMPOUNDHEAD,					/**< ƥ༭񤫤ΡɡMW_COMPOUND_HEAD */
	SPLITKIND_COMPOUNDPART,					/**< ƥ༭񤫤ΡɡMW_COMPOUND_PART */
	SPLITKIND_COMPOUND,						/**< ƥ༭񤫤ΡɡMW_COMPOUND */
	SPLITKIND_COMPOUNDLEAF,					/**< ƥ༭񤫤ΡɡMW_COMPOUND_LEAF */
	SPLITKIND_OCHAIREwoI_HEAD,				/**< Ω̵OCHAIREؽΡɡƬʸ */
	SPLITKIND_OCHAIREwoIwoD_HEAD,			/**< Ω졦°̵OCHAIREؽΡɡƬʸ */
	SPLITKIND_OCHAIREwoI_SINGLE,			/**< Ω̵OCHAIREؽΡɡƬǤĺǸ */
	SPLITKIND_OCHAIREwoIwoD_SINGLE,			/**< Ω졦°̵OCHAIREؽΡɡƬǤĺǸ */
	SPLITKIND_DELETEDHISTORY,				/**< ޡդؽ */
	SPLITKIND_SIZE							/**< ʼ */
};



/** metaword ̻ͥ
 */
struct priority_of_metaword_pair_t {
	const int	pri;				/**< ͥ */
	const int	sub;				/**< sub-priority Ĥݤ */
};

/** metaword ͥ
 *
 *@note
 *	ʸڤ⡼ɤоݤˤäƤϡ̤βžΤ
 *
 *	CAND_HISTORYؽ OCHAIREؽиϡ
 *	ʸĹץ⡼ɻΤ߻Ѳǽ
 *	ʥӥӤǤϽ̤βžбʰ١ˡ
 *
 *	üʸڤʤϡ
 *	ʸĹץ⡼ɻΤ߻Ѳǽ
 *	ʥӥӤǤϱüǶڤʤʸбʰ١ˡ
 *
 *	MW_COMPOUND_*  ʸĹץ⡼ɻΤߤʤΤϡ
 *	ñ˥르ꥺνΰ㤤ؤб
 */
struct priority_of_metaword_t {
	const struct priority_of_metaword_pair_t	splitkind_pri[SPLITKIND_SIZE];	/**< ʸڤͥپ */
	const struct priority_of_metaword_pair_t	CAND_COUNTER_MAXLIMIT;			/**< CAND_HISTORYؽ OCHAIREؽйξ¡ʣʸĹץ⡼ɻΤߡ */
	const struct priority_of_metaword_pair_t	CAND_COUNTER_MAXLIMIT_VALUE;	/**< CAND_COUNTER_MAXLIMITŬѤ줿Ѥͥ١ʣʸĹץ⡼ɻΤߡ */
	const struct priority_of_metaword_pair_t	OCHAIRE_WEAKMODE;				/**< OCHAIREؽΡ(false == anthy_settings.anthy_mode.lattice.with_ochaire_strong) */
	const struct priority_of_metaword_pair_t	CAND_STRONGMODE;				/**< CAND_HISTORYؽΡ(true == anthy_settings.anthy_mode.lattice.with_candhistory_strong) */
	const struct priority_of_metaword_pair_t	CAND_COUNTER_MINLIMIT;			/**< CAND_HISTORYؽ OCHAIREؽй򳫻Ϥ벼¡ʣʸĹץ⡼ɻΤߡ */
	const struct priority_of_metaword_pair_t	CAND_WEAKMODE;					/**< CAND_HISTORYؽΡ(false == anthy_settings.anthy_mode.lattice.with_candhistory_strong) */
};



extern double calc_metaword_score( const struct splitter_context* const sc,
								  struct meta_word* const mw, const struct meta_word* const prev_mw,
								  enum splitkind_of_metaword* const mw_kind, double* const mw_prob );

extern enum splitkind_of_metaword get_metaword_splitkind( const struct meta_word* const mw );

extern int calc_cmpnode_priority( const struct priority_of_metaword_t* const pri,
								 struct meta_word* const mw,
								 int cmp_priority,
								 int cmp_minlen,
								 int* const have_sub_priority,
								 int* const ret_minlen );


extern void choose_path_by_maxlen_n_phrases( struct splitter_context* const sc,
											size_t from, size_t to );
extern void choose_path_by_manual( struct splitter_context* const sc,
								  size_t from, size_t to );
extern void hinted_path_by_manual( struct splitter_context* const sc,
								  size_t from, size_t to );


#ifdef __cplusplus
}
#endif

#endif /* _lattice_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
