/*
 * ʸФ򥽡Ȥ롣
 * Ūˤ϶ܤʸ⸫ơñηˤɾ򤹤롣
 * ֤äκ⤹롣
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Copyright (C) 2000-2006 TABATA Yusuke
 * Copyright (C) 2001 UGAWA Tomoharu
 *
 * $Id: candsort.c,v 1.27 2002/11/17 14:45:47 yusuke Exp $
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <limits.h>
#include <stdlib.h>
#include <stdio.h>

#include <anthy/segment.h>
#include <anthy/splitter.h>
#include <anthy/ordering.h>
#include "sorter.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_MATH_H)
# include <math.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ERRNO_H)
# include <errno.h>
#endif

#include "anthy/anthy.h"			/* Patched by G-HAL, Mon,04 May,2009 */
#include "anthy/logger.h"			/* Patched by G-HAL, Fri,01 May,2009 */
#include "anthy/settings.h"			/* Patched by G-HAL, Fri,14 Nov,2008 */
#include "src-diclib/alternative_mergesort.h"	/* Patched by G-HAL, Sun,02 Nov,2008 */
#include "anthy/cand_ent_score.h"		/* Patched by G-HAL, Sat,17 Oct,2009 */
#include "anthy/segment.h"
#include "anthy/splitter.h"
#include "anthy/ordering.h"
#include "src-splitter/wordborder.h"		/* Patched by G-HAL, Sat,22 Nov,2008 */
#include "anthy/record.h"			/* Patched by G-HAL, Fri,01 May,2009 */
#include "sorter.h"
#endif

/* ؽˤ */
#define OCHAIRE_BASE OCHAIRE_SCORE
/* CAND_HISTORYؽˤ, Patched by G-HAL, Thu,13 Nov,2008 */
#define CANDHISTORY_BASE CANDHISTORY_SCORE
#if 0		/* Patched by G-HAL, Wed,23 Nov,2011 */
/* metawordʬ̵ȤΡҤ餬ʥʤΥ */
#define NOCONV_WITH_BIAS UINT32_C(900000)
/* ̤θ */
#define NORMAL_BASE 100
#endif
/* ñ */
#define SINGLEWORD_BASE 10
#if 0	/* Patched by G-HAL, Fri,24 Jul,2009 */
/* ʣ */
#define COMPOUND_BASE (OCHAIRE_SCORE / 2)
#else
/** ʣ */
#define	COMPOUND_BASE	COMPOUND_SCORE
#endif
/* ʣΰʬʸˤ */
#define COMPOUND_PART_BASE 2
#if 0		/* Patched by G-HAL, Wed,23 Nov,2011 */
/* °Τ */
#define DEPWORD_BASE (OCHAIRE_SCORE / 2)
#endif
/* 񤫤ñκ㥹, Patched by G-HAL, Sun,23 Nov,2008 */
#define DICENT_BASE 10
/* Ҥ餬ʥʤΥǥեȤΥ */
#define NOCONV_BASE 1

/* ̵äݤƤȽǤ */
static int
uncertain_segment_p(struct seg_ent *se)
{
  struct meta_word *mw;
  if (se->nr_metaword == 0) {
    return 0;
  }

  mw = se->mw_array[0];

  /* Ĺ6 */
  if (se->len * 3 >= mw->len * 5) {
    return 1;
  }
  return 0;
}

static void
release_redundant_candidate(struct seg_ent *se)
{
  int i, j;
  /* ϥȤƤΤscore0θ䤬¤Ǥ */
  for (i = 0; i < se->nr_cands && se->cands[i]->score; i++);
  /* iθ */
  if (i < se->nr_cands) {
    for (j = i; j < se->nr_cands; j++) {
      anthy_release_cand_ent(se->cands[j]);
    }
    se->nr_cands = i;
  }
}

/* qsortѤθӴؿ */
static int
candidate_compare_func(const void *p1, const void *p2)
{
 #if 0		/* Patched by G-HAL, Sat,01 Nov,2008, Sat,22 Nov,2008, Sat,24 Jan,2009, Sun,26 Apr,2009 */
  const struct cand_ent *const *c1 = (const struct cand_ent *const *) p1, *const *c2 = (const struct cand_ent *const *) p2;
  return (*c2)->score - (*c1)->score;
 #else
  const struct cand_ent* const* const c1 = (const struct cand_ent* const* const) p1;
  const struct cand_ent* const* const c2 = (const struct cand_ent* const* const) p2;
  const int ret_by_score = (*c2)->score - (*c1)->score;
  if (0 != ret_by_score) {
    return ret_by_score;
  }
  if ((*c1)->mw && (*c2)->mw) {
    const int ret_by_mw_score = (*c2)->mw->score - (*c1)->mw->score;
    if (0 != ret_by_mw_score) {
      return ret_by_mw_score;
    }
    const int ret_by_depth_of_dep = (*c2)->mw->cand_hint_depth_of_dep - (*c1)->mw->cand_hint_depth_of_dep;
    if (0 != ret_by_depth_of_dep) {
      return - ret_by_depth_of_dep;
    }
    const int ret_by_length_of_dep = (*c2)->mw->cand_hint_length_of_dep - (*c1)->mw->cand_hint_length_of_dep;
    if (0 != ret_by_length_of_dep) {
      return - ret_by_length_of_dep;
    }
  }
  return - ((*c2)->str.len - (*c1)->str.len);
 #endif
}

static void
sort_segment(struct seg_ent *se)
{
 #if 0	/* Patched by G-HAL, Sun,02 Nov,2008, Mon,05 Jan,2009, Wed,24 Jun,2009 */
  qsort(se->cands, se->nr_cands,
	sizeof(struct cand_ent *),
	candidate_compare_func);
 #else
  if (1 < se->nr_cands) {
    const int ret = mergesort( se->cands, se->nr_cands, sizeof(struct cand_ent *), candidate_compare_func );
    if (0 != ret) {
      anthy_log( 1, "BUG: sort_segment(): mergesort(): %d:'%s'\n", errno, strerror(errno) );
      abort();
    }
  } else {
   #if defined(DEBUG) && (1 <= DEBUG)
    anthy_log( 1, "sort_segment(): mergesort(): %d.\n", se->nr_cands );
   #endif
  }
 #endif
}

static void
trim_kana_candidate(struct seg_ent *se)
{
  int i;
  if (NULL == se->cands) {  /* ⤷ϳؽǡƤк */
    return;
  }
  if (se->cands[0]->flag & CEF_KATAKANA) {
    return ;
  }
  for (i = 1; i < se->nr_cands; i++) {
    if (se->cands[i]->flag & CEF_KATAKANA) {
      /* ޤǲ */
      se->cands[i]->score = NOCONV_BASE;
    }
  }
}

static void
check_dupl_candidate(struct seg_ent *se)
{
  int i,j;
 #if 0		/* Patched by G-HAL, Tue,02 Dec,2008, Sat,24 Jan,2009, Sun,08 Feb,2009, Tue,24 Feb,2009, Fri,01 May,2009, Tue,04 Aug,2009, Sun,25 Oct,2009 */
  for (i = 0; i < se->nr_cands - 1; i++) {
    for (j = i + 1; j < se->nr_cands; j++) {
      if (!anthy_xstrcmp(&se->cands[i]->str, &se->cands[j]->str)) {
	/* 롼ɤޥåΤ֤Ȥ٤ */
	se->cands[j]->score = 0;
	se->cands[i]->flag |= se->cands[j]->flag;
      }
    }
  }
 #else
  for (i = 0; i < (se->nr_cands - 1); ++i) {
    struct cand_ent* const ca_i = se->cands[i];
   #if defined(DEBUG)
    if (anthy_settings.anthy_mode.enable_error_record) {
      if (ca_i->mw && (ca_i->mw->cand_hint_freq < 1)) {
	char buf[256];
	anthy_snputxstr(buf, _number_(buf)-1, &(ca_i->str), ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
	anthy_log(1, "src-ordering/candsort.c:check_dupl_candidate(): *** BROKEN DATA *** cand_hint_freq is less than 1: '%s'\n", buf );

	if (!anthy_select_section(ERROR, 1)) {
	  if (!anthy_select_row_with_learn(&(se->str),1,0)) {
	    xstr* msg;
	    anthy_set_nth_xstr( 0, &(ca_i->str) );
	    { snprintf( buf, sizeof(buf), "cand_hint_freq is less than 1." );
	      msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
	      anthy_set_nth_xstr( 1, msg );
	      anthy_free_xstr( msg );
	    }
	    { snprintf( buf, sizeof(buf), "src-ordering/candsort.c:check_dupl_candidate()" );
	      msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
	      anthy_set_nth_xstr( 1, msg );
	      anthy_free_xstr( msg );
	    }
	    anthy_mark_row_used();
	  }
	}
      }
    }
   #endif
    for (j = (i + 1); j < se->nr_cands; ++j) {
      struct cand_ent* const ca_j = se->cands[j];
      if ((!anthy_settings.anthy_mode.proccorpus)
	  || (anthy_settings.anthy_mode.proccorpus
	      && (((NULL == ca_i->mw) || (NULL == ca_j->mw))
		  || ((ca_i->mw && ca_j->mw)
		      && (ca_i->mw->seg_class == ca_j->mw->seg_class)
		      && (ca_i->mw->dep_class == ca_j->mw->dep_class))))
      ) {
	if (0 == anthy_xstrcmp(&ca_i->str, &ca_j->str)) {
	  ca_j->score = 0;
	  ca_i->flag |= (ca_j->flag & ~(CEF_SPECIAL_EVAL_SCORE));
	  if ((ca_i->nr_words < 1) && (NULL == ca_i->elm) && (ca_i->core_elm_index < 0)) {
	    ca_i->nr_words       = ca_j->nr_words;
	    ca_i->elm            = ca_j->elm;
	    ca_i->core_elm_index = ca_j->core_elm_index;
	    ca_j->nr_words       = 0;
	    ca_j->elm            = NULL;
	    ca_j->core_elm_index = -1;
	  }
	}
      }
    }
  }
  return;
 #endif
}

/* ʻƤˤä줿ɾ */
static void
eval_candidate_by_metaword(struct cand_ent *ce)
{
  int i;
  int score = 1;

  /* ޤñ٤ˤscoreû */
  for (i = 0; i < ce->nr_words; i++) {
    struct cand_elm *elm = &ce->elm[i];
    int pos, div_factor = 1;
    int freq;

    if (elm->nth < 0) {
      /* ƤоݳʤΤǥå */
      continue;
    }
    pos = anthy_wtype_get_pos(elm->wt);
    if (pos == POS_PRE || pos == POS_SUC) {
      div_factor = 4;
    }

    freq = anthy_get_nth_dic_ent_freq(elm->se, elm->nth);
    score += freq / div_factor;
  }

  if (ce->mw) {
   #if 1	/* Patched by G-HAL, Mon,13 Jul,2009 */
    if (ce->nr_words < 1) {
      score = ce->mw->cand_hint_freq;
    }
   #endif
   #if 1	/* Patched by G-HAL, Wed,24 Jun,2009 - Thu,25 Jun,2009 */
    if ((MW_V_RENYOU_A == ce->mw->type) || (MW_V_RENYOU_NOUN == ce->mw->type)) {
      if (CANDIDATE_RENYOU_SCORE_GEOMETRICMEAN == anthy_settings.anthy_mode.candidate.renyou_score) {
	double tmp = fabs( (double)score * (double)ce->mw->cand_hint_freq );
	if (tmp < 4.0) {
	  tmp = fabs( score + ce->mw->cand_hint_freq );
	}
	score = (int) sqrt( tmp );
      } else if (CANDIDATE_RENYOU_SCORE_LASTWORD == anthy_settings.anthy_mode.candidate.renyou_score) {
	score = ce->mw->cand_hint_freq;
      } else {
      }
    }
   #endif
    score *= ce->mw->struct_score;
    score /= RATIO_BASE;
   #if 1	/* Patched by G-HAL, Sat,22 Nov,2008 */
    if (anthy_settings.anthy_mode.depgraph.score.decrease_biasscore_threshold <= ce->mw->cand_hint_depth_of_dep) {
      score += anthy_settings.anthy_mode.depgraph.score.decrease_biasscore;
    }
    score += (ce->mw->cand_hint_depth_of_dep * anthy_settings.anthy_mode.depgraph.score.decrease_score);
    /* ʸ°, Sun,17 May,2009 */
    if (ce->mw->can_use < ok) {
      score /= 2;
    }
    if (score <= 0) {
      score = 0;
    }
   #endif
  }
 #if 1
  if (score < DICENT_BASE) {	/* Added by G-HAL, Sun,23 Nov,2008 */
    score = DICENT_BASE;
  }
  if (CEF_TUNESCORE & ce->flag) {	/* Added by G-HAL, Thu,27 Nov,2008 */
    score += ((CEF_TUNESCORE_SIGN & ce->flag) ? -1 : +1) * ((CEF_TUNESCORE_NUM & ce->flag) / CEF_TUNESCORE_CLOUMN);
  }
 #endif
  ce->score = score;
}

/** ¦裱⤷ϥߥåȺѤ߸䤬ꤵ줿 mw κ¦Ȱפ뤫ɤȽꤹ
 *@param[in]	se		裱䤪ӥߥåȺѤ߸Υꥹȡɾθ߰֡
 *@param[in]	mw		ȽȤ mwɾθ߰֡
 *@retval	0		פʤ
 *@retval	1		פ
 *
 *	Patches by G-HAL
 *		Fri,14 Nov,2008
 *		Sat,25 Jul,2009
 *		Tue,04 Aug,2009 - Wed,05 Aug,2009
 */
static int check_is_match_leftmw( const struct seg_ent* se, const struct meta_word* mw )
{
  if ((NULL == se) || (NULL == mw)) {
    return 0;
  }

  for (mw = mw->mw1_left, se = se->prev;
       mw;
       mw = mw->mw1_left, se = se->prev
  ) {
    int committed;
    if (NULL == se) {
      return 0;
    }
    {
      committed = se->committed;
      if ((committed < 0) || (se->nr_cands <= committed)) {
	committed = se->provisional_committed;
       #if defined(DEBUG) && (3 <= DEBUG)
	anthy_log(1, "TRACE: check_is_match_leftmw();p:%d\n", committed );
       #endif
      } else {
       #if defined(DEBUG) && (3 <= DEBUG)
	anthy_log(1, "TRACE: check_is_match_leftmw();c:%d\n", committed );
       #endif
      }
      if ((committed < 0) || (se->nr_cands <= committed)) {
	committed = 0;
      }
    }
    if ((NULL == mw->mw1_left)
	&& ((MW_OCHAIREwithoutINDEP == mw->type)
	    || (MW_OCHAIREwithoutINDEPwithoutDEP == mw->type))
    ) {
      /* Ω줬̵ʸ */
      xstr xs = se->cands[committed]->str;
      int  diff_len = (xs.len - mw->len);
      if (diff_len < 0) {
	return 0;
      }
      xs.str += diff_len;
      xs.len -= diff_len;
      if (0 != anthy_xstrcmp(&xs, &(mw->cand_hint))) {
	return 0;
      }
    } else {
      if (0 != anthy_xstrcmp(&(se->cands[committed]->str), &(mw->cand_hint))) {
	return 0;
      }
    }
  }
 #if defined(DEBUG) && (3 <= DEBUG)
  anthy_log(1, "TRACE: check_is_match_leftmw();match\n" );
 #endif
  return 1;
}

/** ¦ʸڤ֤ꤵ줿 mw α¦Ȱפ뤫ɤȽꤹ
 *@param[in]	se		裱䤪ӥߥåȺѤ߸Υꥹȡɾθ߰֡
 *@param[in]	mw		ȽȤ mwɾθ߰֡
 *@retval	0		פʤ
 *@retval	1		פ
 *
 *	Patches by G-HAL
 *		Thu,27 Aug,2009
 */
static int check_is_match_rightmw( const struct seg_ent* se, const struct meta_word* mw )
{
  if ((NULL == se) || (NULL == mw)) {
    return 0;
  }

  for (mw = mw->mw1_right, se = se->next;
       mw;
       mw = mw->mw1_right, se = se->next
  ) {
    if (NULL == se) {
      return 0;
    }
    if ((NULL == mw->mw1_right)
	&& ((MW_OCHAIREwithoutDEP == mw->type)
	    || (MW_OCHAIREwithoutINDEPwithoutDEP == mw->type))
    ) {
      /* °줬̵ʸ */
      if (se->str.len < mw->len) {
	return 0;
      }
    } else {
      if (se->str.len != mw->len) {
	return 0;
      }
    }
  }
 #if defined(DEBUG) && (3 <= DEBUG)
  anthy_log(1, "TRACE: check_is_match_rightmw();match\n" );
 #endif
  return 1;
}

#if 0
/* ɾ */
static void
eval_candidate(struct cand_ent *ce, int uncertain)
{
  if ((ce->flag &
       (CEF_OCHAIRE | CEF_SINGLEWORD | CEF_HIRAGANA |
	CEF_KATAKANA | CEF_GUESS | CEF_COMPOUND | CEF_COMPOUND_PART |
	CEF_BEST)) == 0) {
    /* splitterξ(metaword)ˤä줿 */
    eval_candidate_by_metaword(ce);
  } else if (ce->flag & CEF_OCHAIRE) {
    ce->score = OCHAIRE_BASE;
  } else if (ce->flag & CEF_SINGLEWORD) {
    ce->score = SINGLEWORD_BASE;
  } else if (ce->flag & CEF_COMPOUND) {
    ce->score = COMPOUND_BASE;
  } else if (ce->flag & CEF_COMPOUND_PART) {
    ce->score = COMPOUND_PART_BASE;
  } else if (ce->flag & CEF_BEST) {
    ce->score = OCHAIRE_BASE;
  } else if (ce->flag & (CEF_HIRAGANA | CEF_KATAKANA |
			 CEF_GUESS)) {
    if (uncertain) {
      /*
       * ʸϳʤɤΤ褦ʤΤǡ
       * Ҥ餬ʥʤθФ褤
       */
      ce->score = NOCONV_WITH_BIAS;
      if (CEF_KATAKANA & ce->flag) {
	ce->score ++;
      }
      if (CEF_GUESS & ce->flag) {
	ce->score += 2;
      }
    } else {
      ce->score = NOCONV_BASE;
    }
  }
  ce->score += 1;
}
#else
/** ɾ
 *@param[in]	se		裱䤪ӥߥåȺѤ߸Υꥹȡɾθ߰֡
 *@param[in]	ce		ɾоݤθ䡿ɾ̤γǼ
 *@param	uncertain	̵äݤƤΥե饰餷
 *
 *	Patched by G-HAL
 *		Fri,14 Nov,2008
 *		Sat,22 Nov,2008
 *		Wed,14 Jan,2009
 *		Sat,24 Jan,2009
 *		Sun,08 Feb,2009
 *		Mon,27 Apr,2009
 *		Tue,19 May,2009
 *		Mon,13 Jul,2009
 *		Wed,22 Jul,2009 - Thu,23 Jul,2009
 *		Wed,05 Aug,2009
 *		Thu,27 Aug,2009
 *		Sat,10 Oct,2009
 */
static void eval_candidate( const struct seg_ent* const se, struct cand_ent* const ce, int uncertain )
{
  eval_candidate_by_metaword( ce );
  ce->score_base = ce->score;

  if (0 == (ce->flag
	    & (CEF_ORIGIN_IS_LEARN |
	       CEF_SINGLEWORD | CEF_HIRAGANA | CEF_KATAKANA | CEF_GUESS |
	       CEF_COMPOUND | CEF_COMPOUND_PART |
	       CEF_BEST))
  ) {
    /* splitterξ(metaword)ˤä줿 */
    if (CEF_GUESS_XCT_PART & ce->flag) {
      ce->score /= 2;
    }

  } else if (ce->flag & (CEF_OCHAIRE | CEF_OCHAIREwithINDEP | CEF_OCHAIREwithDEP)) {
    ce->score = OCHAIRE_SCORE;
    ce->flag |= CEF_AddScoreByOCHAIRE;
    if (check_is_match_leftmw(se,ce->mw)) {
      if (check_is_match_rightmw(se,ce->mw)) {
	ce->score += (OCHAIRE_APPENDSCORE / 100 / anthy_settings.limit.ochaire_maxdepth * ce->mw->ochaire_phrase_score);
      } else {
	ce->score = ce->score_base;
      }
    } else {
      ce->score = CANDHISTORY_SCORE / 2;	/* Ŭ˲ */
    }
    if ((0 == (ce->flag & CEF_OCHAIREwithINDEP)) && (NULL == ce->mw->mw1_left)) {
      ce->score = DICENT_BASE;		/* Ω줬̵ʸ */
    }

  } else if (ce->flag & CEF_CANDHISTORY) {
    ce->flag |= CEF_AddScoreByCANDHISTORY;
    ce->score = CANDHISTORY_BASE;
    ce->score += (CANDHISTORY_APPENDSCORE / 100 * ce->mw->ochaire_phrase_score);

  } else if (ce->flag & CEF_SINGLEWORD) {
    ce->score = SINGLEWORD_BASE;

  } else if (ce->flag & CEF_COMPOUND) {
    if (check_is_match_leftmw(se,ce->mw)) {
      if (check_is_match_rightmw(se,ce->mw)) {
	ce->score += COMPOUND_BASE;
	ce->score += (COMPOUND_APPENDSCORE / 100 * ce->mw->ochaire_phrase_score);
      } else {
	ce->score = ce->score_base;
      }
    } else {
      ce->score = COMPOUND_PART_BASE;
    }

  } else if (ce->flag & CEF_COMPOUND_PART) {
    ce->score = COMPOUND_PART_BASE;

  } else if (ce->flag & CEF_BEST) {
    ce->score = OCHAIRE_BASE;

  } else if (ce->flag & (CEF_HIRAGANA | CEF_KATAKANA | CEF_GUESS)) {
    if (uncertain) {
      /*
       * ʸϳʤɤΤ褦ʤΤǡ
       * Ҥ餬ʥʤθФ褤
       */
      ce->score = NOCONV_BASE;
      if (CEF_KATAKANA & ce->flag) {
	ce->score ++;
      }
      if (CEF_GUESS & ce->flag) {
	ce->score += 2;
      }
    } else {
      ce->score = NOCONV_BASE;
    }
  }

  if (ce->score < 1) {
    ce->score = 1;
  }
  ce->score_tentative = ce->score;
  return;
}
#endif

static void
eval_segment(struct seg_ent *se)
{
  int i;
  int uncertain = uncertain_segment_p(se);
  for (i = 0; i < se->nr_cands; i++) {
    eval_candidate( se, se->cands[i], uncertain );	/* Patched by G-HAL, Fri,14 Nov,2008 */
  }
}

/* ؽƤǽ̤Ĵ */
static void
apply_learning(struct segment_list *sl, int nth)
{
  int i;

  /*
   * ̤ͥ㤤ΤŬѤ
   */

 #if 0	/* Patched by G-HAL, Tue,02 Dec,2008, Tue,13 Jan,2009, Tue,10 Nov,2009 */
  /* 㼭ˤѹ */
  anthy_reorder_candidates_by_relation(sl, nth);
  /* θ */
  for (i = nth; i < sl->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(sl, i);
    /* θ */
    anthy_proc_swap_candidate(seg);
    /* ˤѹ */
    anthy_reorder_candidates_by_history(anthy_get_nth_segment(sl, i));
  }
 #else
  /* 㼭ˤѹ */
  anthy_reorder_candidates_by_relation(sl, nth);

  if (!anthy_settings.anthy_mode.anonymous) {
    /* ؽˤĴ */
    for (i = nth; i < sl->nr_segments; ++i) {
      if (anthy_settings.anthy_mode.learn.enable_indeppair) {
	/* INDEPPAIRؽˤؤ */
	anthy_proc_swap_candidate( anthy_get_nth_segment(sl,i) );
      }
      /* ˤؤ */
      anthy_reorder_candidates_by_history( anthy_get_nth_segment(sl,i) );
      /* CAND_HISTORY will be update in here, but the contents of CAND_HISTORY will not change. Memo by G-HAL, Thu,21 Aug,2008 */
    }
  }
  return;
 #endif
}

/** ƤФ륨ȥݥ
 * @nthʹߤʸоݤȤ
 */
#if 0	/* Patched by G-HAL, Thu,12 Nov,2009 */
void
anthy_sort_candidate(struct segment_list *sl, int nth)
#else
void anthy_sort_candidate( struct splitter_context* const sc, struct segment_list* const sl, int nth )
#endif
{
  int i;
 #if 0		/* Patched by G-HAL, Sun,01 Nov,2009 */
  for (i = nth; i < sl->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(sl, i);
    /* ޤɾ */
    eval_segment(seg);
    /* Ĥ˥Ȥ */
    sort_segment(seg);
    /* ֤äȥ㤤0դ */
    check_dupl_candidate(seg);
    /* ⤦ɥȤ */
    sort_segment(seg);
    /* ɾ0θ */
    release_redundant_candidate(seg);
  }
 #else
  for (i = nth; i < sl->nr_segments; ++i) {
    struct seg_ent* const seg = anthy_get_nth_segment( sl, i );
    eval_segment(seg);				/* δɾ */
  }
  anthy_reorder_candidates_by_ucdic( sc, sl, nth );	/* 㼭ˤ륹Ĵ */
  for (i = nth; i < sl->nr_segments; ++i) {
    struct seg_ent* const seg = anthy_get_nth_segment( sl, i );
    sort_segment(seg);				/*  */
    check_dupl_candidate(seg);			/* ֤äȥ㤤0դ */
    sort_segment(seg);				/* ⤦ɥ */
    release_redundant_candidate(seg);		/* ɾ0θ */
  }
 #endif

  /* ؽŬѤ */
  apply_learning(sl, nth);

  /* ޤȤ */
  for ( i = nth ; i < sl->nr_segments ; i++){
    sort_segment(anthy_get_nth_segment(sl, i));
  }

  if (anthy_settings.anthy_mode.candidate.trim_kana_score) {	/* Patched by G-HAL, Wed,18 Feb,2009 */
    /* ʤθ䤬ƬǤʤкǸ˲ */
    for (i = nth; i < sl->nr_segments; i++) {
      trim_kana_candidate(anthy_get_nth_segment(sl, i));
    }
    /* ޤȤ */
    for ( i = nth ; i < sl->nr_segments ; i++){
      sort_segment(anthy_get_nth_segment(sl, i));
    }
  }
}
/* vim:ts=8 sw=2 nomodified:
 */
