/*
 * Ф
 *
 *
 * ɤߤ A B A A A
 * ǤäȤ褦ʾȤ˸Υ롣
 *
 * Copyright (C) 2006-2007 TABATA Yusuke
 *
 */
#if 0		/* Patched by G-HAL */
#include <stdlib.h>

#include <anthy/segment.h>
#include <anthy/record.h>
#include "sorter.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MATH_H)
# include <math.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include "anthy/anthy.h"		/* Patched by G-HAL, Sat,14 Mar,2009 */
#include "anthy/settings.h"		/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "anthy/xstr.h"			/* Patched by G-HAL, Wed,15 Oct,2008 */
#include "anthy/cand_ent_score.h"	/* Patched by G-HAL, Sat,17 Oct,2009 */
#include "anthy/segment.h"
#include "anthy/record.h"
#include "anthy/splitter.h"		/* Patched by G-HAL, Sat,15 Nov,2008 */
#include "sorter.h"
#include "src-worddic/exception_word_list.h"	/* Patched by G-HAL, Sat,01 Nov,2008 */
#include "src-worddic/dic_learn.h"	/* Patched by G-HAL, Fri,31 Oct,2008 */
#include "src-splitter/wordborder.h"	/* Patched by G-HAL, Wed,14 Jan,2009 */
#endif

#if 0	/* Patched by G-HAL, Tue,13 Jan,2009 */
#define HISTORY_DEPTH 8
#define MAX_HISTORY_ENTRY 200

/** ʸΥߥåȤɲä */
static void
learn_cand_history(struct seg_ent *seg)
{
  int nr, i;

  if (anthy_select_section("CAND_HISTORY", 1)) {
    return ;
  }
  if (anthy_select_row(&seg->str, 1)) {
    return ;
  }
  /* եȤ */
  nr = anthy_get_nr_values();
  nr ++;
  if (nr > HISTORY_DEPTH) {
    nr = HISTORY_DEPTH;
  }
  for (i = nr - 1; i > 0; i--) {
    xstr *xs = anthy_get_nth_xstr(i - 1);
    anthy_set_nth_xstr(i, xs);
  }
  /* 0ܤ */
  anthy_set_nth_xstr(0, &seg->cands[seg->committed]->str);
  anthy_mark_row_used();
}

static void
learn_suffix_history(struct seg_ent *seg)
{
  int i;
  struct cand_ent *cand = seg->cands[seg->committed];
  if (anthy_select_section("SUFFIX_HISTORY", 1)) {
    return ;
  }
  for (i = 0; i < cand->nr_words; i++) {
    struct cand_elm *elm = &cand->elm[i];
    xstr xs;
    if (elm->nth == -1) {
      continue;
    }
    if (anthy_wtype_get_pos(elm->wt) != POS_SUC) {
      continue;
    }
    if (anthy_select_row(&elm->str, 1)) {
      continue;
    }
    if (anthy_get_nth_dic_ent_str(elm->se, &elm->str, elm->nth, &xs)) {
      continue;
    }
    anthy_set_nth_xstr(0, &xs);
    free(xs.str);
  }
}

/** ƤФؿ 
 * ɲä */
void
anthy_learn_cand_history(struct segment_list *sl)
{
  int i, nr = 0;
  for (i = 0; i < sl->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(sl, i);
    xstr *xs = &seg->str;
    if (seg->committed < 0) {
      continue;
    }
    if (anthy_select_row(xs, 0)) {
      if (seg->committed == 0) {
	/* Υȥ̵꤬ơߥåȤ줿ƬΤΤǤХѥ */
	continue;
      }
    }
    /**/
    learn_cand_history(seg);
    learn_suffix_history(seg);
    nr ++;
  }
  if (nr > 0) {
    if (!anthy_select_section("CAND_HISTORY", 1)) {
      anthy_truncate_section(MAX_HISTORY_ENTRY);
    }
    if (!anthy_select_section("SUFFIX_HISTORY", 1)) {
      anthy_truncate_section(MAX_HISTORY_ENTRY);
    }
  }
}
#else
/** Ω
 *@param[in]		seg		ʸ
 *@param[in]		ce		ʸ
 *@param		j		ʣξ
 *@param[in,out]	yomi		Ω
 *@param[in,out]	ent		Ω
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009 - Wed,14 Jan,2009
 *		Sat,24 Jan,2009
 *		Mon,09 Feb,2009
 *		Mon,09 Aug,2010
 */
static void get_indepword( struct seg_ent* const seg, struct cand_ent* const ce, int j, xstr* const yomi, xstr* const ent )
{
  yomi->str = NULL;  yomi->len = 0;
  ent->str  = NULL;  ent->len  = 0;

  do {
    if (ce->core_elm_index < 0) {
      /* ʼΩ̵ */
      if (((CEF_COMPOUND | CEF_COMPOUND_PART | CEF_OCHAIRE | CEF_CANDHISTORY) & ce->flag) && ce->mw) {
	yomi->str = anthy_xstr_dup_str( &(seg->str) );
	yomi->len = seg->str.len - ce->mw->cand_hint_length_of_dep;
	ent->str  = anthy_xstr_dup_str( &(ce->str) );
	ent->len  = ce->str.len - ce->mw->cand_hint_length_of_dep;
      } else if (CEF_GUESS_KATAcoreHIRAdep & ce->flag) {
	yomi->str = anthy_xstr_dup_str( &(seg->str) );
	yomi->len = seg->str.len - 1;
	ent->str  = anthy_xstr_dup_str( &(ce->str) );
	ent->len  = ce->str.len - 1;
      } else {
	yomi->str = anthy_xstr_dup_str( &(seg->str) );
	yomi->len = seg->str.len;
	ent->str  = anthy_xstr_dup_str( &(ce->str) );
	ent->len  = ce->str.len;
      }
    } else {
      struct cand_elm* const elm = &(ce->elm[j + PART_CORE]);
      int	res;
      if (elm->nth < 0) {
	/* Ω줬Ĥʤ */
	break;
      }
      res = anthy_get_nth_dic_ent_str( elm->se, &(elm->str), elm->nth, ent );
      if (res || (NULL == ent->str) || (ent->len <= 0)) {
	break;
      }
      yomi->str = anthy_xstr_dup_str( &(elm->str) );
      yomi->len = elm->str.len;
    }
  } while (0);

  return;
}

/** °
 *@param[in]		seg		ʸ
 *@param[in]		ce		ʸ
 *@param		j		ʣξ
 *@param[in,out]	xs		°
 *
 *	Patches by G-HAL
 *		Tue,03 Feb,2009
 *		Mon,09 Feb,2009
 */
static void get_depword( struct seg_ent* const seg, struct cand_ent* const ce, int j, xstr* const xs )
{
  static const xchar	dummy_str[] = { '\x0' };

  xs->str = NULL;  xs->len = 0;

  if (ce->core_elm_index < 0) {
    /* ʼΩ̵ */
    if (((CEF_COMPOUND | CEF_COMPOUND_PART) & ce->flag) && ce->mw) {
      xs->str = &(seg->str.str[seg->str.len - ce->mw->cand_hint_length_of_dep]);
      xs->len = ce->mw->cand_hint_length_of_dep;
    } else if (CEF_GUESS_KATAcoreHIRAdep & ce->flag) {
      xs->str = &(seg->str.str[seg->str.len - 1]);
      xs->len = 1;
    } else {
      xs->str = dummy_str;
      xs->len = 0;
    }
  } else {
    struct cand_elm* const elm = &(ce->elm[j + PART_DEPWORD]);
    xs->str = elm->str.str;
    xs->len = elm->str.len;
  }
  return;
}


/** ʸѴ̤ؽ
 *@param[in]	seg		ʸ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009
 *		Fri,26 Jun,2009
 */
static void learn_cand_history( struct seg_ent* const seg )
{
  struct cand_ent* const	n = seg->cands[seg->committed];

  if (CEF_DONTLEARN_CANDHISTORY & n->flag) {
    return;
  }
  if (anthy_settings.anthy_mode.extra_flag.exception_word.cand_history
      && anthy_ishit_exception_word(&(seg->str)))
  {
    return;
  }
  if (anthy_select_section(CAND_HISTORY, 1)) {
    return;
  }

  anthy_learn_history_str( &(seg->str), &(n->str), 1 );
  return;
}

/** Ѵ̤μΩؽ
 *@param[in]	seg		ʸ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009
 *		Wed,14 Jan,2009
 *		Sat,24 Jan,2009
 *		Tue,24 Feb,2009
 *		Fri,26 Jun,2009
 */
static void learn_indep_history( struct seg_ent* const seg )
{
  struct cand_ent* const	ce = seg->cands[seg->committed];
  int	j;
  xstr	yomi;
  xstr	ent;

  if (CEF_DONTLEARN_INDEP_HISTORY & ce->flag) {
    return;
  }
  if (anthy_select_section(INDEP_HISTORY, 1)) {
    return;
  }
  if (anthy_settings.anthy_mode.candidate.disable_indepscore_with_prefix_or_postfix
      && (NR_PARTS <= ce->nr_words)
  ) {
    if ((0 <= ce->elm[PART_PREFIX].nth)
	|| (0 <= ce->elm[PART_POSTFIX].nth)
    ) {
      /* ƬդƤϼΩؽʤ */
      return;
    }
  }

  /* ʣγ */
  j = 0;
  do {
    get_indepword( seg, ce, j, &yomi, &ent );

    if ((0 < yomi.len) && (0 < ent.len)) {
      /* ؽե饰Υå */
      if (!anthy_settings.anthy_mode.extra_flag.exception_word.indep_history
	  || !anthy_ishit_exception_word(&yomi))
      {
	anthy_learn_history_str( &yomi, &ent, 1 );
      } else {
	ce->flag |= CEF_DONTLEARN_DEP_HISTORY;
      }
    }
    if (yomi.str) {
      free(yomi.str);
    }
    if (ent.str) {
      free(ent.str);
    }

    j += NR_PARTS;
  } while (j < ce->nr_words);
  return;
}


/** Ѵ̤°ؽ
 *@param[in]	seg		ʸ
 *
 *	Patches by G-HAL
 *		Tue,03 Feb,2009
 */
static void learn_dep_history( struct seg_ent* const seg )
{
  struct cand_ent* const	ce = seg->cands[seg->committed];
  int	j;
  xstr	xs;

  if (CEF_DONTLEARN_DEP_HISTORY & ce->flag) {
    return;
  }
  if (anthy_select_section(DEP_HISTORY, 1)) {
    return;
  }

  /* ʣγ */
  j = 0;
  do {
    get_depword( seg, ce, j, &xs );

    anthy_select_row_with_learn( &xs, 1, 1 );
    anthy_mark_row_used();

    j += NR_PARTS;
  } while (j < ce->nr_words);
  return;
}

/** Ƭؽ
 *@param[in]	seg		ʸ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009
 *		Mon,16 Aug,2010
 */
static void learn_pos_history( struct seg_ent* const seg )
{
  struct cand_ent* const cand = seg->cands[seg->committed];
  int	i;
  enum ANTHY_SECTIONS_	section;
  int	res;
  xstr	xs;

  for (i = 0; i < cand->nr_words; ++i) {
    struct cand_elm* const elm = &cand->elm[i];
    if (elm->nth < 0) {
      continue;
    }
    section = NONE_SECTION;
    switch (anthy_wtype_get_pos(elm->wt)) {
    case POS_PRE:	section = anthy_settings.anthy_mode.learn.enable_prefix_history ? PREFIX_HISTORY : NONE_SECTION;	break;
    case POS_SUC:	section = anthy_settings.anthy_mode.learn.enable_suffix_history ? SUFFIX_HISTORY : NONE_SECTION;	break;
    }
    if (NONE_SECTION != section) {
      if (anthy_select_section(section,1)) {
	continue;
      }
      xs.str = NULL;	xs.len = 0;
      res = anthy_get_nth_dic_ent_str( elm->se, &elm->str, elm->nth, &xs );
      if (res || (NULL == xs.str) || (xs.len <= 0)) {
	if (xs.str) {
	  free( xs.str );
	}
	continue;
      }
      anthy_learn_history_str( &(elm->str), &xs, 1 );
      free( xs.str );
    }
  }
  return;
}

/** ƤФؿؽԤ
 *@param[in]	sl		ʸ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009
 *		Tue,03 Feb,2009
 *		Fri,06 Feb,2009
 *		Sat,14 Mar,2009, Wed,25 Mar,2009
 *		Sun,12 Apr,2009
 */
void anthy_learn_cand_history( struct segment_list* const sl )
{
  int i;
  for (i = 0; i < sl->nr_segments; ++i) {
    struct seg_ent* const seg = anthy_get_nth_segment( sl, i );
    if (seg->committed < 0) {
      continue;
    }
    if (anthy_settings.anthy_mode.learn.enable_candhistory) {
      learn_cand_history( seg );
    }
    if (anthy_settings.anthy_mode.learn.enable_indephistory) {
      learn_indep_history( seg );
    }
    if (anthy_settings.anthy_mode.learn.enable_dephistory) {
      learn_dep_history( seg );
    }
    learn_pos_history( seg );

   #if defined(DEBUG) && (2 <= DEBUG)
    /* ʸΥå */
    /* IN¦åƤΤǡOUT¦ǤΥåס */
    if (anthy_settings.anthy_mode.enable_error_record) {
      struct cand_ent* const	n = seg->cands[seg->committed];
      if (n && n->mw && (n->mw->cand_hint_freq < 1)) {
	if (!anthy_select_section(ERROR, 1)) {
	  if (!anthy_select_row_with_learn(&(seg->str),1,0)) {
	    char buf[256];
	    xstr* msg;
	    anthy_set_nth_xstr( 0, &(n->str) );
	    { snprintf( buf, sizeof(buf), "cand_hint_freq is less than 1." );
	      msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
	      anthy_set_nth_xstr( 1, msg );
	      anthy_free_xstr( msg );
	    }
	    { snprintf( buf, sizeof(buf), "src-ordering/candhistory.c:anthy_learn_cand_history()" );
	      msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
	      anthy_set_nth_xstr( 2, msg );
	      anthy_free_xstr( msg );
	    }
	    anthy_mark_row_used();
	  }
	}
      }
    }
   #endif
  }
  return;
}
#endif



#if 0	/* Patched by G-HAL, Tue,13 Jan,2009 */
/* ߤƸνŤߤ׻ */
static int
get_history_weight(xstr *xs)
{
  int i, nr = anthy_get_nr_values();
  int w = 0;
  for (i = 0; i < nr; i++) {
    xstr *h = anthy_get_nth_xstr(i);
    if (!h) {
      continue;
    }
    if (!anthy_xstrcmp(xs, h)) {
      w++;
      if (i == 0) {
	/* ľ˳ꤵ줿ΤˤϹ⤤*/
	w += (HISTORY_DEPTH / 2);
      }
    }
  }
  return w;
}

static void
reorder_by_candidate(struct seg_ent *se)
{
  int i, primary_score;
  /**/
  if (anthy_select_section("CAND_HISTORY", 1)) {
    return ;
  }
  if (anthy_select_row(&se->str, 0)) {
    return ;
  }
  /* Ǥɾι⤤ */
  primary_score = se->cands[0]->score;
  /**/
  for (i = 0; i < se->nr_cands; i++) {
    struct cand_ent *ce = se->cands[i];
    int weight = get_history_weight(&ce->str);
    ce->score += primary_score / (HISTORY_DEPTH /2) * weight;
  }
  anthy_mark_row_used();
}

/* γؽŬѤ */
static void
reorder_by_suffix(struct seg_ent *se)
{
  int i, j;
  int delta = 0;
  int top_cand = -1;
  if (anthy_select_section("SUFFIX_HISTORY", 0)) {
    return ;
  }
  /* Ƹ */
  for (i = 0; i < se->nr_cands; i++) {
    struct cand_ent *ce = se->cands[i];
    /* ñ */
    for (j = 0; j < ce->nr_words; j++) {
      struct cand_elm *elm = &ce->elm[j];
      xstr xs;
      if (elm->nth == -1) {
	continue;
      }
      if (anthy_wtype_get_pos(elm->wt) != POS_SUC) {
	continue;
      }
      /* Ѵʸ򥭡˸ */
      if (anthy_select_row(&elm->str, 0)) {
	continue;
      }
      /* Ѵʸ */
      if (anthy_get_nth_dic_ent_str(elm->se, &elm->str, elm->nth, &xs)) {
	continue;
      }
      /* ʸӤ */
      if (anthy_xstrcmp(&xs, anthy_get_nth_xstr(0))) {
	free(xs.str);
	continue;
      }
      /**/
      if (top_cand < 0) {
	top_cand = i;
      }
      if (delta == 0) {
	delta = (se->cands[top_cand]->score - ce->score) + 1;
      }
      ce->score += delta;
      free(xs.str);
    }
  }
}

/* ǲ */
void
anthy_reorder_candidates_by_history(struct seg_ent *se)
{
  reorder_by_candidate(se);
  reorder_by_suffix(se);
}
#else
/** ؽνŤߤ׻Ѳ
 *@param[in]	xs		
 *@return			زûŤߡʺ硧(anthy_settings.limit.historyrecord_maxdepth + 1)*(anthy_settings.limit.historyrecord_maxdepth)㡧0
 *
 *	Patches by G-HAL
 *		Sat,23 Aug,2008
 *		Fri,05 Sep,2008 - Sat,06 Sep,2008
 *		Fri,31 Oct,2008
 *		Tue,13 Jan,2009
 */
static int get_history_weight_by_freq( const xstr* const xs )
{
  const int	nr = anthy_get_nr_values();
  int		i;
  int		item_num = 0;
  int		number_of_parsed_item = anthy_settings.limit.historyrecord_maxdepth + 1;
  int		w = 0;

  for (i = 0; i < nr; ++i) {
    const anthy_time_t	timestamp = anthy_get_nth_int64(i);
    int			frequency = 0;
    const xstr*		h;
    if (0 != timestamp) {
      ++i; if (nr <= i) break;
      frequency = anthy_get_nth_value(i);
      if (0 != frequency) {
	++i; if (nr <= i) break;
      } else {
	/* May be broken data. */
	h = anthy_get_nth_xstr(i);
	if (NULL == h) {
	  ++i; if (nr <= i) break;
	}
      }
    }
    h = anthy_get_nth_xstr(i);
    if (NULL == h) {
      /* May be broken data. */
      continue;
    }
    ++ item_num;
    if (0 == anthy_xstrcmp(xs, h)) {
      if (0 < frequency) {
	w += frequency;
      } else {
	++ w;
      }
      number_of_parsed_item = item_num;
      break;
    }
  }
  if (anthy_settings.limit.historyrecord_maxdepth < number_of_parsed_item) {
    return 0;
  }
  /* ؽФ롢٥Υߥå */
  if (anthy_settings.limit.historyrecord_maxdepth < w) {
    w = anthy_settings.limit.historyrecord_maxdepth;
  }
 #if 0	/* Patch12-Pattern9  CANDHISTORY_BASE ƳΤǡǤβû, Fri,14 Nov,2008 */
  /* ľ˳ꤵ줿ΤˤϹ⤤ */
  if (1 == number_of_parsed_item) {
    w += (anthy_settings.limit.historyrecord_maxdepth / 2);
  }
 #endif
  /* ǶȤ줿ʪۤɡ٥⾮ϰϤǡû */
  return (w * anthy_settings.limit.historyrecord_maxdepth) + (anthy_settings.limit.historyrecord_maxdepth - number_of_parsed_item);
}


/** ؽνŤߤ׻ʥ󥰤ˤ
 *@param[in]	xs		
 *@return			ٽ̡1.0:ǹ⡢0.0:㡢-0.0̵
 *
 *	Patches by G-HAL
 *		Mon,26 Jan,2009
 */
static double get_history_weight_by_rank( const xstr* const xs )
{
  const int	nr = anthy_get_nr_values();
  int		i;
  int		item_num = 0;
  int		number_of_parsed_item = anthy_settings.limit.historyrecord_maxdepth + 1;

  for (i = 0; i < nr; ++i) {
    const anthy_time_t	timestamp = anthy_get_nth_int64(i);
    int			frequency = 0;
    const xstr*		h;
    if (0 != timestamp) {
      ++i; if (nr <= i) break;
      frequency = anthy_get_nth_value(i);
      if (0 != frequency) {
	++i; if (nr <= i) break;
      } else {
	/* May be broken data. */
	h = anthy_get_nth_xstr(i);
	if (NULL == h) {
	  ++i; if (nr <= i) break;
	}
      }
    }
    h = anthy_get_nth_xstr(i);
    if (NULL == h) {
      /* May be broken data. */
      continue;
    }
    ++ item_num;
    if (0 == anthy_xstrcmp(xs, h)) {
      number_of_parsed_item = item_num;
    }
  }
  if (0 == item_num) {
    return +1.0;
  }
  if (anthy_settings.limit.historyrecord_maxdepth < number_of_parsed_item) {
    return -0.0;
  }
  return (double)(item_num - (number_of_parsed_item - 1)) / (double)item_num;
}


/** CAND_HISTORYؽŬѤ
 *@param[in]	se		ʸᷲ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009 - Wed,14 Jan,2009
 */
static void reorder_by_candidate( struct seg_ent* const se )
{
  int i;
  int	weight;
  if (anthy_select_section(CAND_HISTORY, 1)) {
    return;
  }
  if (anthy_select_row(&se->str, 0)) {
    return;
  }
  for (i = 0; i < se->nr_cands; i++) {
    struct cand_ent* const ce = se->cands[i];
    if (CEF_AddScoreByLEARNstrong & ce->flag) {
      continue;
    }
    weight = get_history_weight_by_freq( &(ce->str) );
    if (0 < weight) {
      ce->flag |= CEF_AddScoreByCANDHISTORY;
      ce->score += (int)( (double)CANDHISTORY_ADDSCORE * weight
			 / anthy_settings.limit.historyrecord_maxdepth
			 / anthy_settings.limit.historyrecord_maxdepth);
    }
  }
  return;
}

/** ΩγؽŬѤ
 *@param[in]	se		ʸᷲ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009 - Wed,14 Jan,2009
 *		Sat,24 Jan,2009
 *		Tue,24 Feb,2009
 *		Sat,28 Feb,2009
 *		Tue,15 Sep,2009
 */
static void reorder_by_indep_history( struct seg_ent* const se )
{
  int	i,j;

  if (anthy_select_section(INDEP_HISTORY,0)) {
    return;
  }

  /* ʸ */
  for (i = 0; i < se->nr_cands; ++i) {
    struct cand_ent* const	ce = se->cands[i];
    if (CEF_AddScoreByLEARNstrong & ce->flag) {
      /* ؽˤ̲û */
      continue;
    }
    if (CEF_GUESS & ce->flag) {
      /* CEF_GUESSϲʤ */
      continue;
    }
    if (anthy_settings.anthy_mode.candidate.disable_indepscore_with_prefix_or_postfix
	&& (NR_PARTS <= ce->nr_words)
    ) {
      if ((0 <= ce->elm[PART_PREFIX].nth)
	  || (0 <= ce->elm[PART_POSTFIX].nth)
      ) {
	/* ƬդƤϼΩؽŬѤʤ */
	continue;
      }
    }

    /* ñʸʣγ˲û */
    j = 0;
    do {
      xstr	yomi;
      xstr	ent;
      get_indepword( se, ce, j, &yomi, &ent );

      if ((0 < yomi.len) && (0 < ent.len)) {
	if (!anthy_select_row(&yomi,0)) {
	 #if 0	/* ȡޤҤȤĳؽȿǾɤʤ */
	  const int weight = get_history_weight_by_freq( &ent );
	  if (0 < weight) {
	    ce->flag |= CEF_AddScoreByHISTORYweak;
	    ce->score += (int)( (double)INDEPHISTORY_ADDSCORE * weight
			       / anthy_settings.limit.historyrecord_maxdepth
			       / anthy_settings.limit.historyrecord_maxdepth);
	  }
	 #else
	  const double rank = get_history_weight_by_rank( &ent );
	  if (
	 # if defined(HAVE_DECL_SIGNBIT) && HAVE_DECL_SIGNBIT
	      0 == signbit(rank)
	 # else
	      1
	 # endif
	  ) {
	    ce->flag |= CEF_AddScoreByHISTORYweak;
	    ce->score += (int)( (double)INDEPHISTORY_ADDSCORE * rank );
	  }
	 #endif
	}
      }
      if (yomi.str) {
	free(yomi.str);
      }
      if (ent.str) {
	free(ent.str);
      }

      j += NR_PARTS;
    } while (j < ce->nr_words);
  }
  return;
}

/** °γؽŬѤ
 *@param[in]	se		ʸᷲ
 *
 *	Patches by G-HAL
 *		Tue,03 Feb,2009
 */
static void reorder_by_dep_history( struct seg_ent* const se )
{
  int	i,j;
  xstr	xs;

  if (anthy_select_section(DEP_HISTORY,0)) {
    return;
  }

  /* ʸ */
  for (i = 0; i < se->nr_cands; ++i) {
    struct cand_ent* const	ce = se->cands[i];
    if (CEF_AddScoreByLEARNstrong & ce->flag) {
      /* ؽˤ̲û */
      continue;
    }

    /* ʣγ */
    j = 0;
    do {
      get_depword( se, ce, j, &xs );

      if ((0 < xs.len) && !anthy_select_row(&xs,0)) {
	const int	count = anthy_get_row_frequency();
	if (0 < count) {
	  ce->flag |= CEF_AddScoreByHISTORYweak;
	  ce->score += (int)( (double)anthy_settings.anthy_mode.depgraph.score.increase_biasscore_by_learn
			     * log10( 1.0 + count ) );
	}
      }

      j += NR_PARTS;
    } while (j < ce->nr_words);
  }
  return;
}

/** ƬγؽŬѤ
 *@param[in]	se		ʸᷲ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009 - Wed,14 Jan,2009
 *		Mon,26 Jan,2009
 *		Tue,15 Sep,2009
 */
static void reorder_by_pos_history( struct seg_ent* const se )
{
  int	i, j;
  enum ANTHY_SECTIONS_	section;
  int	res;
  xstr	xs;
  int		weight;
  double	rank;
  int	highscore_pre = 0;
  int	highscore_suc = 0;
  int*	highscore;

  /* ʸ */
  for (i = 0; i < se->nr_cands; ++i) {
    struct cand_ent* const ce = se->cands[i];
    if (CEF_AddScoreByLEARNstrong & ce->flag) {
      continue;
    }

    /* ʸñ */
    for (j = 0; j < ce->nr_words; ++j) {
      struct cand_elm* const elm = &ce->elm[j];
      if (elm->nth < 0) {
	continue;
      }
      section = NONE_SECTION;
      switch (anthy_wtype_get_pos(elm->wt)) {
      case POS_PRE:	section = PREFIX_HISTORY;	highscore = &highscore_pre;	break;
      case POS_SUC:	section = SUFFIX_HISTORY;	highscore = &highscore_suc;	break;
      }
      if (NONE_SECTION != section) {
	if (anthy_select_section(section,0)) {
	  continue;
	}
	if (anthy_select_row(&elm->str, 0)) {
	  continue;
	}
	if (0 == (*highscore)) {
	  (*highscore) = ce->score;
	}
	xs.str = NULL;	xs.len = 0;
	res = anthy_get_nth_dic_ent_str( elm->se, &elm->str, elm->nth, &xs );
	if (res || (NULL == xs.str) || (xs.len <= 0)) {
	  if (xs.str) {
	    free( xs.str );
	  }
	  continue;
	}
       #if 0	/* Ȳ礭Ƥޤɤʤäݤ */
	weight = get_history_weight_by_freq( &xs );
	if (0 < weight) {
	  ce->flag |= CEF_AddScoreByHISTORYweak;
	  ce->score += (int)( (double)POSHISTORY_ADDSCORE * weight
			     / anthy_settings.limit.historyrecord_maxdepth
			     / anthy_settings.limit.historyrecord_maxdepth);
	}
       #else
	rank = get_history_weight_by_rank( &xs );
	if (
       # if defined(HAVE_DECL_SIGNBIT) && HAVE_DECL_SIGNBIT
	    0 == signbit(rank)
       # else
	    1
       # endif
	) {
	  ce->flag |= CEF_AddScoreByHISTORYweak;
	  ce->score += (int)((*highscore) * rank * anthy_settings.anthy_mode.prefix_suffix.score.increase_ratio_by_learn) + 1;
	}
       #endif
	free( xs.str );
      }
    }
  }
  return;
}

/** ʸФƳؽ̤ȿǤ
 *@param[in]	se		ʸᷲ
 *
 *	Patches by G-HAL
 *		Tue,13 Jan,2009
 *		Tue,03 Feb,2009
 */
void anthy_reorder_candidates_by_history( struct seg_ent* const se )
{
  reorder_by_candidate( se );
  if (anthy_settings.anthy_mode.learn.enable_indephistory) {
    reorder_by_indep_history( se );
  }
  if (0 != anthy_settings.anthy_mode.depgraph.score.increase_biasscore_by_learn) {
    reorder_by_dep_history( se );
  }
  reorder_by_pos_history( se );
}
#endif

/* vim:ts=8 sw=2 nomodified:
 */
