#ifndef _main_h_included_
#define _main_h_included_

#if 0		/* Patched by G-HAL */
#include <anthy/xstr.h>
#include <anthy/dic.h>
#include <anthy/splitter.h>
#include <anthy/segment.h>
#include <anthy/ordering.h>
#include <anthy/prediction.h>
#else
#include "anthy/xstr.h"
#include "anthy/dic.h"
#include "anthy/splitter.h"
#include "anthy/segment.h"
#include "anthy/ordering.h"
#include "anthy/prediction.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*
   ͽ¬ѴθΥå
 */
struct prediction_cache {
  /* ͽ¬ʸ */
  xstr str;
  /* ͽ¬줿ο */
  int nr_prediction;
  /* ͽ¬줿 */
  struct prediction_t* predictions;
};

/** AnthyѴƥ
 * ѴʸʤɤäƤ
 */
struct anthy_context {
  /** ƥȤλʸʴѴѤʿ̾Ѵ줿ʪ, Commented by G-HAL, Sat,18 Apr,2009 */
  xstr str;
  /** ʸΥꥹ */
  struct segment_list seg_list;
  /** 񥻥å */
  dic_session_t dic_session;
  /** splitterξ */
  struct splitter_context split_info;
  /** ¤ؤ */
  struct ordering_context_wrapper ordering_info;
  /** ͽ¬ */
  struct prediction_cache prediction;
  /** 󥳡ǥ */
 #if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,08 Jun,2009 */
  int encoding;
 #else
  enum ANTHY_ENCODING encoding;
 #endif
  /** ѴΥ⡼ */
  int reconversion_mode;
  /** ʸڤΥҥƥ󥰾, Patched by G-HAL, Mon,20 Apr,2009 */
  int* lattice_hint;
};


/* context.c */
extern void anthy_init_contexts(void);
extern void anthy_quit_contexts(void);
extern void anthy_init_personality(void);
extern void anthy_quit_personality(void);
extern int anthy_do_set_personality(const char *id);
extern struct anthy_context *anthy_do_create_context(int encoding);
extern int anthy_do_context_set_str(struct anthy_context *ac, xstr *s, int is_reverse);
extern void anthy_do_reset_context(struct anthy_context *ac);
extern void anthy_do_release_context(struct anthy_context *ac);
#if 1	/* Patched by G-HAL, Sun,26 Apr,2009 */
extern void anthy_do_release_prev_commit( struct anthy_context* const ac );
#endif

extern void anthy_do_resize_segment(struct anthy_context *ac,int nth,int resize);

extern int anthy_do_set_prediction_str(struct anthy_context *ac, xstr *xs);
extern void anthy_release_segment_list(struct anthy_context *ac);
extern void anthy_save_history(const char *fn, struct anthy_context *ac);

/* for debug */
extern void anthy_do_print_context(struct anthy_context *ac, int encoding);


/* ʤ٤ؤեåȤˤ */


#ifdef __cplusplus
}
#endif

#endif /* _main_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
