/*
 * եʤɤΤ
 * ѤΥեɤ߹ߥ⥸塼
 *
 * Copyright (C) 2000-2006 TABATA Yusuke
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <anthy/conf.h>
#include <anthy/ruleparser.h>
#include <anthy/logger.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_CTYPE_H)
# include <ctype.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ALLOCA_H)	/* Patched by G-HAL, Wed,13 Oct,2010 */
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/conf.h"
#include "anthy/ruleparser.h"
#include "anthy/logger.h"
#endif

/* ʸˡեΥѡѤ */
#define MAX_TOKEN_LEN 256
/* Υ󥯥롼ɤο */
#define MAX_INCLUDE_DEPTH 4

#define PS_INIT 0
#define PS_TOKEN 1
#define PS_EOF 2
#define PS_RET 3

static const char *NL = "NL";

static struct parser_stat {
  FILE *fp_stack[MAX_INCLUDE_DEPTH];
  FILE *fp;
  int cur_fpp;/* åΥǥå */
  int line_num;
  char **tokens;
  int nr_token;
  int max_nr_token;	/* Patched by G-HAL, Mon,13 Oct,2008 */
} g_ps;

struct line_stat{
  int stat;
  char buf[MAX_TOKEN_LEN];
  int buf_index;
};

static FILE *
open_file_in_confdir(const char *fn)
{
  const char *dn;
  char *full;
  size_t dname_len;

  if (!fn) {
    return stdin;
  }

 #if 0	/* Patched by G-HAL, Mon,03 Mar,2009 */
  if (fn[0] == '/' ||
      (fn[0] == '.' && fn[1] == '/')) {
    /* Хѥ⤷ϥȥǥ쥯ȥʤΤǤΤޤfopen */
    return fopen(fn, "r");
  }
 #else
  if (('/' == fn[0])
      || (('.' == fn[0]) && ('/' == fn[1]))
      || (('.' == fn[0]) && ('.' == fn[1]) && ('/' == fn[2]))
  ) {
    return fopen(fn, "r");
    /*
     * ǤǤ⡢Directory Traversal Hack Attempt кˤϤʤäƤʤ
     *	./../../foo/var.baz
     * Ȥ¨롣⡢ХѥǻǤΤ
     * Directory Traversal Hack Attempt кǤ̵ɡ
     */
  }
 #endif

  dn = anthy_conf_get_str("ANTHYDIR");
  if (!dn) {
    return 0;
  }
  dname_len =  strlen(dn);
  full = (char*) alloca(dname_len + strlen(fn) + 2);
  sprintf(full, "%s/%s", dn, fn);

  return fopen(full, "r");
}

/** Хååˤ륨פgetc
 * פ줿ʸʤ֤ͤ1ˤʤ롣
 */
static int
mygetc (int *cc)
{
  *cc = fgetc(g_ps.fp);
  if (*cc == '\\') {
    int c2 = fgetc(g_ps.fp);
    switch(c2) {
    case '\\':
      *cc = '\\';
      return 1;
    case '\n':
      *cc = ' ';
      return 1;
    case '\"':
      *cc = '\"';
      return 1;
    default:;
      /* go through */
    }
  }
  return 0;
}

#define myisblank(c)	((c) == ' ' || (c) == '\t')

/* Ԥ˰ʸɲä */
static void
pushchar(struct line_stat *ls, int cc)
{
  if (ls->buf_index == MAX_TOKEN_LEN - 1) {
    ls->buf[MAX_TOKEN_LEN - 1] = 0;
  } else {
    ls->buf[ls->buf_index] = cc;
    ls->buf_index ++;
  }
}

static const char *
get_token_in(struct line_stat *ls)
{
  int cc, esc;
  int in_quote = 0;
  if (ls->stat == PS_EOF) {
    return NULL;
  }
  if (ls->stat == PS_RET) {
    return NL;
  }
  /* ȡ󤬻ϤޤޤǶɤФ */
  do {
    esc = mygetc(&cc);
  } while (cc > 0 && myisblank(cc) && esc == 0);
  if (cc == -1) {
    return NULL;
  }
  if (cc == '\n'){
    return NL;
  }

  /**/
  if (cc == '\"' && !esc) {
    in_quote = 1;
  }
  /**/
  do {
    pushchar(ls, cc);
    esc = mygetc(&cc);
    if (cc < 0){
      /* EOF */
      pushchar(ls, 0);
      ls->stat = PS_EOF;
      return ls->buf;
    }
    if (cc == '\n' && !esc) {
      /*  */
      pushchar(ls, 0);
      ls->stat = PS_RET;
      return ls->buf;
    }
    if (!in_quote && myisblank(cc)) {
      break;
    }
    if (in_quote && cc == '\"' && !esc) {
      pushchar(ls, '\"');
      break;
    }
  } while (1);
  pushchar(ls, 0);
  return ls->buf;
}

/* ɤ */
static int
get_line_in(void)
{
  const char *t;
  struct line_stat ls;

  ls.stat = PS_INIT;
  do{
    ls.buf_index = 0;
    t = get_token_in(&ls);
    if (!t) {
      return -1;
    }
    if (t == NL) {
      return 0;
    }
    g_ps.nr_token++;
  #if 0		/* Patched by G-HAL, Mon,13 Oct,2008 */
    g_ps.tokens = realloc(g_ps.tokens, sizeof(char *)*g_ps.nr_token);
  #else
    if (g_ps.max_nr_token < g_ps.nr_token) {
      g_ps.max_nr_token += 128;
      g_ps.tokens = (char**) realloc(g_ps.tokens, sizeof(char *)*g_ps.max_nr_token);
    }
  #endif
    g_ps.tokens[g_ps.nr_token-1] = strdup(t);
  } while(1);
}

static void
proc_include(void)
{
  FILE *fp;
  if (g_ps.nr_token != 2) {
    anthy_log(0, "Syntax error in include directive.\n");
    return ;
  }
  if (g_ps.cur_fpp > MAX_INCLUDE_DEPTH - 1) {
    anthy_log(0, "Too deep include.\n");
    return ;
  }
  fp = open_file_in_confdir(g_ps.tokens[1]);
  if (!fp) {
    anthy_log(0, "Failed to open %s.\n", g_ps.tokens[1]);
    return ;
  }
  g_ps.cur_fpp++;
  g_ps.fp_stack[g_ps.cur_fpp] = fp;
  g_ps.fp = fp;
}

/* 󥯥롼ɤΥͥȤ򲼤 */
static void
pop_file(void)
{
  fclose(g_ps.fp);
  g_ps.cur_fpp --;
  g_ps.fp = g_ps.fp_stack[g_ps.cur_fpp];
}

static void
get_line(void)
{
  int r;

 again:
  anthy_free_line();
  g_ps.line_num ++;

  r = get_line_in();
  if (r == -1){
    /* EOFǤʾɤ */
    if (g_ps.cur_fpp > 0) {
      pop_file();
      goto again;
    }else{
      return ;
    }
  }
  if (g_ps.nr_token < 1) {
    goto again;
  }
  if (!strcmp(g_ps.tokens[0], "\\include")) {
    proc_include();
    goto again;
  }else if (!strcmp(g_ps.tokens[0], "\\eof")) {
    if (g_ps.cur_fpp > 0) {
      pop_file();
      goto again;
    }else{
      anthy_free_line();
      return ;
    }
  }
  if (g_ps.tokens[0][0] == '#'){
    goto again;
  }
}

void
anthy_free_line(void)
{
  int i;
  if (g_ps.tokens) {        /* ʥꥢɻ */
   #if 0		/* Patched by G-HAL, Mon,13 Oct,2008, Fri,05 Dec,2008 */
    for (i = 0; i < g_ps.nr_token; i++) {
      free(g_ps.tokens[i]);
    }
    free(g_ps.tokens);
    g_ps.tokens = 0;
   #else
    for (i = 0; i < g_ps.nr_token; ++i) {
      free(g_ps.tokens[i]);
    }
   #endif
  }
  g_ps.nr_token = 0;
}

int
anthy_open_file(const char *fn)
{
  g_ps.fp_stack[0] = open_file_in_confdir(fn);
  if (!g_ps.fp_stack[0]) {
    return -1;
  }
  /* ѡξ֤ */
  g_ps.cur_fpp = 0;
  g_ps.fp = g_ps.fp_stack[0];
  g_ps.line_num = 0;
  g_ps.nr_token = 0;        /* ˺ν */
 #if 0
  g_ps.tokens = NULL;       /* ˺ν */
 #else
  g_ps.max_nr_token = 128;	/* Patched by G-HAL, Mon,13 Oct,2008 */
  g_ps.tokens = (char**) malloc(sizeof(char *)*g_ps.max_nr_token);	/* Patched by G-HAL, Mon,13 Oct,2008 */
 #endif
  return 0;
}

void
anthy_close_file(void)
{
  if (g_ps.fp != stdin) {
    fclose(g_ps.fp);
  }
  anthy_free_line();        /* ˺ɻ */
  if (g_ps.tokens) {	/* Patched by G-HAL, Mon,13 Oct,2008 */
    free( g_ps.tokens );
    g_ps.tokens = NULL;
  }
  g_ps.max_nr_token = 0;	/* Patched by G-HAL, Mon,13 Oct,2008 */
}

/* Patched by G-HAL, Thu,16 Oct,2008 */
FILE* const anthy_get_fp( void )
{
	return g_ps.fp;
}

/* Patched by G-HAL, Fri,29 Aug,2008, Fri,17 Oct,2008, Wed,22 Oct,2008, Wed,13 Oct,2010 */
#if defined(HAVE_FSEEKO)
off_t anthy_fsizeo_file( void )
{
  const off_t ptr = ftello( g_ps.fp );
  fseeko( g_ps.fp, 0, SEEK_END );
  const off_t ret = ftello( g_ps.fp );
  fseeko( g_ps.fp, ptr, SEEK_SET );
  return ret;
}
#else
long anthy_fsizeo_file( void )
{
  const long ptr = ftell( g_ps.fp );
  fseek( g_ps.fp, 0, SEEK_END );
  const long ret = ftell( g_ps.fp );
  fseek( g_ps.fp, ptr, SEEK_SET );
  return ret;
}
#endif

int
anthy_read_line(char ***tokens, int *nr)
{
  get_line();
  *tokens = g_ps.tokens;
  *nr = g_ps.nr_token;
  if (!*nr) {
    return -1;
  }
  return 0;
}

int
anthy_get_line_number(void)
{
  return g_ps.line_num;
}
/* vim:ts=8 sw=2 nomodified:
 */
