/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	Ķɤ߹
 *@date		Fri,17 Oct,2008 - Sat,18 Oct,2008
 *@date		Tue,28 Oct,2008
 *@date		Sat,29 Nov,2008 - Mon,01 Dec,2008
 *@date		Tue,30 Dec,2008
 *@date		Tue,13 Jan,2009
 *@date		Mon,19 Jan,2009
 *@date		Sat,24 Jan,2009, Sun,25 Jan,2009
 *@date		Mon,26 Jan,2009, Thu,29 Jan,2009
 *@date		Tue,03 Feb,2009, Wed,04 Feb,2009, Fri,06 Feb,2009
 *@date		Sun,08 Feb,2009
 *@date		Wed,11 Feb,2009 - Thu,12 Feb,2009
 *@date		Wed,18 Feb,2009, Sat,21 Feb,2009, Tue,24 Feb,2009, Sat,28 Feb,2009
 *@date		Sun,08 Mar,2009
 *@date		Sat,14 Mar,2009, Wed,25 Mar,2009
 *@date		Sat,18 Apr,2009 - Mon,20 Apr,2009
 *@date		Mon,25 May,2009 - Mon,08 Jun,2009
 *@date		Fri,12 Jun,2009
 *@date		Wed,17 Jun,2009
 *@date		Wed,24 Jun,2009 - Thu,25 Jun,2009
 *@date		Tue,14 Jul,2009
 *@date		Sat,25 Jul,2009
 *@date		Wed,21 Oct,2009 - Thu,22 Oct,2009
 *@date		Sun,25 Oct,2009
 *@date		Sat,31 Oct,2009
 *@date		Wed,04 Nov,2009
 *@date		Sun,08 Nov,2009
 *@date		Tue,10 Nov,2009
 *@date		Thu,12 Nov,2009
 *@date		Sat,14 Nov,2009 - Sun,15 Nov,2009
 *@date		Wed,18 Nov,2009
 *@date		Wed,21 Jul,2010
 *@date		Mon,16 Aug,2010 - Fri,20 Aug,2010
 *@date		Fri,03 Sep,2010
 *@date		Thu,09 Sep,2010
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>
#endif

#include "src-diclib/alternative_strlcpy.h"
#include "anthy/anthy.h"
#include "anthy/conf.h"
#include "anthy/settings.h"
#include "anthy/logger.h"
#include "anthy/ruleparser.h"
#include "anthy/segment.h"
#include "src-worddic/dic_main.h"



/** Ķեιʸǡ */
struct parser_entry_t {
	const char* const	tag;			/**< ̥ */
	void (*func)( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );		/**< ̥˱Ƽ¹Ԥ륳ޥɤμ */
	void*				ptr;			/**< оݤѿ */
	size_t				ptr_size;		/**< оݤѿ礭 */
	intmax_t			min_value;		/**< (parse_set_value_entry)ͤβ(parse_get_*value_entry) */
	intmax_t			max_value;		/**< ͤξ(parse_get_*value_entry) */
};


static void parse_string_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_get_octedvalue_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_get_value_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_set_value_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_get_truefalse_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_get_floatvalue_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_get_string_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_tunescore_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_cefflag_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );
static void parse_systemconf_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr );


static const struct parser_entry_t	parser_entry[] = {
	{ "GETA_UCS4", parse_get_value_entry, &(anthy_settings.GETA_UCS4), sizeof(anthy_settings.GETA_UCS4), 0, INT32_MAX },

	{ "USER_DIR", parse_string_entry, &(anthy_settings.filename.user_dir), sizeof(anthy_settings.filename.user_dir), 0,0 },
	{ "LOCK_FILE", parse_string_entry, &(anthy_settings.filename.lock_file), sizeof(anthy_settings.filename.lock_file), 0,0 },
	{ "PRIVATE_DIC", parse_string_entry, &(anthy_settings.filename.private_dic), sizeof(anthy_settings.filename.private_dic), 0,0 },
	{ "PRIVATE_DIC_EXT", parse_string_entry, &(anthy_settings.filename.private_dic_ext), sizeof(anthy_settings.filename.private_dic_ext), 0,0 },
	{ "IMPORTED_WORDS", parse_string_entry, &(anthy_settings.filename.imported_words), sizeof(anthy_settings.filename.imported_words), 0,0 },
	{ "IMPORTED_WORDS_EXT", parse_string_entry, &(anthy_settings.filename.imported_words_ext), sizeof(anthy_settings.filename.imported_words_ext), 0,0 },
	{ "RECORD1", parse_string_entry, &(anthy_settings.filename.record1), sizeof(anthy_settings.filename.record1), 0,0 },
	{ "RECORD1_BIN_EXT", parse_string_entry, &(anthy_settings.filename.record1_bin_ext), sizeof(anthy_settings.filename.record1_bin_ext), 0,0 },
	{ "RECORD2", parse_string_entry, &(anthy_settings.filename.record2), sizeof(anthy_settings.filename.record2), 0,0 },
	{ "RECORD_EXT", parse_string_entry, &(anthy_settings.filename.record_ext), sizeof(anthy_settings.filename.record_ext), 0,0 },
	{ "LOGFILE", parse_string_entry, &(anthy_settings.filename.logfile), sizeof(anthy_settings.filename.logfile), 0,0 },

	{ "FILE_UMASK", parse_get_octedvalue_entry, &(anthy_settings.file_umask), sizeof(anthy_settings.file_umask), INTMAX_MIN, INTMAX_MAX },

	{ "RECORDFILE2_LIMIT", parse_get_value_entry, &(anthy_settings.recordfile2_limit), sizeof(anthy_settings.recordfile2_limit), 0, INTMAX_MAX },
	{ "RECORDFILE1_LIMIT", parse_get_value_entry, &(anthy_settings.recordfile1_limit), sizeof(anthy_settings.recordfile1_limit), 0, INTMAX_MAX },

	{ "LEARNING_limit", parse_get_value_entry, &(anthy_settings.section[NONE_SECTION].max_entry), sizeof(anthy_settings.section[NONE_SECTION].max_entry), -1, SSIZE_MAX },
	{ "EXPANDPAIR_limit", parse_get_value_entry, &(anthy_settings.section[EXPANDPAIR].max_entry), sizeof(anthy_settings.section[EXPANDPAIR].max_entry), -1, SSIZE_MAX },
	{ "UNKNOWN_WORD_limit", parse_get_value_entry, &(anthy_settings.section[UNKNOWN_WORD].max_entry), sizeof(anthy_settings.section[UNKNOWN_WORD].max_entry), -1, SSIZE_MAX },
	{ "SUFFIX_HISTORY_limit", parse_get_value_entry, &(anthy_settings.section[SUFFIX_HISTORY].max_entry), sizeof(anthy_settings.section[SUFFIX_HISTORY].max_entry), -1, SSIZE_MAX },
	{ "INDEPPAIR_limit", parse_get_value_entry, &(anthy_settings.section[INDEPPAIR].max_entry), sizeof(anthy_settings.section[INDEPPAIR].max_entry), -1, SSIZE_MAX },
	{ "INDEP_HISTORY_limit", parse_get_value_entry, &(anthy_settings.section[INDEP_HISTORY].max_entry), sizeof(anthy_settings.section[INDEP_HISTORY].max_entry), -1, SSIZE_MAX },
	{ "DEP_HISTORY_limit", parse_get_value_entry, &(anthy_settings.section[DEP_HISTORY].max_entry), sizeof(anthy_settings.section[DEP_HISTORY].max_entry), -1, SSIZE_MAX },
	{ "OCHAIRE_limit", parse_get_value_entry, &(anthy_settings.section[OCHAIRE].max_entry), sizeof(anthy_settings.section[OCHAIRE].max_entry), -1, SSIZE_MAX },
	{ "CAND_HISTORY_limit", parse_get_value_entry, &(anthy_settings.section[CAND_HISTORY].max_entry), sizeof(anthy_settings.section[CAND_HISTORY].max_entry), -1, SSIZE_MAX },
	{ "PREFIX_HISTORY_limit", parse_get_value_entry, &(anthy_settings.section[PREFIX_HISTORY].max_entry), sizeof(anthy_settings.section[PREFIX_HISTORY].max_entry), -1, SSIZE_MAX },
	{ "DATA_SAMPLING_limit", parse_get_value_entry, &(anthy_settings.section[DATA_SAMPLING].max_entry), sizeof(anthy_settings.section[DATA_SAMPLING].max_entry), -1, SSIZE_MAX },

	{ "OCHAIRE_MINDEPTH", parse_get_value_entry, &(anthy_settings.limit.ochaire_mindepth), sizeof(anthy_settings.limit.ochaire_mindepth), 1, 32 },
	{ "OCHAIRE_MAXDEPTH", parse_get_value_entry, &(anthy_settings.limit.ochaire_maxdepth), sizeof(anthy_settings.limit.ochaire_maxdepth), 1, 32 },
	{ "HISTORYRECORD_MAXDEPTH", parse_get_value_entry, &(anthy_settings.limit.historyrecord_maxdepth), sizeof(anthy_settings.limit.historyrecord_maxdepth), 1, 127 },

	{ "ENABLE_ERROR_RECORD", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.enable_error_record), sizeof(anthy_settings.anthy_mode.enable_error_record), 0,0 },

  #if defined(USE_ICONV)
	{ "ANTHY_ENCODING_ISO2022JP",    parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_ISO2022JP    , 0 },
	{ "ANTHY_ENCODING_EUCJP0213",    parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_EUCJP0213    , 0 },
	{ "ANTHY_ENCODING_EUCJP0212",    parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_EUCJP0212    , 0 },
	{ "ANTHY_ENCODING_EUCJPMS",      parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_EUCJPMS      , 0 },
	{ "ANTHY_ENCODING_SHIFTJIS",     parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_SHIFTJIS     , 0 },
	{ "ANTHY_ENCODING_SHIFTJIS0213", parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_SHIFTJIS0213 , 0 },
	{ "ANTHY_ENCODING_SHIFTJISMS",   parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_SHIFTJISMS   , 0 },
	{ "ANTHY_ENCODING_UTF8",         parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_UTF8         , 0 },
	{ "ANTHY_ENCODING_USERDEFINE",   parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_ENCODING_USERDEFINE   , 0 },
	{ "ANTHY_ENCODING_USERDEFINE_NAME", parse_get_string_entry, &(anthy_settings.anthy_mode.encoding_name), sizeof(anthy_settings.anthy_mode.encoding_name), 0,0 },
	{ "ANTHY_ENCODING_EUCJP_AS_EUCJP0213", parse_set_value_entry, &(anthy_settings.anthy_mode.default_eucjp_encoding), sizeof(anthy_settings.anthy_mode.default_eucjp_encoding), ANTHY_ENCODING_EUCJP0213, 0 },
	{ "ANTHY_ENCODING_EUCJP_AS_EUCJP0212", parse_set_value_entry, &(anthy_settings.anthy_mode.default_eucjp_encoding), sizeof(anthy_settings.anthy_mode.default_eucjp_encoding), ANTHY_ENCODING_EUCJP0212, 0 },
	{ "ANTHY_ENCODING_EUCJP_AS_EUCJPMS",   parse_set_value_entry, &(anthy_settings.anthy_mode.default_eucjp_encoding), sizeof(anthy_settings.anthy_mode.default_eucjp_encoding), ANTHY_ENCODING_EUCJPMS, 0 },
  #endif
	{ "ANTHY_ENCODING_EUCJP",      parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_EUC_JP_ENCODING    , 0 },
	{ "ANTHY_ENCODING_UTF8",       parse_set_value_entry, &(anthy_settings.anthy_mode.encoding), sizeof(anthy_settings.anthy_mode.encoding), ANTHY_UTF8_ENCODING      , 0 },

	{ "ANTHY_RECONVERT_AUTO",    parse_set_value_entry, &(anthy_settings.anthy_mode.reconversion_mode), sizeof(anthy_settings.anthy_mode.reconversion_mode), ANTHY_RECONVERT_AUTO   , 0 },
	{ "ANTHY_RECONVERT_DISABLE", parse_set_value_entry, &(anthy_settings.anthy_mode.reconversion_mode), sizeof(anthy_settings.anthy_mode.reconversion_mode), ANTHY_RECONVERT_DISABLE, 0 },
	{ "ANTHY_RECONVERT_ALWAYS",  parse_set_value_entry, &(anthy_settings.anthy_mode.reconversion_mode), sizeof(anthy_settings.anthy_mode.reconversion_mode), ANTHY_RECONVERT_ALWAYS , 0 },

	{ "ENABLE_PROVISIONAL_COMMITTED", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.enable_provisional_committed), sizeof(anthy_settings.anthy_mode.enable_provisional_committed), 0,0 },

	{ "ENABLE_KEEPALIVE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable), sizeof(anthy_settings.anthy_mode.keepalive.enable), 0,0 },
	{ "ENABLE_KEEPALIVE_REFER_COMPOUND", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable_refer_compound), sizeof(anthy_settings.anthy_mode.keepalive.enable_refer_compound), 0,0 },
	{ "ENABLE_KEEPALIVE_REFER_UCDIC_FOR_LATTICE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_lattice), sizeof(anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_lattice), 0,0 },
	{ "ENABLE_KEEPALIVE_REFER_UCDIC_FOR_CANDIDATE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_candidate), sizeof(anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_candidate), 0,0 },
	{ "ENABLE_KEEPALIVE_REFER_OCHAIRE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable_refer_ochaire), sizeof(anthy_settings.anthy_mode.keepalive.enable_refer_ochaire), 0,0 },
	{ "ENABLE_KEEPALIVE_REFER_CORPUS", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable_refer_corpus), sizeof(anthy_settings.anthy_mode.keepalive.enable_refer_corpus), 0,0 },
	{ "ENABLE_KEEPALIVE_LEARN_OCHAIRE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.keepalive.enable_learn_ochaire), sizeof(anthy_settings.anthy_mode.keepalive.enable_learn_ochaire), 0,0 },

	{ "VITERBI_MODE", parse_set_value_entry, &(anthy_settings.anthy_mode.lattice.mode), sizeof(anthy_settings.anthy_mode.lattice.mode), ANTHY_LATTICE_MODE_VITERBI, 0 },
	{ "MAXLEN_MODE", parse_set_value_entry, &(anthy_settings.anthy_mode.lattice.mode), sizeof(anthy_settings.anthy_mode.lattice.mode), ANTHY_LATTICE_MODE_MAXLEN_BY_N_PHRASES, 0 },
	{ "MANUALLATTICE_MODE", parse_set_value_entry, &(anthy_settings.anthy_mode.lattice.mode), sizeof(anthy_settings.anthy_mode.lattice.mode), ANTHY_LATTICE_MODE_MANUAL, 0 },

	{ "LATTICE_HINTING_NONE", parse_set_value_entry, &(anthy_settings.anthy_mode.lattice.hinting), sizeof(anthy_settings.anthy_mode.lattice.hinting), ANTHY_LATTICE_HINTING_NONE, 0 },
	{ "LATTICE_HINTING_BY_KATAKANA", parse_set_value_entry, &(anthy_settings.anthy_mode.lattice.hinting), sizeof(anthy_settings.anthy_mode.lattice.hinting), ANTHY_LATTICE_HINTING_BY_KATAKANA, 0 },
	{ "LATTICE_HINTING_BY_CHARACTER", parse_set_value_entry, &(anthy_settings.anthy_mode.lattice.hinting), sizeof(anthy_settings.anthy_mode.lattice.hinting), ANTHY_LATTICE_HINTING_BY_CHARACTER, 0 },

	{ "LATTICE_HINTING_CHARACTER", parse_get_value_entry, &(anthy_settings.anthy_mode.lattice.hinting_character), sizeof(anthy_settings.anthy_mode.lattice.hinting_character), 0, INTMAX_MAX },

	{ "LATTICE_WITH_OCHAIRE_STRONG", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_ochaire_strong), sizeof(anthy_settings.anthy_mode.lattice.with_ochaire_strong), 0,0 },
	{ "LATTICE_WITH_OCHAIRE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_ochaire), sizeof(anthy_settings.anthy_mode.lattice.with_ochaire), 0,0 },
	{ "LATTICE_WITH_CANDHISTORY_STRONG", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_candhistory_strong), sizeof(anthy_settings.anthy_mode.lattice.with_candhistory_strong), 0,0 },
	{ "LATTICE_WITH_CANDHISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_candhistory), sizeof(anthy_settings.anthy_mode.lattice.with_candhistory), 0,0 },
	{ "LATTICE_WITH_CAND_SCORE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_cand_score), sizeof(anthy_settings.anthy_mode.lattice.with_cand_score), 0,0 },
	{ "LATTICE_WITH_CANDSTRUCT_SCORE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_candstruct_score), sizeof(anthy_settings.anthy_mode.lattice.with_candstruct_score), 0,0 },
	{ "LATTICE_WITH_CAND_CORPUS", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.with_cand_corpus), sizeof(anthy_settings.anthy_mode.lattice.with_cand_corpus), 0,0 },
	{ "CORPUS_ADJ_BY_COUNT_NUMERATOR", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.corpus_adj_by_count_numerator), sizeof(anthy_settings.anthy_mode.lattice.corpus_adj_by_count_numerator), 0,+100 },
	{ "CORPUS_ADJ_BY_COUNT_DENOMINATOR", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.corpus_adj_by_count_denominator), sizeof(anthy_settings.anthy_mode.lattice.corpus_adj_by_count_denominator), 0,+100 },
	{ "VITERBI_MODE_LATTICE_BIASPROB_BY_OCHAIRE", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.biasprob_by_ochaire), sizeof(anthy_settings.anthy_mode.lattice.biasprob_by_ochaire), -1,+1 },
	{ "LATTICE_BIASSCORE_BY_COMPOUND", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.biasscore_by_compound), sizeof(anthy_settings.anthy_mode.lattice.biasscore_by_compound), -1,INTMAX_MAX },
	{ "LATTICE_BIASSCORE_BY_UCDIC", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.biasscore_by_ucdic), sizeof(anthy_settings.anthy_mode.lattice.biasscore_by_ucdic), -1,INTMAX_MAX },
	{ "LATTICE_BIASSCORE_BY_OCHAIRE", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.biasscore_by_ochaire), sizeof(anthy_settings.anthy_mode.lattice.biasscore_by_ochaire), -1,INTMAX_MAX },
	{ "LATTICE_BIASSCORE_BY_LEARNEDFREQ", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.biasscore_by_learnedfreq), sizeof(anthy_settings.anthy_mode.lattice.biasscore_by_learnedfreq), -1,INTMAX_MAX },
	{ "LATTICE_BIASSCORE_BY_DEPHISTORY", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.biasscore_by_dephistory), sizeof(anthy_settings.anthy_mode.lattice.biasscore_by_dephistory), -1,INTMAX_MAX },
	{ "LATTICE_AUTOEXPAND_DEPS", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.autoexpand_deps), sizeof(anthy_settings.anthy_mode.lattice.autoexpand_deps), 0,0 },
	{ "VITERBI_MODE_WITH_POISSON", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.viterbi.with_poisson), sizeof(anthy_settings.anthy_mode.lattice.viterbi.with_poisson), 0,0 },
	{ "VITERBI_MODE_BIAS_SUBSTITUTES_POISSON", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.viterbi.bias_substitutes_poisson), sizeof(anthy_settings.anthy_mode.lattice.viterbi.bias_substitutes_poisson),  0, +1 },
	{ "VITERBI_MODE_METAWORD_EFFECTS_SENTENCE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.viterbi.metaword_effects_sentence), sizeof(anthy_settings.anthy_mode.lattice.viterbi.metaword_effects_sentence), 0,0 },
	{ "VITERBI_MODE_DECREASE_PROBABILITY_PHRASE_WITH_PRE_POST", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.sw), sizeof(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.sw), 0,0 },
	{ "VITERBI_MODE_DECREASE_PROBABILITY_PHRASE_WITH_PRE_AND_POST", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_pre_and_post), sizeof(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_pre_and_post), -100, +100 },
	{ "VITERBI_MODE_DECREASE_PROBABILITY_PHRASE_WITH_PRE", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_pre), sizeof(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_pre), -100, +100 },
	{ "VITERBI_MODE_DECREASE_PROBABILITY_PHRASE_WITH_POST", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_post), sizeof(anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_post), -100, +100 },
	{ "MAXLEN_MODE_PHRASES", parse_get_value_entry, &(anthy_settings.anthy_mode.lattice.maxlen_mode.phrases), sizeof(anthy_settings.anthy_mode.lattice.maxlen_mode.phrases), 1, 255 },
	{ "MAXLEN_MODE_PHRASE_WITH_PRE_POST_AS_2", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.maxlen_mode.phrase_with_pre_post_as_2), sizeof(anthy_settings.anthy_mode.lattice.maxlen_mode.phrase_with_pre_post_as_2), 0,0 },
	{ "MAXLEN_MODE_PUREMODE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.lattice.maxlen_mode.puremode), sizeof(anthy_settings.anthy_mode.lattice.maxlen_mode.puremode), 0,0 },

	{ "DEPGRAPH_WITH_SYMBOL", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.depgraph.with_xct_symbol), sizeof(anthy_settings.anthy_mode.depgraph.with_xct_symbol), 0,0 },
	{ "DEPGRAPH_WITH_PART", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.depgraph.with_xct_part), sizeof(anthy_settings.anthy_mode.depgraph.with_xct_part), 0,0 },

	{ "DEPGRAPH_SCORE_DECREASE_RATIO", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_ratio), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_ratio), -10, +10 },
	{ "DEPGRAPH_SCORE_DECREASE_RATIO_BY_LENGTH", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_ratio_by_length), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_ratio_by_length), -1, +1 },
	{ "DEPGRAPH_SCORE_DECREASE_BIASRATIO", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_biasratio), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_biasratio), -10, +10 },
	{ "DEPGRAPH_SCORE_DECREASE_BIASRATIO_THRESHOLD", parse_get_value_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_biasratio_threshold), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_biasratio_threshold), 0, 255 },
	{ "DEPGRAPH_SCORE_DECREASE_SCORE", parse_get_value_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_score), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_score), INTMAX_MIN, INTMAX_MAX },
	{ "DEPGRAPH_SCORE_DECREASE_BIASSCORE", parse_get_value_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_biasscore), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_biasscore), INTMAX_MIN, INTMAX_MAX },
	{ "DEPGRAPH_SCORE_DECREASE_BIASSCORE_THRESHOLD", parse_get_value_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_biasscore_threshold), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_biasscore_threshold), 0, 255 },
	{ "DEPGRAPH_SCORE_DECREASE_BIASSCORE_XCT_PART", parse_get_value_entry, &(anthy_settings.anthy_mode.depgraph.score.decrease_biasscore_xct_part), sizeof(anthy_settings.anthy_mode.depgraph.score.decrease_biasscore_xct_part), INTMAX_MIN, INTMAX_MAX },
	{ "DEPGRAPH_SCORE_INCREASE_BIASSCORE_BY_LEARN", parse_get_value_entry, &(anthy_settings.anthy_mode.depgraph.score.increase_biasscore_by_learn), sizeof(anthy_settings.anthy_mode.depgraph.score.increase_biasscore_by_learn), INTMAX_MIN, INTMAX_MAX },

	{ "PREFIX_SUFFIX_SCORE_INCREASE_RATIO_BY_LEARN", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.prefix_suffix.score.increase_ratio_by_learn), sizeof(anthy_settings.anthy_mode.prefix_suffix.score.increase_ratio_by_learn), -10, +10 },
	{ "CANDIDATE_STRUCT_PROB_WITHOUT_CORPUS", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.candidate.struct_prob_without_corpus), sizeof(anthy_settings.anthy_mode.candidate.struct_prob_without_corpus), -1, +2 },
	{ "CANDIDATE_STRUCT_PROB_DEFAULT", parse_get_floatvalue_entry, &(anthy_settings.anthy_mode.candidate.struct_prob_default), sizeof(anthy_settings.anthy_mode.candidate.struct_prob_default), -1, +2 },
	{ "CANDIDATE_SCORE_TRIM_KANA", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.candidate.trim_kana_score), sizeof(anthy_settings.anthy_mode.candidate.trim_kana_score), 0,0 },
	{ "CANDIDATE_DISABLE_INDEPSCORE_WITH_PREFIX_OR_POSTFIX", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.candidate.disable_indepscore_with_prefix_or_postfix), sizeof(anthy_settings.anthy_mode.candidate.disable_indepscore_with_prefix_or_postfix), 0,0 },
	{ "CANDIDATE_RENYOU_SCORE_FIRSTWORD",     parse_set_value_entry, &(anthy_settings.anthy_mode.candidate.renyou_score), sizeof(anthy_settings.anthy_mode.candidate.renyou_score), CANDIDATE_RENYOU_SCORE_FIRSTWORD    ,0 },
	{ "CANDIDATE_RENYOU_SCORE_LASTWORD",      parse_set_value_entry, &(anthy_settings.anthy_mode.candidate.renyou_score), sizeof(anthy_settings.anthy_mode.candidate.renyou_score), CANDIDATE_RENYOU_SCORE_LASTWORD     ,0 },
	{ "CANDIDATE_RENYOU_SCORE_GEOMETRICMEAN", parse_set_value_entry, &(anthy_settings.anthy_mode.candidate.renyou_score), sizeof(anthy_settings.anthy_mode.candidate.renyou_score), CANDIDATE_RENYOU_SCORE_GEOMETRICMEAN,0 },
	{ "CANDIDATE_SCORE_UCDIC_RATIO", parse_get_value_entry, &(anthy_settings.anthy_mode.candidate.ucdict_score_ratio), sizeof(anthy_settings.anthy_mode.candidate.ucdict_score_ratio), -2000, +2000 },
	{ "CANDIDATE_SCORE_CORPUS_UDICT", parse_get_value_entry, &(anthy_settings.anthy_mode.candidate.udict_corpus_score), sizeof(anthy_settings.anthy_mode.candidate.udict_corpus_score), -2000, +2000 },

	{ "DONOT_LEARN_EXCEPTION_WORD_AT_INDEPPAIR", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.extra_flag.exception_word.indep_history), sizeof(anthy_settings.anthy_mode.extra_flag.exception_word.indep_history), 0,0 },
	{ "DONOT_LEARN_EXCEPTION_WORD_AT_INDEP_HISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.extra_flag.exception_word.indep_history), sizeof(anthy_settings.anthy_mode.extra_flag.exception_word.indep_history), 0,0 },
	{ "DONOT_LEARN_EXCEPTION_WORD_AT_OCHAIRE", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.extra_flag.exception_word.ochaire), sizeof(anthy_settings.anthy_mode.extra_flag.exception_word.ochaire), 0,0 },
	{ "DONOT_LEARN_EXCEPTION_WORD_AT_CAND_HISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.extra_flag.exception_word.cand_history), sizeof(anthy_settings.anthy_mode.extra_flag.exception_word.cand_history), 0,0 },
	{ "DONOT_LEARN_EXCEPTION_WORD_AT_PREDICTION", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.extra_flag.exception_word.prediction), sizeof(anthy_settings.anthy_mode.extra_flag.exception_word.prediction), 0,0 },

	{ "TUNE_SCORE_NUM_ANK", parse_tunescore_entry, &(anthy_settings.anthy_mode.extra_flag.num_ank), sizeof(anthy_settings.anthy_mode.extra_flag.num_ank), -7, +7 },
	{ "TUNE_SCORE_NUM_JIS", parse_tunescore_entry, &(anthy_settings.anthy_mode.extra_flag.num_jis), sizeof(anthy_settings.anthy_mode.extra_flag.num_jis), -7, +7 },
	{ "TUNE_SCORE_NUM_KANSUUZI", parse_tunescore_entry, &(anthy_settings.anthy_mode.extra_flag.num_kansuuzi), sizeof(anthy_settings.anthy_mode.extra_flag.num_kansuuzi), -7, +7 },
	{ "TUNE_SCORE_NUM_SEPARATED_ANK", parse_tunescore_entry, &(anthy_settings.anthy_mode.extra_flag.num_separated_ank), sizeof(anthy_settings.anthy_mode.extra_flag.num_separated_ank), -7, +7 },
	{ "TUNE_SCORE_NUM_SEPARATED_JIS", parse_tunescore_entry, &(anthy_settings.anthy_mode.extra_flag.num_separated_jis), sizeof(anthy_settings.anthy_mode.extra_flag.num_separated_jis), -7, +7 },
	{ "TUNE_SCORE_NUM_ZIPCODE", parse_tunescore_entry, &(anthy_settings.anthy_mode.extra_flag.num_zipcode), sizeof(anthy_settings.anthy_mode.extra_flag.num_zipcode), -7, +7 },

	{ "DONOT_LEARN_GUESS", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.guess), sizeof(anthy_settings.anthy_mode.extra_flag.guess), 0,0 },
	{ "DONOT_LEARN_HIRAGANA", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.hiragana), sizeof(anthy_settings.anthy_mode.extra_flag.hiragana), 0,0 },
	{ "DONOT_LEARN_KATAKANA", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.katakana), sizeof(anthy_settings.anthy_mode.extra_flag.katakana), 0,0 },
	{ "DONOT_LEARN_KIGOU", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.kigou), sizeof(anthy_settings.anthy_mode.extra_flag.kigou), 0,0 },
	{ "DONOT_LEARN_MUHENKAN", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.muhenkan), sizeof(anthy_settings.anthy_mode.extra_flag.muhenkan), 0,0 },
	{ "DONOT_LEARN_ZENHAN", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.zenhan), sizeof(anthy_settings.anthy_mode.extra_flag.zenhan), 0,0 },
	{ "DONOT_LEARN_NUM_ANK", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.num_ank), sizeof(anthy_settings.anthy_mode.extra_flag.num_ank), 0,0 },
	{ "DONOT_LEARN_NUM_JIS", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.num_jis), sizeof(anthy_settings.anthy_mode.extra_flag.num_jis), 0,0 },
	{ "DONOT_LEARN_NUM_KANSUUZI", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.num_kansuuzi), sizeof(anthy_settings.anthy_mode.extra_flag.num_kansuuzi), 0,0 },
	{ "DONOT_LEARN_NUM_SEPARATED_ANK", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.num_separated_ank), sizeof(anthy_settings.anthy_mode.extra_flag.num_separated_ank), 0,0 },
	{ "DONOT_LEARN_NUM_SEPARATED_JIS", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.num_separated_jis), sizeof(anthy_settings.anthy_mode.extra_flag.num_separated_jis), 0,0 },
	{ "DONOT_LEARN_NUM_ZIPCODE", parse_cefflag_entry, &(anthy_settings.anthy_mode.extra_flag.num_zipcode), sizeof(anthy_settings.anthy_mode.extra_flag.num_zipcode), 0,0 },

	{ "ENABLE_AUTOLEARN", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_autolearn), sizeof(anthy_settings.anthy_mode.learn.enable_autolearn), 0,0 },
	{ "ENABLE_UNLEARN", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_unlearn), sizeof(anthy_settings.anthy_mode.learn.enable_unlearn), 0,0 },
	{ "ENABLE_RELEASELEARN", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_release), sizeof(anthy_settings.anthy_mode.learn.enable_release), 0,0 },
	{ "ENABLE_PREDICTION", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_prediction), sizeof(anthy_settings.anthy_mode.learn.enable_prediction), 0,0 },
	{ "ENABLE_CANDHISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_candhistory), sizeof(anthy_settings.anthy_mode.learn.enable_candhistory), 0,0 },
	{ "ENABLE_INDEPPAIR", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_indeppair), sizeof(anthy_settings.anthy_mode.learn.enable_indeppair), 0,0 },
	{ "ENABLE_INDEPHISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_indephistory), sizeof(anthy_settings.anthy_mode.learn.enable_indephistory), 0,0 },
	{ "ENABLE_DEPHISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_dephistory), sizeof(anthy_settings.anthy_mode.learn.enable_dephistory), 0,0 },
	{ "ENABLE_EXPANDPAIR", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_expandpair), sizeof(anthy_settings.anthy_mode.learn.enable_expandpair), 0,0 },
	{ "ENABLE_PREFIX_HISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_prefix_history), sizeof(anthy_settings.anthy_mode.learn.enable_prefix_history), 0,0 },
	{ "ENABLE_SUFFIX_HISTORY", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_suffix_history), sizeof(anthy_settings.anthy_mode.learn.enable_suffix_history), 0,0 },

	{ "ENABLE_OCHAIRE1", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire1), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire1), 0,0 },
	{ "ENABLE_OCHAIRE1_WITHOUT_DEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire1_wo_dep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire1_wo_dep), 0,0 },
	{ "ENABLE_OCHAIRE2", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire2), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire2), 0,0 },
	{ "ENABLE_OCHAIRE2_WITHOUT_DEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep), 0,0 },
	{ "ENABLE_OCHAIRE2_WITHOUT_INDEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep), 0,0 },
	{ "ENABLE_OCHAIRE2_WITHOUT_INDEP_WITHOUT_DEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep), 0,0 },
	{ "ENABLE_OCHAIRE3", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire3), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire3), 0,0 },
	{ "ENABLE_OCHAIRE3_WITHOUT_DEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire3_wo_dep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire3_wo_dep), 0,0 },
	{ "ENABLE_OCHAIRE3_WITHOUT_INDEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep), 0,0 },
	{ "ENABLE_OCHAIRE3_WITHOUT_INDEP_WITHOUT_DEP", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep_wo_dep), sizeof(anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep_wo_dep), 0,0 },
	{ "ENABLE_DATASAMPLING", parse_get_truefalse_entry, &(anthy_settings.anthy_mode.learn.enable_datasampling), sizeof(anthy_settings.anthy_mode.learn.enable_datasampling), 0,0 },

/*	{ "CONFFILE", parse_systemconf_entry, NULL, (size_t)0,0,0 }, */
/*	{ "SESSION-ID", parse_systemconf_entry, NULL, (size_t)0,0,0 }, */
/*	{ "HOME", parse_systemconf_entry, NULL, (size_t)0,0,0 }, */
	{ "prefix", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "datadir", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "ANTHYDIR", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "DIC_FILE", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "ZIPDICT_EUC", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "WORDS_FILE", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "DEPWORD", parse_systemconf_entry, NULL, (size_t)0,0,0 },
	{ "INDEPWORD", parse_systemconf_entry, NULL, (size_t)0,0,0 },

	{ "", NULL, NULL, 0, 0,0 },
};



static void parse_string_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}
	strlcpy( entry->ptr, tokens[1], entry->ptr_size );
	return;
}

static void parse_get_octedvalue_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	intmax_t	val;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	val = strtoimax( tokens[1], NULL, 8 );
	if (val < entry->min_value) {
		anthy_log( 1, "The value is too small in '%s'.\n", entry->tag );
		return;
	}
	if (entry->max_value < val) {
		anthy_log( 1, "The value is too large in '%s'.\n", entry->tag );
		return;
	}

	switch (entry->ptr_size) {
  #if defined(INDEPENDENTCASE_INT64_T)
	case sizeof(int64_t):	*((int64_t*const)entry->ptr) = (int64_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT32_T)
	case sizeof(int32_t):	*((int32_t*const)entry->ptr) = (int32_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT16_T)
	case sizeof(int16_t):	*((int16_t*const)entry->ptr) = (int16_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT8_T)
	case sizeof(int8_t):	*((int8_t*const)entry->ptr)  = (int8_t) val;	break;
  #endif
	default:
		anthy_log( 1, "***BUG*** in '%s'.\n", entry->tag );
		break;
	}
	return;
}

static void parse_get_value_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	intmax_t	val;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	val = strtoimax( tokens[1], NULL, 0 );
	if (val < entry->min_value) {
		anthy_log( 1, "The value is too small in '%s'.\n", entry->tag );
		return;
	}
	if (entry->max_value < val) {
		anthy_log( 1, "The value is too large in '%s'.\n", entry->tag );
		return;
	}

	switch (entry->ptr_size) {
  #if defined(INDEPENDENTCASE_INT64_T)
	case sizeof(int64_t):	*((int64_t*const)entry->ptr) = (int64_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT32_T)
	case sizeof(int32_t):	*((int32_t*const)entry->ptr) = (int32_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT16_T)
	case sizeof(int16_t):	*((int16_t*const)entry->ptr) = (int16_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT8_T)
	case sizeof(int8_t):	*((int8_t*const)entry->ptr)  = (int8_t) val;	break;
  #endif
	default:
		anthy_log( 1, "***BUG*** in '%s'.\n", entry->tag );
		break;
	}
	return;
}

static void parse_set_value_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	if (nr < 1) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}
	if ((2 == nr) && ('t' != tokens[1][0])) {
		anthy_log( 1, "Unknown argment in '%s'.\n", entry->tag );
		return;
	}

	switch (entry->ptr_size) {
  #if defined(INDEPENDENTCASE_INT64_T)
	case sizeof(int64_t):	*((int64_t*const)entry->ptr) = (int64_t)entry->min_value;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT32_T)
	case sizeof(int32_t):	*((int32_t*const)entry->ptr) = (int32_t)entry->min_value;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT16_T)
	case sizeof(int16_t):	*((int16_t*const)entry->ptr) = (int16_t)entry->min_value;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT8_T)
	case sizeof(int8_t):	*((int8_t*const)entry->ptr)  = (int8_t)entry->min_value;	break;
  #endif
	default:
		anthy_log( 1, "***BUG*** in '%s'.\n", entry->tag );
		break;
	}
	return;
}

static void parse_get_truefalse_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	intmax_t	val;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	switch (tokens[1][0]) {
	case '0':
	case 'F':
	case 'f':
	case 'N':
	case 'n':
	case '-':
		val = 0;
		break;
	case '1':
	case 'T':
	case 't':
	case 'Y':
	case 'y':
	case '+':
	default:
		val = 1;
		break;
	}

	switch (entry->ptr_size) {
  #if defined(INDEPENDENTCASE_INT64_T)
	case sizeof(int64_t):	*((int64_t*const)entry->ptr) = (int64_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT32_T)
	case sizeof(int32_t):	*((int32_t*const)entry->ptr) = (int32_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT16_T)
	case sizeof(int16_t):	*((int16_t*const)entry->ptr) = (int16_t) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_INT8_T)
	case sizeof(int8_t):	*((int8_t*const)entry->ptr)  = (int8_t) val;	break;
  #endif
	default:
		anthy_log( 1, "***BUG*** in '%s'.\n", entry->tag );
		break;
	}
	return;
}

static void parse_get_floatvalue_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	double		val;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	val = strtod( tokens[1], NULL );
	/*
	 * C99⡼ɤˤ GNU/Linux glibc  strtold() 
	 * íܤ֤ͤ١Ȥʤȡ
	 * Ū C99⡼ɤꤷΤߡư餷
	 * ¾˱ƶФȷ顢⡼ɤѤʤˤ
	 */
	if ((INTMAX_MIN < entry->min_value) && (val < entry->min_value)) {
		anthy_log( 1, "The value is too small in '%s'.\n", entry->tag );
		return;
	}
	if ((entry->max_value < INTMAX_MAX) && (entry->max_value < val)) {
		anthy_log( 1, "The value is too large in '%s'.\n", entry->tag );
		return;
	}

	switch (entry->ptr_size) {
  #if defined(INDEPENDENTCASE_LONG_DOUBLE)
	case sizeof(long double):	*((long double*const)entry->ptr) = (long double) val;	break;
  #endif
  #if defined(INDEPENDENTCASE_DOUBLE)
	case sizeof(double):		*((double*const)entry->ptr)      = (double) val;		break;
  #endif
  #if defined(INDEPENDENTCASE_FLOAT)
	case sizeof(float):			*((float*const)entry->ptr)       = (float) val;			break;
  #endif
	default:
		anthy_log( 1, "***BUG*** in '%s'.\n", entry->tag );
		break;
	}
	return;
}

static void parse_get_string_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	const char* * const	ptr = (const char* *)entry->ptr;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	if (NULL != (*ptr)) {
		free( *ptr );
	}
	*ptr = strdup( tokens[1] );
	return;
}

static void parse_tunescore_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	int	val;
	int	sign = 0;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	val = strtol( tokens[1], NULL, 0 );
	if (val < entry->min_value) {
		anthy_log( 1, "The value is too small in '%s'.\n", entry->tag );
		return;
	}
	if (entry->max_value < val) {
		anthy_log( 1, "The value is too large in '%s'.\n", entry->tag );
		return;
	}

	*((uint16_t*const) entry->ptr) &= ~CEF_TUNESCORE;
	if (val < 0) {
		val = -val;
		sign = 1;
		*((uint16_t*const) entry->ptr) |= CEF_TUNESCORE_SIGN;
	}
	*((uint16_t*const) entry->ptr) |= (CEF_TUNESCORE_NUM & (val * CEF_TUNESCORE_CLOUMN));

	return;
}

static void parse_cefflag_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	unsigned int	val;
	size_t			i;

	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	val = 0;
	for (i = 0; tokens[1][i]; ++i) {
		switch (tokens[1][i]) {
		case '_':	val = 0;	break;
		case 'E':	val |=  CEF_DONTLEARN_EXPANDPAIR;	break;
		case 'e':	val &= ~CEF_DONTLEARN_EXPANDPAIR;	break;
		case 'I':	val |=  CEF_DONTLEARN_INDEP_HISTORY;	break;
		case 'i':	val &= ~CEF_DONTLEARN_INDEP_HISTORY;	break;
		case 'D':	val |=  CEF_DONTLEARN_DEP_HISTORY;	break;
		case 'd':	val &= ~CEF_DONTLEARN_DEP_HISTORY;	break;
		case 'P':	val |=  CEF_DONTLEARN_PREDICTION;	break;
		case 'p':	val &= ~CEF_DONTLEARN_PREDICTION;	break;
		case 'C':	val |=  CEF_DONTLEARN_CANDHISTORY;	break;
		case 'c':	val &= ~CEF_DONTLEARN_CANDHISTORY;	break;
		case 'H':	val |=  CEF_DONTLEARN_OCHAIRE_IFONLYITS;	break;
		case 'h':	val &= ~CEF_DONTLEARN_OCHAIRE_IFONLYITS;	break;
		case 'O':	val |=  CEF_DONTLEARN_OCHAIRE_IFHAVEIT;	break;
		case 'o':	val &= ~CEF_DONTLEARN_OCHAIRE_IFHAVEIT;	break;
		case 'A':	val |=  CEF_DONTLEARN_ALL;	break;
		case 'a':	val &= ~CEF_DONTLEARN_ALL;	break;
		default:
			anthy_log( 1, "Unknown argment '%c' in '%s'.\n", tokens[1][i], entry->tag );
			break;
		}
	}

	*((uint16_t*const) entry->ptr) &= ~CEF_DONTLEARN_ALL;
	*((uint16_t*const) entry->ptr) |= (CEF_DONTLEARN_ALL & val);

	return;
}

static void parse_systemconf_entry( const struct parser_entry_t* const entry, const char* const* const tokens, int nr )
{
	if (nr < 2) {
		anthy_log( 1, "Too few argment in '%s'.\n", entry->tag );
		return;
	}
	if (2 < nr) {
		anthy_log( 1, "Too many argment in '%s'.\n", entry->tag );
		return;
	}

	anthy_do_conf_override( entry->tag, tokens[1] );

	return;
}



void parse_packed_flag( void )
{
	if (anthy_settings.anthy_mode.anonymous) {
		anthy_settings.anthy_mode.keepalive.enable_learn_ochaire = 0;
		anthy_settings.anthy_mode.learn.enable_autolearn                = 0;
		anthy_settings.anthy_mode.learn.enable_prediction               = 0;
		anthy_settings.anthy_mode.learn.enable_candhistory              = 0;
		anthy_settings.anthy_mode.learn.enable_indeppair                = 0;
		anthy_settings.anthy_mode.learn.enable_indephistory             = 0;
		anthy_settings.anthy_mode.learn.enable_dephistory               = 0;
		anthy_settings.anthy_mode.learn.enable_expandpair               = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire2                 = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep          = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep        = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire3                 = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire3_wo_dep          = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep        = 0;
		anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep_wo_dep = 0;
		anthy_settings.anthy_mode.learn.enable_datasampling             = 0;
		anthy_settings.anthy_mode.lattice.biasprob_by_ochaire      = 0.0;
		anthy_settings.anthy_mode.lattice.biasscore_by_ochaire     = 0.0;
		anthy_settings.anthy_mode.lattice.biasscore_by_learnedfreq = 0.0;
		anthy_settings.anthy_mode.lattice.biasscore_by_dephistory  = 0.0;
		anthy_settings.anthy_mode.depgraph.score.increase_biasscore_by_learn = 0;
		anthy_settings.anthy_mode.prefix_suffix.score.increase_ratio_by_learn = 0.00;
		anthy_settings.anthy_mode.candidate.disable_indepscore_with_prefix_or_postfix = 1;
	}
	if (anthy_settings.anthy_mode.proccorpus) {
		anthy_settings.anthy_mode.enable_provisional_committed = 0;
		anthy_settings.anthy_mode.keepalive.enable = 0;
		anthy_settings.anthy_mode.keepalive.enable_refer_compound = 0;
		anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_lattice   = 0;
		anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_candidate = 0;
		anthy_settings.anthy_mode.keepalive.enable_refer_ochaire  = 0;
		anthy_settings.anthy_mode.keepalive.enable_refer_corpus   = 0;
		anthy_settings.anthy_mode.lattice.biasscore_by_compound = 0.0;
		anthy_settings.anthy_mode.lattice.biasscore_by_ucdic    = 0.0;
		anthy_settings.anthy_mode.candidate.ucdict_score_ratio = 0;
		anthy_settings.anthy_mode.candidate.udict_corpus_score = 0;
	}
	anthy_settings.anthy_mode.lattice.mw_max_score
			= (anthy_settings.anthy_mode.lattice.with_cand_score ? (65535.0 * 3.0 / FREQ_RATIO) : 1000.0)
			+ anthy_settings.anthy_mode.lattice.biasscore_by_compound
			+ (15 * anthy_settings.anthy_mode.lattice.biasscore_by_ucdic)
			+ anthy_settings.anthy_mode.lattice.biasscore_by_ochaire
			+ (10.0 * anthy_settings.anthy_mode.lattice.biasscore_by_learnedfreq)
			+ ( anthy_settings.anthy_mode.lattice.biasscore_by_dephistory * 10.0 );
	return;
}


void anthy_load_settings( void )
{
	struct stat	st;

	{	/* Check and Open */
		if (anthy_settings.filename.PathSeparator[0] != anthy_settings.filename.user_conffile[0]) {
			return;
		}
		if (0 != stat(anthy_settings.filename.user_conffile, &st)) {
			return;
		}
		if (anthy_settings.timestamp.conffile == st.st_mtime) {
			return;
		}
		if (-1 == anthy_open_file(anthy_settings.filename.user_conffile)) {
			return;
		}
		anthy_settings.timestamp.conffile = st.st_mtime;
	}

	{	/* Read and Parse */
		char**	tokens;
		int		nr;
		size_t	i;

		while (!anthy_read_line(&tokens, &nr)) {
			if (nr < 1) {
				continue;
			}
			for (i = 0; i < _number_(parser_entry); ++i) {
				if (0 == strcasecmp(parser_entry[i].tag, tokens[0])) {
					(*parser_entry[i].func)( &(parser_entry[i]), tokens, nr );
					break;
				}
			}
			if (_number_(parser_entry) <= i) {
				anthy_log( 1, "A tag '%s' in the user-configuration file is unknown.\n", tokens[0] );
			}
			anthy_free_line();
		}
	}

	anthy_close_file();

	parse_packed_flag();
	return;
}



void anthy_load_settings_from_systemconf( void )
{
	char	*(tokens[2]);
	int		nr;
	size_t	i;

	for (i = 0; i < _number_(parser_entry); ++i) {
		if (parser_entry[i].ptr || parser_entry[i].ptr_size) {
			tokens[1] = anthy_conf_get_str( parser_entry[i].tag );
			if (tokens[1]) {
				nr = 2;
				tokens[0] = parser_entry[i].tag;
				(*parser_entry[i].func)( &(parser_entry[i]), tokens, nr );
				anthy_settings.timestamp.conffile = 0;
			}
		}
	}

	anthy_load_settings();
	return;
}


void anthy_init_settings( void )
{
	const char* const conffile = getenv("ANTHY_CONFFILE");
	if (conffile) {
		strlcpy( anthy_settings.filename.user_conffile, conffile, sizeof(anthy_settings.filename.user_conffile) );
	}
	if (('~' == anthy_settings.filename.user_conffile[0])
		&& (anthy_settings.filename.PathSeparator[0] == anthy_settings.filename.user_conffile[1])
	){
		char	tmp_conffile[PATH_MAX];
		const char* const home = getenv("HOME");
		if (home) {
			strlcpy( tmp_conffile, anthy_settings.filename.user_conffile, sizeof(tmp_conffile) );
			strlcpy( anthy_settings.filename.user_conffile, home, sizeof(anthy_settings.filename.user_conffile) );
			strlcat( anthy_settings.filename.user_conffile, "/", sizeof(anthy_settings.filename.user_conffile) );
			strlcat( anthy_settings.filename.user_conffile, &(tmp_conffile[2]), sizeof(anthy_settings.filename.user_conffile) );
		}
	}
	anthy_load_settings();

	anthy_settings.timestamp.currentsession = anthy_settings.timestamp.initial = time( NULL );
	anthy_settings.timestamp.lastsession = 0;

  #if 0
	umask( file_umask_org = umask( (mode_t)(-1) ) );		/* ϡΣԤ򥢥ȥߥå˼¹ԤߤǤ⤽ˡ̵ */
	anthy_settings.file_umask |= file_umask_org;
	/* Anthy ϡ桼ץफΥ饤֥ƤӽФǼ¹ԤƱץȤʤˤΤǡ
	 * umask() ѹȤޤ
	 * äơopen()  permission ꤷ fdopen() 롣
	 *
	 * anthy_settings.file_umask_org ˥ǥե umask ƤȻפä
	 * ˤΩʤΤǤ᤿
	 */
  #endif

	return;
}

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
