/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ʸȽ
 *@date		Thr,23 Dec,2004 - Sun,26 Dec,2004
 *@date		Tue,09 Jun,2009
 *@date		Thu,14 Oct,2010
 *@author	Copyright(C)2004-2010 G-HAL
 */
#ifndef _check_source_encoding_h_included_
#define _check_source_encoding_h_included_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


#define	CHECK_SOURCECODE_ENCODING_CHAR10	((uint8_t)(""[0]))	/* 󤸤Τ */
#define	CHECK_SOURCECODE_ENCODING_CHAR11	((uint8_t)("000"[1]))	/* 󤸤Τ */
#define	CHECK_SOURCECODE_ENCODING_CHAR12	((uint8_t)("000"[2]))	/* 󤸤Τ */
#define	CHECK_SOURCECODE_ENCODING_CHAR13	((uint8_t)("000"[3]))	/* 󤸤Τ */
#define	CHECK_SOURCECODE_ENCODING_CHAR20	((uint8_t)(""[0]))	/* ʤΤʤ */
#define	CHECK_SOURCECODE_ENCODING_CHAR23	((uint8_t)("\0\0\0"[3]))	/* ʤΤʤ */

#if defined(ICONV_ISO2022JP)
#define	CHECK_SOURCECODE_ENCODING_ISO2022JP		(CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0x1B))
#endif
#if defined(ICONV_ISO2022JP2)
#define	CHECK_SOURCECODE_ENCODING_ISO2022JP2	(CHECK_SOURCECODE_ENCODING_ISO2022JP && (CHECK_SOURCECODE_ENCODING_CHAR23=='D'))
#endif
#if defined(ICONV_ISO2022JP3)
#define	CHECK_SOURCECODE_ENCODING_ISO2022JP3	(CHECK_SOURCECODE_ENCODING_ISO2022JP && (CHECK_SOURCECODE_ENCODING_CHAR23=='O'))
#endif
#if defined(ICONV_ISO2022JP2004)
#define	CHECK_SOURCECODE_ENCODING_ISO2022JP2004	(CHECK_SOURCECODE_ENCODING_ISO2022JP && (CHECK_SOURCECODE_ENCODING_CHAR23=='Q'))
#endif
#if defined(ICONV_EUCJP)
#define	CHECK_SOURCECODE_ENCODING_EUCJP			(CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0xB4))
#endif
#if defined(ICONV_EUCJP)
#define	CHECK_SOURCECODE_ENCODING_EUCJP0212		(CHECK_SOURCECODE_ENCODING_EUCJP && (CHECK_SOURCECODE_ENCODING_CHAR20==UINT8_C(0x8F)))
#endif
#if defined(ICONV_EUCJP0213)
#define	CHECK_SOURCECODE_ENCODING_EUCJP0213		(CHECK_SOURCECODE_ENCODING_EUCJP && (CHECK_SOURCECODE_ENCODING_CHAR20==UINT8_C(0xF4)))
#endif
#if defined(ICONV_SHIFTJIS)
#define	CHECK_SOURCECODE_ENCODING_SHIFTJIS		(CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0x8A))
#endif
#if defined(ICONV_SHIFTJIS0213)
#define	CHECK_SOURCECODE_ENCODING_SHIFTJIS0213	(CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0xEA))
#endif
#if defined(ICONV_SHIFTJISMS)
#define	CHECK_SOURCECODE_ENCODING_SHIFTJISMS	(CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0xFA))
#endif
#if defined(ICONV_UTF8)
#define	CHECK_SOURCECODE_ENCODING_UTF8			(CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0xE6))
#endif
#if defined(ICONV_UCS4BE)
#define	CHECK_SOURCECODE_ENCODING_UCS4BE		((CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0x00)) && (CHECK_SOURCECODE_ENCODING_CHAR11==UINT8_C(0x00)) && (CHECK_SOURCECODE_ENCODING_CHAR12==UINT8_C(0x6F)) && (CHECK_SOURCECODE_ENCODING_CHAR13==UINT8_C(0x22)))
#endif
#if defined(ICONV_UCS4LE)
#define	CHECK_SOURCECODE_ENCODING_UCS4LE		((CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0x22)) && (CHECK_SOURCECODE_ENCODING_CHAR11==UINT8_C(0x6F)) && (CHECK_SOURCECODE_ENCODING_CHAR12==UINT8_C(0x00)) && (CHECK_SOURCECODE_ENCODING_CHAR13==UINT8_C(0x00)))
#endif
#if defined(ICONV_UCS2BE)
#define	CHECK_SOURCECODE_ENCODING_UCS2BE		((CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0x6F)) && (CHECK_SOURCECODE_ENCODING_CHAR11==UINT8_C(0x22)) && (CHECK_SOURCECODE_ENCODING_CHAR12==UINT8_C(0x00)) && (CHECK_SOURCECODE_ENCODING_CHAR13==UINT8_C(0x30)))
#endif
#if defined(ICONV_UCS2LE)
#define	CHECK_SOURCECODE_ENCODING_UCS2LE		((CHECK_SOURCECODE_ENCODING_CHAR10==UINT8_C(0x22)) && (CHECK_SOURCECODE_ENCODING_CHAR11==UINT8_C(0x6F)) && (CHECK_SOURCECODE_ENCODING_CHAR12==UINT8_C(0x30)) && (CHECK_SOURCECODE_ENCODING_CHAR13==UINT8_C(0x00)))
#endif

#ifndef SRCCODE_ENCODING
# define	SRCCODE_ENCODING	(	\
					    (0 + CHECK_SOURCECODE_ENCODING_ISO2022JP2004)	? ""ICONV_ISO2022JP2004 \
					: ( (0 + CHECK_SOURCECODE_ENCODING_ISO2022JP3)		? ""ICONV_ISO2022JP3 \
					: ( (0 + CHECK_SOURCECODE_ENCODING_ISO2022JP2)		? ""ICONV_ISO2022JP2 \
					: ( (0 + CHECK_SOURCECODE_ENCODING_ISO2022JP)		? ""ICONV_ISO2022JP \
					: ( (0 + CHECK_SOURCECODE_ENCODING_EUCJP0212)		? ""ICONV_EUCJP \
					: ( (0 + CHECK_SOURCECODE_ENCODING_EUCJP0213)		? ""ICONV_EUCJP0213 \
					: ( (0 + CHECK_SOURCECODE_ENCODING_EUCJP)			? ""ICONV_EUCJP \
					: ( (0 + CHECK_SOURCECODE_ENCODING_SHIFTJIS0213)	? ""ICONV_SHIFTJIS0213 \
					: ( (0 + CHECK_SOURCECODE_ENCODING_SHIFTJISMS)		? ""ICONV_SHIFTJISMS \
					: ( (0 + CHECK_SOURCECODE_ENCODING_SHIFTJIS)		? ""ICONV_SHIFTJIS \
					: ( (0 + CHECK_SOURCECODE_ENCODING_UCS4BE)			? ""ICONV_UCS4BE \
					: ( (0 + CHECK_SOURCECODE_ENCODING_UCS4LE)			? ""ICONV_UCS4LE \
					: ( (0 + CHECK_SOURCECODE_ENCODING_UCS2BE)			? ""ICONV_UCS2BE \
					: ( (0 + CHECK_SOURCECODE_ENCODING_UCS2LE)			? ""ICONV_UCS2LE \
					: ( (0 + CHECK_SOURCECODE_ENCODING_UTF8)			? ""ICONV_UTF8 \
					: "" )))))))))))))))
#endif


#ifdef __cplusplus
}
#endif

#endif /* _check_source_encoding_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
