/*
 * Anthy library interface
 * Anthy is a KanaKanji conversion engine (Library for Japanese Input Method)
 *
 * please read doc/LIB file in source package.
 *
 * Most of declarations are public interface.
 * So, be careful if you want to modify this file.
 *
 * $Id: anthy.h,v 1.6 2002/03/05 02:45:32 gniibe Exp $
 */
#ifndef _anthy_h_included_
#define _anthy_h_included_

#ifdef __cplusplus
extern "C" {
#endif


/* Data types */
struct anthy_conv_stat {
  int nr_segment;
};

struct anthy_segment_stat {
  int nr_candidate;
  int seg_len;
};

struct anthy_prediction_stat {
  int nr_prediction;
};

typedef struct anthy_context *anthy_context_t;



/* constants */
#define NTH_UNCONVERTED_CANDIDATE -1
#define NTH_KATAKANA_CANDIDATE -2
#define NTH_HIRAGANA_CANDIDATE -3
#define NTH_HALFKANA_CANDIDATE -4
#if defined(USE_ICONV)	/* Patched by G-HAL, Sun,07 Jun,2009 - Mon,08 Jun,2009 */
/** ʸɼ
 *@attention
 *	src-diclib/anthy_iconv.c ˤƼơ֥뤬롣
 *	뤳ȡ
 */
enum ANTHY_ENCODING {
  ANTHY_COMPILED_ENCODING = 0,				/**< ɤʸɤƱ */
  ANTHY_ENCODING_EUCJP = 1,				/**< EUC-JP ηϤϴĶǻ ʳ黲ȤΤ׸͡ */
  ANTHY_ENCODING_UTF8 = 2,				/**< UTF-8 ʳ黲ȤΤ׸͡ */
  ANTHY_ENCODING_ISO2022JP,				/**< ISO-2022-JP ѡ */
  ANTHY_ENCODING_EUCJP0213,				/**< EUC-JP JIS X 0213 ѡ */
  ANTHY_ENCODING_EUCJP0212,				/**< EUC-JP JIS X 0208/0212 ѡ */
  ANTHY_ENCODING_EUCJPMS,				/**< EUC-JP-MS CP51932 ѡ */
  ANTHY_ENCODING_SHIFTJIS,				/**< ShiftJIS JIS X 0208 ѡ */
  ANTHY_ENCODING_SHIFTJIS0213,				/**< ShiftJIS JIS X 0213 ѡ */
  ANTHY_ENCODING_SHIFTJISMS,				/**< ShiftJIS Microsoft CP932 ѡ */
  ANTHY_ENCODING_USERDEFINE,				/**< ץ ANTHY_ENCODING_USERDEFINE_NAME ǻꤵ줿ʪ ѡ */
  ANTHY_ENCODING_MAX,					/**< ʼ */
  ANTHY_EUC_JP_ENCODING = ANTHY_ENCODING_EUCJP,		/**< EUC-JP ̾ */
  ANTHY_UTF8_ENCODING = ANTHY_ENCODING_UTF8,		/**< UTF-8 ̾ */
};
#else
/* encoding constants */
#define ANTHY_COMPILED_ENCODING 0
#define ANTHY_EUC_JP_ENCODING 1
#define ANTHY_UTF8_ENCODING 2
#endif
/* reconvert mode */
#define ANTHY_RECONVERT_AUTO 0
#define ANTHY_RECONVERT_DISABLE 1
#define ANTHY_RECONVERT_ALWAYS 2

/* Configuration */
extern int anthy_init(void);
extern void anthy_quit(void);
extern void anthy_conf_override(const char *var, const char *val);
extern int anthy_set_personality(const char *id);



/* Context management */
extern anthy_context_t anthy_create_context(void);
extern void anthy_reset_context(anthy_context_t ac);
extern void anthy_release_context(anthy_context_t ac);



/* Conversion control */
extern int anthy_set_string(anthy_context_t ac, const char *s);
/* nth,resize ie. +1,-1 */
extern void anthy_resize_segment(anthy_context_t ac, int nth, int resize);
extern int anthy_get_stat(anthy_context_t ac, struct anthy_conv_stat *s);
extern int anthy_get_segment_stat(anthy_context_t ac, int n, struct anthy_segment_stat *s);
/* context,nth segment,nth candidate,buffer,buffer len */
extern int anthy_get_segment(anthy_context_t ac, int nth_seg, int nth_cand, char *buf, int buflen);
/* ʸᤴȤ˥ߥåȤ */
extern int anthy_commit_segment(anthy_context_t ac, int s, int c);

/* Prediction */
#define HAS_ANTHY_PREDICTION
extern int anthy_set_prediction_string(anthy_context_t ac, const char* s);
extern int anthy_get_prediction_stat(anthy_context_t ac, struct anthy_prediction_stat *ps);
/* context, nth prediction, buffer, buffer len*/
extern int anthy_get_prediction(anthy_context_t ac, int nth, char* buf, int buflen);
#define HAS_ANTHY_COMMIT_PREDICTION
extern int anthy_commit_prediction(anthy_context_t ac, int nth);

/* Etc */
extern void anthy_print_context(anthy_context_t ac);

extern const char *anthy_get_version_string(void);
typedef void (*anthy_logger)(int lv, const char *msg);
extern void anthy_set_logger(anthy_logger lg, int level);

/* experimental and unstable */
#define HAS_ANTHY_CONTEXT_SET_ENCODING
extern int anthy_context_set_encoding(anthy_context_t ac, int encoding);
#define HAS_ANTHY_SET_RECONVERSION_MODE
extern int anthy_set_reconversion_mode(anthy_context_t ac, int mode);

extern void anthy_checkupdate_baserecord( void );	/**< Patched by G-HAL, Tue,14 Jul,2008, ãʤ last-record2_default  last-record1_default إեå */
extern void anthy_update_base_record( void );		/**< Patched by G-HAL, Thu,21 Aug,2008, Ū last-record2_default  last-record1_default إեå */


#ifdef __cplusplus
}
#endif

#endif /* _anthy_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
