/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ؽǡ
 *@date		Wed,27 Aug,2008 - Fri,29 Aug,2008
 *@date		Wed,15 Oct,2008
 *@date		Fri,17 Oct,2008
 *@date		Wed,22 Oct,2008
 *@date		Tue,13 Jan,2009
 *@date		Wed,11 Feb,2009
 *@date		Wed,18 Nov,2009
 *@date		Wed,29 Sep,2010
 *@date		Tue,12 Oct,2010
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_CSTDINT)
# include <cstdint>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_NEW)
# include <new>
#endif
#if defined(HAVE_STDEXCEPT)
# include <stdexcept>
#endif
#if defined(HAVE_EXCEPTION)
# include <exception>
#endif

#include "anthy/settings.h"
#include "anthy/record.h"
#include "anthy/logger.h"
#include "record_sub.inc"	// extern ̾Τξͤ򤱤١record_sub.c ˤʤä
#include "record_adjustment.h"

#define	USE_THROW
#include "heap_t.h"


/** Ρɤɾͤ׻
 *@param[in]		col			׻оݥΡ
 *@return						ɾ͡ʾۤɾ
 */
static anthy_time_t calc_node_score( const struct trie_node* const col )
{
	static const int	Frequency_MagicNumber = 4;
	const anthy_time_t ret
			= (col->timestamp - anthy_settings.timestamp.currentsession)
			/ (col->frequency + Frequency_MagicNumber);
	return (ret < 0) ? ret : 0;
}



/** Ķʬγؽǡκ
 *@param[in]		rst			оݤΥ쥳
 */
void anthy_truncate_record( struct record_stat* const rst )
{
	if (!rst) {
		return;
	}

	anthy_settings.timestamp.currentsession = time(NULL);

	try {
		HeapT<xstr*,anthy_time_t>*	tree = new(std::nothrow) HeapT<xstr*,anthy_time_t>( anthy_settings.section[NONE_SECTION].max_entry );
		if (NULL == tree) {
			anthy_log( 1, "FATAL ERROR: Out of memory on anthy_truncate_record()" );
			return;
		}
		struct record_section* sec = rst->section_list.next;
		struct record_section* next_sec;

		for (; sec; sec = next_sec) {
			next_sec = sec->next;
			struct trie_node*	col = trie_first(&sec->cols);
			if (!col) {
				// Υ϶
				continue;
			}

			ssize_t	max_entry = anthy_settings.section[sec->section].max_entry;		// Ĥȥ
			if (max_entry < 0) {
				// ΥϺʤ
				continue;
			} else if (0 == max_entry) {
				// Υ
				free_section(rst, sec);
			} else if (0 < max_entry) {
				size_t	count = max_entry;
				tree->clear();
				for (struct trie_node* next; col; col = next) {
					next = trie_next(&sec->cols, col);
					if ((rst->cur_section == sec) && (rst->cur_row == col)) {
						rst->cur_row = NULL;
					}
					const anthy_time_t cur_score = calc_node_score( col );
					if (0 < count) {
						const bool	ret_in = tree->in( &(col->row.key), cur_score );
						if (!ret_in) {
							anthy_log( 1, "FATAL ERROR: An overflow error occurred of an access to an array, on anthy_truncate_record()" );
						}
						count --;
					  #if defined(DEBUG) && (4 <= DEBUG)
						anthy_log( 1, "sec:%d, in: %d, %08"PRIX32"",
								  sec->section, col->row.key.len, col->row.key.str[0] );
					  #endif
					} else {
						const anthy_time_t* const top_val = tree->top_var();
						if (top_val && (cur_score < (*top_val))) {
						  #if defined(DEBUG) && (4 <= DEBUG)
							anthy_log( 1, "sec:%d: %"PRId64" < %"PRId64", delete col: %3d, %04x, %"PRId64", %d",
									  sec->section, cur_score, *top_val,
									  col->row.key.len, col->row.key.str[0],
									  col->timestamp, col->frequency );
						  #endif
							trie_remove( &(sec->cols), &(col->row.key), &(sec->lru_nr_used), &(sec->lru_nr_sused) );
						} else {
							xstr*	key;
							const bool	ret_out = tree->out( &key );
							if (!ret_out) {
								anthy_log( 1, "FATAL ERROR: An underflow error occurred of an access to an array, on anthy_truncate_record()" );
							} else {
							  #if defined(DEBUG) && (4 <= DEBUG)
								anthy_log( 1, "sec:%d: %"PRId64" > %"PRId64", delete top: %3d, %04"PRIX32"",
										  sec->section, cur_score, *top_val,
										  key->len, key->str[0] );
							  #endif
								const int	ret_remove = trie_remove( &(sec->cols), key, &(sec->lru_nr_used), &(sec->lru_nr_sused) );
								if (!ret_remove) {
									anthy_log( 1, "FATAL ERROR: sec:%d, trie_remove() failed. :top",
											  sec->section );
								}
							}
							const bool	ret_in = tree->in( &(col->row.key), cur_score );
							if (!ret_in) {
								anthy_log( 1, "FATAL ERROR: An overflow error occurred of an access to an array, on anthy_truncate_record()" );
							}
						}
					}
				}
			}
		}

		delete tree;
	}
	catch (const std::bad_alloc &e) {
		anthy_log( 1, "FATAL ERROR: src-worddic/record_truncate.cc: Out of memory on anthy_truncate_record()" );
		return;
	}
	catch (const HeapT<xstr*,anthy_time_t>::range_error &e) {
		anthy_log( 1, "FATAL ERROR: src-worddic/record_truncate.cc: catch (range_error): ***BUG***" );
		return;
	}
	catch (const HeapT<xstr*,anthy_time_t>::out_of_range &e) {
		anthy_log( 1, "FATAL ERROR: src-worddic/record_truncate.cc: catch (out_of_range): ***BUG***" );
		return;
	}
	catch (...){
		anthy_log( 1, "FATAL ERROR: src-worddic/record_truncate.cc: catch (...): ***BUG***" );
		return;
	}

	return;
}

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
