/*
 * ؽʤɤ뤿Υǡ١
 * ʸ(xstr)򥭡ˤƹ®˹(row)򸡺뤳ȤǤ롥
 * ʣΥĤȤǤؽΰ㤦եʤɤб
 *  ( * ʸ -> )
 * ƹԤʸ󤫿ˤʤäƤ
 *
 * ֥ѥȥꥷȥ饤פȤǡ¤ѤƤ롣
 * θʤɤ򰷤äƤ붵ʽ򻲾ȤΤ
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/*
 * Funded by IPA̤Ƨեȥ¤ 2002 1/18
 * Funded by IPA̤Ƨեȥ¤ 2005
 * Copyright (C) 2005 YOSHIDA Yuichi
 * Copyright (C) 2000-2006 TABATA Yusuke
 * Copyright (C) 2000-2003 UGAWA Tomoharu
 * Copyright (C) 2001-2002 TAKAI Kosuke
 */
/*
 * ѡʥƥ""ƿ̾ѡʥƥǤꡤ
 * եؤɤ߽񤭤ϹԤʤ
 */
#if 0		/* Patched by G-HAL */
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include <anthy/anthy.h>
#include <anthy/dic.h>
#include <anthy/alloc.h>
#include <anthy/conf.h>
#include <anthy/ruleparser.h>
#include <anthy/record.h>
#include <anthy/logger.h>
#include <anthy/prediction.h>

#include "dic_main.h"
#include "dic_personality.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_ERRNO_H)
# include <errno.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>
#endif
#if defined(HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_ARPA_INET_H)
# include <arpa/inet.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_NETINET_IN_H)
# include <netinet/in.h>
#endif
#if defined(HAVE_SYS_ENDIAN_H)
# include <sys/endian.h>
#endif
#if defined(HAVE_ENDIAN_H)
# include <endian.h>
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_ALLOCA_H)
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/settings.h"	/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "src-diclib/alternative_strlcpy.h"	/* Patched by G-HAL, Fri,31 Oct,2008 */
#include "src-diclib/alternative_mergesort.h"	/* Patched by G-HAL, Sun,02 Nov,2008 */
#include "anthy/xstr.h"		/* Patched by G-HAL, Fri,31 Oct,2008 */
#include "anthy/anthy.h"
#include "anthy/dic.h"
#include "anthy/alloc.h"
#include "anthy/conf.h"
#include "anthy/ruleparser.h"
#include "anthy/record.h"
#include "anthy/logger.h"
#include "anthy/prediction.h"
#include "anthy/dicutil.h"	/* Patched by G-HAL, Wed,14 Jan,2009 */
#include "dic_main.h"
#include "dic_personality.h"
#include "dic_learn.h"		/* Patched by G-HAL, Fri,31 Oct,2008 */
#include "record_sub.inc"	/* Patched by G-HAL, Wed,27 Aug,2008, extern ̾Τξͤ򤱤١record_sub.c ˤʤä */
#include "record_adjustment.h"	/* Patched by G-HAL, Wed,27 Aug,2008 */
#endif

/* Ŀͼ򥻡֤ե̾suffix */
/* #define ENCODING_SUFFIX ".utf8"*/	/* Patched by G-HAL, Fri,31 Oct,2008 */


#if 0	/* Patched by G-HAL, Wed,27 Aug,2008 */
enum val_type {
  RT_EMPTY, RT_VAL, RT_XSTR, RT_XSTRP
};

/*  */
struct record_val {
  enum val_type type;
  union {
    xstr str;
    int val;
    xstr* strp;
  } u;
};

/*  */
struct record_row {
  xstr key;
  int nr_vals;
  struct record_val *vals;
};

/* trie node */
struct trie_node {
  struct trie_node *l;
  struct trie_node *r;
  int bit;
  struct record_row row;
  struct trie_node *lru_prev, *lru_next; /* ξü롼 */
  int dirty; /* LRU Τ used, sused ӥå */
  time_t	timestamp;	/* ޴Υ Patched by G-HAL, Fri,22 Aug,2008 */
  int		frequency;	/* ޴Υ Patched by G-HAL, Fri,22 Aug,2008 */
};

/* trie treeroot */
struct trie_root {
  struct trie_node root;
  allocator node_ator;
};

#define LRU_USED  UINT8_C(0x01)
#define LRU_SUSED UINT8_C(0x02)
#define PROTECT   UINT8_C(0x04) /* ʬ񤭽Ф˻Ȥ(LRUȤϴطʤ)
			*   ʬ񤭽ФǤϡե˽񤭽Ф
			*   ե¾ΥץϿ
			*   ɤ߹ࡣˤäơ줫ɲä
			*   ȤΡɤäΤɤ
			*/
/*
 * LRU:
 *   USED:  ǻȤ줿
 *   SUSED: ¸줿 used ӥå
 *
 * LRUꥹȾǤϡ USED ɬꥹƬ¤Ǥ뤬 SUSED 
 * ե饰ʤΥΡɤȺߤƤǽ롣
 *
 * nĤĤ褦˻ꤵ줿ư
 *    1. used > n
 *        LRU ꥹȤƬ n ܰʹߤä
 *    2. used + sused > n
 *        used -> Ĥ
 *        sused -> sused ե饰
 *        ʳ -> ä
 *    3. ʳ
 *        ƻĤ
 * ե˽񤭽Фˡ used || sused -> sused Ȥƽ񤭽Ф
 */

/**  */
struct record_section {
  const char *name;
  struct trie_root cols;
  struct record_section *next;
  int lru_nr_used, lru_nr_sused; /* LRU  */
};

/** ǡ١ */
struct record_stat {
  struct record_section section_list; /* sectionΥꥹ*/
  struct record_section *cur_section;
  struct trie_root xstrs; /* xstr  intern 뤿 trie */
  struct trie_node *cur_row;
  int row_dirty; /* cur_row ¸ɬפ뤫 */
  int encoding;
  /**/
  int is_anon;
  const char *id;         /* ѡʥƥid */
  char *base_fn; /* ܥե Хѥ */
  char *journal_fn; /* ʬե Хѥ */
  /**/
  time_t base_timestamp; /* ܥեΥॹ */
  int last_update;  /* ʬեκǸɤ */
  time_t journal_timestamp; /* ʬեΥॹ */
};
#endif


#if 0		/* Patched by G-HAL, Thu,21 Aug,2008 */
/* ʬ100KBۤܥեإޡ */
#define FILE2_LIMIT 102400
#endif

static void save_base_record_bin( struct record_stat* const rst );	/* Patched by G-HAL, Thu,16 Oct,2008 */


/*
 * xstr  intern:
 *  Ŀͤ( record_stat )ʸ intern 롣ϡ
 *  ¾ˡǡ١ flush ˥ǡ١
 *  ͳ褹 xstr ̵ˤʤΤɤŪ롣
 *  äơǡ١ flush Ǥ xstr  intern 
 *  Υǡ١ xstrs ϤΤޤ¸롣
 *
 *  xstrs: xstr  intern ѤΥǡ١
 *         row  key  intern 줿 xstr ȤƻȤ
 *         row  value ϻʤ
 *                    (Ūˤϻȥ󥿤ĤƤ⤤)
 *  : intern_xstr()
 */

/*
 * ʬ񤭽Ф:
 *  ǡ١¸ʣ anthy 饤֥󥯤
 *  ץγؽƱΤˡؽι
 *  ե˽񤭽Ф
 *
 * ܥե  Ť anthy γؽƱ
 *                 ʬŬѤ븵Ȥʤե롣
 *                 Ūˤϵưɤ߹ࡣ
 *                 Υץǥե1baseȸƤ֤Ȥ롣
 * ʬե  ܥեФ빹
 *                 ǡ١Ф빹ߥåȤ뤿Ӥ
 *                 ɤ߽񤭤롣
 *                 Υץǥե2journalȸƤ֤Ȥ롣
 *  :
 *     ǡ١Ф빹ߥåȤȡޤʬե
 *     ¾Υץɲäɤ߹ߡθ˼ʬ
 *     ߥåȤʬե˽񤭽Ф
 *     ϥåեѤƥȥߥå˹Ԥ롣ޤ
 *     ܥե롢ʬեȤ⡢åäƤ֤
 *     ץ󤷤ƤƤϤʤ
 *  ɲäȺ:
 *     ɲäϤǤ˥ǹ줿 row 򥳥ߥåȤˤä
 *     ˽񤭽Фᡢ
 *       1. ߥåо row ʳʬեξ
 *       2. ߥåо row ʬե˽񤭽Ф
 *     Ȥ롣Ϥޤ row ĤäƤ֤ǥߥå
 *     Ԥ(׵򥳥ߥåȤȤư)ᡢ
 *       1. ξʬե˽񤭽Ф
 *       2. ʬեɤ߹ߤˤ׵¹Ԥ
 *     Ȥ롣
 *  ܥեι:
 *     ʬե뤬粽ȡʬեξ
 *     ܥեȿǤƺʬեˤ롣
 *     ץ:
 *       ʬե˽񤭽ФԤä塢ʬե礭Ĵ١
 *       粽ƤСΤȤΥΥǡ١(ˤ
 *       ƤκʬեιŬѤƤ)ܥե
 *       񤭽Ф
 *     ʳΥץ:
 *       ʬեɤˡܥե뤬Ƥ뤫
 *       եΥॹפĴ١ƤСߥå
 *       줿ľ˹եɲä
 *       ǡ١ flush ܥե롢ʬե
 *       ɤ߹ľ
 *       ǡ١ flush ˤꡢ
 *           cur_row ̵ˤʤ (NULL ˤʤ)
 *           cur_section ͭ¸(sectionϲʤ)
 *           xstr  intern Ƥ¸
 *                              (٤Ƥ xstr  intern ƤϤ)
 *   ɡͤˤʤ:
 *     if (ܥե뤬Ƥ) {
 *             ʬեإߥåȤ줿񤭽Ф;
 *             ǡ١Υեå;
 *             ܥեɹȺʬեκǽɹ֥ꥢ;
 *             ʬեɹȺʬեκǽɹֹ;
 *     } else {
 *             if (ɲ) {
 *                     ʬեɹȺʬեκǽɹֹ;
 *                     ʬեؤν񤭽Ф;
 *             } else {
 *                     ʬեؤν񤭽Ф;
 *                     ʬեɹȺʬեκǽɹֹ;
 *             }
 *     }
 *     if (ʬե뤬礭) {
 *             ܥեؤν񤭽Ф;
 *             ʬեΥꥢ;
 *     }
 */

static allocator record_ator;

/* trie */
#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
static void init_trie_root(struct trie_root *n);
static int trie_key_nth_bit(xstr* key, int n);
#endif
static int trie_key_first_diff_bit_1byte(xchar c1, xchar c2);
static int trie_key_first_diff_bit(xstr *k1, xstr *k2);
#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
static int trie_key_cmp(xstr *k1, xstr *k2);
#endif
static void trie_key_dup(xstr *dst, xstr *src);
#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
static void trie_row_init(struct record_row *rc);
static void trie_row_free(struct record_row *rc);
#endif
static struct trie_node *trie_find(struct trie_root *root, xstr *key);
static struct trie_node *trie_insert(struct trie_root *root, xstr *key,
				     int dirty, int *nr_used, int *nr_sused);
#if 0	/* Patched by G-HAL, Wed,27 Aug,2008 - Thu,28 Aug,2008 */
static void trie_remove(struct trie_root *root, xstr *key,
			int *nr_used, int *nr_sused);
static struct trie_node *trie_first(struct trie_root *root);
static struct trie_node *trie_next(struct trie_root *root,
				   struct trie_node *cur);
static void trie_remove_all(struct trie_root *root,
			    int *nr_used, int *nr_sused);
static void trie_remove_old(struct trie_root *root, int count,
			    int* nr_used, int* nr_sused);
#endif
static void trie_mark_used(struct trie_root *root, struct trie_node *n,
			   int *nr_used, int *nr_sused);


/*
 * ȥ饤μ
 * struct trie_nodeΤrowʳʬrow.key
 * λtrie_row_freeȤärowƤ
 */

#define PUTNODE(x) ((x) == &root->root ? printf("root\n") : anthy_putxstrln(&(x)->row.key))
static int
debug_trie_dump(FILE* fp, struct trie_node* n, int encoding)
{
  int cnt = 0;
  char buf[1024];

  if (n->l->bit > n->bit) {
    cnt = debug_trie_dump(fp, n->l, encoding);
  } else {
    if (n->l->row.key.len == -1) {
      if (fp) {
	fprintf(fp, "root\n");
      }
    } else {
      if (fp) {
       #if 0	/* Patched by G-HAL, Tue,09 Jun,2009 */
	anthy_sputxstr(buf, &n->l->row.key, encoding);
       #else
	anthy_snputxstr( buf, sizeof(buf), &(n->l->row.key), encoding );
       #endif
	fprintf(fp, "%s\n", buf);
      }
      cnt = 1;
    }
  }

  if (n->r->bit > n->bit) {
    return cnt + debug_trie_dump(fp, n->r, encoding);
  } else {
    if (n->r->row.key.len == -1) {
      if(fp) {
	fprintf(fp, "root\n");
      }
    } else {
      if(fp) {
       #if 0	/* Patched by G-HAL, Tue,09 Jun,2009 */
	anthy_sputxstr(buf, &n->r->row.key, encoding);
       #else
	anthy_snputxstr( buf, sizeof(buf), &(n->r->row.key), encoding );
       #endif
	fprintf(fp, "%s\n", buf);
      }
      return cnt + 1;
    }
  }

  return cnt;
}

#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
static void
init_trie_root(struct trie_root *root)
{
  struct trie_node* n;
  root->node_ator = anthy_create_allocator(sizeof(struct trie_node), NULL);
  n = &root->root;
  n->l = n;
  n->r = n;
  n->bit = 0;
  n->lru_next = n;
  n->lru_prev = n;
  n->dirty = 0;
  trie_row_init(&n->row);
  n->row.key.len = -1;
  n->timestamp = 0;		/* Patched by G-HAL, Fri,22 Aug,2008 */
  n->frequency = 0;		/* Patched by G-HAL, Fri,22 Aug,2008 */
}

/*
 * bit0: 0
 * bit1: headΥ0
 * bit2: ʸΥӥå0
 * bit3: ʸΥӥå1
 *   ...
 * ʸĹۤ0
 */
static int
trie_key_nth_bit(xstr* key, int n)
{
  switch (n) {
  case 0:
    return 0;
  case 1:
    return key->len + 1; /* key->len == -1 ? 0 : non-zero */
  default:
    {
      int pos;
      n -= 2;
      pos = n / (sizeof(xchar) << 3);
      if (pos >= key->len) {
	return 0;
      }
      return key->str[pos] & (1 << (n % (sizeof(xchar) << 3)));
    }
  }
}
#endif

/* c1 == c2 ǤϸƤǤϤʤ */
static int
trie_key_first_diff_bit_1byte(xchar c1, xchar c2)
{
  int i;
  int ptn;
  for (i = 0, ptn = c1 ^ c2; !(ptn & 1); i++, ptn >>= 1 )
    ;
  return i;
}

/*
 * k1 == k2 ǤϸƤǤϤʤ
 * ki->str[0 .. (ki->len - 1)]0ϤʤȲ
 */
#define MIN(a,b) ((a)<(b)?(a):(b))
static int
trie_key_first_diff_bit(xstr *k1, xstr *k2)
{
  int len;
  int i;

  len = MIN(k1->len, k2->len);
  if (len == -1) {
    return 1;
  }
  for ( i = 0 ; i < len ; i++ ){
    if (k1->str[i] != k2->str[i]) {
      return (2 + (i * (sizeof(xchar) << 3)) +
	      trie_key_first_diff_bit_1byte(k1->str[i], k2->str[i]));
    }
  }
  if (k1->len < k2->len) {
    return (2 + (i * (sizeof(xchar) << 3)) +
	    trie_key_first_diff_bit_1byte(0, k2->str[i]));
  } else {
    return (2 + (i * (sizeof(xchar) << 3)) +
	    trie_key_first_diff_bit_1byte(k1->str[i], 0));
  }
}
#undef MIN

#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
static int
trie_key_cmp(xstr *k1, xstr *k2)
{
  if (k1->len == -1 || k2->len == -1) {
    return k1->len - k2->len;
  }
  return anthy_xstrcmp(k1, k2);
}
#endif

static void
trie_key_dup(xstr *dst, xstr *src)
{
  dst->str = anthy_xstr_dup_str(src);
  dst->len = src->len;
}

/*
 * Ĥʤ 0
 */
static struct trie_node *
trie_find(struct trie_root *root, xstr *key)
{
  struct trie_node *p;
  struct trie_node *q;

  p = &root->root;
  q = p->l;
  while (p->bit < q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  return trie_key_cmp(&q->row.key,key) ? NULL : q;
}

/*
 * ĹޥåΤؿ
 *  key õơϤưפʤʤäΡɤ֤
 */
static struct trie_node *
trie_find_longest (struct trie_root* root, xstr *key)
{
  struct trie_node *p;
  struct trie_node *q;

  p = &root->root;
  q = p->l;
  while (p->bit < q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }

  return q;
}

/*
 * ɲäΡɤ֤
 * ǤƱĥΡɤȤϡɲä0֤
 */
static struct trie_node *
trie_insert(struct trie_root *root, xstr *key,
	    int dirty, int *nr_used, int *nr_sused)
{
  struct trie_node *n;
  struct trie_node *p;
  struct trie_node *q;
  int i;

  p = &root->root;
  q = p->l;
  while (p->bit < q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  if (trie_key_cmp(&q->row.key,key) == 0) {
    if (q->dirty & PROTECT) {	/* Patched by G-HAL, Thu,30 Oct,2008 */
      return NULL;
    }
    /* USED > SUSED > 0 ǶĤ */
    if (dirty == LRU_USED) {
      trie_mark_used(root, q, nr_used, nr_sused);
    } else if (q->dirty == 0) {
      q->dirty = dirty;
    }
    return 0;
  }
  i = trie_key_first_diff_bit(&q->row.key, key);
  p = &root->root;
  q = p->l;
  while (p->bit < q->bit && i > q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  n = (struct trie_node*) anthy_smalloc(root->node_ator);
  trie_row_init( &(n->row), root->default_nr_num );	/* Patched by G-HAL, Fri,17 Oct,2008 */
  trie_key_dup(&n->row.key, key);
  n->bit = i;
  if (trie_key_nth_bit(key, i)) {
    n->l = q;
    n->r = n;
  } else {
    n->l = n;
    n->r = q;
  }
  if (p->l == q) {
    p->l = n;
  } else {
    p->r = n;
  }

  /* LRU ν */
  if (dirty == LRU_USED) {
    root->root.lru_next->lru_prev = n;
    n->lru_prev = &root->root;
    n->lru_next = root->root.lru_next;
    root->root.lru_next = n;
    (*nr_used)++;
  } else {
    root->root.lru_prev->lru_next = n;
    n->lru_next = &root->root;
    n->lru_prev = root->root.lru_prev;
    root->root.lru_prev = n;
    if (dirty == LRU_SUSED) {
      (*nr_sused)++;
    }
  }
  n->dirty = dirty;
  n->timestamp = anthy_settings.timestamp.initial;	/* Patched by G-HAL, Fri,22 Aug,2008, Sun,12 Oct,2008 */
  n->frequency = 0;		/* Patched by G-HAL, Fri,22 Aug,2008 */
  return n;
}

#if 0	/* Patched by G-HAL, Wed,27 Aug,2008 - Thu,28 Aug,2008 */
/*
 * Ρɤ򸫤ĤȺ
 * trie_row_freeƤӡޤǡʬfree
 *
 * ǡȥΡɤ롣
 * оݤΥǡϺоݤΥΡɤ˳ǼƤȤ
 * ¤ʤȤա
 * 1. оݤդĥΡɤ˺оݤդޤޤƤȤ
 *  оݤΥΡɤϡҤؤλޤΤΤޤƤϤƻ
 * 2. оݤդĥΡɤ˺оݤդޤޤƤȤ
 *  1. ˲äơоݤդĥΡɤ򻦤ơ˺
 *  оݤΥΡɤоݤդĥΡɤΰ֤˰ư
 */
static void
trie_remove(struct trie_root *root, xstr *key,
	    int *nr_used, int *nr_sused)
{
  struct trie_node *p;
  struct trie_node *q;
  struct trie_node **pp = NULL; /* gcc  warning  */
  struct trie_node **qq;
  p = &root->root;
  qq = &p->l;
  q = *qq;
  while (p->bit < q->bit) {
    pp = qq;
    p = q;
    qq = trie_key_nth_bit(key,p->bit) ? &p->r : &p->l;
    q = *qq;
  }
  if (trie_key_cmp(&q->row.key, key) != 0) {
    return ;
  }
  if (p != q) {
    /* case 2. */
    struct trie_node *r;
    struct trie_node *s;
    r = &root->root;
    s = r->l;
    while (s != q) {
      r = s;
      s = trie_key_nth_bit(key, r->bit) ? r->r : r->l;
    }
    *pp = (p->r == q) ? p->l : p->r;
    p->l = q->l;
    p->r = q->r;
    p->bit = q->bit;
    if (trie_key_nth_bit(key, r->bit)) {
      r->r = p;
    } else {
      r->l = p;
    }
    p = q;
  } else {
    *pp = (p->r == q) ? p->l : p->r;
  }
  p->lru_prev->lru_next = p->lru_next;
  p->lru_next->lru_prev = p->lru_prev;
  if (p->dirty == LRU_USED) {
    (*nr_used)--;
  } else if (p->dirty == LRU_SUSED) {
    (*nr_sused)--;
  }
  trie_row_free(&p->row);
  anthy_sfree(root->node_ator, p);
}

/* headʳΥΡɤʤ 0 ֤ */
static struct trie_node *
trie_first (struct trie_root *root)
{
  return root->root.lru_next == &root->root ?
    NULL : root->root.lru_next;
}

/* ΥΡɤʤ 0 ֤ */
static struct trie_node *
trie_next (struct trie_root *root,
	   struct trie_node *cur)
{
  return cur->lru_next == &root->root ? 0 : cur->lru_next;
}

/*
 * headʳƤΥΡɤ
 * trie_row_freeƤӡޤǡʬfree
 */
static void
trie_remove_all (struct trie_root *root,
		 int *nr_used, int *nr_sused)
{
  struct trie_node* p;
  for (p = root->root.lru_next; p != &root->root; p = p->lru_next) {
    trie_row_free(&p->row);
  }
  anthy_free_allocator(root->node_ator);
  init_trie_root(root);
  *nr_used = 0;
  *nr_sused = 0;
}

/*
 * LRU ꥹȤƬ count ܤޤǤĤƻĤ
 */
static void
trie_remove_old (struct trie_root *root, int count,
		 int *nr_used, int *nr_sused)
{
  struct trie_node *p;
  struct trie_node *q;

  if (*nr_used > count) {
    for (p = root->root.lru_next; count; count--, p = p->lru_next)
      ;
    /* p  head ޤǤä */
    for ( ; p != &root->root; p = q) {
      q = p->lru_next;
      trie_remove(root, &p->row.key, nr_used, nr_sused);
    }
  } else if (*nr_used + *nr_sused > count) {
    for (p = root->root.lru_next; p->dirty == LRU_USED; p = p->lru_next)
      ;
    /*
     * p  root ޤ  sused    -> dirty := 0
     *                   ʳ -> ä
     */
    for ( ; p != &root->root; p = q) {
      q = p->lru_next;
      if (p->dirty == LRU_SUSED) {
	p->dirty = 0;
      } else {
	trie_remove(root, &p->row.key, nr_used, nr_sused);
      }
    }
    *nr_sused = 0;
  }
}
#endif

static void
trie_mark_used (struct trie_root *root, struct trie_node *n,
		int *nr_used, int *nr_sused)
{
  switch(n->dirty) {
  case LRU_USED:
    break;
  case LRU_SUSED:
    (*nr_sused)--;
    /* fall through */
  default:
    n->dirty = LRU_USED;
    (*nr_used)++;
    break;
  }
  n->lru_prev->lru_next = n->lru_next;
  n->lru_next->lru_prev = n->lru_prev;
  root->root.lru_next->lru_prev = n;
  n->lru_next = root->root.lru_next;
  root->root.lru_next = n;
  n->lru_prev = &root->root;
}

/*
 * ȥ饤μϤޤ
 */

static xstr *
do_get_index_xstr(struct record_stat *rec)
{
  if (!rec->cur_row) {
    return 0;
  }
  return &rec->cur_row->row.key;
}

#if 0	/* Patched by G-HAL, Fri,17 Oct,2008 */
static struct record_section*
do_select_section(struct record_stat *rst, const char *name, int flag)
#else
static struct record_section* const
do_select_section( struct record_stat* const rst, const enum ANTHY_SECTIONS_ section, int flag)
#endif
{
  struct record_section *rsc;

  for (rsc = rst->section_list.next; rsc; rsc = rsc->next) {
   #if 0	/* Patched by G-HAL, Fri,17 Oct,2008 */
    if (!strcmp(name, rsc->name)) {
      return rsc;
    }
   #else
    if (section == rsc->section) {
      return rsc;
    }
   #endif
  }

  if (flag) {
    rsc = (struct record_section*) malloc(sizeof(struct record_section));
    /* rsc->name = strdup(name); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
    rsc->section = section;		/* Patched by G-HAL, Fri,17 Oct,2008 */
    rsc->default_nr_num = anthy_settings.section[section].default_nr_num;	/* Patched by G-HAL, Fri,17 Oct,2008 */
    rsc->inc_nr_num     = anthy_settings.section[section].inc_nr_num;		/* Patched by G-HAL, Thu,23 Oct,2008 */
    rsc->next = rst->section_list.next;
    rst->section_list.next = rsc;
    rsc->lru_nr_used = 0;
    rsc->lru_nr_sused = 0;
    init_trie_root(&rsc->cols);
    rsc->cols.default_nr_num = rsc->default_nr_num;	/* Patched by G-HAL, Fri,17 Oct,2008 */
    return rsc;
  }

  return NULL;
}

/** ̾饻ֹѴ
 *@param[in]	name		̾
 *@ret				ֹ桢Ĥʤ MAX_SECTION ֤
 *
 * Patched by G-HAL, Thu,30 Oct,2008
 */
static enum ANTHY_SECTIONS_ convert_section_name2number( const char* const name )
{
  enum ANTHY_SECTIONS_ sec_number;
  for (sec_number = NONE_SECTION; sec_number < MAX_SECTION; ++sec_number) {
    if (!strcmp(name, anthy_settings.section[sec_number].name)) {
      break;
    }
  }
  return sec_number;
}

static struct trie_node*
do_select_longest_row(struct record_section *rsc, xstr *name)
{
  /* Commented by G-HAL ա do_select_longest_row() ϡʸʾΤ߸ */
  struct trie_node *mark, *found;
  xstr xs;
  int i;

  if ((NULL == name) || (NULL == name->str) || (name->len < 1) || (0 == name->str[0])) {
    /* ⤷ϳؽǡƤк */
    return NULL;
  }

  mark = trie_find_longest(&rsc->cols, name);
  xs.str = name->str;
  for (i = (mark->row.key.len <= name->len) ? mark->row.key.len : name->len; i > 1; i--) {  /* ʥꥢν */
    /* 롼ȥΡɤ i == 1 ǥޥåΤǽ
     * trie_key_nth_bit 
     */
    xs.len = i;
    found = trie_find(&rsc->cols, &xs);
    if (found) {
      return found;
    }
  }
  return NULL;
}

static struct trie_node*
do_select_row(struct record_section* rsc, xstr *name,
		 int flag, int dirty)
{
  struct trie_node *node;

  if (flag) {
    node = trie_insert(&rsc->cols, name, dirty,
		       &rsc->lru_nr_used, &rsc->lru_nr_sused);
    if (node) {
     #if 0	/* Patched by G-HAL, Mon,13 Oct,2008 */
      node->row.nr_vals = 0;
      node->row.vals = 0;
     #endif
    } else {
      node = trie_find(&rsc->cols, name);
    }
  } else {
    node = trie_find(&rsc->cols, name);
  }
  return node;
}

/** row򤷳ؽƤӽФѡ
 *@param[in]	rsc			õ륻
 *@param[in]	idx			õ륤ǥåʸ
 *@param	create_if_not_exist	̵ɲä
 *@param	force_countup		ʣؽȻפǤ⶯Ūٹ
 *@param	timestamp		Ͽ빹
 *@return				ؽΡ
 *
 * Patched by G-HAL, Sat,23 Aug,2008, Thu,30 Oct,2008
 */
static struct trie_node* const do_select_row_with_learn( struct record_section* const rsc, const xstr* const idx, int create_if_not_exist, int force_countup, anthy_time_t timestamp )
{
  struct trie_node* const node = do_select_row( rsc, idx, create_if_not_exist, LRU_USED );
  if (!node) {
    return NULL;
  }

  if (force_countup || (node->timestamp != timestamp)) {
    node->timestamp = timestamp;
    if (node->frequency < INT_MAX) {
      node->frequency = node->frequency + 1;
    }
  }
  return node;
}


static void
do_mark_row_used(struct record_section* rsc, struct trie_node* node)
{
  trie_mark_used(&rsc->cols, node, &rsc->lru_nr_used, &rsc->lru_nr_sused);
}

#if 0	/* Patched by G-HAL, Wed,27 Aug,2008 */
static void
do_truncate_section(struct record_stat *s, int count)
{
  if (!s->cur_section) {
    return;
  }

  trie_remove_old(&s->cur_section->cols, count,
		  &s->cur_section->lru_nr_used,
		  &s->cur_section->lru_nr_sused);
}
#endif


static struct trie_node*
do_select_first_row(struct record_section *rsc)
{
  return trie_first(&rsc->cols);
}

static struct trie_node*
do_select_next_row(struct record_section *rsc,
  struct trie_node* node)
{
  return trie_next(&rsc->cols, node);
}


static int
do_get_nr_values(struct trie_node *node)
{
  if (!node)
    return 0;
  return node->row.nr_vals;
}

static struct record_val *
get_nth_val_ent(struct trie_node *node, int n, size_t inc_nr_num )
{
  struct record_row *col;
  col = &node->row;
  if (n < 0) {
    return NULL;
  }
  if (n < do_get_nr_values(node)) {
    return &col->vals[n];
  }
  if (0 < inc_nr_num) {	/* Patched by G-HAL, Thu,23 Oct,2008 */
    int i;
  #if 0		/* Patched by G-HAL, Mon,13 Oct,2008, Fri,17 Oct,2008, Thu,23 Oct,2008 */
    col->vals = realloc(col->vals, sizeof(struct record_val)*(n + 1));
  #else
    if (col->max_nr_vals < (n + 1)) {
      col->max_nr_vals += inc_nr_num * ((int)( ((n + 1) - col->max_nr_vals) / inc_nr_num ) + 1);
      col->vals = (struct record_val*) realloc(col->vals, sizeof(struct record_val) * col->max_nr_vals );
    }
  #endif
    for (i = col->nr_vals; i < n+1; i++) {
      col->vals[i].type = RT_EMPTY;
    }
    col->nr_vals = n + 1;
    return &col->vals[n];
  }
  return NULL;
}

#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
static void
free_val_contents(struct record_val* v)
{
  switch (v->type) {
  case RT_XSTR:
    anthy_free_xstr_str(&v->u.str);
    break;
  case RT_XSTRP:
  case RT_VAL:
  case RT_EMPTY:
  default:
    break;
  }
}
#endif

static void
do_set_nth_value( const struct record_section* const rsc, struct trie_node* const node, int nth, int val )
{
  struct record_val *v = get_nth_val_ent(node, nth, rsc->inc_nr_num );	/* Patched by G-HAL, Thu,23 Oct,2008 */
  if (!v) {
    return ;
  }
  free_val_contents(v);
  v->type = RT_VAL;
  v->u.val = val;
}

/* Patched by G-HAL, Wed,22 Oct,2008 */
static void do_set_nth_int64( const struct record_section* const rsc, struct trie_node* const node, int nth, int64_t val )
{
  struct record_val *v = get_nth_val_ent( node, nth, rsc->inc_nr_num );
  if (!v) {
    return ;
  }
  free_val_contents(v);
  v->type = RT_INT64;
  v->u.int64 = val;
}

static int
do_get_nth_value(struct trie_node *node, int n)
{
  struct record_val *v = get_nth_val_ent(node, n, 0);
  if (v && v->type == RT_VAL) {
    return v->u.val;
  }
  return 0;
}

/* Patched by G-HAL, Wed,22 Oct,2008 */
static int64_t do_get_nth_int64( struct trie_node* const node, int n )
{
  struct record_val* const v = get_nth_val_ent( node, n, 0 );
  if (!v) {
    return 0;
  }
  if (v->type == RT_INT64) {
    return v->u.int64;
  }
  if (v->type == RT_VAL) {
    return v->u.val;
  }
  return 0;
}

static xstr*
intern_xstr (struct trie_root* xstrs, xstr* xs)
{
  struct trie_node* node;
  int dummy;

  if ((NULL == xs) || (xs->len < 0)) {
    /* ⤷ϳؽǡƤк */
    return NULL;
  }
  node = trie_find(xstrs, xs);
  if (!node)
    node = trie_insert(xstrs, xs, 0, &dummy, &dummy);
  return &node->row.key;
}

static void
do_set_nth_xstr( const struct record_section* const rsc,
		struct trie_node* const node, int nth, xstr *xs,
		struct trie_root* const xstrs )
{
  struct record_val *v = get_nth_val_ent(node, nth, rsc->inc_nr_num );	/* Patched by G-HAL, Thu,23 Oct,2008 */
  if (!v){
    return ;
  }
  free_val_contents(v);
  v->type = RT_XSTRP;
  v->u.strp = intern_xstr(xstrs, xs);
}

static void
do_truncate_row (struct trie_node* node, int n)
{
  int i;
  if (n < node->row.nr_vals) {
    for (i = n; i < node->row.nr_vals; i++) {
      free_val_contents(node->row.vals + i);
    }
  #if 0		/* Patched by G-HAL, Mon,13 Oct,2008 */
    node->row.vals = realloc(node->row.vals,
				sizeof(struct record_val)* n);
  #endif
    node->row.nr_vals = n;
  }
}

static void
do_remove_row (struct record_section* rsc,
		  struct trie_node* node)
{
  xstr* xs;
  xs = anthy_xstr_dup(&node->row.key);
  trie_remove(&rsc->cols, &node->row.key,
	      &rsc->lru_nr_used, &rsc->lru_nr_sused);

  anthy_free_xstr(xs);
}

static xstr *
do_get_nth_xstr(struct trie_node *node, int n)
{
  struct record_val *v = get_nth_val_ent(node, n, 0);
  if (v) {
    if (v->type == RT_XSTR) {
      return &v->u.str;
    } else if (v->type == RT_XSTRP) {
      return v->u.strp;
    }
  }
  return 0;
}

#if 0	/* Patched by G-HAL, Tue,14 Jul,2008 */
static void
lock_record (struct record_stat* rs)
{
  if (rs->is_anon) {
    return ;
  }
  anthy_priv_dic_lock();
}

static void
unlock_record (struct record_stat* rs)
{
  if (rs->is_anon) {
    return ;
  }
  anthy_priv_dic_unlock();
}
#endif

#if 0
/* ɤ߹ߤɬפ뤫å
 * ɬפ֤ͤ0ˤʤ */
static int
check_base_record_uptodate(struct record_stat *rst)
#else
/** ܥ쥳ɤκɹɬפݤ
 *@param[in]		rst			쥳ɴ
 *@retval		0			ɬ
 *@retval		1			
 *
 *@comment
 *	Commented by G-HAL
 *		Wed,29 Sep,2010
 */
static int check_base_record_uptodate( const struct record_stat* const rst )
#endif
{
  struct stat st;
  if (rst->is_anon) {
    return 1;
  }
  anthy_check_user_dir();
  if (stat(rst->base_fn, &st) < 0) {
    return 0;
  } else if (st.st_mtime != rst->base_timestamp) {
    return 0;
  }
  return 1;
}


/** ؽɲä
 *@param[in]	rst		Ͽ쥳
 *@param[in]	rsc		Ͽ襻
 *@param[in]	node		Ͽrow
 *@param[in]	commit_xs_arg	Ͽʸ
 *@param	frequency_arg	پ˲û
 *@param	timestamp_arg	Ͽ빹
 *@param	reorder_to_top	ϿܤŪƬˤ(1)(0)
 *@retval	0		
 *@retval	1		ɲä
 *
 *	Patches by G-HAL
 *		Sat,23 Aug,2008
 *		Fri,17 Oct,2008
 *		Wed,22 Oct,2008 - Thu,23 Oct,2008
 *		Thu,30 Oct,2008 - Fri,31 Oct,2008
 *		Fri,07 Nov,2008, Tue,18 Nov,2008
 *		Tue,13 Jan,2009 - Wed,14 Jan,2009
 *		Wed,29 Sep,2010
 */
static struct trie_node* const
do_learn_history_str( struct record_stat* const rst,
		     struct record_section* const rsc,
		     struct trie_node* const node,
		     const xstr* const commit_xs_arg,
		     int frequency_arg,
		     anthy_time_t timestamp_arg,
		     int reorder_to_top )
{
  struct history_record_t {
    anthy_time_t	timestamp;
    int			frequency;
    xstr		xs;
  };

  struct history_record_t* const history = alloca( sizeof(struct history_record_t[anthy_settings.limit.historyrecord_maxdepth]) );
  struct history_record_t commit = {
    .timestamp = timestamp_arg,
    .frequency = frequency_arg,
    .xs = {
      .str = commit_xs_arg->str,
      .len = commit_xs_arg->len,
    }
  };
  const int	nr = do_get_nr_values( node );
  int		ptr;
  int		committed_ptr = -1;
  int64_t	val64;
  int		val;
  const xstr*	xs;
  int		i, j;
  int		reorder = -1;
  anthy_time_t	max_timestamp = commit.timestamp;
  int64_t	cur_score, max_score;
  static const int	Frequency_MagicNumber = 4;

  /* ߤγؽǡɤ߹ */
  for (i = 0, ptr = 0; i < anthy_settings.limit.historyrecord_maxdepth; ++i) {
    history[i].timestamp = 0;
    history[i].frequency = -1;
    history[i].xs.str = NULL;
    history[i].xs.len = 0;

    if (nr <= ptr) { continue; }
    val64 = do_get_nth_int64( node, ptr );
    if (0 != val64) {
      history[i].timestamp = val64;
      ptr++;

      if (nr <= ptr) { continue; }
      val = do_get_nth_value( node, ptr );
      if (0 != val) {
	history[i].frequency = val;
	ptr++;
      } else {
	xs = do_get_nth_xstr( node, ptr );
	if (NULL == xs) {
	  history[i].frequency = val;
	  ptr++;
	} else {
	  /* May be broken data. */
	}
      }
    } else {
      history[i].timestamp = commit.timestamp;
      history[i].frequency = 1;
    }

    if (nr <= ptr) { continue; }
    xs = do_get_nth_xstr( node, ptr );
    ptr++;
    if (!xs) { continue; /* May be broken data. */ }

    history[i].xs.str = anthy_xstr_dup_str(xs);
    history[i].xs.len = xs->len;

    if (0 == anthy_xstrcmp(&commit.xs, xs)) {
      commit.frequency += history[i].frequency;
      if (commit.timestamp < history[i].timestamp) {
	commit.timestamp = history[i].timestamp;
      }
      history[i].timestamp = commit.timestamp;
      history[i].frequency = commit.frequency;
      committed_ptr = i;
    }
    if ((max_timestamp < history[i].timestamp) && (0 <= history[i].frequency)) {
      max_timestamp = history[i].timestamp;
      reorder = i;
    }
  }

  /* ǡĴ */
  if ((commit.frequency < 0) || ((INT_MAX - Frequency_MagicNumber) < commit.frequency)) {
    commit.frequency = INT_MAX - Frequency_MagicNumber;
  }
  if (committed_ptr < 0) {
    committed_ptr = anthy_settings.limit.historyrecord_maxdepth - 1;
    if (history[committed_ptr].xs.str) {
      free( history[committed_ptr].xs.str );
    }
    history[committed_ptr].timestamp = commit.timestamp;
    history[committed_ptr].frequency = commit.frequency;
    history[committed_ptr].xs.str    = anthy_xstr_dup_str( &(commit.xs) );
    history[committed_ptr].xs.len    = commit.xs.len;
  }

  /* 񤭹 */
  i = 0;
  if (reorder_to_top && (reorder < 0)) {
    ptr = committed_ptr;
    do_set_nth_int64( rsc, node, i*3+0, history[ptr].timestamp );
    do_set_nth_value( rsc, node, i*3+1, history[ptr].frequency );
    do_set_nth_xstr(  rsc, node, i*3+2, &(history[ptr].xs), &rst->xstrs );
    history[ptr].frequency = -1;
    ++i;
  }
  for (; i < anthy_settings.limit.historyrecord_maxdepth; ++i) {
    ptr = -1;
    max_score = INT64_MAX;
    for (j = 0; j < anthy_settings.limit.historyrecord_maxdepth; ++j) {
      if (0 <= history[j].frequency) {
	cur_score = (anthy_settings.timestamp.currentsession - history[j].timestamp) / (history[j].frequency + Frequency_MagicNumber);
	if (cur_score < max_score) {
	  ptr = j;
	  max_score = cur_score;
	}
      }
    }
    if (ptr < 0) {
      break;
    }
    do_set_nth_int64( rsc, node, i*3+0, history[ptr].timestamp );
    do_set_nth_value( rsc, node, i*3+1, history[ptr].frequency );
    do_set_nth_xstr(  rsc, node, i*3+2, &(history[ptr].xs), &rst->xstrs );
    history[ptr].frequency = -1;
  }
  do_truncate_row( node, i*3 );

  /*  */
  for (i = anthy_settings.limit.historyrecord_maxdepth - 1; 0 <= i; --i) {
    if (history[i].xs.str) {
      free( history[i].xs.str );
    }
  }
  do_mark_row_used( rsc, node );

  return node;
}


#if 0	/* Patched by G-HAL */
/*
 * row format:
 *  ROW := OPERATION SECTION KEY VALUE*
 *  OPERATION := "ADD"    (ɲäޤLRU)
 *               "DEL"    ()
 *  SECTION := (ʸ)
 *  KEY     := TD
 *  VALUE   := TD
 *  TD      := TYPE DATA  (򤢤˽)
 *  TYPE    := "S"        (xstr)
 *             "N"        (number)
 *  DATA    := (Ȥ˥ꥢ饤)
 */

static char*
read_1_token (FILE* fp, int* eol)
{
  int c;
  char* s;
  int in_quote;
  int len;

  in_quote = 0;
  s = NULL;
  len = 0;
  while (1) {
    c = fgetc(fp);
    switch (c) {
    case EOF: case '\n':
      goto out;
    case '\\':
      c = fgetc(fp);
      if (c == EOF || c == '\n') {
	goto out;
      }
      break;
    case '\"':
      in_quote = !in_quote;
      continue;
    case ' ': case '\t': case '\r':
      if (in_quote) {
	break;
      }
      if (s != NULL) {
	goto out;
      }
      break;
    default:
      break;
    }

    s = (char*) realloc(s, len + 2);
    s[len] = c;
    len ++;
  }
out:
  if (s) {
    s[len] = '\0';
  }
  *eol = (c == '\n');
  return s;
}
#else
/** ե뤫ȡ󣱤ɤ߽Ф
 *@param[in]		fp		ɤ߽Фե
 *@param[in,out]	eol		1:ޤɤ
 *@param[in,out]	eof		1:ե뽪üޤɤ
 *@retval		NULL		ɤ߽ФƤ̵ä(eol,eof)
 *@return				ɤ߽Ф
 *
 *@comment
 *
 * row format:
 *  ROW := OPERATION SECTION KEY VALUE*
 *  OPERATION := "ADD"    (ɲäޤLRU)
 *               "DEL"    ()
 *  SECTION := (ʸ)
 *  KEY     := TD
 *  VALUE   := TD
 *  TD      := TYPE DATA  (򤢤˽)
 *  TYPE    := "S"        (xstr)
 *             "N"        (number)
 *             "O"        (number of int64_t)
 *             "T"        (number of timestamp)
 *             "F"        (number of frequency)
 *  DATA    := (Ȥ˥ꥢ饤)
 *
 *
 * Patched by G-HAL
 *	Fri,22 Aug,2008
 *	Mon,13 Oct,2008, Fri,17 Oct,2008, Wed,22 Oct,2008
 *	Mon,16 May,2011 - Tue,17 May,2011
 */
static char* read_1_token( FILE* const fp, int* const eol, int* const eof )
{
  const size_t  str_len_init = 32;
  const size_t  str_len_step = 32;
  const size_t  str_len_max  = 10240;

  size_t  str_len = str_len_init;
  char*   s       = (char*) malloc( str_len );
  size_t  len     = 0;
  int in_quote   = 0;
  int blank_skip = 1;
  assert( NULL != s );
  if (eol) { (*eol) = 0; }
  if (eof) { (*eof) = 0; }

  do {
    int c = fgetc( fp );

    switch (c) {
    case EOF:
      if (eof) {
	(*eof) = 1;
      }
      goto DOUBLE_BREAK;

    case '\n':
      if (eol) {
	(*eol) = 1;
      }
      goto DOUBLE_BREAK;

    case '\\':
      c = fgetc( fp );
      if (EOF == c) {
	if (eof) {
	  (*eof) = 1;
	}
	goto DOUBLE_BREAK;
      }
      if ('\n' == c) {
	if (eol) {
	  (*eol) = 1;
	}
	goto DOUBLE_BREAK;
      }
      blank_skip = 0;
      break;

    case '\"':
      in_quote = !in_quote;
      blank_skip = 0;
      continue;

    case ' ':
    case '\t':
    case '\r':
      if (in_quote) {
	break;
      }
      if (0 == blank_skip) {
	goto DOUBLE_BREAK;
      }
      break;

    default:
      blank_skip = 0;
      break;
    }
    if (blank_skip) {
      continue;
    }

    if (str_len < (len + 2)) {
      if (str_len_max <= str_len) {
	goto DOUBLE_BREAK;
      }
      str_len += str_len_step;
      char* const new_s = (char* const) realloc( s, str_len );
      if (NULL == new_s) {
	goto DOUBLE_BREAK;
      }
      s = new_s;
    }

    s[len] = c; ++len;
  } while (1);

 DOUBLE_BREAK:
  if (len < 1) {
    free( s );
    return NULL;
  }

  char* const ret_s = (char*) realloc( s, (len + 1) );
  if (NULL == ret_s) {
    /* BUG? */
    fprintf( stderr, "CRIT: " __FILE__ ":%d:%s realloc() is failed.\n", __LINE__, __FUNCTION__ );
    abort();
  }
  ret_s[len] = '\0';
  return ret_s;
}
#endif

/* journalADDιԤɤ */
static void
read_add_row(FILE *fp, struct record_stat* rst,
	     struct record_section* rsc)
{
  int n;
  xstr* xs;
  char *token;
 #if 0		/* Patched by G-HAL, Tue,17 May,2011 */
  int eol;
 #else
  int eol;
  int eof;
 #endif
  struct trie_node* node;

 #if 0		/* Patched by G-HAL, Tue,17 May,2011 */
  token = read_1_token(fp, &eol);
  if (!token) {
    return ;
  }
 #else
  token = read_1_token( fp, &eol, &eof );
  if (eof) {
    /* Data was broken. */
    fputc( '\n', fp );
  }
  if (NULL == token) {
    return;
  }
 #endif

  xs = anthy_cstr_to_xstr(/* xstr ɽ S ɤ߼ΤƤ */
			  token + 1,
			  rst->encoding);
  node = do_select_row(rsc, xs, 1, LRU_USED);
  anthy_free_xstr(xs);
  free(token);

  if (node->dirty & PROTECT) {
    /* ¸٤ row ʤΤǡʬեɤ߼ΤƤ */
   #if 0		/* Patched by G-HAL, Tue,17 May,2011 */
    while (!eol) {
      free(read_1_token(fp, &eol));
    }
   #else
    while (!eol && !eof) {
      token = read_1_token( fp, &eol, &eof );
      if (eof) {
	/* Data was broken. */
	fputc( '\n', fp );
      }
      if (NULL == token) {
	break;
      }
      free( token );
    }
   #endif
    return ;
  }

  n = 0;
 #if 0		/* Patched by G-HAL, Fri,22 Aug,2008 - Fri,24 Oct,2008, Tue,17 May,2011 */
  while (!eol) {
    token = read_1_token(fp, &eol);
    if (token) {
      switch(*token) {
	/* String ʸ */
      case 'S':
	{
	  xstr* xs;
	  xs = anthy_cstr_to_xstr(token + 1, rst->encoding);
	  do_set_nth_xstr(node, n, xs, &rst->xstrs);
	  anthy_free_xstr(xs);
	}
	break;
	/* Number  */
      case 'N':
	do_set_nth_value(node, n, atoi(token + 1));
	break;
      }
      free(token);
      n++;
    }
  }
 #else
  while (token && !eol && !eof) {
    token = read_1_token( fp, &eol, &eof );
    if (eof) {
      /* Data was broken. */
      fputc( '\n', fp );
    }
    if (token) {
      switch(*token) {
      case 'S':	/* String ʸ */
	{
	  xstr* xs;
	  xs = anthy_cstr_to_xstr(token + 1, rst->encoding);
	  do_set_nth_xstr( rsc, node, n, xs, &rst->xstrs);
	  anthy_free_xstr(xs);
	}
	n++;
	break;
      case 'N':	/* Number  */
	do_set_nth_value( rsc, node, n, atoi(token + 1) );
	n++;
	break;

      case 'O':	/* Number (64bit) */
	do_set_nth_int64( rsc, node, n, atoll(token + 1) );
	n++;
	break;

      case 'T':	/* Timestamp (64bit) */
	node->timestamp = atoll(token + 1);
	break;

      case 'F':	/* Frequency  */
	node->frequency = atoi(token + 1);
	break;
      }
      free(token);
    }
  }
 #endif
  do_truncate_row(node, n);
}

/* journalDELιԤɤ */
static void
read_del_row(FILE *fp, struct record_stat* rst,
	     struct record_section* rsc)
{
  struct trie_node* node;
  char* token;
  xstr* xs;
 #if 0		/* Patched by G-HAL, Tue,17 May,2011 */
  int eol;
 #else
  int eol;
  int eof;
 #endif

 #if 0		/* Patched by G-HAL, Tue,17 May,2011 */
  token = read_1_token(fp, &eol);
  if (!token) {
    return ;
  }
 #else
  token = read_1_token( fp, &eol, &eof );
  if (eof) {
    /* Data was broken. */
    fputc( '\n', fp );
  }
  if (NULL == token) {
    return;
  }
 #endif

  xs = anthy_cstr_to_xstr(/* xstr ɽ S ɤФ */
			  token + 1,
			  rst->encoding);
  if ((node = do_select_row(rsc, xs, 0, 0)) != NULL) {
    do_remove_row(rsc, node);
  }
  anthy_free_xstr(xs);
  free(token);
}

/** ʬե뤫1ɤ߹ */
#if 0		/* Patched by G-HAL, Fri,17 Oct,2008, Thu,30 Oct,2008, Tue,17 May,2011 */
static void
read_1_row(struct record_stat* rst, FILE* fp, char *op)
{
  char* sec_name;
  struct record_section* rsc;
  int eol;

  sec_name = read_1_token(fp, &eol);
  if (!sec_name || eol) {
    free(sec_name);
    return ;
  }
  rsc = do_select_section(rst, sec_name, 1);
  free(sec_name);
  if (!rsc) {
    return ;
  }

  if (strcmp(op, "ADD") == 0) {
    read_add_row(fp, rst, rsc);
  } else if (strcmp(op, "DEL") == 0) {
    read_del_row(fp, rst, rsc);
  }
}
#else
static void read_1_row( struct record_stat* const rst, FILE* const fp, int mode_add )
{
  int eol;
  int eof;
  char* const sec_name = read_1_token( fp, &eol, &eof );
  enum ANTHY_SECTIONS_ sec_number;
  struct record_section* rsc;

  if (NULL == sec_name) {
    return;
  }
  if (eol) {
    free( sec_name );
    return;
  }
  if (eof) {
    /* Data was broken. */
    fputc( '\n', fp );
    free( sec_name );
    return;
  }
  sec_number = convert_section_name2number( sec_name );
  free( sec_name );
  if (MAX_SECTION <= sec_number) {
    return;
  }
  rsc = do_select_section( rst, sec_number, 1 );
  if (!rsc) {
    return ;
  }

  if (mode_add) {
    read_add_row(fp, rst, rsc);
  } else {
    read_del_row(fp, rst, rsc);
  }
  return;
}
#endif

/*
 * journal(ʬ)եɤ
 */
static void
read_journal_record(struct record_stat* rs)
{
 #if 0		/* Patched by G-HAL, Tue,17 May,2011 */
  FILE* fp;
  struct stat st;

  if (rs->is_anon) {
    return ;
  }
  fp = fopen(rs->journal_fn, "r");
  if (fp == NULL) {
    return;
  }
 #else
  if (rs->is_anon) {
    return;
  }
  const int fd_flags = (O_RDWR | O_APPEND | O_CREAT | O_EXLOCK);
  const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
  const int fd = open( rs->journal_fn, fd_flags, fd_mode );
  if (fd < 0) {
    return;
  }
  FILE* const fp = fdopen( fd, "r+" );
  if (NULL == fp) {
    close( fd );
    return;
  }

  struct stat st;
 #endif
  if (fstat(fileno(fp), &st) == -1) {
    fclose(fp);
    return ;
  }
  if (st.st_size < rs->last_update) {
    /* ե륵ʤäƤΤǡ
     * ǽ餫ɤ߹ */
    fseek(fp, 0, SEEK_SET);
  } else {
    fseek(fp, rs->last_update, SEEK_SET);
  }
  rs->journal_timestamp = st.st_mtime;
  while (!feof(fp)) {
   #if 0		/* Patched by G-HAL, Thu,30 Oct,2008, Tue,17 May,2011 */
    char *op;
    int eol;
    op = read_1_token(fp, &eol);
    if (op && !eol) {
      read_1_row(rs, fp, op);
    }
    free(op);
   #else
    int eol;
    int eof;
    char* const op = read_1_token( fp, &eol, &eof );
    if (op && !eol && !eof) {
      if (strcmp(op, "ADD") == 0) {
	read_1_row( rs, fp, 1 );
      } else if (strcmp(op, "DEL") == 0) {
	read_1_row( rs, fp, 0 );
      } else {
	/* Syntax error. */
      }
      free(op);
    }
   #endif
  }
  rs->last_update = ftell(fp);
  fclose(fp);
}

static void
write_string(FILE* fp, const char* str)
{
  fprintf(fp, "%s", str);
}

/* ֥륯Ȥ⤷ϥХåå˥Хååդ */
static void
write_quote_string(FILE* fp, const char* str)
{
  const char* p;

  for (p = str; *p; p++) {
    if (*p == '\"' || *p == '\\') {
      fputc('\\', fp);
    }
    fputc(*p, fp);
  }
}

#if 0	/* Patched by G-HAL, Tue,09 Jun,2009, Wed,10 Jun,2009 */
static void
write_quote_xstr(FILE* fp, xstr* xs, int encoding)
{
  char* buf;

  if ((NULL == xs) || (NULL == xs->str) || (xs->len < 1) || (0 == xs->str[0])) {
    /* ⤷ϳؽǡƤк */
    return;
  }

  buf = (char*) alloca(xs->len * 6 + 2); /* EUC ޤUTF8 */
  anthy_sputxstr(buf, xs, encoding);
  write_quote_string(fp, buf);
}
#else
static void write_quote_xstr( FILE* const fp, xstr* const xs, enum ANTHY_ENCODING encoding )
{
  if ((NULL == xs) || (NULL == xs->str) || (xs->len < 1) || (0 == xs->str[0])) {
    /* ⤷ϳؽǡƤк */
    return;
  }
  {
    const size_t	buf_size = MAX_BYTES_PER_XCHAR * xs->len + MAX_BYTES_BASE;
    char* const		buf = alloca( buf_size );
    anthy_snputxstr( buf, buf_size, xs, encoding );
    write_quote_string( fp, buf );
  }
  return;
}
#endif

static void
write_number(FILE* fp, int x)
{
  fprintf(fp, "%d", x);
}

/* Patched by G-HAL, Wed,22 Oct,2008 */
static void write_number64( FILE* const fp, int64_t x )
{
  fprintf(fp, "%"PRId64"", x );
  return;
}

/* Patched by G-HAL, Fri,22 Aug,2008, Sun,19 Oct,2008 */
static void write_timet( FILE* const fp, anthy_time_t x )
{
  if (sizeof(x) <= 4) {
    fprintf(fp, "%"PRId32"", (int32_t)x );
  } else if (sizeof(x) <= 8) {
    fprintf(fp, "%"PRId64"", (int64_t)x );
  } else {
    fprintf(fp, "%"PRIdMAX"", (intmax_t)x );
  }
  return;
}

/* journal1ɵ */
#if 0	/* Patched by G-HAL, Fri,17 Oct,2008 */
static void
commit_add_row(struct record_stat* rst,
	       const char* sname, struct trie_node* node)
#else
static void
commit_add_row( struct record_stat* const rst,
	       const enum ANTHY_SECTIONS_ section, struct trie_node* const node )
#endif
{
 #if 0		/* Patched by G-HAL, Tue,28 Oct,2008, Wed,29 Oct,2008, Tue,17 May,2011 */
  FILE* fp;
  int i;

  fp = fopen(rst->journal_fn, "a");
  if (fp == NULL) {
    return;
  }
 #else
  const int fd_flags = (O_WRONLY | O_APPEND | O_CREAT | O_EXLOCK);
  const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);

  const int fd = open( rst->journal_fn, fd_flags, fd_mode );
  if (fd < 0) {
    return;
  }
  FILE* const fp = fdopen( fd, "a" );
  if (NULL == fp) {
    close( fd );
    return;
  }
 #if defined(HAVE_FSEEKO)
  fseeko( fp, 0, SEEK_END );
 #else
  fseek( fp, 0, SEEK_END );
 #endif
  int i;
 #endif

  write_string(fp, "ADD \"");
  /* write_quote_string(fp, sname); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
  write_quote_string(fp, anthy_settings.section[section].name );	/* Patched by G-HAL, Fri,17 Oct,2008 */
  write_string(fp, "\" S\"");
  write_quote_xstr(fp, &node->row.key, rst->encoding);
  write_string(fp, "\"");

  for (i = 0; i < node->row.nr_vals; i++) {
    switch (node->row.vals[i].type) {
    case RT_EMPTY:
      write_string(fp, " E");
      break;
    case RT_VAL:
      write_string(fp, " N");
      write_number(fp, node->row.vals[i].u.val);
      break;
    case RT_INT64:		/* Patched by G-HAL, Wed,22 Oct,2008 */
      write_string(fp, " O" );
      write_number64(fp, node->row.vals[i].u.int64 );
      break;
    case RT_XSTR:
      write_string(fp, " S\"");
      write_quote_xstr(fp, &node->row.vals[i].u.str, rst->encoding);
      write_string(fp, "\"");
      break;
    case RT_XSTRP:
      write_string(fp, " S\"");
      write_quote_xstr(fp, node->row.vals[i].u.strp, rst->encoding);
      write_string(fp, "\"");
      break;
    }
  }
  {	/* Patched by G-HAL, Fri,22 Aug,2008 */
    write_string(fp, " T");
    write_timet(fp, node->timestamp );
    write_string(fp, " F");
    write_number(fp, node->frequency );
  }
  write_string(fp, "\n");
  rst->last_update = ftell(fp);
  fclose(fp);
}

/* Ƥ row  */
static void
clear_record(struct record_stat* rst)
{
  struct record_section *rsc;
  for (rsc = rst->section_list.next; rsc; rsc = rsc->next) {
    trie_remove_all(&rsc->cols, &rsc->lru_nr_used, &rsc->lru_nr_sused);
  }
  rst->cur_row = NULL;
}

#if 0	/* Patched by G-HAL */
/* ܥեɤ */
static void
read_session(struct record_stat *rst)
{
  char **tokens;
  int nr;
  int in_section = 0;
  while (!anthy_read_line(&tokens, &nr)) {
    xstr *xs;
    int i;
    int dirty = 0;
    struct trie_node* node;

    if (!strcmp(tokens[0], "---") && nr > 1) {
      /* ڤ */
      in_section = 1;
      rst->cur_section = do_select_section(rst, tokens[1], 1);
      goto end;
    }
    if (!in_section || nr < 2) {
      /* 󤬻ϤޤäƤʤ or ԤԴ */
      goto end;
    }
    /* ƬLRUΥޡɤ */
    if (tokens[0][0] == '-') {
      dirty = 0;
    } else if (tokens[0][0] == '+') {
      dirty = LRU_SUSED;
    }
    /* index */
    xs = anthy_cstr_to_xstr(&tokens[0][1], rst->encoding);
    node = do_select_row(rst->cur_section, xs, 1, dirty);
    anthy_free_xstr(xs);
    if (!node) {
      goto end;
    }
    rst->cur_row = node;
    /**/
    for (i = 1; i < nr; i++) {
      if (tokens[i][0] == '"') {
	char *str;
	str = strdup(&tokens[i][1]);
	str[strlen(str) - 1] = 0;
	xs = anthy_cstr_to_xstr(str, rst->encoding);
	free(str);
	do_set_nth_xstr(rst->cur_row, i-1, xs, &rst->xstrs);
	anthy_free_xstr(xs);
      }else if (tokens[i][0] == '*') {
	/* EMPTY entry */
	get_nth_val_ent(rst->cur_row, i-1, 1);
      } else {
	do_set_nth_value(rst->cur_row, i-1, atoi(tokens[i]));
      }
    }
  end:
    anthy_free_line();
  }
}
#else
/** ܥեɤ
 *@param[in]	rst		ɹ쥳
 *@param	refresh		ŪؽκƹۤԤ(1)(0)
 *
 * Patched by G-HAL
 *		Fri,29 Aug,2008
 *		Fri,17 Oct,2008
 *		Fri,22 Aug,2008
 *		Thu,23 Oct,2008
 *		Fri,31 Oct,2008
 *		Sat,29 Nov,2008
 *		Tue,13 Jan,2009 - Wed,14 Jan,2009
 *		Sat,24 Jan,2009
 *		Sun,08 Feb,2009
 *		Sat,25 Apr,2009
 */
static void read_session( struct record_stat* const rst, int refresh )
{
  char** tokens;
  int nr;
  int in_section = 0;
  enum ANTHY_SECTIONS_ sec_number;
  struct record_section* rsc;
  int do_set = 1;
  int need_candhistory_refresh = refresh;

  while (!anthy_read_line(&tokens, &nr)) {
    xstr* idx;
    int dirty;
    struct trie_node* node;
    int i;
    int val;
    anthy_time_t timestamp;

    if (!strcmp(tokens[0], "---") && nr > 1) {
      /* ڤ */
      sec_number = convert_section_name2number( tokens[1] );
      if (MAX_SECTION <= sec_number) {
	in_section = 0;
	goto end;
      }
      if (PREDICTION == sec_number) {
	rsc = rst->cur_section = do_select_section( rst, CAND_HISTORY, 1 );
	do_set = 0;
	need_candhistory_refresh = 1;
      } else if (need_candhistory_refresh && (CAND_HISTORY == sec_number)) {
	rsc = rst->cur_section = do_select_section( rst, CAND_HISTORY, 1 );
	do_set = 0;
      } else if (need_candhistory_refresh && (SUFFIX_HISTORY == sec_number)) {
	rsc = rst->cur_section = do_select_section( rst, SUFFIX_HISTORY, 1 );
	do_set = 0;
      } else {
	rsc = rst->cur_section = do_select_section( rst, sec_number, 1 );
	do_set = 1;
      }
      in_section = 1;
      goto end;
    }
    if (!in_section || (nr < 2)) {
      /* 󤬻ϤޤäƤʤ or ԤԴ */
      goto end;
    }
    /* ƬLRUΥޡɤ */
    if (tokens[0][0] == '-') {
      dirty = 0;
    } else if (tokens[0][0] == '+') {
      dirty = LRU_SUSED;
    } else {
      goto end;
    }
    /* index */
    idx = anthy_cstr_to_xstr( &tokens[0][1], rst->encoding );
    node = do_select_row( rsc, idx, 1, dirty );
    if (!node) {
      anthy_free_xstr( idx );
      goto end;
    }
    rst->cur_row = node;
    /* ƹ */
    val = -1; timestamp = 0;
    for (i = 1; i < nr; i++) {
      if (tokens[i][0] == '"') {
	char* str;
	xstr* xs;
	str = strdup(&tokens[i][1]);
	str[strlen(str) - 1] = 0;
	xs = anthy_cstr_to_xstr( str, rst->encoding );
	free(str);
	if (do_set) {
	  do_set_nth_xstr( rsc, node, i-1, xs, &(rst->xstrs) );
	} else {
	  if (0 == timestamp) {
	    timestamp = anthy_settings.timestamp.currentsession;
	  }
	  if (PREDICTION == sec_number) {
	    do_learn_history_str( rst, rsc, node, xs, 0, timestamp, 0 );
	  } else if (CAND_HISTORY == sec_number) {
	    if (-1 == val) {
	      do_learn_history_str( rst, rsc, node, xs, 1, 1, 0 );
	    } else {
	      do_learn_history_str( rst, rsc, node, xs, val, timestamp, 0 );
	    }
	  } else if (SUFFIX_HISTORY == sec_number) {
	    if (-1 == val) {
	      do_learn_history_str( rst, rsc, node, xs, 1, 1, 0 );
	    } else {
	      do_learn_history_str( rst, rsc, node, xs, val, timestamp, 0 );
	    }
	  }
	  val = -1; timestamp = 0;
	}
	anthy_free_xstr(xs);
      }else if (tokens[i][0] == '*') {
	/* EMPTY entry */
	get_nth_val_ent( node, i-1, rsc->inc_nr_num );
      }else if (tokens[i][0] == 'T') {
	node->timestamp = atoll(&(tokens[i][1]));
      }else if (tokens[i][0] == 'F') {
	node->frequency = atoi(&(tokens[i][1]));
      }else if (tokens[i][0] == 'O') {
	timestamp = atoll(&(tokens[i][1]));
	if (do_set) {
	  do_set_nth_int64( rsc, node, i-1, timestamp );
	}
      } else {
	val = atoi(tokens[i]);
	if (do_set) {
	  do_set_nth_value( rsc, node, i-1, val );
	} else {
	  if (0 == timestamp) {
	    timestamp = val;
	  }
	}
      }
    }

    /* OCHAIREؽΥݽ  ѥηѴ */
    if (OCHAIRE == sec_number) {
      int need_garbagecollect = 1;
      i = 1 + do_get_nth_value( node, 0 ) * 2;
      switch (do_get_nr_values(node) - i) {
      case 5:
	if ((NULL == do_get_nth_xstr(node,i+0))
	    && (NULL == do_get_nth_xstr(node,i+1))
	    && (NULL == do_get_nth_xstr(node,i+2))
	    && (NULL == do_get_nth_xstr(node,i+3))
	    && (NULL == do_get_nth_xstr(node,i+4))
	) {
	  need_garbagecollect = 0;
	}
	break;
      case 4:
	if ((NULL == do_get_nth_xstr(node,i+0))
	    && (NULL == do_get_nth_xstr(node,i+1))
	    && (NULL == do_get_nth_xstr(node,i+2))
	    && (NULL == do_get_nth_xstr(node,i+3))
	) {
	  need_garbagecollect = 0;
	  do_set_nth_value( rsc, node, i + 4, do_get_nth_value( node, i + 3 ) );
	  do_set_nth_value( rsc, node, i + 3, do_get_nth_value( node, i + 2 ) );
	  do_set_nth_value( rsc, node, i + 2, do_get_nth_value( node, i + 1 ) );
	  do_set_nth_value( rsc, node, i + 1, do_get_nth_value( node, i + 0 ) );
	  do_set_nth_value( rsc, node, i + 0, -1 );
	}
	break;
      case 2:
	if ((NULL == do_get_nth_xstr(node,i+0))
	    && (NULL == do_get_nth_xstr(node,i+1))
	) {
	  need_garbagecollect = 0;
	  do_set_nth_value( rsc, node, i + 4, do_get_nth_value( node, i + 1 ) );
	  do_set_nth_value( rsc, node, i + 3, do_get_nth_value( node, i + 0 ) );
	  do_set_nth_value( rsc, node, i + 2, -1 );
	  do_set_nth_value( rsc, node, i + 1, -1 );
	  do_set_nth_value( rsc, node, i + 0, -1 );
	}
	break;
      }
      if (need_garbagecollect) {
	do_truncate_row( node, i + 5 );
	do_set_nth_value( rsc, node, i + 0, -1 );
	do_set_nth_value( rsc, node, i + 1, -1 );
	do_set_nth_value( rsc, node, i + 2, -1 );
	do_set_nth_value( rsc, node, i + 3, -1 );
	do_set_nth_value( rsc, node, i + 4, -1 );
      }
    }

    anthy_free_xstr( idx );
end:
    anthy_free_line();
  }
  rst->baserecord_size = anthy_fsizeo_file();
  return;
}
#endif



/* uint8_t Хʥɤ߹, by G-HAL, Thu,16 Oct,2008 */
static uint8_t fread_uint8( FILE* const fp )
{
  uint8_t data;
  fread( &data, 1, 1, fp );
  return data;
}

/* uint16_t Хʥɤ߹, by G-HAL, Thu,16 Oct,2008 */
static uint16_t fread_uint16( FILE* const fp )
{
  uint16_t data;
  fread( &data, 2, 1, fp );
  return ntohs(data);
}

/* uint32_t  24bit֤Хʥɤ߹, by G-HAL, Sun,19 Oct,2008 */
static uint32_t fread_uint24( FILE* const fp )
{
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[4];
  (*(uint32_t*)&(buf[0])) = 0;
  fread( &(buf[1]), 3, 1, fp );
  return ntohl( *(uint32_t*)&(buf[0]) );
 #else
  uint8_t buf[4];
  fread( &(buf[1]), 1, 1, fp );
  fread( &(buf[2]), 1, 1, fp );
  fread( &(buf[3]), 1, 1, fp );
  return ((uint32_t)buf[1] << 16) + ((uint32_t)buf[2] <<  8) + ((uint32_t)buf[3] <<  0);
 #endif
}

/* uint32_t Хʥɤ߹, by G-HAL, Thu,16 Oct,2008 */
static uint32_t fread_uint32( FILE* const fp )
{
  uint32_t data;
  fread( &data, 4, 1, fp );
  return ntohl(data);
}

/* uint64_t Хʥɤ߹, by G-HAL, Thu,16 Oct,2008, Mon,20 Oct,2008 */
static uint64_t fread_uint64( FILE* const fp )
{
 #if defined(HAVE_DECL_BETOH64) && HAVE_DECL_BETOH64
  uint64_t data;
  fread( &data, 8, 1, fp );
  return betoh64( data );
 #else
 # if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[8];
  fread( buf, 8, 1, fp );
  const uint32_t u = ntohl( *((uint32_t*)&(buf[0])) );
  const uint32_t d = ntohl( *((uint32_t*)&(buf[4])) );
  return (((uint64_t)u) << 32) | ((uint64_t)d);
 # else
  uint32_t u;
  uint32_t d;
  fread( &u, 4, 1, fp );
  fread( &d, 4, 1, fp );
  return ((uint64_t)ntohl(u) << 32) + ((uint64_t)ntohl(d) <<  0);
 # endif
 #endif
}

/* ĹͤХʥɤ߹, by G-HAL, Sun,19 Oct,2008, Mon,20 Oct,2008, Tue,21 Oct,2008 */
static uint64_t fread_uintv64_core( uint8_t type, FILE* const fp )
{
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[8];

  (*(uint64_t*)&(buf[0])) = 0;
  fread( &(buf[8-type]), type, 1, fp );
  if (type <= 4) {
    return ntohl( *((uint32_t*)&(buf[4])) );
  } else {
   #if defined(HAVE_DECL_BETOH64) && HAVE_DECL_BETOH64
    return betoh64( *((uint64_t*)&(buf[0])) );
   #else
    const uint32_t u = ntohl( *((uint32_t*)&(buf[0])) );
    const uint32_t d = ntohl( *((uint32_t*)&(buf[4])) );
    return (((uint64_t)u) << 32) | ((uint64_t)d);
   #endif
  }
 #else
  uint64_t ret = 0;
  uint8_t buf;
  size_t len;
  for (len = 0; len < type; ++len) {
    fread( &buf, 1, 1, fp );
    ret = (ret << 8) + (uint64_t)buf;
  }
  return ret;
 #endif
}
/* ĹͤХʥɤ߹, by G-HAL, Sun,19 Oct,2008, Mon,20 Oct,2008, Tue,21 Oct,2008 */
static uint64_t fread_uintv64( FILE* const fp )
{
  uint8_t type;
  fread( &type, 1, 1, fp );
  if (8 < type) {
    anthy_log(0, "Failed to parse a length identifier in read_session_bin().\n" );
    return 0;
  }
  return fread_uintv64_core( type, fp );
}

/* դĹͤХʥɤ߹, by G-HAL, Tue,21 Oct,2008 */
static uint64_t fread_xintv64( int* const sign, FILE* const fp )
{
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t type;
  uint8_t buf[8];
  fread( &type, 1, 1, fp );
  if (0 == (UINT8_C(0x80) & type)) {
    *sign = 0;
    return fread_uintv64_core( type, fp );
  }
  *sign = 1;
  type &= UINT8_C(0x7F);
  if (8 < type) {
    anthy_log(0, "Failed to parse a length identifier in read_session_bin().\n" );
    return 0;
  }

  (*(int64_t*)&(buf[0])) = (int64_t)-1;
  fread( &(buf[8-type]), type, 1, fp );
  if (type <= 4) {
    return ((int32_t) ntohl( *((uint32_t*)&(buf[4])) ));
  } else {
   #if defined(HAVE_DECL_BETOH64) && HAVE_DECL_BETOH64
    return betoh64( *((uint64_t*)&(buf[0])) );
   #else
    const uint32_t u = ntohl( *((uint32_t*)&(buf[0])) );
    const uint32_t d = ntohl( *((uint32_t*)&(buf[4])) );
    return (((uint64_t)u) << 32) | ((uint64_t)d);
   #endif
  }
 #else
 # error	"Not implemented, yet."
 #endif
}


/* xstr Хʥɤ߹, by G-HAL, Thu,16 Oct,2008 */
static void fread_xstr_ucs4( xstr* const msg, size_t* const msg_max_len, FILE* const fp )
{
  uint16_t len;
  uint16_t i;
  xchar* ptr;

  msg->len = len = fread_uint16( fp );

  if ((*msg_max_len) < len) {
    *msg_max_len = len;
    free( msg->str );
    msg->str = (xchar*) malloc( sizeof(xchar) * len );
  }
  for (i = 0, ptr = msg->str; i < len; i++, ptr++) {
    *ptr = fread_uint32( fp );
  }
  return;
}

/* xstr UCS2255ʸʲˤХʥɤ߹, by G-HAL, Thu,16 Oct,2008 */
static void fread_xstr_shrink( xstr* const msg, size_t* const msg_max_len, FILE* const fp )
{
  uint8_t len;
  int i;
  xchar* ptr;

  msg->len = len = fread_uint8( fp );

  if ((*msg_max_len) < len) {
    *msg_max_len = len;
    free( msg->str );
    msg->str = (xchar*) malloc( sizeof(xchar) * len );
  }
  for (i = 0, ptr = msg->str; i < len; i++, ptr++) {
    *ptr = fread_uint16( fp );
  }
  return;
}


/* ܥեХʥɤ, by G-HAL, Thu,16 Oct,2008, Tue,21 Oct,2008, Thu,23 Oct,2008 */
static int read_session_bin( struct record_stat* const rst )
{
  FILE* const	fp = anthy_get_fp();
  char section_name[UINT8_MAX +1];
  enum ANTHY_SECTIONS_ sec_number = NONE_SECTION;
  struct record_section* rsc;
  struct trie_node* node;
  size_t ret;
  int  in_section = 0;
  int  nr = 0;
  char token;
  uint64_t val64;
  int val_sign;
  int dirty = 0;
  xstr   xs;
  size_t xs_max_len = 64;
  xs.len = 0;
  xs.str = (xchar*) malloc( sizeof(xchar) * xs_max_len );

  while (1) {
    ret = fread( &token, 1, 1, fp );
    if (1 != ret) {
      anthy_log(0, "Uncertain terminate of a file in read_session_bin().\n");
      goto FAIL;
    }
    switch (token) {
    case '=':
      {	/* 󶭳ʸ */
	const uint8_t len = fread_uint8( fp );
	if (0 == len) {
	  goto SUCCESS;
	}
	fread( section_name, len, 1, fp );
	section_name[len] = '\0';
	sec_number = convert_section_name2number( section_name );
	if (MAX_SECTION <= sec_number) {
	  anthy_log(0, "Failed to parse a section name in read_session_bin().\n" );
	  goto FAIL;
	}
	rsc = rst->cur_section = do_select_section( rst, sec_number, 1 );
	in_section = 1;
      }
      break;

    case 'p':
    case 'm':
    case 'P':
    case 'M':
      {	/* LRUΥޡ */
	if (in_section < 1) {
	  /* 󤬻ϤޤäƤʤ */
	  anthy_log(0, "Failed to parse a section in read_session_bin().\n" );
	  goto FAIL;
	}
	if ('p' == token) {
	  dirty = LRU_SUSED;
	  fread_xstr_shrink( &xs, &xs_max_len, fp );
	} else if ('m' == token) {
	  dirty = 0;
	  fread_xstr_shrink( &xs, &xs_max_len, fp );
	} else if ('P' == token) {
	  dirty = LRU_SUSED;
	  fread_xstr_ucs4( &xs, &xs_max_len, fp );
	} else if ('M' == token) {
	  dirty = 0;
	  fread_xstr_ucs4( &xs, &xs_max_len, fp );
	}
	node = rst->cur_row = do_select_row( rsc, &xs, 1, dirty );
	in_section = 2;
	nr = 0;
      }
      break;

    default:
      /* row */
      if (in_section < 2) {
	anthy_log(0, "Failed to parse a LRU mark in read_session_bin().\n");
	goto FAIL;
      }
      switch (token) {
      case '*':
	/* EMPTY entry */
	get_nth_val_ent( node, nr, rsc->inc_nr_num );
	break;
      case 's':
	fread_xstr_shrink( &xs, &xs_max_len, fp );
	do_set_nth_xstr( rsc, node, nr, &xs, &(rst->xstrs) );
	break;
      case 'S':
	fread_xstr_ucs4( &xs, &xs_max_len, fp );
	do_set_nth_xstr( rsc, node, nr, &xs, &(rst->xstrs) );
	break;
      case 'N':
	val64 = fread_xintv64( &val_sign, fp );
	if (!val_sign) {
	  do_set_nth_value( rsc, node, nr, (int)val64 );
	} else {
	  do_set_nth_value( rsc, node, nr, (int)((int64_t)val64) );
	}
	break;
      case 'O':
	val64 = fread_xintv64( &val_sign, fp );
	if (!val_sign) {
	  do_set_nth_int64( rsc, node, nr, (int64_t)val64 );
	} else {
	  do_set_nth_int64( rsc, node, nr, ((int64_t)val64) );
	}
	break;
      case 'R':
	node->timestamp = fread_uintv64( fp );
	node->frequency = fread_uintv64( fp );
	break;
      default:
	anthy_log(0, "Unknown mark in read_session_bin().\n");
	goto FAIL;
      }
      in_section = 3;
      nr++;
      break;
    }
  }
FAIL:
  free( xs.str );
  return 0;

SUCCESS:
  free( xs.str );
  return -1;
}

#if 0	/* Patched by G-HAL, Wed,14 Jan,2009 */
/* ޤΥǡ١˥ե뤫ɤ߹ */
static void
read_base_record(struct record_stat *rst)
#else
/** ޤΥǡ١˥ե뤫ɤ߹
 *@param[in]	rst		ɹ쥳
 *@param	refresh		ŪؽκƹۤԤ(1)(0)
 *
 * Patched by G-HAL
 *		Thu,16 Oct,2008
 *		Wed,14 Jan,2009
 *		Tue,14 Jul,2009
 *		Wed,22 Jul,2009
 */
static void read_base_record( struct record_stat* const rst, int refresh )
#endif
{
 #if 0		/* Patched by G-HAL, Thu,16 Oct,2008, Tue,14 Jul,2009 */
  struct stat st;
  if (rst->is_anon) {
    clear_record(rst);
    return ;
  }
  anthy_check_user_dir();

  if (anthy_open_file(rst->base_fn) == -1) {
    return ;
  }

  clear_record(rst);
  read_session(rst);
  anthy_close_file();

  if (stat(rst->base_fn, &st) == 0) {
    rst->base_timestamp = st.st_mtime;
  }
  rst->last_update = 0;
 #else
  {
    clear_record( rst );
    rst->last_update = 0;
    rst->base_timestamp = 0;
  }

  if (rst->is_anon) {
    return;
  }

  anthy_check_user_dir();

  if (-1 == anthy_open_file(rst->basebin_fn)) {
FALLBACK:
    /* ƥȷ˥եХå */
    if (-1 == anthy_open_file(rst->base_fn)) {
      return;
    } else {
      read_session( rst, refresh );
      anthy_close_file();
    }
    save_base_record_bin( rst );

  } else {
    /* Хʥɤ߹ */
    const int ret = read_session_bin( rst );
    anthy_close_file();
    if (!ret) {
      clear_record( rst );
      goto FALLBACK;
    }

    if (-1 == anthy_open_file(rst->base_fn)) {
      rst->baserecord_size = 0;
      return;
    } else {
      rst->baserecord_size = anthy_fsizeo_file();
      anthy_close_file();
    }
  }
  { struct stat st;
    if (0 == stat(rst->base_fn, &st)) {
      rst->base_timestamp = st.st_mtime;
    }
  }
  return;
 #endif
}

static FILE *
open_tmp_in_recorddir(void)
{
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008, Fri,31 Oct,2008, Tue,17 May,2011 */
  char *pn;
  const char *hd;
  const char *sid;
  sid = anthy_conf_get_str("SESSION-ID");
  hd = anthy_conf_get_str("HOME");
  pn = alloca(strlen(hd)+strlen(sid) + 10);
  sprintf(pn, "%s/.anthy/%s", hd, sid);
  return fopen(pn, "w");
 #else
  const char* const home = anthy_conf_get_str("HOME");
  const char* const sid = anthy_conf_get_str("SESSION-ID");
  /* const size_t fn_len = strlen(home)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(sid)
      + 1;*/
  char* pn = (char*) alloca( PATH_MAX );
  const int fd_flags = (O_WRONLY | O_APPEND | O_CREAT | O_TRUNC | O_EXLOCK);
  const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
  snprintf(pn, PATH_MAX,
	   "%s%s%s%s%s",
	   home,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.user_dir,
	   anthy_settings.filename.PathSeparator,
	   sid );
  const int fd = open( pn, fd_flags, fd_mode );
  if (fd < 0) {
    return NULL;
  }
  FILE* const fp = fdopen( fd, "w" );
  if (NULL == fp) {
    close( fd );
  }
  return fp;
 #endif
}

/*
 * ե뤫baseեrename
 */
static void
update_file(const char *fn)
{
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008, Fri,31 Oct,2008 */
  const char *hd;
  char *tmp_fn;
  const char *sid;
  hd = anthy_conf_get_str("HOME");
  sid = anthy_conf_get_str("SESSION-ID");
  tmp_fn = alloca(strlen(hd)+strlen(sid) + 10);

  sprintf(tmp_fn, "%s/.anthy/%s", hd, sid);
 #else
  const char* const home = anthy_conf_get_str("HOME");
  const char* const sid = anthy_conf_get_str("SESSION-ID");
  /* const size_t fn_len = strlen(home)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(sid)
      + 1;*/
  char* tmp_fn = (char*) alloca( PATH_MAX );
  snprintf(tmp_fn, PATH_MAX,
	   "%s%s%s%s%s",
	   home,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.user_dir,
	   anthy_settings.filename.PathSeparator,
	   sid );
 #endif
  if (rename(tmp_fn, fn)){
    anthy_log(0, "Failed to update record file %s -> %s.\n", tmp_fn, fn);
  }
}

/* ¸ */
static void
save_a_row(FILE *fp, struct record_stat* rst,
	   struct record_row *c, int dirty,
	   anthy_time_t timestamp, int frequency )	/* Patched by G-HAL, Sun,19 Oct,2008 */
{
 #if 0	/* Patched by G-HAL, Tue,09 Jun,2009, Wed,10 Jun,2009 */
  int i;
  char *buf = (char*) alloca(c->key.len * 6 + 2);
 #else
  int i;
  const size_t	buf_size = MAX_BYTES_PER_XCHAR * c->key.len + MAX_BYTES_BASE;
  char* const	buf = alloca( buf_size );
 #endif
  /* LRUΥޡ */
  if (dirty == 0) {
    fputc('-', fp);
  } else {
    fputc('+', fp);
  }
 #if 0	/* Patched by G-HAL, Tue,03 Feb,2009 */
  anthy_sputxstr(buf, &c->key, rst->encoding);
  /* index  */
  fprintf(fp, "%s ", buf);
 #else
  /* index  */
  if (0 < c->key.len) {
    anthy_snputxstr( buf, buf_size, &(c->key), rst->encoding );
    fprintf(fp, "%s", buf );
  }
  fputc(' ', fp);
 #endif
  /**/
  for (i = 0; i < c->nr_vals; i++) {
    struct record_val *val = &c->vals[i];
    switch (val->type) {
    case RT_EMPTY:
      fprintf(fp, "* ");
      break;
    case RT_XSTR:
      /* should not happen */
      fprintf(fp, "\"");
      write_quote_xstr(fp, &val->u.str, rst->encoding);
      fprintf(fp, "\" ");
      abort();
      break;
    case RT_XSTRP:
      fprintf(fp, "\"");
      write_quote_xstr(fp, val->u.strp, rst->encoding);
      fprintf(fp, "\" ");
      break;
    case RT_VAL:
      fprintf(fp, "%d ", val->u.val);
      break;
    case RT_INT64:		/* Patched by G-HAL, Wed,22 Oct,2008 */
      fprintf(fp, "O%"PRId64" ", val->u.int64 );
      break;
    default:
      anthy_log(0, "Faild to save an unknown record. (in record.c)\n");
      break;
    }
  }
  {	/* Patched by G-HAL, Fri,22 Aug,2008 */
    write_string(fp, "T");
    write_timet(fp, timestamp );
    write_string(fp, " F");
    write_number(fp, frequency );
  }
  fprintf(fp, "\n");
}


/* uint8_t Хʥ¸, by G-HAL, Thu,16 Oct,2008 */
static void fwrite_uint8( const uint8_t data, FILE* const fp )
{
  fwrite( &data, 1, 1, fp );
  return;
}

/* uint16_t Хʥ¸, by G-HAL, Thu,16 Oct,2008 */
static void fwrite_uint16( const uint16_t data, FILE* const fp )
{
  const uint16_t n = htons(data);
  fwrite( &n, 2, 1, fp );
  return;
}

/* uint32_t  24bit֤Хʥ¸, by G-HAL, Sun,19 Oct,2008 */
static void fwrite_uint24( const uint32_t data, FILE* const fp )
{
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[4];
  *((uint32_t*)&(buf[0])) = htonl(data);
  fwrite( &(buf[1]), 3, 1, fp );
  return;
 #else
 # error	"Not implemented, yet."
 #endif
}

/* uint32_t Хʥ¸, by G-HAL, Thu,16 Oct,2008 */
static void fwrite_uint32( const uint32_t data, FILE* const fp )
{
  const uint32_t n = htonl(data);
  fwrite( &n, 4, 1, fp );
  return;
}

/* uint64_t Хʥ¸, by G-HAL, Thu,16 Oct,2008, Mon,20 Oct,2008 */
static void fwrite_uint64( const uint64_t data, FILE* const fp )
{
 #if defined(HAVE_DECL_HTOBE64) && HAVE_DECL_HTOBE64
  const uint64_t n = htobe64( data );
  fwrite( &n, 8, 1, fp );
  return;
 #else
 # if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[8];
  *((uint32_t*)&(buf[0])) = htonl((data >> 32) & UINT32_C(0xFFFFFFFF));
  *((uint32_t*)&(buf[4])) = htonl(data & UINT32_C(0xFFFFFFFF));
  fwrite( buf, 8, 1, fp );
 # else
 #  error	"Not implemented, yet."
 # endif
 #endif
  return;
}

/* ̵ĹͤХʥ¸, by G-HAL, Sun,19 Oct,2008, Mon,20 Oct,2008 */
static void fwrite_uintv64( const uint64_t data, FILE* const fp )
{
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[8];
  uint8_t len;
 #if defined(HAVE_DECL_HTOBE64) && HAVE_DECL_HTOBE64
  *((uint64_t*)&(buf[0])) = htobe64( data );
 #else
  *((uint32_t*)&(buf[0])) = htonl( (data >> 32) & ((((uint64_t)1) << 32)-1) );
  *((uint32_t*)&(buf[4])) = htonl( data & ((((uint64_t)1) << 32)-1) );
 #endif
  if (data < (((uint64_t)1) << (8*4))) {
    if (data < (((uint64_t)1) << (8*2))) {
      if (data < (((uint64_t)1) << (8*1))) {
	buf[6] = 1;
	fwrite( &(buf[6]), 2, 1, fp );
      } else {
	buf[5] = 2;
	fwrite( &(buf[5]), 3, 1, fp );
      }
    } else {
      if (data < (((uint64_t)1) << (8*3))) {
	buf[4] = 3;
	fwrite( &(buf[4]), 4, 1, fp );
      } else {
	buf[3] = 4;
	fwrite( &(buf[3]), 5, 1, fp );
      }
    }
  } else {
    if (data < (((uint64_t)1) << (8*6))) {
      if (data < (((uint64_t)1) << (8*5))) {
	buf[2] = 5;
	fwrite( &(buf[2]), 6, 1, fp );
      } else {
	buf[1] = 6;
	fwrite( &(buf[1]), 7, 1, fp );
      }
    } else {
      if (data < (((uint64_t)1) << (8*7))) {
	buf[0] = 7;
	fwrite( &(buf[0]), 8, 1, fp );
      } else {
	len = 8;
	fwrite( &len, 1, 1, fp );
	fwrite( &(buf[0]), 8, 1, fp );
	/*
	 * buf[] γݤ char buf[9] Ȥäơ
	 *	buf[0] = '8';
	 *	fwrite( &(buf[0]), 9, 1, fp );
	 * ȤȤȡƬ
	 *	*((uint32_t*)&(buf[1]))
	 * ǥ饤ȰȿˤʤϤ롣
	 *  HP-UX Ȥ ARM ȤΤꡣ
	 */
      }
    }
  }
  return;
 #else
 # error	"Not implemented, yet."
 #endif
}


/* ͭĹͤХʥ¸, by G-HAL, Tue,21 Oct,2008 */
static void fwrite_sintv64( const int64_t data, FILE* const fp )
{
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  uint8_t buf[8];
  uint8_t len;
  if (0 <= data) {
    fwrite_uintv64( data, fp );
    return;
  }
 #if defined(HAVE_DECL_HTOBE64) && HAVE_DECL_HTOBE64
  *((uint64_t*)&(buf[0])) = htobe64( data );
 #else
  *((uint32_t*)&(buf[0])) = htonl( (data >> 32) & ((((uint64_t)1) << 32)-1) );
  *((uint32_t*)&(buf[4])) = htonl( data & ((((uint64_t)1) << 32)-1) );
 #endif
  if ((((int64_t)0) - (((int64_t)1) << (8*4))) <= data) {
    if ((((int64_t)0) - (((int64_t)1) << (8*2))) <= data) {
      if ((((int64_t)0) - (((int64_t)1) << (8*1))) <= data) {
	buf[6] = 1 | UINT8_C(0x80);
	fwrite( &(buf[6]), 2, 1, fp );
      } else {
	buf[5] = 2 | UINT8_C(0x80);
	fwrite( &(buf[5]), 3, 1, fp );
      }
    } else {
      if ((((int64_t)0) - (((int64_t)1) << (8*3))) <= data) {
	buf[4] = 3 | UINT8_C(0x80);
	fwrite( &(buf[4]), 4, 1, fp );
      } else {
	buf[3] = 4 | UINT8_C(0x80);
	fwrite( &(buf[3]), 5, 1, fp );
      }
    }
  } else {
    if ((((int64_t)0) - (((int64_t)1) << (8*6))) <= data) {
      if ((((int64_t)0) - (((int64_t)1) << (8*5))) <= data) {
	buf[2] = 5 | UINT8_C(0x80);
	fwrite( &(buf[2]), 6, 1, fp );
      } else {
	buf[1] = 6 | UINT8_C(0x80);
	fwrite( &(buf[1]), 7, 1, fp );
      }
    } else {
      if ((((int64_t)0) - (((int64_t)1) << (8*7))) <= data) {
	buf[0] = 7 | UINT8_C(0x80);
	fwrite( &(buf[0]), 8, 1, fp );
      } else {
	len = 8 | UINT8_C(0x80);
	fwrite( &len, 1, 1, fp );
	fwrite( &(buf[0]), 8, 1, fp );
      }
    }
  }
  return;
 #else
 # error	"Not implemented, yet."
 #endif
}


/* xstr UCS4ˤХʥ¸, by G-HAL, Thu,16 Oct,2008 */
static void fwrite_xstr_ucs4( const xstr* const msg, FILE* const fp )
{
  uint32_t i;
  const xchar* ptr;

  const uint16_t len = (msg->len < UINT16_MAX) ? msg->len : (UINT16_MAX - 1);
  fwrite_uint16( len, fp );

  for (i = 0, ptr = msg->str; i < len; i++, ptr++) {
    fwrite_uint32( (*ptr), fp );
  }
  return;
}

/* xstrUCS2255ʸʲˤХʥ¸, by G-HAL, Mon,20 Oct,2008 */
static void fwrite_xstr_shrink( const xstr* const msg, FILE* const fp )
{
  int i;
  const xchar* ptr;

  const uint8_t len = (msg->len < UINT8_MAX) ? msg->len : (UINT8_MAX - 1);
  fwrite_uint8( len, fp );

  for (i = 0, ptr = msg->str; i < len; i++, ptr++) {
    fwrite_uint16( (*ptr), fp );
  }
  return;
}

/* xstr UCS4ˤХʥ¸, by G-HAL, Tue,21 Oct,2008 */
static void fwrite_xstr( const uint8_t tag_ucs4, const uint8_t tag_shrink, const xstr* const msg, FILE* const fp )
{
  if ((0 <= msg->len) && (msg->len < UINT8_MAX) && anthy_xstr_is_ucs2(msg)) {
    fwrite( &tag_shrink, 1, 1, fp );
    fwrite_xstr_shrink( msg, fp );
  } else {
    fwrite( &tag_ucs4, 1, 1, fp );
    fwrite_xstr_ucs4( msg, fp );
  }
  return;
}


/* Хʥ¸, by G-HAL, Thu,16 Oct,2008, Sun,19 Oct,2008, Tue,32 Oct,2008 */
static void save_a_row_bin( FILE* const fp, struct record_stat* const rst,
			   struct record_row* const c, int dirty,
			   anthy_time_t timestamp, int frequency )
{
  int i;
  const struct record_val* val;

  /* LRUΥޡ index  */
  if (0 == dirty) {
    fwrite_xstr( 'M', 'm', &(c->key), fp );
  } else {
    fwrite_xstr( 'P', 'p', &(c->key), fp );
  }

  /* row  */
  for (i = 0, val = &(c->vals[0]); i < c->nr_vals; i++, val++) {
    switch (val->type) {
    case RT_EMPTY:
      fwrite( "*", 1, 1, fp );
      break;
    case RT_XSTR:
      /* should not happen */
      abort();
      break;
    case RT_XSTRP:
      fwrite_xstr( 'S', 's', val->u.strp, fp );
      break;
    case RT_VAL:
      {
	fwrite( "N", 1, 1, fp );
	if (val->u.val < 0) {
	  fwrite_sintv64( val->u.val, fp );
	} else {
	  fwrite_uintv64( val->u.val, fp );
	}
      }
      break;
    case RT_INT64:
      {
	fwrite( "O", 1, 1, fp );
	if (val->u.int64 < 0) {
	  fwrite_sintv64( val->u.int64, fp );
	} else {
	  fwrite_uintv64( val->u.int64, fp );
	}
      }
      break;
    default:
      anthy_log(0, "Faild to save an unknown record. (in record.c)\n" );
      break;
    }
  }

  /* 󥰤 */
  {
    fwrite( "R", 1, 1, fp );
    if (timestamp < 0) {
      anthy_log(0, "Timestamp of scoreing was broken. (in record.c)\n" );
      fwrite_uint8( 0, fp );
    } else {
      fwrite_uintv64( timestamp, fp );
    }
    if (frequency < 0) {
      anthy_log(0, "Frequency of scoreing was broken. (in record.c)\n" );
      fwrite_uint8( 0, fp );
    } else {
      fwrite_uintv64( frequency, fp );
    }
  }

  return;
}

/** Хʥ¸, by G-HAL, Thu,16 Oct,2008, Tue,21 Oct,2008
 *@note
 *	ͤƥͥåȥǥ
 *
 * 
 *	'='					󶭳
 *		len: uint8_t			ʸ
 *			name: uint8_t[]		ʸISO-646/JIS X0201
 *
 *	'p'					LRU ޡ(0 != dirty)
 *		(xstr_shrink)			ʸ
 *	'P'					LRU ޡ(0 != dirty)
 *		(xstr_ucs4)			ʸ
 *	'm'					LRU ޡ(0 == dirty)
 *		(xstr_shrink)			ʸ
 *	'M'					LRU ޡ(0 == dirty)
 *		(xstr_ucs4)			ʸ
 *
 *	'*'					RT_EMPTY
 *	's'					RT_XSTRP
 *		(xstr_shrink)			(val->u.strp)
 *	'S'					RT_XSTRP
 *		(xstr_ucs4)			(val->u.strp)
 *	'N'					RT_VAL
 *		(val)				(val->u.val)
 *	'R'					
 *		(val)				timestamp
 *			(val)			frequency
 *
 * 
 *	(xstr_ucs4)
 *		len: uint16_t			ʸ
 *			str: uint32_t[]		ʸUCS-4
 *
 *	(xstr_shrink)
 *		len: uint8_t			ʸ
 *			str: uint16_t[]		ʸUCS-2
 *
 *	(val)
 *		len: uint8_t			ǡĹ
 *			val: ?int??_t		
 */
static void save_base_record_bin( struct record_stat* const rst )
{
  FILE* const fp = open_tmp_in_recorddir();
  struct record_section* sec;
  struct trie_node* col;

  if (!fp) {
    anthy_log(0, "Failed to open temporaly session file.\n");
    return;
  }
  for (sec = rst->section_list.next;
       sec; sec = sec->next) {
    if (!trie_first(&sec->cols)) {
      continue;
    }
    {	/* 󶭳ʸ */
      const size_t  len_org = strlen(anthy_settings.section[sec->section].name);
      const uint8_t len = (len_org < UINT8_MAX) ? len_org : (UINT8_MAX - 1);
      fwrite( "=", 1, 1, fp );
      fwrite_uint8( len, fp );
      fwrite( anthy_settings.section[sec->section].name, len, 1, fp );
    }
    /* ƥ¸ */
    for (col = trie_first(&sec->cols); col;
	 col = trie_next(&sec->cols, col)) {
      save_a_row_bin(fp, rst, &col->row, col->dirty, col->timestamp, col->frequency );
    }
  }
  { /* ü */
    fwrite( "=", 1, 1, fp );
    fwrite_uint8( 0, fp );
  }
  fclose(fp);
  update_file( rst->basebin_fn );
  return;
}


static void
update_base_record(struct record_stat* rst)
{
  struct record_section *sec;
  struct trie_node *col;
  FILE *fp;
  struct stat st;

  if ((0 < anthy_settings.recordfile1_limit) && (anthy_settings.recordfile1_limit <= rst->baserecord_size)) {	/* Patched by G-HAL, Wed,27 Aug,2008, Fri,17 Oct,2008 */
      anthy_truncate_record( rst );
  }

  /* եärecord񤭽Ф */
  anthy_check_user_dir();
  fp = open_tmp_in_recorddir();
  if (!fp) {
    anthy_log(0, "Failed to open temporaly session file.\n");
    return ;
  }
  /* ƥФ */
  for (sec = rst->section_list.next;
       sec; sec = sec->next) {
    if (!trie_first(&sec->cols)) {
      /*Υ϶*/
      continue;
    }
    /* 󶭳ʸ */
    /* fprintf(fp, "--- %s\n", sec->name); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
     fprintf(fp, "--- %s\n", anthy_settings.section[sec->section].name);	/* Patched by G-HAL, Fri,17 Oct,2008 */
    /* ƥ¸ */
    for (col = trie_first(&sec->cols); col;
	 col = trie_next(&sec->cols, col)) {
      save_a_row(fp, rst, &col->row, col->dirty, col->timestamp, col->frequency );
    }
  }
 #if defined(HAVE_FSEEKO)
  rst->baserecord_size = ftello(fp);	/* Patched by G-HAL, Fri,29 Aug,2008 */
 #else
  rst->baserecord_size = ftell(fp);	/* Patched by G-HAL, Fri,29 Aug,2008, Wed,13 Oct,2010 */
 #endif
  fclose(fp);

  /* ̾rename */
  update_file(rst->base_fn);

  if (stat(rst->base_fn, &st) == 0) {
    rst->base_timestamp = st.st_mtime;
  }
  /* journalեä */
  unlink(rst->journal_fn);
  rst->journal_timestamp = 0;	/* Patched by G-HAL, Mon,19 Oct,2009 */
  rst->last_update = 0;

  save_base_record_bin( rst );		/* Patched by G-HAL, Thu,16 Oct,2008 */
}

#if 0	/* Patched by G-HAL, Fri,17 Oct,2008 */
static void
commit_del_row(struct record_stat* rst,
	       const char* sname, struct trie_node* node)
#else
static void
commit_del_row( struct record_stat* const rst,
	       enum ANTHY_SECTIONS_ section, struct trie_node* const node )
#endif
{
 #if 0		/* Patched by G-HAL, Tue,28 Oct,2008, Tue,17 May,2011 */
  FILE* fp;

  fp = fopen(rst->journal_fn, "a");
  if (fp == NULL) {
    return;
  }
 #else
  const int fd_flags = (O_WRONLY | O_APPEND | O_CREAT | O_EXLOCK);
  const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
  const int fd = open( rst->journal_fn, fd_flags, fd_mode );
  if (fd < 0) {
    return;
  }
  FILE* const fp = fdopen( fd, "a" );
  if (NULL == fp) {
    close( fd );
    return;
  }
 #endif
  write_string(fp, "DEL \"");
  /* write_quote_string(fp, sname); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
  write_quote_string(fp, anthy_settings.section[section].name);	/* Patched by G-HAL, Fri,17 Oct,2008 */
  write_string(fp, "\" S\"");
  write_quote_xstr(fp, &node->row.key, rst->encoding);
  write_string(fp, "\"");
  write_string(fp, "\n");
  fclose(fp);
}

/*
 * sync_add: ADD ν񤭹
 * sync_del_and_del: DEL ν񤭹ߤȺ
 *   ɤ񤭹ߤˡ¾Υץˤäƥǥ¸줿
 *   ɤ߹ࡣ
 *   ΤȤǡ١եå夹ǽ⤢롣ǡ١
 *   եå夬ȡ cur_row Ƥ xstr ̵ˤʤ롣
 *    cur_section ͭ¸롣
 */
static void
sync_add(struct record_stat* rst, struct record_section* rsc,
	 struct trie_node* node)
{
  lock_record(rst);
  if (check_base_record_uptodate(rst)) {
    node->dirty |= PROTECT;
    /* ʬեɤ */
    read_journal_record(rst);
    node->dirty &= ~PROTECT;
    /* commit_add_row(rst, rsc->name, node); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
    commit_add_row(rst, rsc->section, node);	/* Patched by G-HAL, Fri,17 Oct,2008 */
    read_journal_record(rst);	/* Patched by G-HAL, Wed,14 Jan,2009 */
  } else {
    /* ɤ߹ */
    /* commit_add_row(rst, rsc->name, node); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
    commit_add_row(rst, rsc->section, node);	/* Patched by G-HAL, Fri,17 Oct,2008 */
    read_base_record(rst,0);	/* Patched by G-HAL, Wed,14 Jan,2009 */
    read_journal_record(rst);
  }
 #if 0	/* Patched by G-HAL, Tue,14 Jul,2009 */
  if ((0 < anthy_settings.recordfile2_limit) && (anthy_settings.recordfile2_limit < rst->last_update)) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    update_base_record(rst);
  }
 #endif
  unlock_record(rst);
}

static void
sync_del_and_del(struct record_stat* rst, struct record_section* rsc,
		 struct trie_node* node)
{
  lock_record(rst);
 #if 0		/* Patched by G-HAL, Fri,17 Oct,2008, Thu,30 Oct,2008 */
  commit_del_row(rst, rsc->name, node);
 #else
  if (rsc && node) {
    commit_del_row( rst, rsc->section, node );
  }
 #endif
  if (!check_base_record_uptodate(rst)) {
    read_base_record(rst,0);	/* Patched by G-HAL, Wed,14 Jan,2009 */
  }
  read_journal_record(rst);
 #if 0	/* Patched by G-HAL, Tue,14 Jul,2009 */
  if ((0 < anthy_settings.recordfile2_limit) && (anthy_settings.recordfile2_limit < rst->last_update)) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    update_base_record(rst);
  }
 #endif
  unlock_record(rst);
}


/*
 * predictionط
 */

static int
read_prediction_node(struct trie_node *n, struct prediction_t* predictions, int index)
{
 #if 0		/* Patched by G-HAL, Thu,30 Oct,2008 */
  int i;
  int nr_predictions = do_get_nr_values(n);
  for (i = 0; i < nr_predictions; i += 2) {
    anthy_time_t t = do_get_nth_int64(n, i);
    xstr* xs = do_get_nth_xstr(n, i + 1);
    if (t && xs) {
      if (predictions) {
	predictions[index].timestamp = t;
	predictions[index].src_str = anthy_xstr_dup(&n->row.key);
	predictions[index].str = anthy_xstr_dup(xs);
      }
      ++index;
    }
  }
  return index;
 #else
  const int	nr_predictions = do_get_nr_values(n);
  int		ptr;
  const xstr*	xs;
  int		val;
  int64_t	val64;
 #if defined(DEBUG) && (2 <= DEBUG)
  char buf[256];
 #endif

  for (ptr = 0; ptr < nr_predictions; ptr++) {
    val64 = do_get_nth_int64( n, ptr );
    if (0 != val64) {
      ptr++;
      val = do_get_nth_value( n, ptr );
      if (0 != val) {
	ptr++;
      } else {
	/* May be bug. */
      }
    }
    xs = do_get_nth_xstr( n, ptr );
    if (!xs) { continue; /* May be bug. */ }

   #if defined(DEBUG) && (2 <= DEBUG)
    anthy_snputxstr(buf, _number_(buf)-1, xs, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
    fprintf(stderr,"%"PRId64",%d,'%s'\n", val64, xs->len, buf );
   #endif
    if (val64) {
      if (predictions) {
	predictions[index].timestamp = val64;
	predictions[index].src_str = anthy_xstr_dup(&n->row.key);
	predictions[index].str = anthy_xstr_dup(xs);
      }
      ++index;
    }
  }
  return index;
 #endif
}


/*
 * trie򤿤ɤꡢprefixޥåread_prediction_node
 * Ƥpredictions˷̤ɲä롣
 */
static int
traverse_record_for_prediction(xstr* key, struct trie_node *n,
			       struct prediction_t* predictions, int index)
{
  if (n->l->bit > n->bit) {
    index = traverse_record_for_prediction(key, n->l, predictions, index);
  } else {
    if (n->l->row.key.len != -1) {
      if (anthy_xstrncmp(&n->l->row.key, key, key->len) == 0) {
	index = read_prediction_node(n->l, predictions, index);
      }
    }
  }
  if (n->r->bit > n->bit) {
    index = traverse_record_for_prediction(key, n->r, predictions, index);
  } else {
    if (n->r->row.key.len != -1) {
      if (anthy_xstrncmp(&n->r->row.key, key, key->len) == 0) {
	index = read_prediction_node(n->r, predictions, index);
      }
    }
  }
  return index;
}

/*
 * key õ
 * key ʸĹۤ뤫Ρɤ̵ʤäõǤڤ
 * triekeyǼƤȤǤʤʤդ֤
 */
static struct trie_node *
trie_find_for_prediction (struct trie_root* root, xstr *key)
{
  struct trie_node *p;
  struct trie_node *q;

  p = &root->root;
  q = p->l;

  while (p->bit < q->bit) {
    if (q->bit >= 2) {
      if ((q->bit - 2) / (int)(sizeof(xchar) << 3) >= key->len) {
	break;
      }
    }
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  return p;
}

static int
prediction_cmp(const void* lhs, const void* rhs)
{
  const struct prediction_t* const lpre = (const struct prediction_t* const) lhs;
  const struct prediction_t* const rpre = (const struct prediction_t* const) rhs;
 #if 0		/* Patched by G-HAL, Wed,22 Oct,2008, Fri,01 Nov,2008 */
  return rpre->timestamp - lpre->timestamp;
 #else
  const anthy_time_t tmp = rpre->timestamp - lpre->timestamp;
  return (0 == tmp) ? 0 : ((tmp < 0) ? -1 : +1);
 #endif
}

int
anthy_traverse_record_for_prediction(xstr* key, struct prediction_t* predictions)
{
  struct trie_node* mark;
  int nr_predictions;
 #if 0		/* Patched by G-HAL, Thu,30 Oct,2008 */
  if (anthy_select_section(PREDICTION, 0)) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    return 0;
  }
 #else
  if (anthy_settings.anthy_mode.anonymous) {
    return 0;
  }
  if (anthy_select_section(CAND_HISTORY, 0)) {
    return 0;
  }
 #endif

  /* ꤵ줿ʸprefix˻nodeõ */
  mark = trie_find_for_prediction(&anthy_current_record->cur_section->cols, key);
  if (!mark) {
    return 0;
  }
  nr_predictions = traverse_record_for_prediction(key, mark, predictions, 0);
 #if 0	/* Patched by G-HAL, Sun,02 Nov,2008, Mon,05 Jan,2009, Wed,24 Jun,2009 */
  if (predictions) {
    /* ॹפͽ¬򥽡Ȥ */
    qsort(predictions, nr_predictions, sizeof(struct prediction_t), prediction_cmp);
  }
 #else
  if (predictions && (1 < nr_predictions)) {
    /* ॹפͽ¬򥽡Ȥ */
    const int ret = mergesort( predictions, nr_predictions, sizeof(struct prediction_t), prediction_cmp );
    if (0 != ret) {
      anthy_log( 1, "BUG: anthy_traverse_record_for_prediction(): mergesort(): %d:'%s'\n", errno, strerror(errno) );
      abort();
    }
  } else {
   #if defined(DEBUG) && (1 <= DEBUG)
    anthy_log( 1, "anthy_traverse_record_for_prediction(): mergesort(): %d.\n", nr_predictions );
   #endif
  }
 #endif
  return nr_predictions;
}

/* Wrappers begin.. */
#if 0	/* Patched by G-HAL, Fri,17 Oct,2008 */
int
anthy_select_section(const char *name, int flag)
#else
int anthy_select_section( const enum ANTHY_SECTIONS_ section, int flag )
#endif
{
  struct record_stat* rst;
  struct record_section* rsc;

  rst = anthy_current_record;
  if (rst->row_dirty && rst->cur_section && rst->cur_row) {
    sync_add(rst, rst->cur_section, rst->cur_row);
  }
  rst->cur_row = NULL;
  rst->row_dirty = 0;
  /* rsc = do_select_section(rst, name, flag); */	/* Patched by G-HAL, Fri,17 Oct,2008 */
  rsc = do_select_section(rst, section, flag);	/* Patched by G-HAL, Fri,17 Oct,2008 */
  if (!rsc) {
    return -1;
  }
  rst->cur_section = rsc;
  return 0;
}

int
anthy_select_row(xstr *name, int flag)
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = anthy_current_record;
  if (!rst->cur_section) {
    return -1;
  }
  if (rst->row_dirty && rst->cur_row) {
    sync_add(rst, rst->cur_section, rst->cur_row);
    rst->row_dirty = 0;
  }
  node = do_select_row(rst->cur_section, name, flag, LRU_USED);
  if (!node) {
    return -1;
  }
  rst->cur_row = node;
  rst->row_dirty = flag;
  return 0;
}


/** row򤷳ؽʳθƤӽФѡ
 *@param[in]	idx			õ륤ǥåʸ
 *@param	create_if_not_exist	̵ɲä
 *@param	force_countup		ʣؽȻפǤ⶯Ūٹ
 *@retval	0			ｪλ
 *@retval	-1			Ԥ
 *
 * Patched by G-HAL, Sat,23 Aug,2008, Thu,30 Oct,2008, Tue,03 Feb,2009
 */
int anthy_select_row_with_learn( const xstr* const idx, int create_if_not_exist, int force_countup )
{
  struct record_stat* const rst = anthy_current_record;
  struct trie_node* node;

  if (!rst || !rst->cur_section) {
    return -1;
  }
  if (rst->row_dirty && rst->cur_row) {
    sync_add( rst, rst->cur_section, rst->cur_row );
    rst->row_dirty = 0;
  }
  rst->cur_row = NULL;

  sync_del_and_del( rst, NULL, NULL );

  node = do_select_row_with_learn( rst->cur_section, idx, create_if_not_exist, force_countup, anthy_settings.timestamp.currentsession );
  if (!node) {
    return -1;
  }
  rst->cur_row = node;
  rst->row_dirty = create_if_not_exist;
  return 0;
}


int
anthy_select_longest_row(xstr *name)
{
  /* Commented by G-HAL ա anthy_select_longest_row() ϡʸʾΤ߸ */
  struct record_stat* rst;
  struct trie_node* node;

  rst = anthy_current_record;
  if (!rst->cur_section)
    return -1;

  if (rst->row_dirty && rst->cur_row) {
    sync_add(rst, rst->cur_section, rst->cur_row);
    rst->row_dirty = 0;
  }
  node = do_select_longest_row(rst->cur_section, name);
  if (!node) {
    return -1;
  }

  rst->cur_row = node;
  rst->row_dirty = 0;
  return 0;
}

#if 0	/* Patched by G-HAL, Wed,27 Aug,2008 */
void
anthy_truncate_section(int count)
{
  do_truncate_section(anthy_current_record, count);
}
#endif

void
anthy_truncate_row(int nth)
{
  struct trie_node *cur_row = anthy_current_record->cur_row;
  if (!cur_row) {
    return ;
  }
  do_truncate_row(cur_row, nth);

}

int
anthy_mark_row_used(void)
{
  struct record_stat* rst = anthy_current_record;
  if (!rst->cur_row) {
    return -1;
  }

  do_mark_row_used(rst->cur_section, rst->cur_row);
  sync_add(rst, rst->cur_section, rst->cur_row);
  rst->row_dirty = 0;
  return 0;
}

void
anthy_set_nth_value(int nth, int val)
{
  struct record_stat* rst;

  rst = anthy_current_record;
  if (!rst->cur_row) {
    return;
  }
  do_set_nth_value( rst->cur_section, rst->cur_row, nth, val );	/* Patched by G-HAL, Thu,23 Oct,2008 */
  rst->row_dirty = 1;
}

/* Patched by G-HAL, Wed,22 Oct,2008, Thu,23 Oct,2008 */
void anthy_set_nth_int64( int nth, int64_t val )
{
  struct record_stat* const rst = anthy_current_record;
  if (!rst->cur_row) {
    return;
  }
  do_set_nth_int64( rst->cur_section, rst->cur_row, nth, val );
  rst->row_dirty = 1;
}

void
anthy_set_nth_xstr(int nth, xstr *xs)
{
  struct record_stat* rst = anthy_current_record;
  if (!rst->cur_row) {
    return;
  }
  do_set_nth_xstr( rst->cur_section, rst->cur_row, nth, xs, &rst->xstrs );	/* Patched by G-HAL, Thu,23 Oct,2008 */
  rst->row_dirty = 1;
}

int
anthy_get_nr_values(void)
{
  return do_get_nr_values(anthy_current_record->cur_row);
}

int
anthy_get_nth_value(int n)
{
  return do_get_nth_value(anthy_current_record->cur_row, n);
}

/* Patched by G-HAL, Wed,22 Oct,2008 */
int64_t anthy_get_nth_int64( int nth )
{
  return do_get_nth_int64( anthy_current_record->cur_row, nth );
}

xstr *
anthy_get_nth_xstr(int n)
{
  return do_get_nth_xstr(anthy_current_record->cur_row, n);
}

/* Patched by G-HAL, Tue,04 Nov,2008 */
int anthy_get_row_frequency( void )
{
  if (anthy_current_record && anthy_current_record->cur_row) {
    return anthy_current_record->cur_row->frequency;
  }
  return 0;
}

/* Patched by G-HAL, Tue,04 Nov,2008 */
anthy_time_t anthy_get_row_timestamp( void )
{
  if (anthy_current_record && anthy_current_record->cur_row) {
    return anthy_current_record->cur_row->timestamp;
  }
  return 0;
}

int
anthy_select_first_row(void)
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = anthy_current_record;
  if (!rst->cur_section)
    return -1;

  if (rst->row_dirty && rst->cur_row) {
    sync_add(rst, rst->cur_section, rst->cur_row);
    rst->row_dirty = 0;
  }
  node = do_select_first_row(rst->cur_section);
  if (!node) {
    return -1;
  }
  rst->cur_row = node;
  rst->row_dirty = 0;
  return 0;
}

int
anthy_select_next_row(void)
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = anthy_current_record;
  if (!rst->cur_section || !rst->cur_row)
    return -1;

  /* sync_add()  cur_row ̵ˤʤ뤳ȤΤǡ
   * Ȥ row_dirty Ǥ sync_add() ʤ
   */
  rst->row_dirty = 0;
  node = do_select_next_row(rst->cur_section, rst->cur_row);
  if (!node)
    return -1;
  rst->cur_row = node;
  rst->row_dirty = 0;
  return 0;
}

xstr *
anthy_get_index_xstr(void)
{
  return do_get_index_xstr(anthy_current_record);
}

/** CAND_HISTORYؽɲä
 *@param[in]	idx		ǥåʸ
 *@param[in]	commit_xs	Ͽʸ
 *@param	count		پ˲û
 *@retval	0		Ԥ
 *@retval	1		
 *
 *	Patches by G-HAL
 *		Sat,23 Aug,2008
 *		Fri,17 Oct,2008
 *		Wed,22 Oct,2008 - Thu,23 Oct,2008
 *		Thu,30 Oct,2008 - Fri,31 Oct,2008
 *		Tue,13 Jan,2009
 */
int anthy_learn_history_str( const xstr* const idx, const xstr* const commit_xs, int count )
{
  struct record_stat* const	rst = anthy_current_record;
  struct record_section*	rsc;
  struct trie_node*		node;

  if (!rst || !rst->cur_section) {
    return 0;
  }
  rsc = rst->cur_section;

  if (anthy_select_row_with_learn(idx,1,0)) {
    return 0;
  }
  node = rst->cur_row;
  do_learn_history_str( rst, rsc, node,
		       commit_xs,
		       count,
		       anthy_settings.timestamp.currentsession,
		       1 );

  sync_add( rst, rsc, node );
  rst->row_dirty = 0;
  return 1;
}
/*..Wrappers end*/

#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
/*
 * trie_row_init ϲǤ⤤
 */
static void
trie_row_init(struct record_row* rc)
{
  rc->nr_vals = 0;
  rc->vals = NULL;
}

static void
trie_row_free(struct record_row *rc)
{
  int i;
  for (i = 0; i < rc->nr_vals; i++)
    free_val_contents(rc->vals + i);
  free(rc->vals);
  free(rc->key.str);
}
#endif

#if 0	/* Patched by G-HAL, Thu,28 Aug,2008 */
/* 륻ΥǡƲ */
static void
free_section(struct record_stat *r, struct record_section *rs)
{
  struct record_section *s;
  trie_remove_all(&rs->cols, &rs->lru_nr_used, &rs->lru_nr_sused);
  if (r->cur_section == rs) {
    r->cur_row = NULL;
    r->cur_section = NULL;
  }
  for (s = &r->section_list; s && s->next; s = s->next) {
    if (s->next == rs) {
      s->next = s->next->next;
    }
  }
  if (rs->name){
    free((void *)rs->name);
  }
  free(rs);
}
#endif

/* ٤ƤΥǡ */
static void
free_record(struct record_stat *rst)
{
  struct record_section *rsc;
  for (rsc = rst->section_list.next; rsc; ){
    struct record_section *tmp;
    tmp = rsc;
    rsc = rsc->next;
    free_section(rst, tmp);
  }
  rst->section_list.next = NULL;
}

void
anthy_release_section(void)
{
  struct record_stat* rst;

  rst = anthy_current_record;
  if (!rst->cur_section) {
    return ;
  }
  free_section(rst, rst->cur_section);
  rst->cur_section = NULL;
}

void
anthy_release_row(void)
{
  struct record_stat* rst;

  rst = anthy_current_record;
  if (!rst->cur_section || !rst->cur_row) {
    return;
  }

  rst->row_dirty = 0;
  /* sync_del_and_del Ǻ⤹ */
  sync_del_and_del(rst, rst->cur_section, rst->cur_row);
  rst->cur_row = NULL;
}

/** row 򵼻
 *
 *	Patches by G-HAL
 *		Sat,17 Jan,2009
 *		Thu,19 Feb,2009 - Fri,20 Feb,2009
 */
void anthy_pseudorelease_row( void )
{
  struct record_stat* const	rst = anthy_current_record;
  if (!rst || !rst->cur_section || !rst->cur_row) {
    return;
  }
  {
    struct record_section*	rsc = rst->cur_section;
    struct trie_node*		node = rst->cur_row;
    if (0 < node->timestamp) {
      node->timestamp = - node->timestamp;
      sync_add( rst, rsc, node );
      rst->row_dirty = 0;
    }
  }
  return;
}

/** row ȿؽ
 *
 *	Patches by G-HAL
 *		Tue,30 Dec,2008
 */
void anthy_unlearn_row( void )
{
  struct record_stat* const	rst = anthy_current_record;
  if (!rst || !rst->cur_section || !rst->cur_row) {
    return;
  }
  {
    struct record_section*	rsc = rst->cur_section;
    struct trie_node*		node = rst->cur_row;
    anthy_time_t		timestamp = anthy_settings.timestamp.currentsession;

    if (timestamp < node->timestamp) {
      node->timestamp = timestamp - 1;
      sync_add( rst, rsc, node );
      rst->row_dirty = 0;
    }
  }
  return;
}

static void
check_record_encoding(struct record_stat *rst)
{
  FILE *fp;
  if (anthy_open_file(rst->base_fn) == 0) {
    /* EUCե뤬ä */
    anthy_close_file();
    return ;
  }
  fp = fopen(rst->journal_fn, "r");
  if (fp) {
    /* EUCκʬե뤬ä */
    fclose(fp);
    return ;
  }
  rst->encoding = ANTHY_UTF8_ENCODING;
 #if 0		/* Patched by G-HAL, Fri,31 Oct,2008 */
  strcat(rst->base_fn, ENCODING_SUFFIX);
  strcat(rst->journal_fn, ENCODING_SUFFIX);
 #else
  strlcat( rst->base_fn, anthy_settings.filename.record_ext, PATH_MAX );
  strlcat( rst->journal_fn, anthy_settings.filename.record_ext, PATH_MAX );
 #endif
}

static void
record_dtor(void *p)
{
  int dummy;
  struct record_stat *rst = (struct record_stat*) p;
  free_record(rst);
  if (rst->id) {
    free(rst->base_fn);
    free(rst->basebin_fn);	/* Patched by G-HAL, Thu,16 Oct,2008 */
    free(rst->journal_fn);
  }
  trie_remove_all(&rst->xstrs, &dummy, &dummy);
}

void
anthy_reload_record(void)
{
#if 0	/* Patched by G-HAL, Wed,14 Jan,2009 */
  struct stat st;
  struct record_stat *rst = anthy_current_record;

  if (stat(rst->journal_fn, &st) == 0 &&
      rst->journal_timestamp == st.st_mtime) {
    return ;
  }

  lock_record(rst);
  read_base_record(rst);
  read_journal_record(rst);
  unlock_record(rst);
#else
  struct record_stat* const rst = anthy_current_record;
  struct stat st;
  int need_update = 0;

  if (!check_base_record_uptodate(rst)) {
    need_update = 1;
  } else {
    if (stat(rst->journal_fn, &st) < 0){
      need_update = 1;
    } else {
      if (rst->journal_timestamp != st.st_mtime) {
	need_update = 1;
      }
    }
  }
  if (need_update) {
    lock_record( rst );
    read_base_record( rst, 0 );
    read_journal_record( rst );
    unlock_record( rst );
  }
  return;
#endif
}

void
anthy_init_record(void)
{
  record_ator = anthy_create_allocator(sizeof(struct record_stat),
				       record_dtor);
}

static void
setup_filenames(const char *id, struct record_stat *rst)
{
 #if 0	/* Patched by G-HAL, Thu,16 Oct,2008, Fri,17 Oct,2008 */
  const char *home = anthy_conf_get_str("HOME");
  int base_len = strlen(home) + strlen(id) + 10;

  /* ܥե */
  rst->base_fn = (char*) malloc(base_len +
				strlen("/.anthy/last-record1_"));
  sprintf(rst->base_fn, "%s/.anthy/last-record1_%s",
	  home, id);
  /* ʬե */
  rst->journal_fn = (char*) malloc(base_len +
				   strlen("/.anthy/last-record2_"));
  sprintf(rst->journal_fn, "%s/.anthy/last-record2_%s",
	  home, id);
 #else
  const char* const home = anthy_conf_get_str("HOME");
  /* const size_t base_len = strlen(home)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(id)
      + strlen(anthy_settings.filename.record_ext)
      + 1;*/

  {	/* ܥե */
    /* const size_t record1_base_len = base_len + strlen(anthy_settings.filename.record1);*/
    rst->base_fn = (char*) malloc( PATH_MAX );
    snprintf( rst->base_fn, PATH_MAX,
	     "%s%s%s%s%s%s",
	     home,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.user_dir,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.record1,
	     id );
  }
  {	/* ܥեʥХʥ */
    /* const size_t basebin_fn_len = strlen(rst->base_fn)
	+ strlen(anthy_settings.filename.record1_bin_ext)
	+ 1;*/
    rst->basebin_fn = (char*) malloc( PATH_MAX );
    snprintf( rst->basebin_fn, PATH_MAX,
	     "%s%s",
	     rst->base_fn,
	     anthy_settings.filename.record1_bin_ext );
  }
  {	/* ʬե */
    /* const size_t record2_base_len = base_len + strlen(anthy_settings.filename.record2);*/
    rst->journal_fn = (char*) malloc( PATH_MAX );
    snprintf( rst->journal_fn, PATH_MAX,
	     "%s%s%s%s%s%s",
	     home,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.user_dir,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.record2,
	     id );
    rst->journal_timestamp = 0;	/* Patched by G-HAL, Mon,19 Oct,2009 */
  }
 #endif
}

/** ؽǡɤ߹ߤԤ
 *@param[in]	id		ѡʥƥID
 *@param	refresh		ŪؽκƹۤԤ(1)(0)
 *
 * Patched by G-HAL
 *	Fri,29 Aug,2008
 *	Wed,14 Jan,2009
 *	Tue,14 Jul,2009
 *@memo
 *	experimental and unstable
 */
struct record_stat* anthy_create_record( const char* const id, int refresh )
{
  struct record_stat *rst;

  if (!id) {
    return NULL;
  }

  rst = (struct record_stat*) anthy_smalloc(record_ator);
  rst->id = id;
  rst->section_list.next = NULL;
  init_trie_root(&rst->xstrs);
  rst->cur_section = NULL;
  rst->cur_row = NULL;
  rst->row_dirty = 0;
  rst->encoding = 0;

  /* ե̾ʸ */
  setup_filenames(id, rst);

  rst->baserecord_size = 0;	/* Patched by G-HAL, Fri,29 Aug,2008 */
  rst->last_update = 0;

  if (!strcmp(id, ANON_ID)) {
    rst->is_anon = 1;
  } else {
    rst->is_anon = 0;
    anthy_check_user_dir();
  }

  /* ե뤫ɤ߹ */
  lock_record(rst);
  check_record_encoding(rst);
  read_base_record( rst, refresh );	/* Patched by G-HAL, Wed,14 Jan,2009 */
  read_journal_record(rst);
  if (refresh
	  || ((0 < anthy_settings.recordfile2_limit) && (anthy_settings.recordfile2_limit < rst->last_update))
  ) {
	  update_base_record( rst );
  }
  unlock_record(rst);

  return rst;
}

void
anthy_release_record(struct record_stat *rs)
{
  anthy_sfree(record_ator, rs);
}

/** ؽ flush ԤãݤȽꤷãʤ¹Ԥ
 *
 * Patched by G-HAL
 *	Tue,14 Jul,2009
 *@memo
 *	experimental and unstable
 */
void anthy_checkupdate_baserecord( void )
{
  struct record_stat* const	rst = anthy_current_record;
  if (rst) {
    lock_record( rst );
    if (check_base_record_uptodate(rst)) {
      read_journal_record( rst );
    } else {
      read_base_record( rst, 0 );
      read_journal_record( rst );
    }
    if ((0 < anthy_settings.recordfile2_limit) && (anthy_settings.recordfile2_limit < rst->last_update)) {
      update_base_record( rst );
    }
    unlock_record( rst );
  }
  return;
}

/** ؽκƹۤԤ
 *
 * Patched by G-HAL
 *	Thu,21 Aug,2008
 *	Wed,14 Jan,2009
 *@memo
 *	experimental and unstable
 */
void anthy_update_base_record( void )
{
  int	ret = anthy_dic_util_init_with_dicrefresh();
  if (!ret) {
    struct record_stat* const	rst = anthy_current_record;
    if (rst) {
      lock_record( rst );
      read_base_record( rst, 1 );
      read_journal_record( rst );
      update_base_record( rst );
      unlock_record( rst );
    }
  }
  return;
}
/* vim:ts=8 sw=2 nomodified:
 */
