#ifndef _rkconv_h_included_
#define _rkconv_h_included_

#ifdef __cplusplus
extern "C" {
#endif


struct rk_map;
struct rk_rule
{
	const char* lhs;
	const char* rhs;
	const char* follow;
};
struct rk_conv_context;

extern struct rk_map*
rk_map_create(const struct rk_rule* rules);
extern struct rk_conv_context*
rk_context_create(int brk);
extern struct rk_map*
rk_select_map(struct rk_conv_context* cc, struct rk_map* map);
extern int
rk_push_key(struct rk_conv_context* cc, int c);
extern int rk_push_euc2( struct rk_conv_context* cc, char* const p );	/* Patched by G-HAL, Wed,04 Feb,2009 */
extern int rk_push_euc3( struct rk_conv_context* cc, char* const p );	/* Patched by G-HAL, Wed,04 Feb,2009 */
extern int
rk_result(struct rk_conv_context* cc, char* buf, int size);
extern void
rk_context_free(struct rk_conv_context* cc);
extern int
rk_map_free(struct rk_map* map);
extern int
rk_partial_result(struct rk_conv_context* cc, char* buf, int size);

extern void
rk_flush(struct rk_conv_context* cc);
extern void
rk_terminate(struct rk_conv_context* cc);
extern int
rk_get_pending_str(struct rk_conv_context* cc, char* buf, int size);
extern struct rk_map*
rk_register_map(struct rk_conv_context* cc, int mapn, struct rk_map* map);
extern void
rk_select_registered_map(struct rk_conv_context* cc, int mapn);
extern int
rk_selected_map(struct rk_conv_context* cc);

extern struct rk_rule*
rk_merge_rules(const struct rk_rule* r1, const struct rk_rule* r2);
extern void
rk_rules_free(struct rk_rule* rules);

extern const char *brk_roman_get_previous_pending(struct rk_conv_context *rkctx);
extern int         brk_roman_get_decided_len(struct rk_conv_context *rkctx);


#ifdef __cplusplus
}
#endif

#endif /* _rkconv_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
