/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ʸڤ˱ɾ
 *@date		Tue,03 Nov,2009 - Wed,04 Nov,2009
 *@date		Fri,06 Nov,2009
 *@date		Sat,07 Nov,2009
 *@date		Thu,12 Nov,2009 - Sat,14 Nov,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@date		Fri,07 Oct,2011
 *@author	Copyright(C)2009-2011 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#include "anthy/settings.h"
#include "anthy/xstr.h"
#include "anthy/dic.h"
#include "anthy/splitter.h"
#include "anthy/wtype.h"
#include "src-splitter/wordborder.h"
#include "src-worddic/dic_ent.h"
#include "anthy/splitter.h"
#include "src-splitter/cand_wt_name.h"
#include "src-splitter/depgraph_type_sym.h"
#include "src-ordering/ucdict.h"
#include "src-splitter/metaword_relationscore.h"



/** ʸڤѤΥΥ
 *@param[in]			left_seg				¦ΥNULLԲġ
 *@param[in]			right_seg				¦ΥNULLġ
 *@retval				INT_MIN					̵
 *@return										
 *
 *	Patches by G-HAL
 *		Tue,03 Nov,2009 - Wed,04 Nov,2009
 *		Fri,06 Nov,2009
 *		Sat,07 Nov,2009
 *		Thu,12 Nov,2009 - Sat,14 Nov,2009
 */
static int calc_metaword_relation_score_with_seg1_seg2( const struct ucdic_seg_info* const left_seg, const struct ucdic_seg_info* const right_seg )
{
	assert( left_seg );
	int score = INT_MIN;
	int flag = anthy_dic_check_word_relation( left_seg->id_base_fin, right_seg ? right_seg->id_base_fin : 0 );
	if (0 == flag) {
		return score;
	}
	{ /* ե饰Ƚ */
		int re_check = 0;
		uint32_t left_id  = left_seg->id_wo_dep;
		uint32_t right_id = right_seg ? right_seg->id_wo_dep : 0;
		const int seg1_deptype = flag & UCDICT_SEG1_NODE_DEPTYPE_FLAGS;
		const int seg2_deptype = flag & UCDICT_SEG2_NODE_DEPTYPE_FLAGS;

		{ /* °Ƚ */
			if (UCDICT_SEG1_NODE_NO_DEP == seg1_deptype) {
				if (left_seg->have_dep) {
					return score;
				}
			} else if (UCDICT_SEG1_NODE_HAVE_DEP == seg1_deptype) {
				if (!left_seg->have_dep) {
					return score;
				}
				left_id = left_seg->id_w_dep;
				re_check = 1;
			}
			if (right_seg) {
				if (UCDICT_SEG2_NODE_NO_DEP == seg2_deptype) {
					if (right_seg->have_dep) {
						return score;
					}
				} else if (UCDICT_SEG2_NODE_HAVE_DEP == seg2_deptype) {
					if (!right_seg->have_dep) {
						return score;
					}
					right_id = right_seg->id_w_dep;
					re_check = 1;
				}
			}
		}

		{ /* ʻȽ */
			if (UCDICT_SEG1_NODE_HAVE_WT & flag) {
				left_id = anthy_hash_str_update( left_id, left_seg->wt );
				re_check = 1;
			}
			left_id = anthy_hash_uint8_update( left_id, '\0' );
			if (UCDICT_SEG1_NODE_HAVE_WT_H & flag) {
				left_id = anthy_hash_str_update( left_id, left_seg->wt_h );
				re_check = 1;
			}
			left_id = anthy_hash_uint8_update( left_id, '\0' );
			if (UCDICT_SEG1_NODE_HAVE_WT_C & flag) {
				left_id = anthy_hash_str_update( left_id, left_seg->wt_c );
				re_check = 1;
			}
			left_id = anthy_hash_uint8_update( left_id, '\0' );
			if (UCDICT_SEG1_NODE_HAVE_WT_S & flag) {
				left_id = anthy_hash_str_update( left_id, left_seg->wt_s );
				re_check = 1;
			}
			left_id = anthy_hash_uint8_update( left_id, '\0' );

			if (right_seg) {
				if (UCDICT_SEG2_NODE_HAVE_WT & flag) {
					right_id = anthy_hash_str_update( right_id, right_seg->wt );
					re_check = 1;
				}
				right_id = anthy_hash_uint8_update( right_id, '\0' );
				if (UCDICT_SEG2_NODE_HAVE_WT_H & flag) {
					right_id = anthy_hash_str_update( right_id, right_seg->wt_h );
					re_check = 1;
				}
				right_id = anthy_hash_uint8_update( right_id, '\0' );
				if (UCDICT_SEG2_NODE_HAVE_WT_C & flag) {
					right_id = anthy_hash_str_update( right_id, right_seg->wt_c );
					re_check = 1;
				}
				right_id = anthy_hash_uint8_update( right_id, '\0' );
				if (UCDICT_SEG2_NODE_HAVE_WT_S & flag) {
					right_id = anthy_hash_str_update( right_id, right_seg->wt_s );
					re_check = 1;
				}
				right_id = anthy_hash_uint8_update( right_id, '\0' );
			}
		}

		if (re_check) {
			/* ĥڥ */
			flag = anthy_dic_check_word_relation( anthy_hash_finalize(left_id), right_seg ? anthy_hash_finalize(right_id) : 0 );
			if (0 == flag) {
				return score;
			}
			if ((UCDICT_SEG1_NODE_HAVE_DEP == seg1_deptype) && !(UCDICT_SEG1_LEAF_HAVE_DEP & flag)) {
				return score;
			}
			if (right_seg) {
				if ((UCDICT_SEG2_NODE_HAVE_DEP == seg2_deptype) && !(UCDICT_SEG2_LEAF_HAVE_DEP & flag)) {
					return score;
				}
			}
		}
	}
	{ /* ŬѼ¹ */
		score = ((UCDICT_PRIORITY_MINUS & flag) ? -1 : +1) * (UCDICT_PRIORITY_VALUE & flag);
	}
	return score;
}



/** ʸڤѤΥ¦ϸꡢ¦ʸƥѡȺƵ
 *@param[in]			left_seg				¦Υ
 *@param[in,out]		right_seg				¦Υΰhave_dep, wt_h, wt_c, wt_s
 *@param[in]			right_mw				¦ʸ
 *@param				right_part_num			¦ʸνΥѡ
 *@param[in]			right_hash				¦ʸɤ߲̾Υϥå
 *@param[in]			right_dep				¦ʸ°
 *@retval				INT_MIN					̵
 *@return										
 *
 *	Patches by G-HAL
 *		Tue,03 Nov,2009 - Wed,04 Nov,2009
 *		Fri,06 Nov,2009
 *		Sat,07 Nov,2009
 *		Thu,12 Nov,2009 - Fri,13 Nov,2009
 *		Fri,07 Oct,2011
 */
static int calc_metaword_relation_score_with_seg1_seg2part( const struct ucdic_seg_info* const left_seg, struct ucdic_seg_info* const right_seg,
														   const struct meta_word* const right_mw, int right_part_num, const uint32_t right_hash, const xstr* const right_dep )
{
	int score = INT_MIN;

	const struct part_info* const	right_p  = &(right_mw->wl->part[right_part_num]);
  #if 0		/* Patched by G-HAL, Fri,07 Oct,2011 */
	const wtype_t					right_wt = anthy_get_wtype_with_ct( right_p->wt, CT_NONE );
  #else
	wtype_t right_wt;
	anthy_get_wtype_with_ct( &right_wt, right_p->wt, CT_NONE );
  #endif
	const struct seq_ent* const		right_se = right_p->seq;
	const struct dic_ent* const*	right_dic_ents;
	uint32_t						right_id;
	int i;
	if (right_se) {
		i = (right_se->nr_dic_ents - 1);
		right_dic_ents = right_se->dic_ents;
	} else {
		i = 0;
		right_dic_ents = NULL;
	}
	for (; 0 <= i; --i, ++right_dic_ents) {
		if (right_dic_ents) {
			const struct dic_ent* const	right_de = right_dic_ents ? *right_dic_ents : NULL;
			if (!anthy_wtype_include(right_wt, right_de->type)) {
				continue;
			}
			right_id = anthy_hash_xstr_update( right_hash, &(right_de->str) );
			if (PART_CORE == right_part_num) {
				right_seg->wt = right_de->wt_name;
			}
		} else {
			right_id = right_hash;
			if (PART_CORE == right_part_num) {
				right_seg->wt = "";
			}
		}

		if ((right_part_num + 1) <= PART_POSTFIX) {
			const int hit_value = calc_metaword_relation_score_with_seg1_seg2part( left_seg, right_seg, right_mw, right_part_num + 1, right_id, right_dep );
			if (score < hit_value) {
				score = hit_value;
			}

		} else {
			right_seg->id_base     = anthy_hash_uint32_update( right_id, '\0' );
			right_seg->id_base_fin = anthy_hash_finalize( right_seg->id_base );
			right_seg->id_wo_dep   = anthy_hash_uint32_update( right_seg->id_base, '\0' );
			right_seg->id_w_dep    = right_seg->have_dep ? anthy_hash_uint32_update( anthy_hash_xstr_update( right_seg->id_base, right_dep ), '\0') : right_seg->id_wo_dep;

			const int hit_value = calc_metaword_relation_score_with_seg1_seg2( left_seg, right_seg );
			if (score < hit_value) {
				score = hit_value;
			}
		}
	}
	return score;
}



/** ʸڤѤΥ¦ʸƥѡȺƵ
 *@param[in]			left_seg				¦Υΰhave_dep, wt_h, wt_c, wt_s
 *@param[in,out]		right_seg				¦Υΰhave_dep, wt_h, wt_c, wt_s
 *@param[in]			left_mw					¦ʸ
 *@param				left_part_num			¦ʸνΥѡ
 *@param[in]			left_hash				¦ʸνΥϥå
 *@param[in]			left_dep				¦ʸ°
 *@param[in]			right_mw				¦ʸ
 *@param[in]			right_hash				¦ʸɤ߲̾Υϥå
 *@param[in]			right_dep				¦ʸ°
 *@retval				INT_MIN					̵
 *@return										
 *
 *	Patches by G-HAL
 *		Thu,12 Nov,2009 - Sat,14 Nov,2009
 *		Fri,07 Oct,2011
 */
static int calc_metaword_relation_score_with_seg1part( struct ucdic_seg_info* const left_seg, struct ucdic_seg_info* const right_seg,
													  const struct meta_word* const left_mw, int left_part_num, const uint32_t left_hash, const xstr* const left_dep,
													  const struct meta_word* const right_mw, const uint32_t right_hash, const xstr* const right_dep )
{
	int score = INT_MIN;

	const struct part_info* const	left_p  = &(left_mw->wl->part[left_part_num]);
  #if 0		/* Patched by G-HAL, Fri,07 Oct,2011 */
	const wtype_t					left_wt = anthy_get_wtype_with_ct( left_p->wt, CT_NONE );
  #else
	wtype_t left_wt;
	anthy_get_wtype_with_ct( &left_wt, left_p->wt, CT_NONE );
  #endif
	const struct seq_ent* const		left_se = left_p->seq;
	const struct dic_ent* const*	left_dic_ents;
	uint32_t						left_id;
	int i;
	if (left_se) {
		i = (left_se->nr_dic_ents - 1);
		left_dic_ents = left_se->dic_ents;
	} else {
		i = 0;
		left_dic_ents = NULL;
	}
	for (; 0 <= i; --i, ++left_dic_ents) {
		if (left_dic_ents) {
			const struct dic_ent* const	left_de = left_dic_ents ? *left_dic_ents : NULL;
			if (!anthy_wtype_include(left_wt, left_de->type)) {
				continue;
			}
			left_id = anthy_hash_xstr_update( left_hash, &(left_de->str) );
			if (PART_CORE == left_part_num) {
				left_seg->wt = left_de->wt_name;
			}
		} else {
			left_id = left_hash;
			if (PART_CORE == left_part_num) {
				left_seg->wt = "";
			}
		}

		if ((left_part_num + 1) <= PART_POSTFIX) {
			const int hit_value = calc_metaword_relation_score_with_seg1part( left_seg, right_seg, left_mw, left_part_num + 1, left_id, left_dep, right_mw, right_hash, right_dep );
			if (score < hit_value) {
				score = hit_value;
			}

		} else {
			left_seg->id_base     = anthy_hash_uint32_update( left_id, '\0' );
			left_seg->id_base_fin = anthy_hash_finalize( left_seg->id_base );
			if (0 == anthy_dic_search_word_relation_key(left_seg->id_base_fin)) {
				continue;
			}
			left_seg->id_wo_dep   = anthy_hash_uint32_update( left_seg->id_base, '\0' );
			left_seg->id_w_dep    = left_seg->have_dep ? anthy_hash_uint32_update( anthy_hash_xstr_update( left_seg->id_base, left_dep ), '\0') : left_seg->id_wo_dep;

			{	const int hit_value = calc_metaword_relation_score_with_seg1_seg2( left_seg, NULL );
				if (score < hit_value) {
					score = hit_value;
				}
			}
			if (right_seg) {
				const int hit_value = calc_metaword_relation_score_with_seg1_seg2part( left_seg, right_seg, right_mw, 0, right_hash, right_dep );
				if (score < hit_value) {
					score = hit_value;
				}
			}
		}
	}
	return score;
}



/** ʸڤѤΥ
 *@param[in]			sc						Ѵ
 *@param[in]			mw1						¦ʸNULL ξ keepalive
 *@param[in]			mw2						¦ʸ
 *@retval				0						̵
 *@return										
 *
 *	Patches by G-HAL
 *		Tue,03 Nov,2009 - Wed,04 Nov,2009
 *		Fri,06 Nov,2009
 *		Sat,07 Nov,2009
 *		Thu,12 Nov,2009 - Sat,14 Nov,2009
 */
int calc_metaword_relation_score( const struct splitter_context* const sc, const struct meta_word* const mw1, const struct meta_word* const mw2 )
{
	int score = INT_MIN;
	assert( sc );
	assert( mw2 );

	const struct meta_word* const right_mw = (MW_WRAP == mw2->type) ? mw2->mw1 : mw2;
	if ((NULL == right_mw->wl) || (NR_PARTS != right_mw->nr_parts)) {
		/* ؽٹ¥Ĺ伫ưʸϡʻ̵Τ㼭θǤʤ */

	} else {
		const struct part_info* const	right_p_dep            = &(right_mw->wl->part[PART_DEPWORD]);
		const xstr						right_dep              = { .str = (0 < right_p_dep->len) ? sc->ce[right_p_dep->from].c : NULL, .len = right_p_dep->len  };
		const xstr						right_indep_yomi       = { .str = sc->ce[right_mw->from].c, .len = (right_mw->len - right_dep.len) };
		const uint32_t					right_indep_yomi_hash  = anthy_hash_uint32_update( anthy_hash_xstr_start( &right_indep_yomi ), '\0' );
		struct ucdic_seg_info	right_seg;
		right_seg.have_dep = (0 < right_dep.len);
		right_seg.wt_h = anthy_depgraph_pos_class_sym( right_mw );
		right_seg.wt_c = anthy_depgraph_ct_class_sym( right_mw );
		right_seg.wt_s = anthy_depgraph_dep_class_sym( right_mw );

		if (NULL == mw1) {
			score = calc_metaword_relation_score_with_seg1part( &right_seg, NULL, right_mw, 0, right_indep_yomi_hash, &right_dep, NULL, 0, NULL );
			if (anthy_settings.anthy_mode.keepalive.enable_refer_ucdic_for_lattice) {
				const struct ucdic_seg_info* const left_seg = sc->prev_commit.seg_ucinfo;
				if (left_seg) {
					const int hit_value = calc_metaword_relation_score_with_seg1_seg2part( left_seg, &right_seg, right_mw, 0, right_indep_yomi_hash, &right_dep );
					if (score < hit_value) {
						score = hit_value;
					}
				}
			}

		} else {
			const struct meta_word* const left_mw  = (MW_WRAP == mw1->type) ? mw1->mw1 : mw1;
			if ((NULL == left_mw->wl) || (NR_PARTS != left_mw->nr_parts)) {
				/* ؽٹ¥Ĺ伫ưʸϡʻ̵Τ㼭θǤʤ */

			} else {
				const struct part_info* const	left_p_dep            = &(left_mw->wl->part[PART_DEPWORD]);
				const xstr						left_dep              = { .str = (0 < left_p_dep->len) ? sc->ce[left_p_dep->from].c : NULL, .len = left_p_dep->len  };
				const xstr						left_indep_yomi       = { .str = sc->ce[left_mw->from].c, .len = (left_mw->len - left_dep.len) };
				const uint32_t					left_indep_yomi_hash  = anthy_hash_uint32_update( anthy_hash_xstr_start( &left_indep_yomi ), '\0' );
				struct ucdic_seg_info	left_seg;
				left_seg.have_dep = (0 < left_dep.len);
				left_seg.wt_h = anthy_depgraph_pos_class_sym( left_mw );
				left_seg.wt_c = anthy_depgraph_ct_class_sym( left_mw );
				left_seg.wt_s = anthy_depgraph_dep_class_sym( left_mw );
				score = calc_metaword_relation_score_with_seg1part( &left_seg, &right_seg, left_mw, 0, left_indep_yomi_hash, &left_dep, right_mw, right_indep_yomi_hash, &right_dep );
			}
		}
	}
	return (INT_MIN != score) ? score : 0;
}
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
