/**@file
 *			Patches for the Anthy, by G-HAL
 *@brief	ʸڤꥢ르ꥺࡧư
 *@date		Sat,18 Apr,2009 - Mon,20 Apr,2009
 *@date		Sun,07 Jun,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif

#include "anthy/settings.h"
#include "anthy/splitter.h"
#include "src-splitter/lattice.h"



/** ʸ󤫤ʸڤΥҥȾ
 *@param[in]		in_xs		ҥȾФʸ
 *@param[in,out]	out_xs		ҥȾʸü 0 դü 0 ʸ˥Ȥʤ
 *@return						ҥȾout_xs->len + 1 礭
 *
 *@date		Mon,20 Apr,2009
 */
const int* const anthy_convert_hint_border( const xstr* const in_xs, xstr* const out_xs )
{
	switch (anthy_settings.anthy_mode.lattice.hinting) {
	case ANTHY_LATTICE_HINTING_NONE:
		{
			out_xs->str = (xchar*) malloc( sizeof(xchar) * (in_xs->len + 1) );
			anthy_xstrcpy( out_xs, in_xs );
			out_xs->str[in_xs->len] = 0;
			return NULL;
		}
		break;

	case ANTHY_LATTICE_HINTING_BY_KATAKANA:
		{	size_t	i;
			xstr* const hira_xs = anthy_xstr_kata_to_hira( in_xs );
			xstr* const kata_xs = anthy_xstr_vu_to_uddot( in_xs );
			int* const lattice_hint = (int*) malloc( sizeof(int) * (hira_xs->len + 1) );

			out_xs->str = (xchar*) malloc( sizeof(xchar) * (hira_xs->len + 1) );
			anthy_xstrcpy( out_xs, hira_xs );
			out_xs->str[hira_xs->len] = 0;

			for (i = 0; i < hira_xs->len; ++i) {
				lattice_hint[i] = 0;
				if (kata_xs->str[i] != hira_xs->str[i]) {
					lattice_hint[i] = 1;
				}
			}

			anthy_free_xstr( kata_xs );
			anthy_free_xstr( hira_xs );
			return lattice_hint;
		}
		break;

	case ANTHY_LATTICE_HINTING_BY_CHARACTER:
		{	size_t		i, j;
			const xchar	delimiter = anthy_settings.anthy_mode.lattice.hinting_character;
			int* const	lattice_hint = (int*) calloc( (in_xs->len + 1), sizeof(int) );

			out_xs->str = (xchar*) malloc( sizeof(xchar) * (in_xs->len + 1) );

			for (i = 0, j = 0; i < in_xs->len; ++i) {
				if (delimiter == in_xs->str[i]) {
					lattice_hint[j] = 1;
				} else {
					out_xs->str[j] = in_xs->str[i];
					++j;
				}
			}

			out_xs->str[j] = 0;
			out_xs->len = j;
			return lattice_hint;
		}
		break;
	}
	return NULL;
}



/** ưϤʸڤ֤ΥҥȾꤹ
 *@param[in,out]	sc			ʸڤδþ
 *@param			from		Ϥʸ
 *@param			to			λʸ
 *
 *@date		Sat,18 Apr,2009 - Mon,20 Apr,2009
 */
void hinted_path_by_manual( struct splitter_context* const sc,
						   size_t from, size_t to )
{
	if (NULL == sc->word_split_info) {
		return;
	}
	if (NULL == sc->ce[from].hint) {
		return;
	}

	{	size_t	i;
		for (i = from; i < to; ++i) {
			if (sc->ce[i].hint[0]) {
				sc->word_split_info->seg_border[i] = 1;
			}
		}
	}
	return;
}



/** ưϤʸڤ֤ꤹ
 *@param[in,out]	sc			ʸڤδþ
 *@param			from		Ϥʸ
 *@param			to			λʸ
 *
 *@date		Sat,18 Apr,2009 - Mon,20 Apr,2009
 */
void choose_path_by_manual( struct splitter_context* const sc,
						   size_t from, size_t to )
{
	if (NULL == sc->word_split_info) {
		return;
	}
	if (NULL == sc->ce[from].hint) {
		return;
	}

	{	size_t	i;
		for (i = from; i < to; ++i) {
			if (sc->ce[i].hint[0]) {
				sc->word_split_info->seg_border[i] = 1;
			}
		}
	}
	return;
}

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
