/*
 * Ψɾӥӥ르ꥺ(viterbi algorithm)ˤä
 * ʸζڤꤷƥޡ롣
 *
 *
 * ƤӽФؿ
 *  anthy_mark_borders()
 *
 * Copyright (C) 2006-2007 TABATA Yusuke
 * Copyright (C) 2004-2006 YOSHIDA Yuichi
 * Copyright (C) 2006 HANAOKA Toshiyuki
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/*
 * ƥ¸ߤmeta_wordĤʤǥդޤ
 * (ΥդΤȤƥ(lattice/«)⤷ϥȥꥹ(trellis)ȸƤӤޤ)
 * meta_wordɤ³դΥΡɤȤʤꡢ¤lattice_node
 * 󥯤Ȥƹޤ
 *
 * ǤνϼĤǤǹޤ
 * (1) դĤġƥΡɤؤãΨ
 * (2) դ()餿ɤäƺŬʥѥ
 *
 */
#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <anthy/alloc.h>
#include <anthy/xstr.h>
#include <anthy/segclass.h>
#include <anthy/splitter.h>
#include <anthy/feature_set.h>
#include <anthy/diclib.h>
#include "wordborder.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_MATH_H)
# include <math.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#include "anthy/settings.h"	/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "anthy/alloc.h"
#include "anthy/xstr.h"
#include "anthy/segclass.h"
#include "anthy/splitter.h"
#include "anthy/feature_set.h"
#include "anthy/diclib.h"
#include "wordborder.h"
#include "src-splitter/lattice.h"	/* Patched by G-HAL, Fri,06 Mar,2009 */
#endif

static float anthy_normal_length = 20.0; /* ʸδԤĹ */
static void *trans_info_array;

#if defined(DEBUG)
# define NODE_MAX_SIZE 5000
#else
# define NODE_MAX_SIZE 50
#endif

/* դΥΡ(ܾ) */
struct lattice_node {
  int border; /* ʸΤɤϤޤ֤ */
  enum seg_class seg_class; /* ξ֤ʻ */


  double real_probability;  /* ˻ޤǤγΨ(ʸ̵) */
  double adjusted_probability;  /* ˻ޤǤγΨ(ʸͭ) */
  double mw_bias_probability;		/* mw μˤΨ, Patched by G-HAL, Tue,17 Aug,2010 */
 #if defined(DEBUG)
  double current_probability;		/* ΥΡɤγΨ, Patched by G-HAL, Tue,17 Aug,2010 */
  double tailphrase_probability;	/* ǸΡɤγΨ, Patched by G-HAL, Tue,17 Aug,2010 */
 #endif


  struct lattice_node* before_node; /* ܾ */
  struct meta_word* mw; /* ܾ֤бmeta_word */

  struct lattice_node* next; /* ꥹȹ¤ΤΥݥ */
};

struct node_list_head {
  struct lattice_node *head;
  int nr_nodes;
};

struct lattice_info {
  /* ܾ֤ΥꥹȤ */
  struct node_list_head *lattice_node_list;
  struct splitter_context *sc;
  /* ΡɤΥ */
  allocator node_allocator;
};

/*
 */
static void
print_lattice_node(struct lattice_info *info, struct lattice_node *node)
{
  if (!node) {
    printf("**lattice_node (null)*\n");
    return ;
  }
  printf("**lattice_node probability=%.128f\n", node->real_probability);
  if (node->mw) {
    anthy_print_metaword(info->sc, node->mw);
  }
}

static double
get_poisson(double lambda, int r)
{
  int i;
  double result;

  /* פ˥ݥ諒ʬ */
  result = pow(lambda, (double)r) * exp(-lambda);
  for (i = 2; i <= r; ++i) {
    result /= i;
  }

  return result;
}

/* ʸη饹Ĵ */
static double
get_form_bias(struct meta_word *mw)
{
  double bias;
  int r;
  /* wrapƤΤȤ */
  while (mw->type == MW_WRAP) {
    mw = mw->mw1;
  }
 #if 0		/* Patched by G-HAL, Sat,28 Nov,2009, Wed,21 Jul,2010 */
  /* ʸĹˤĴ */
  r = mw->len;
  if (r > 6) {
    r = 6;
  }
  if (r < 2) {
    r = 2;
  }
  if (mw->seg_class == SEG_RENTAI_SHUSHOKU &&
      r < 3) {
    /* ؼ */
    r = 3;
  }
  bias = get_poisson(anthy_normal_length, r);
 #else
  if (anthy_settings.anthy_mode.lattice.viterbi.with_poisson) {
    /* ʸĹˤĴ */
    r = mw->len;
    if (r > 6) {
      r = 6;
    }
    if (r < 2) {
      r = 2;
    }
    if (mw->seg_class == SEG_RENTAI_SHUSHOKU &&
	r < 3) {
      /* ؼ */
      r = 3;
    }
    bias = get_poisson(anthy_normal_length, r);
  } else {
    bias = anthy_settings.anthy_mode.lattice.viterbi.bias_substitutes_poisson;
  }
 #endif

 #if 1
  /* ƬդƤϸ, Patched by G-HAL, Sat,28 Feb,2009 */
  if (anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.sw
      && (mw->wl)
  ) {
    if (0 < mw->wl->part[PART_PREFIX].len) {
      if (0 < mw->wl->part[PART_POSTFIX].len) {
	bias *= anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_pre_and_post;
      } else {
	bias *= anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_pre;
      }
    } else if (0 < mw->wl->part[PART_POSTFIX].len) {
      bias *= anthy_settings.anthy_mode.lattice.viterbi.decrease_probability_phrase_with_pre_post.with_post;
    }
  }
 #endif

  return bias;
}

#if 0	/* Patched by G-HAL */
static void
build_feature_list(struct lattice_node *node,
		   struct feature_list *features)
{
  int pc, cc;
  if (node) {
    cc = node->seg_class;
  } else {
    cc = SEG_TAIL;
  }
  anthy_feature_list_set_cur_class(features, cc);
  if (node && node->before_node) {
    pc = node->before_node->seg_class;
  } else {
    pc = SEG_HEAD;
  }
  anthy_feature_list_set_class_trans(features, pc, cc);

  if (node && node->mw) {
    struct meta_word *mw = node->mw;
    anthy_feature_list_set_dep_class(features, mw->dep_class);
    anthy_feature_list_set_dep_word(features,
				    mw->dep_word_hash);
    anthy_feature_list_set_mw_features(features, mw->mw_features);
    anthy_feature_list_set_noun_cos(features, mw->core_wt);

  }
  anthy_feature_list_sort(features);
}
#else
/** ʸڤ֤ˤ륳ѥѥ
 *@param[in,out]	fl			ѥѥ
 *@param[in]		prev_commit		before_node ̵ʸڤ֤ʸ
 *@param[in]		before_node		ʸڤ֤ʸ
 *@param[in]		after_node		ʸڤ֤θʸ
 *
 *@comment
 *	before_node  prev_commit  NULL ξ硢
 *	ʸ SEG_HEAD Ǥ򼨤
 *	after_node  NULL ξ硢
 *	ʸ SEG_TAIL Ǥ򼨤
 *
 *
 *	Patched by G-HAL
 *		Sat,25 Apr,2009
 *		Tue,20 Jul,2010
 *		Fri,13 Aug,2010, Sun,15 Aug,2010
 */
static void build_feature_list( struct feature_list* const fl,
			       const struct seg_dep_info_t* const prev_commit,
			       const struct lattice_node* const before_node,
			       const struct lattice_node* const after_node )
{
  enum seg_class	prev_cl = SEG_HEAD;
  enum seg_class	cur_cl  = SEG_TAIL;
 #if defined(CORPUS_ANALYSIS_MODE_IID)
  if (before_node) {
    prev_cl = before_node->seg_class;
  } else if (prev_commit) {
    prev_cl = prev_commit->seg_class;
  }

  if (after_node && after_node->mw) {
    const struct meta_word* const mw = after_node->mw;
    cur_cl = after_node->seg_class;
    anthy_feature_list_set_dep_class(   fl, mw->dep_class );
    anthy_feature_list_set_dep_word(    fl, mw->dep_word_hash );
    anthy_feature_list_set_mw_features( fl, mw->mw_features );
    anthy_feature_list_set_noun_cos(    fl, mw->core_wt );
  }
 #elif defined(CORPUS_ANALYSIS_MODE_IDI)
  if (before_node && before_node->mw) {
    prev_cl = before_node->seg_class;
    anthy_feature_list_set_dep_class(   fl, before_node->mw->dep_class );
    anthy_feature_list_set_dep_word(    fl, before_node->mw->dep_word_hash );
  } else if (prev_commit) {
    prev_cl = prev_commit->seg_class;
    if (SEG_HEAD != prev_cl) {
      anthy_feature_list_set_dep_class(   fl, prev_commit->dep_class );
      anthy_feature_list_set_dep_word(    fl, prev_commit->dep_word_hash );
    }
  }

  if (after_node && after_node->mw) {
    cur_cl = after_node->seg_class;
    anthy_feature_list_set_mw_features( fl, after_node->mw->mw_features );
    anthy_feature_list_set_noun_cos(    fl, after_node->mw->core_wt );
  }
 #elif defined(CORPUS_ANALYSIS_MODE_HID_IDI_IwDT)
  if (before_node && before_node->mw) {
    /* ID+I , IwD+T ⡼ɤ ID ʬ */
    prev_cl = before_node->seg_class;
    anthy_feature_list_set_dep_class( fl, before_node->mw->dep_class );
    anthy_feature_list_set_dep_word(  fl, before_node->mw->dep_word_hash );
  } else if (prev_commit) {
    prev_cl = prev_commit->seg_class;
    if (SEG_HEAD != prev_cl) {
      /* ID+I ⡼ɤ ID ʬ */
      anthy_feature_list_set_dep_class( fl, prev_commit->dep_class );
      anthy_feature_list_set_dep_word(  fl, prev_commit->dep_word_hash );
    } else if (after_node && after_node->mw) {
      /* H+ID ⡼ɤ ID ʬ */
      anthy_feature_list_set_dep_class( fl, after_node->mw->dep_class );
      anthy_feature_list_set_dep_word(  fl, after_node->mw->dep_word_hash );
    } else {
      assert( 0 );
    }
  } else if (after_node && after_node->mw) {
    /* H+ID ⡼ɤ ID ʬ */
    anthy_feature_list_set_dep_class( fl, after_node->mw->dep_class );
    anthy_feature_list_set_dep_word(  fl, after_node->mw->dep_word_hash );
  } else {
    assert( 0 );
  }

  if (after_node && after_node->mw) {
    /* ID+I , H+ID ⡼ɤ I ʬ */
    cur_cl = after_node->seg_class;
    anthy_feature_list_set_mw_features( fl, after_node->mw->mw_features );
    anthy_feature_list_set_noun_cos(    fl, after_node->mw->core_wt );
  } else if (before_node && before_node->mw) {
    /* IwD+T ⡼ɤ w ʬ */
    anthy_feature_list_set_mw_features( fl, before_node->mw->mw_features );
    anthy_feature_list_set_noun_cos(    fl, before_node->mw->core_wt );
  } else {
    assert( 0 );
  }
 #else
 # error
 #endif

  anthy_feature_list_set_class_trans( fl, prev_cl, cur_cl );
  anthy_feature_list_set_cur_class(   fl, cur_cl );

  anthy_feature_list_sort( fl );
  return;
}
#endif

#if 0	/* Patched by G-HAL */
static double
calc_probability(int cc, struct feature_list *fl)
{
  struct feature_freq *res, arg;
  double prob;

  /* Ψ׻ */
  res = anthy_find_feature_freq(trans_info_array,
				fl, &arg);
  prob = 0;
  if (res) {
    double pos = res->f[15];
    double neg = res->f[14];
    prob = 1 - (neg) / (double) (pos + neg);
  }
  if (prob <= 0) {
    /* ʸ¸ߤʤѥʤΤ0˶ᤤ */
    prob = 1.0f / (double)(10000 * 100);
  }

  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_LN) {
    anthy_feature_list_print(fl);
    printf(" cc=%d(%s), P=%f\n", cc, anthy_seg_class_name(cc), prob);
  }
  return prob;
}
#else
/** ѥγΨͤ
 *@param		cc			ʸʻ쥯饹ʥǥХåɽѡ
 *@param[in]		fl			ѥθ
 *@return					줿Ψ
 *
 *	Patched by G-HAL
 *		Mon,21 Jul,2010
 *		Fri,03 Sep,2010
 */
static double calc_probability( int cc, struct feature_list *fl )
{
  double prob = 0.0;
  struct feature_freq arg;

  /* Ψ׻ */
  const struct feature_freq* const res = anthy_find_feature_freq( trans_info_array, fl, &arg );
  if (res) {
    const double pos = res->f[15];
    const double neg = res->f[14];
    double prob1 = pos / (pos + neg);
    double prob2 = (pos + anthy_settings.anthy_mode.lattice.corpus_adj_by_count_numerator) / (pos + neg + anthy_settings.anthy_mode.lattice.corpus_adj_by_count_denominator);
    prob = (prob1 < prob2) ? prob1 : prob2;
  }
  if (prob <= 0.0) {
    /* ʸ¸ߤʤѥʤΤ0˶ᤤ */
    prob = 1.0 / (10000.0 * 100.0);
  }

  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_LN) {
    anthy_feature_list_print(fl);
    printf(" cc=%d(%s), P=%f\n", cc, anthy_seg_class_name((enum seg_class)cc), prob);
  }
  return prob;
}
#endif

#if 0	/* Patched by G-HAL, Sat,25 Apr,2009, Tue,20 Jul,2010 */
static double
get_transition_probability(struct lattice_node *node)
#else
static double get_transition_probability( struct lattice_node* const node, const struct seg_dep_info_t* const prev_commit )
#endif
{
  struct feature_list features;
  double probability;

  /**/
  anthy_feature_list_init(&features);
 #if 0	/* Patched by G-HAL, Sat,25 Apr,2009, Tue,20 Jul,2010, Fri,13 Aug,2010 */
  build_feature_list(node, &features);
 #else
  build_feature_list( &features, prev_commit, node->before_node, node );
 #endif
  probability = calc_probability(node->seg_class, &features);
  anthy_feature_list_free(&features);

  /* ʸηФɾ */
  probability *= get_form_bias(node->mw);
  return probability;
}

static struct lattice_info*
alloc_lattice_info(struct splitter_context *sc, int size)
{
  int i;
  struct lattice_info* info = (struct lattice_info*)malloc(sizeof(struct lattice_info));
  info->sc = sc;
  info->lattice_node_list = (struct node_list_head*)
    malloc((size + 1) * sizeof(struct node_list_head));
  for (i = 0; i < size + 1; i++) {
    info->lattice_node_list[i].head = NULL;
    info->lattice_node_list[i].nr_nodes = 0;
  }
  info->node_allocator = anthy_create_allocator(sizeof(struct lattice_node),
						NULL);
  return info;
}

#if 0	/* Patched by G-HAL, Wed,04 Feb,2009 */
static void
calc_node_parameters(struct lattice_node *node)
{
  /* бmetaword̵ʸƬȽǤ */
  node->seg_class = node->mw ? node->mw->seg_class : SEG_HEAD;

  if (node->before_node) {
    /* ܤΡɤ */
    node->real_probability = node->before_node->real_probability *
      get_transition_probability(node);
    node->adjusted_probability = node->real_probability *
      (node->mw ? node->mw->score : 1000);
  } else {
    /* ܤΡɤ̵ */
    node->real_probability = 1.0;
    node->adjusted_probability = node->real_probability;
  }
}
#else
/** Ψͤ򺮹礹
 *@param[in]		base_prob		ܳΨ
 *@param[in]		bias_prob		Ψ
 *@return					γΨ
 *
 *	Patched by G-HAL
 *		Tue,17 Aug,2010
 */
inline static double combine_prob( double base_prob, double bias_prob )
{
  double	ret_prob;
  if (0.0 == bias_prob) {
    ret_prob = base_prob;
  } else {
    if (bias_prob < 0.0) {
      ret_prob = 0.0;
    } else if (bias_prob < 1.0) {
      ret_prob = base_prob * (1.0 - bias_prob) + bias_prob;
    } else {
      ret_prob = 1.0;
    }
  }
  return ret_prob;
}
/** ΡɤؤܳΨ׻
 *@param[in]		sc			ϥǡ
 *@param[in,out]	node			ɾΡ
 *
 *	Patched by G-HAL
 *		Wed,04 Feb,2009
 *		Sat,28 Feb,2009
 *		Sat,25 Apr,2009
 *		Thu,30 Apr,2009 - Fri,01 May,2009
 *		Sat,14 Nov,2009
 *		Tue,17 Nov,2009
 *		Fri,27 Nov,2009
 *		Tue,20 Jul,2010
 *		Tue,17 Aug,2010
 */
static void calc_node_parameters( const struct splitter_context* const sc, struct lattice_node* const node )
{
  if (node->before_node) {
    const struct meta_word* const mw = node->mw;
    node->seg_class = (mw ? mw->seg_class : SEG_HEAD);
    {
      double		mw_biasprob = 0.0;
      const double	mw_score = (mw ? calc_metaword_score( sc, mw, node->before_node->mw, NULL, &mw_biasprob ) : 1.0);
      const double	corpus_prob = get_transition_probability( node, &(sc->prev_commit) );
      const double	trans_prob = combine_prob( corpus_prob, mw_biasprob );
      node->mw_bias_probability = mw_biasprob;

      if (anthy_settings.anthy_mode.lattice.viterbi.metaword_effects_sentence) {
	const double	adj_prob = combine_prob( (corpus_prob * mw_score / anthy_settings.anthy_mode.lattice.mw_max_score), mw_biasprob );
	node->real_probability     = node->before_node->real_probability     * trans_prob;
	node->adjusted_probability = node->before_node->adjusted_probability * adj_prob;
       #if defined(DEBUG)
	node->current_probability = adj_prob;
       #endif
      } else {
	node->real_probability     = node->before_node->real_probability * trans_prob;
	node->adjusted_probability = node->real_probability * mw_score;
       #if defined(DEBUG)
	node->current_probability = trans_prob;
       #endif
      }
    }
  } else {
    /* Ψĥ꡼κ */
    node->real_probability     = 1.0;
    node->adjusted_probability = 1.0;
    node->mw_bias_probability  = 0.0;
   #if defined(DEBUG)
    node->current_probability    = 1.0;
    node->tailphrase_probability = 1.0;
   #endif
    node->seg_class            = sc->prev_commit.seg_dep_info.seg_class;
  }
  return;
}
#endif

static struct lattice_node*
alloc_lattice_node(struct lattice_info *info,
		   struct lattice_node* before_node,
		   struct meta_word* mw, int border)
{
 #if 0	/* Patched by G-HAL, Wed,04 Feb,2009 */
  struct lattice_node* node;
  node = anthy_smalloc(info->node_allocator);
  node->before_node = before_node;
  node->border = border;
  node->next = NULL;
  node->mw = mw;

  calc_node_parameters(node);
 #else
  struct lattice_node* node = (struct lattice_node*) anthy_smalloc( info->node_allocator );
  node->border               = border;
  node->seg_class            = SEG_HEAD;
  node->real_probability     = 0.0;
  node->adjusted_probability = 0.0;
  node->mw_bias_probability  = 0.0;
 #if defined(DEBUG)
  node->current_probability    = 0.0;
  node->tailphrase_probability = 0.0;
 #endif
  node->before_node          = before_node;
  node->mw                   = mw;
  node->next                 = NULL;

  calc_node_parameters( info->sc, node );
 #endif

  return node;
}

static void
release_lattice_node(struct lattice_info *info, struct lattice_node* node)
{
  anthy_sfree(info->node_allocator, node);
}

static void
release_lattice_info(struct lattice_info* info)
{
  anthy_free_allocator(info->node_allocator);
  free(info->lattice_node_list);
  free(info);
}

#if 0		/* Patched by G-HAL, Tue,04 Nov,2008 */
static int
cmp_node_by_type(struct lattice_node *lhs, struct lattice_node *rhs,
		 enum metaword_type type)
{
  if (lhs->mw->type == type && rhs->mw->type != type) {
    return 1;
  } else if (lhs->mw->type != type && rhs->mw->type == type) {
    return -1;
  } else {
    return 0;
  }
}

static int
cmp_node_by_type_to_type(struct lattice_node *lhs, struct lattice_node *rhs,
			 enum metaword_type type1, enum metaword_type type2)
{
  if (lhs->mw->type == type1 && rhs->mw->type == type2) {
    return 1;
  } else if (lhs->mw->type == type2 && rhs->mw->type == type1) {
    return -1;
  } else {
    return 0;
  }
}

#else

/** metaword ӤʥȽꤹ
 *@param[in]		lhs_score	Υ
 *@param[in]		rhs_score	Υ
 *@retval		+1		lhs⤤
 *@retval		0		Ʊ
 *@retval		-1		rhs⤤
 *
 *@attention
 *	ͤ +1, 0, -1 ΣѥΤߤǸƤĽ꤬Τա
 *
 *	Patched by G-HAL, Tue,04 Nov,2008
 */
inline int cmp_node_by_score( int lhs_score, int rhs_score )
{
  if (lhs_score > rhs_score) {
    return +1;
  } else if (lhs_score < rhs_score) {
    return -1;
  }
  return 0;
}


static const struct priority_of_metaword_t VITERBI_PRIORITY_OF_METAWORD = {
  .splitkind_pri[SPLITKIND_OCHAIRE_MIDDLE      ] = { .pri = 37, .sub = 1, },
  .splitkind_pri[SPLITKIND_OCHAIREwoD_MIDDLE   ] = { .pri = 36, .sub = 1, },
  .splitkind_pri[SPLITKIND_OCHAIREwoI_MIDDLE   ] = { .pri = 35, .sub = 1, },
  .splitkind_pri[SPLITKIND_OCHAIREwoIwoD_MIDDLE] = { .pri = 34, .sub = 1, },
  .CAND_COUNTER_MAXLIMIT                         = { .pri =  5, .sub = 0, },
  .CAND_COUNTER_MAXLIMIT_VALUE                   = { .pri =  5, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIRE_HEAD        ] = { .pri = 17, .sub = 1, },
  .splitkind_pri[SPLITKIND_OCHAIREwoD_HEAD     ] = { .pri = 16, .sub = 1, },
  .splitkind_pri[SPLITKIND_OCHAIRE_TAIL        ] = { .pri = 13, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIRE_SINGLE      ] = { .pri = 13, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoI_TAIL     ] = { .pri = 13, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoD_TAIL     ] = { .pri = 13, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoIwoD_TAIL  ] = { .pri = 13, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoD_SINGLE   ] = { .pri = 13, .sub = 0, },
  .OCHAIRE_WEAKMODE                              = { .pri =  5, .sub = 0, },
  .CAND_STRONGMODE                               = { .pri = 13, .sub = 0, },
  .CAND_COUNTER_MINLIMIT                         = { .pri = INT_MAX, .sub = 0, },
  .CAND_WEAKMODE                                 = { .pri =  5, .sub = 0, },
  .splitkind_pri[SPLITKIND_DEFAULT             ] = { .pri =  5, .sub = 0, },
  .splitkind_pri[SPLITKIND_COMPOUNDHEAD        ] = { .pri =  3, .sub = 0, },
  .splitkind_pri[SPLITKIND_COMPOUNDPART        ] = { .pri =  2, .sub = 0, },
  .splitkind_pri[SPLITKIND_COMPOUND            ] = { .pri =  1, .sub = 0, },
  .splitkind_pri[SPLITKIND_COMPOUNDLEAF        ] = { .pri =  5, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoI_HEAD     ] = { .pri =  0, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoIwoD_HEAD  ] = { .pri =  0, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoI_SINGLE   ] = { .pri =  0, .sub = 0, },
  .splitkind_pri[SPLITKIND_OCHAIREwoIwoD_SINGLE] = { .pri =  0, .sub = 0, },
  .splitkind_pri[SPLITKIND_DELETEDHISTORY      ] = { .pri =  0, .sub = 0, },
};


/** ΡɤӤʥӥѡ
 *@param[in]		lhs		ΥΡ
 *@param[in]		rhs		ΥΡ
 *@retval		+1		lhsΨ⤤
 *@retval		0		Ʊ
 *@retval		-1		rhsΨ⤤
 *
 *@attention
 *	ͤ +1, 0, -1 ΣѥΤߤǸƤĽ꤬Τա
 *
 *	Patched by G-HAL
 *		Tue,04 Nov,2008
 *		Wed,05 Nov,2008
 *		Sun,16 Nov,2008
 *		Fri,01 May,2009
 */
static int cmp_node_priority_for_viterbi( struct lattice_node* const lhs, struct lattice_node* const rhs )
{
  int		have_sub_priority = 0;
  int		rhs_minlen = 0;
  int		lhs_minlen = 0;
  const int	rhs_priority_tmp = calc_cmpnode_priority( &VITERBI_PRIORITY_OF_METAWORD, rhs->mw, 0, 0, &have_sub_priority, &rhs_minlen );
  const int	lhs_priority = calc_cmpnode_priority( &VITERBI_PRIORITY_OF_METAWORD, lhs->mw, rhs_priority_tmp, rhs_minlen, &have_sub_priority, &lhs_minlen );
  const int	rhs_priority = calc_cmpnode_priority( &VITERBI_PRIORITY_OF_METAWORD, rhs->mw, lhs_priority    , lhs_minlen, &have_sub_priority, &rhs_minlen );
  if (lhs_priority > rhs_priority) {
    return +1;
  } else if (lhs_priority < rhs_priority) {
    return -1;
  }
  if (have_sub_priority) {
    return cmp_node_by_score( lhs->mw->score, rhs->mw->score );
  }

  return 0;
}
#endif

/*
 * ΡɤӤ
 *
 ** ֤
 * 1: lhsΨ⤤
 * 0: Ʊ
 * -1: rhsΨ⤤
 */
static int
cmp_node(struct lattice_node *lhs, struct lattice_node *rhs)
{
  struct lattice_node *lhs_before = lhs;
  struct lattice_node *rhs_before = rhs;
  int ret;

  if (lhs && !rhs) return 1;
  if (!lhs && rhs) return -1;
  if (!lhs && !rhs) return 0;

  while (lhs_before && rhs_before) {
    if (lhs_before->mw && rhs_before->mw &&
	lhs_before->mw->from + lhs_before->mw->len == rhs_before->mw->from + rhs_before->mw->len) {
     #if 0
      /* ؽ줿Ρɤɤ򸫤 */
      ret = cmp_node_by_type(lhs_before, rhs_before, MW_OCHAIRE);
      if (ret != 0) return ret;

      /* COMPOUND_PARTCOMPOUND_HEADͥ */
      ret = cmp_node_by_type_to_type(lhs_before, rhs_before, MW_COMPOUND_HEAD, MW_COMPOUND_PART);
      if (ret != 0) return ret;
     #else
      /* Ρɾ Patched by G-HAL, Tue,04 Nov,2008, Sun,16 Nov,2008 */
      ret = cmp_node_priority_for_viterbi( lhs_before, rhs_before );
      if (ret != 0) return ret;
     #endif
    } else {
      break;
    }
    lhs_before = lhs_before->before_node;
    rhs_before = rhs_before->before_node;
  }

  /* ǸܳΨ򸫤 */
  if (lhs->adjusted_probability > rhs->adjusted_probability) {
    return 1;
  } else if (lhs->adjusted_probability < rhs->adjusted_probability) {
    return -1;
  } else {
    return 0;
  }
}

/*
 * Υƥ˥Ρɤɲä
 */
static void
push_node(struct lattice_info* info, struct lattice_node* new_node,
	  int position)
{
  struct lattice_node* node;
  struct lattice_node* previous_node = NULL;

  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_LN) {
    print_lattice_node(info, new_node);
  }

  /* Ƭnode̵̵ɲ */
  node = info->lattice_node_list[position].head;
  if (!node) {
    info->lattice_node_list[position].head = new_node;
    info->lattice_node_list[position].nr_nodes ++;
    return;
  }

  while (node->next) {
    /* ;פʥΡɤɲäʤλ޴ */
   #if 0	/* Patched by G-HAL, Wed,04 Jul,2010, Mon,27 Sep,2010 */
    if (new_node->seg_class == node->seg_class &&
	new_node->border == node->border) {
      /* segclassƱǡϤޤ֤Ʊʤ */
      switch (cmp_node(new_node, node)) {
      case 0:
      case 1:
	/* Ψ礭ؽˤΤʤ顢ŤΤ֤*/
	if (previous_node) {
	  previous_node->next = new_node;
	} else {
	  info->lattice_node_list[position].head = new_node;
	}
	new_node->next = node->next;
	release_lattice_node(info, node);
	break;
      case -1:
	/* Ǥʤʤ */
	release_lattice_node(info, new_node);
	break;
      }
      return;
    }
   #else
    if ((new_node->mw && node->mw)
	&& (new_node->seg_class == node->seg_class)
	&& ((new_node->mw->from + new_node->mw->len) == (node->mw->from + node->mw->len))
	&& (new_node->mw->dep_class == node->mw->dep_class)
	&& (new_node->mw->dep_word_hash == node->mw->dep_word_hash)
	&& (new_node->mw->cand_hint_length_of_dep == node->mw->cand_hint_length_of_dep)
	&& (new_node->mw->mw_features == node->mw->mw_features)
	&& (0 == anthy_feature_list_cmp_wtype(new_node->mw->core_wt, node->mw->core_wt))
/*	&& (new_node->mw->type == node->mw->type) */
/*	&& (MW_WRAP != new_node->mw->type) && (MW_WRAP != node->mw->type) */
    ) {
      /* °ƱǱüΰ֤Ʊʤ */
      if (new_node->adjusted_probability >= node->adjusted_probability) {
	/* Ψ礭ʤ顢ŤΤ֤*/
	if (previous_node) {
	  previous_node->next = new_node;
	} else {
	  info->lattice_node_list[position].head = new_node;
	}
	new_node->next = node->next;
	release_lattice_node( info, node );
      } else {
	/* Ǥʤʤ */
	release_lattice_node( info, new_node );
      }
      return;
    }
   #endif
    previous_node = node;
    node = node->next;
  }

  /* ǸΥΡɤθɲ */
  node->next = new_node;
  info->lattice_node_list[position].nr_nodes ++;
}

/* ֳΨ㤤Ρɤõ*/
static void
remove_min_node(struct lattice_info *info, struct node_list_head *node_list)
{
  struct lattice_node* node = node_list->head;
  struct lattice_node* previous_node = NULL;
  struct lattice_node* min_node = node;
  struct lattice_node* previous_min_node = NULL;

  /* ֳΨ㤤Ρɤõ */
  while (node) {
    if (cmp_node(node, min_node) < 0) {
      previous_min_node = previous_node;
      min_node = node;
    }
    previous_node = node;
    node = node->next;
  }

  /* ֳΨ㤤Ρɤ */
  if (previous_min_node) {
    previous_min_node->next = min_node->next;
  } else {
    node_list->head = min_node->next;
  }
  release_lattice_node(info, min_node);
  node_list->nr_nodes --;
}

/* ӥӥ르ꥺѤƷϩ */
static void
choose_path(struct lattice_info* info, int to)
{
  /* ǸޤãܤΤʤǰֳΨ礭Τ */
  struct lattice_node* node;
  struct lattice_node* best_node = NULL;
  int last = to;
  while (!info->lattice_node_list[last].head) {
    /* ǸʸޤܤƤʤä */
    --last;
  }
  for (node = info->lattice_node_list[last].head; node; node = node->next) {
    if (cmp_node(node, best_node) > 0) {
      best_node = node;
    }
  }
  if (!best_node) {
    return;
  }

  /* ܤդˤɤĤʸڤܤϿ */
  node = best_node;
  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_LN) {
    printf("choose_path()\n");
  }
  while (node->before_node) {
    info->sc->word_split_info->best_seg_class[node->border] =
      node->seg_class;
    anthy_mark_border_by_metaword(info->sc, node->mw);
    /**/
    if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_LN) {
      print_lattice_node(info, node);
    }
    /**/
    node = node->before_node;
  }
}

#if 0	/* Patched by G-HAL, Sat,25 Apr,2009, Tue,20 Jul,2010 */
static void
build_graph(struct lattice_info* info, int from, int to)
#else
static void build_graph( struct lattice_info* info, int from, int to )
#endif
{
  int i;
  struct lattice_node* node;
  struct lattice_node* left_node;

  /* ȤʤΡɤɲ */
  node = alloc_lattice_node(info, NULL, NULL, from);
  push_node(info, node, from);

  /* info->lattice_node_list[index]ˤindexޤǤܤäƤΤǤäơ
   * indexܤäƤΤǤϤʤ
   */

  /* Ƥܤ򺸤 */
  for (i = from; i < to; ++i) {
    for (left_node = info->lattice_node_list[i].head; left_node;
	 left_node = left_node->next) {
      struct meta_word *mw;
      /* iʸܤãlattice_nodeΥ롼 */

      for (mw = info->sc->word_split_info->cnode[i].mw; mw; mw = mw->next) {
	int position;
	struct lattice_node* new_node;
	/* iʸܤmeta_wordΥ롼 */

       #if 0		/* Patched by G-HAL, Sun,17 May,2009 */
	if (mw->can_use != ok) {
       #else
	if (mw->can_use < ok) {
       #endif
	  continue; /* 줿ʸζڤޤmetawordϻȤʤ */
	}
	position = i + mw->len;
	new_node = alloc_lattice_node(info, left_node, mw, i);
	push_node(info, new_node, position);

	/* θ䤬¿顢Ψ㤤 */
	if (info->lattice_node_list[position].nr_nodes >= NODE_MAX_SIZE) {
	  remove_min_node(info, &info->lattice_node_list[position]);
	}
      }
    }
  }

  /* ʸ */
  for (node = info->lattice_node_list[to].head; node; node = node->next) {
    struct feature_list features;
    anthy_feature_list_init(&features);
   #if 0	/* Patched by G-HAL, Sat,25 Apr,2009, Tue,20 Jul,2010, Fri,13 Aug,2010, Tue,17 Aug,2010 */
    build_feature_list(NULL, &features);
    node->adjusted_probability = node->adjusted_probability *
      calc_probability(SEG_TAIL, &features);
   #else
    if( node->mw ) {
      build_feature_list( &features, NULL, node, NULL );
    }
    const double probability = calc_probability( SEG_TAIL, &features );
    const double trans_prob  = combine_prob( probability, node->mw_bias_probability );
    node->adjusted_probability = node->adjusted_probability * trans_prob;
   # if defined(DEBUG)
    node->tailphrase_probability = trans_prob;
   # endif
   #endif
    anthy_feature_list_free(&features);
  }
}



void
anthy_mark_borders(struct splitter_context *sc, int from, int to)
{
 #if 0	/* Patched by G-HAL, Sun,16 Nov,2008, Wed,04 Feb,2009, Mon,09 Feb,2009, Fri,20 Feb,2009, Sat,18 Apr,2009, Fri,01 May,2009, Tue,20 Jul,2010 */
  struct lattice_info* info = alloc_lattice_info(sc, to);
  trans_info_array = anthy_file_dic_get_section("trans_info");
  build_graph(info, from, to);
  choose_path(info, to);
  release_lattice_info(info);
 #else
  switch (anthy_settings.anthy_mode.lattice.mode) {
  case ANTHY_LATTICE_MODE_VITERBI:
    {
      struct lattice_info* info = alloc_lattice_info(sc, to);
      trans_info_array = anthy_file_dic_get_section("trans_info");
      build_graph( info, from, to );
      choose_path(info, to);
      release_lattice_info(info);
    }
    break;
  case ANTHY_LATTICE_MODE_MAXLEN_BY_N_PHRASES:
    choose_path_by_maxlen_n_phrases( sc, from, to );
    break;
  case ANTHY_LATTICE_MODE_MANUAL:
    choose_path_by_manual( sc, from, to );
    break;
  }
  return;
 #endif
}
/* vim:ts=8 sw=2 nomodified:
 */
