/*
 * (ߥå)ν򤹤롣
 * ƼγؽƤӽФ
 *
 * anthy_proc_commit() ƤФ
 */
#if 0		/* Patched by G-HAL */
#include <stdlib.h>
#include <time.h>

#include <anthy/ordering.h>
#include <anthy/record.h>
#include <anthy/splitter.h>
#include <anthy/segment.h>
#include "sorter.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_ALLOCA_H)
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/anthy.h"		/* Patched by G-HAL, Wed,11 Feb,2009 */
#include "anthy/settings.h"		/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "anthy/ordering.h"
#include "anthy/record.h"
#include "anthy/splitter.h"
#include "anthy/segment.h"
#include "sorter.h"
#include "src-worddic/exception_word_list.h"	/* Patched by G-HAL, Thu,21 Aug,2008 */
#include "src-worddic/dic_learn.h"	/* Patched by G-HAL, Fri,31 Oct,2008 */
#include "src-splitter/wordborder.h"	/* Patched by G-HAL, Sat,24 Jan,2009 */
#include "anthy/xstr.h"				/* Patched by G-HAL, Thu,12 Nov,2009 */
#include "src-splitter/cand_wt_name.h"		/* Patched by G-HAL, Thu,12 Nov,2009 */
#include "src-splitter/depgraph_type_sym.h"	/* Patched by G-HAL, Thu,12 Nov,2009 */
#include "src-ordering/ucdict.h"		/* Patched by G-HAL, Thu,12 Nov,2009 */
#endif

/* #define MAX_OCHAIRE_ENTRY_COUNT 103424*/	/* Patched by G-HAL, Thu,13 Sep,2007. original: 100, ؽ OCHAIRE γؽξ */
/* #define MAX_OCHAIRE_LEN 32*/		/* Comment by G-HAL, Thu,13 Sep,2007. ؽ OCHAIRE κʸκĹ */
/* #define MAX_PREDICTION_ENTRY 49152*/	/* Patched by G-HAL, Thu,13 Sep,2007. original: 100, PREDICTION γؽξ */

/* #define MAX_UNKNOWN_WORD 2048*/	/* Patched by G-HAL, Thu,13 Sep,2007. original: 100, ̤θ UNKNOWN_WORD γؽξ */

/* 򴹤줿õ */
static void
learn_swapped_candidates(struct segment_list *sl)
{
 #if 0	/* Patched by G-HAL, Tue,02 Dec,2008, Tue,13 Jan,2009 */
  int i;
  struct seg_ent *seg;
  for (i = 0; i < sl->nr_segments; i++) {
    seg = anthy_get_nth_segment(sl, i);
    if (seg->committed != 0) {
      /* ǽθ(0)Ǥʤ(seg->committed)ߥåȤ줿 */
      anthy_swap_cand_ent(seg->cands[0],
			  seg->cands[seg->committed]);
    }
  }
  anthy_cand_swap_ageup();
 #else
  if (anthy_settings.anthy_mode.learn.enable_indeppair) {
    int i;
    for (i = 0; i < sl->nr_segments; ++i) {
      struct seg_ent* const seg = anthy_get_nth_segment(sl, i);
      if (0 <= seg->committed) {
	anthy_swap_cand_ent( seg->cands[0], seg->cands[seg->committed] );
      }
    }
    anthy_cand_swap_ageup();
  }
 #endif
}

/* ĹѤäʸѹФ */
static void
learn_resized_segment(struct splitter_context *sc,
		      struct segment_list *sl)
{
  if (anthy_settings.anthy_mode.learn.enable_expandpair) {	/* Patched by G-HAL, Fri,12 Jun,2009 */
  int i;
  struct meta_word **mw
    = (struct meta_word **) alloca(sizeof(struct meta_word*) * sl->nr_segments);
  int *len_array
    = (int *) alloca(sizeof(int) * sl->nr_segments);
  uint16_t* const extra_flag = (uint16_t* const) alloca(sizeof(uint16_t) * sl->nr_segments);	/* Patched by G-HAL, Thu,27 Nov,2008 */

  /* ʸĹmeta_wordѰդ */
  for (i = 0; i < sl->nr_segments; i++) {
    struct seg_ent *se = anthy_get_nth_segment(sl, i);
    mw[i] = se->cands[se->committed]->mw;
    len_array[i] = se->str.len;
    extra_flag[i] = se->cands[se->committed]->flag;	/* Patched by G-HAL, Thu,27 Nov,2008 */
  }

  anthy_commit_border( sc, sl->nr_segments, mw, len_array, extra_flag );	/* Patched by G-HAL, Thu,27 Nov,2008 */
  }	/* Patched by G-HAL, Fri,12 Jun,2009 */
}

/* ĹѤäʸѹФ */
static void
clear_resized_segment(struct splitter_context *sc,
		      struct segment_list *sl)
{
  int *mark, i, from;
  struct seg_ent *seg;
  mark = (int*) alloca(sizeof(int)*sc->char_count);
  for (i = 0; i < sc->char_count; i++) {
    mark[i] = 0;
  }
  /* ºݤ˳ꤵ줿ʸĹޡ */
  from = 0;
  for (i = 0; i < sl->nr_segments; i++) {
    seg = anthy_get_nth_segment(sl, i);
    mark[from] = seg->len;
    from = from + seg->len;
  }
  for (i = 0; i < sc->char_count; i++) {
    int len = sc->ce[i].initial_seg_len;
    /* ǽĹȳꤵ줿ĹۤʤС
       Ȥʤä̤θβǽ */
    if (len && len != mark[i]) {
      xstr xs;
      xs.str = sc->ce[i].c;
      xs.len = len;
      anthy_forget_unused_unknown_word(&xs);
    }
  }
 #if 0	/* Patched by G-HAL, Sat,23 Aug,2008 */
  if (!anthy_select_section("UNKNOWN_WORD", 0)) {
    anthy_truncate_section(MAX_UNKNOWN_WORD);
  }
 #endif
}

#if 0	/* Patched by G-HAL, Tue,30 Dec,2008 */
/* recordˤؽη̤񤭹 */
static void
commit_ochaire(struct seg_ent *seg, int count, xstr* xs)
{
  int i;
  if (xs->len >= MAX_OCHAIRE_LEN) {
    return ;
  }
  if (anthy_select_row(xs, 1)) {
    return ;
  }
  anthy_set_nth_value(0, count);
  for (i = 0; i < count; i++, seg = seg->next) {
    anthy_set_nth_value(i * 2 + 1, seg->len);
    anthy_set_nth_xstr(i * 2 + 2, &seg->cands[seg->committed]->str);
  }
}

/* recordΰ󤹤뤿ˡؽΥͥƥ֤
   ȥä */
static void
release_negative_ochaire(struct splitter_context *sc,
			 struct segment_list *sl)
{
  int start, len;
  xstr xs;
  (void)sl;
  /* ѴΤҤ餬ʸ */
  xs.len = sc->char_count;
  xs.str = sc->ce[0].c;

  /* xsʬʸФ */
  for (start = 0; start < xs.len; start ++) {
    for (len = 1; len <= xs.len - start && len < MAX_OCHAIRE_LEN; len ++) {
      xstr part;
      part.str = &xs.str[start];
      part.len = len;
      if (anthy_select_row(&part, 0) == 0) {
	anthy_release_row();
      }
    }
  }
}

/* ؽԤ */
static void
learn_ochaire(struct splitter_context *sc,
	      struct segment_list *sl)
{
  int i;
  int count;

  if (anthy_select_section("OCHAIRE", 1)) {
    return ;
  }

  /* ؽΥͥƥ֤ʥȥä */
  release_negative_ochaire(sc, sl);

  /* ؽ򤹤 */
  for (count = 2; count <= sl->nr_segments && count < 5; count++) {
    /* 2ʸʾĹʸФ */

    for (i = 0; i <= sl->nr_segments - count; i++) {
      struct seg_ent *head = anthy_get_nth_segment(sl, i);
      struct seg_ent *s;
      xstr xs;
      int j;
      xs = head->str;
      if (xs.len < 2 && count < 3) {
	/* ڤʸؽ뤳Ȥ򤱤롢
	 * øheuristics */
	continue;
      }
      /* ʸʸ */
      for (j = 1, s = head->next; j < count; j++, s = s->next) {
	xs.len += s->str.len;
      }
      /**/
      commit_ochaire(head, count, &xs);
    }
  }
  if (anthy_select_section("OCHAIRE", 1)) {
    return ;
  }
  anthy_truncate_section(MAX_OCHAIRE_ENTRY_COUNT);
}
#else
/** recordˤؽη̤񤭹
 *@param[in]	head			ؽƬʸ
 *@param	count			ʸ
 *@param[in]	xs			ɤߤʸ
 *@param	without_indep		ؽƤϼΩ̵(1)ͭ(0)
 *@param	head_depword_len	°Ĺtrue == without_indep ΤߡΩǤϤʤ
 *@param	indep_count		ΩʬΥȤԤ(1)Ԥʤ(0)
 *@param	without_dep		ؽƤ°̵(1)ͭ(0)
 *@param	tail_depword_len	°Ĺtrue == without_dep Τߡ
 *@param	dep_count		°ʬΥȤԤ(1)Ԥʤ(0)
 *
 * Patched by G-HAL
 *	Sat,23 Aug,2008
 *	Sat,29 Nov,2008
 *	Sat,17 Jan,2009
 *	Sat,24 Jan,2009
 *	Sun,08 Feb,2009
 *	Sat,25 Apr,2009
 *	Sat,09 May,2009
 */
static void commit_ochaire( const struct seg_ent* const head, int count, const xstr* const xs, int without_indep, int head_depword_len, int indep_count, int without_dep, int tail_depword_len, int dep_count )
{
  {
    if (head_depword_len < 1) {
      without_indep = 0;
    }
    if (tail_depword_len < 0) {
      without_dep = 0;
    }
  }
  { /* ߤ */
    xstr key = *xs;
    if (without_indep) {
      const int head_indepword_yomi_len = (head->len - head_depword_len);
      key.str += head_indepword_yomi_len;
      key.len -= head_indepword_yomi_len;
    }
    if (without_dep) {
      key.len -= tail_depword_len;
    }
    if (anthy_select_row_with_learn(&key,1,0)) {
      return;
    }
  }
  {
    const struct seg_ent* seg = head;
    const int old_nr    = anthy_get_nr_values();
    int old_freq_continuous   = 0;
    int old_freq_withindep    = 0;
    int old_freq_withoutindep = 0;
    int old_freq_withoutdep   = 0;
    int old_freq_withdep      = 0;
    int i;

    /* ׾μ */
    if (3 <= old_nr) {
      const int old_count = anthy_get_nth_value(0);
      i = 1 + old_count * 2;
      if ((i + 5) == old_nr) {
	old_freq_continuous   = anthy_get_nth_value( i + 0 );
	old_freq_withindep    = anthy_get_nth_value( i + 1 );
	old_freq_withoutindep = anthy_get_nth_value( i + 2 );
	old_freq_withoutdep   = anthy_get_nth_value( i + 3 );
	old_freq_withdep      = anthy_get_nth_value( i + 4 );
	if (old_freq_continuous < 0) {
	  old_freq_continuous = 0;
	}
	if (old_freq_withindep < 0) {
	  old_freq_withindep = 0;
	}
	if (old_freq_withoutindep < 0) {
	  old_freq_withoutindep = 0;
	}
	if (old_freq_withoutdep < 0) {
	  old_freq_withoutdep = 0;
	}
	if (old_freq_withdep < 0) {
	  old_freq_withdep = 0;
	}
      }
    }

    /* ؽϿ */
    anthy_set_nth_value( 0, count );
    seg = head;
    i = 0;
    if (without_indep) {
      xstr xs1 = seg->cands[seg->committed]->str;
      const int head_indepword_len = (xs1.len - head_depword_len);
      xs1.str += head_indepword_len;
      xs1.len -= head_indepword_len;
      anthy_set_nth_value( i * 2 + 1, head_depword_len );
      anthy_set_nth_xstr( i * 2 + 2, &xs1 );
      ++i;
      seg = seg->next;
      if (indep_count) {
	++ old_freq_withoutindep;
      }
    } else {
      if (indep_count) {
	++ old_freq_withindep;
      }
    }
    for (; i < (count - 1); ++i, seg = seg->next) {
      anthy_set_nth_value( i * 2 + 1, seg->len );
      anthy_set_nth_xstr( i * 2 + 2, &seg->cands[seg->committed]->str );
    }
    {
      int yomi_len = seg->len;
      xstr tail;
      tail.str = seg->cands[seg->committed]->str.str;
      tail.len = seg->cands[seg->committed]->str.len;
      if (without_dep) {
	yomi_len -= tail_depword_len;
	tail.len -= tail_depword_len;
	if (dep_count) {
	  ++ old_freq_withoutdep;
	}
      } else {
	if (dep_count) {
	  ++ old_freq_withdep;
	}
      }
      anthy_set_nth_value( i * 2 + 1, yomi_len );
      anthy_set_nth_xstr( i * 2 + 2, &tail );
    }

    /* ׾ι */
    i = 1 + count * 2;
    anthy_set_nth_value( i + 0, old_freq_continuous );
    anthy_set_nth_value( i + 1, old_freq_withindep );
    anthy_set_nth_value( i + 2, old_freq_withoutindep );
    anthy_set_nth_value( i + 3, old_freq_withoutdep );
    anthy_set_nth_value( i + 4, old_freq_withdep );

    anthy_truncate_row( i + 5 );
    anthy_mark_row_used();
  }
  return;
}

/** ƤϢ뤷ơrecordˤؽη̤񤭹
 *@param[in]	yomi			ɤߤʸʸ
 *@param[in]	yomi1			ɤߤʸʸΤߡ
 *@param[in]	yomi2			ɤߤʸʸʸΤߡ
 *@param[in]	cand1			Ѵ̡ʸ
 *@param[in]	cand2			Ѵ̡ʸʸ
 *@param	freq_count		freq_continuous ΥȤ򤹤
 *@param	without_dep		ؽƤ°̵(1)ͭ(0)
 *@param	tail_depword_len	°Ĺtrue == without_dep Τߡ
 *
 *@comment
 *	ʸؽΤߡ
 *
 * Patched by G-HAL
 *	Sat,25 Apr,2009
 */
static void commit_keepalive_ochaire( const xstr* const yomi, const xstr* const yomi1, const xstr* const yomi2, const xstr* const cand1, const xstr* const cand2, int freq_count, int without_dep, int tail_depword_len )
{
  {
    if (tail_depword_len < 0) {
      without_dep = 0;
    }
  }
  { /* ߤ */
    xstr key = *yomi;
    if (without_dep) {
      key.len -= tail_depword_len;
    }
    if (anthy_select_row_with_learn(&key,1,0)) {
      return;
    }
  }
  {
    const int old_nr          = anthy_get_nr_values();
    int old_freq_continuous   = 0;
    int old_freq_withindep    = 0;
    int old_freq_withoutindep = 0;
    int old_freq_withoutdep   = 0;
    int old_freq_withdep      = 0;
    const int count = 2;
    int i;

    /* ׾μ */
    if (3 <= old_nr) {
      const int old_count = anthy_get_nth_value(0);
      i = 1 + old_count * 2;
      if ((i + 5) == old_nr) {
	old_freq_continuous   = anthy_get_nth_value( i + 0 );
	old_freq_withindep    = anthy_get_nth_value( i + 1 );
	old_freq_withoutindep = anthy_get_nth_value( i + 2 );
	old_freq_withoutdep   = anthy_get_nth_value( i + 3 );
	old_freq_withdep      = anthy_get_nth_value( i + 4 );
	if (old_freq_continuous < 0) {
	  old_freq_continuous = 0;
	}
	if (old_freq_withindep < 0) {
	  old_freq_withindep = 0;
	}
	if (old_freq_withoutindep < 0) {
	  old_freq_withoutindep = 0;
	}
	if (old_freq_withoutdep < 0) {
	  old_freq_withoutdep = 0;
	}
	if (old_freq_withdep < 0) {
	  old_freq_withdep = 0;
	}
      }
    }

    /* ؽϿ */
    anthy_set_nth_value( 0, count );
    i = 0;
    anthy_set_nth_value( i * 2 + 1, yomi1->len );
    anthy_set_nth_xstr( i * 2 + 2, cand1 );
    ++i;
    {
      int yomi_len = yomi2->len;
      xstr tail = *cand2;
      if (without_dep) {
	yomi_len -= tail_depword_len;
	tail.len -= tail_depword_len;
	++ old_freq_withoutdep;
      } else {
	++ old_freq_withdep;
      }
      anthy_set_nth_value( i * 2 + 1, yomi_len );
      anthy_set_nth_xstr( i * 2 + 2, &tail );
    }

    /* ׾ι */
    if (freq_count) {
      ++ old_freq_continuous;
    }
    i = 1 + count * 2;
    anthy_set_nth_value( i + 0, old_freq_continuous );
    anthy_set_nth_value( i + 1, old_freq_withindep );
    anthy_set_nth_value( i + 2, old_freq_withoutindep );
    anthy_set_nth_value( i + 3, old_freq_withoutdep );
    anthy_set_nth_value( i + 4, old_freq_withdep );

    anthy_truncate_row( i + 5 );
    anthy_mark_row_used();
  }
  return;
}

/** ʸڤؽΥͥƥ֤ʥȥä
 *@param[in]	sc		ʸ
 *
 * Patched by G-HAL
 *	Tue,30 Dec,2008
 *	Sat,17 Jan,2009
 *	Sat,27 Mar,2010
 */
static void release_negative_entry( const struct splitter_context* const sc )
{
  size_t	i, j;
  xstr		xs;
  const xstr*	key;

  for (i = 0; i < sc->char_count; ++i) {
    for (j = (sc->char_count - i); 1 <= j; --j) {
      /* ؽǡ */
      xs.len = j;
      xs.str = sc->ce[i].c;
      if (1 < j) {
	if (0 != anthy_select_longest_row(&xs)) {
	  j = 2;
	  continue;
	  /* ա anthy_select_longest_row() ϡʸʾΤ߸ */
	}
      } else {
	if (0 != anthy_select_row(&xs,0)) {
	  break;
	}
      }
      if (anthy_get_nth_value(0) < 2) {
	continue;
      }
      key = anthy_get_index_xstr();
      j = key->len;

      /* ȿؽ */
      anthy_pseudorelease_row();
    }
  }
  return;
}

/** ʸڤؽΥͥƥ֤ʥȥä
 *@param[in]	sc		ʸ
 *
 * Patched by G-HAL
 *	Tue,30 Dec,2008
 *	Sat,17 Jan,2009
 *	Sat,27 Mar,2010
 */
static void unlearn_negative_entry( const struct splitter_context* const sc )
{
  size_t	i, j;
  xstr		xs;
  const xstr*	key;

  for (i = 0; i < sc->char_count; ++i) {
    for (j = (sc->char_count - i); 1 <= j; --j) {
      /* ؽǡ */
      xs.len = j;
      xs.str = sc->ce[i].c;
      if (1 < j) {
	if (0 != anthy_select_longest_row(&xs)) {
	  j = 2;
	  continue;
	  /* ա anthy_select_longest_row() ϡʸʾΤ߸ */
	}
      } else {
	if (0 != anthy_select_row(&xs,0)) {
	  break;
	}
      }
      if (anthy_get_nth_value(0) < 2) {
	continue;
      }
      key = anthy_get_index_xstr();
      j = key->len;

      /* ȿؽ */
      anthy_unlearn_row();
    }
  }
  return;
}

/** °ʸ
 *@param[in]	s		ʸ
 *
 * Patched by G-HAL
 *	Thu,21 Aug,2008, Sat,23 Aug,2008
 *	Fri,17 Oct,2008
 *	Sat,01 Nov,2008
 *	Fri,14 Nov,2008
 *	Wed,10 Dec,2008
 *	Tue,30 Dec,2008
 *	Sat,24 Jan,2009, Sun,25 Jan,2009
 *	Wed,04 Feb,2009
 *	Sun,08 Feb,2009
 *	Sat,09 May,2009
 */
static int get_depword_len( const struct seg_ent* const s )
{
  const struct cand_ent* const ce = s->cands[s->committed];
  int ret = 0;

  if (ce->mw) {
    ret = ce->mw->cand_hint_length_of_dep;
  } else if ((ce->core_elm_index < 0) || (ce->nr_words < NR_PARTS)) {
    /* ʼΩ̵ */
    if ((CEF_COMPOUND | CEF_COMPOUND_PART) & ce->flag) {
      ret = 0;	/* May be bug. */
    } else if (CEF_GUESS_KATAcoreHIRAdep & ce->flag) {
      ret = 1;
    } else {
      ret = 0;
    }
  } else {
    const struct cand_elm* const depelm = &(ce->elm[ce->nr_words - NR_PARTS + PART_DEPWORD]);
    if (POS_NONE != anthy_wtype_get_pos(depelm->wt)) {
      ret = depelm->str.len;
    } else {
      ret = 0;
    }
  }
  return ret;
}

/** ؽԤ
 *@param[in]	sc		ʸ
 *@param[in]	sl		ʸᷲ
 *
 * Patched by G-HAL
 *	Thu,21 Aug,2008, Sat,23 Aug,2008
 *	Fri,17 Oct,2008
 *	Sat,01 Nov,2008
 *	Fri,14 Nov,2008
 *	Wed,10 Dec,2008
 *	Tue,30 Dec,2008
 *	Sat,24 Jan,2009, Sun,25 Jan,2009
 *	Wed,04 Feb,2009
 *	Sun,08 Feb,2009
 *	Sat,09 May,2009
 *	Fri,26 Jun,2009
 *	Sat,27 May,2010 - Sun,28 May,2010
 *	Wed,18 Aug,2010 - Fri,20 Aug,2010
 */
static void learn_ochaire( const struct splitter_context* const sc, const struct segment_list* const sl )
{
  const int enable_wo_indep
      = anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep
      || anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep
      || anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep
      || anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep_wo_dep;
  const int enable_wo_dep
      = anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep
      || anthy_settings.anthy_mode.learn.enable_ochaire3_wo_dep
      || anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep
      || anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep_wo_dep;
  int count;

  /* ʸڤؽ̷⤹륨ȥä */
  if (anthy_settings.anthy_mode.learn.enable_unlearn) {
    if (!anthy_select_section(CAND_HISTORY, 0)) {
      unlearn_negative_entry( sc );
    }
  }

  if (anthy_select_section(OCHAIRE, 1)) {
    return;
  }

  /* OCHAIREؽΥͥƥ֤ʥȥä */
  if (anthy_settings.anthy_mode.learn.enable_release) {
    release_negative_entry( sc );
  }

  /* ؽ򤹤 */
  for (count = anthy_settings.limit.ochaire_mindepth; count <= sl->nr_segments && count <= anthy_settings.limit.ochaire_maxdepth; ++count) {
    /* 2ʸʾĹʸФ */
    int i;

    for (i = 0; i <= sl->nr_segments - count; ++i) {
      /* ʸʸ */
      struct seg_ent* const head = anthy_get_nth_segment( sl, i );
      struct seg_ent* s;
      int j;
      int dont_learn = 1;

      /* ؽ̵ͭȽ */
      for (j = 0, s = head; j < count; ++j, s = s->next) {
	if (CEF_DONTLEARN_OCHAIRE_IFHAVEIT & s->cands[s->committed]->flag) {
	  dont_learn = 1;
	  break;
	}
	if ((anthy_settings.anthy_mode.extra_flag.exception_word.ochaire)
	    && (anthy_ishit_exception_word(&s->str))
	) {
	  dont_learn = 1;
	  break;
	}
	if (!(CEF_DONTLEARN_OCHAIRE_IFONLYITS & s->cands[s->committed]->flag)) {
	  dont_learn = 0;
	}
      }

      if (!dont_learn) {
	xstr xs = head->str;
	int do_commit_ochaire
	    = ((2 == count) && anthy_settings.anthy_mode.learn.enable_ochaire2)
	    || ((2 < count) && anthy_settings.anthy_mode.learn.enable_ochaire3);
	int do_commit_ochaire_withoutdep
	    = ((2 == count) && anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep)
	    || ((2 < count) && anthy_settings.anthy_mode.learn.enable_ochaire3_wo_dep);
	int do_commit_ochaire_withoutindep
	    = ((2 == count) && anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep)
	    || ((2 < count) && anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep);
	int do_commit_ochaire_withoutindep_withoutdep
	    = ((2 == count) && anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep)
	    || ((2 < count) && anthy_settings.anthy_mode.learn.enable_ochaire3_wo_indep_wo_dep);
	int head_depword_len = 0;
	int tail_depword_len = 0;

	for (j = 1, s = head->next; j < count; j++, s = s->next) {
	  xs.len += s->str.len;
	}
	s = s->prev;
	{
	  head_depword_len = get_depword_len( head );
	  tail_depword_len = get_depword_len( s );
	  if (head->len <= head_depword_len) {
	    do_commit_ochaire_withoutindep |= do_commit_ochaire;
	  }
	  if (tail_depword_len < 1) {
	    do_commit_ochaire_withoutdep |= do_commit_ochaire;
	    do_commit_ochaire_withoutindep_withoutdep |= do_commit_ochaire_withoutindep;
	  }
	  if (head->len <= head_depword_len) {
	    do_commit_ochaire_withoutindep_withoutdep |= do_commit_ochaire_withoutdep;
	  }
	}
	{ /* ʸؽ */
	  if (1 == count) {
	    if (anthy_settings.anthy_mode.learn.enable_ochaire1) {
	      commit_ochaire( head, count, &xs, 0, 0, 1, 0, 0, 1 );
	      if ((tail_depword_len < 1) || (anthy_settings.anthy_mode.learn.enable_ochaire1_wo_dep)) {
		commit_ochaire( head, count, &xs, 0, 0, 0, 1, tail_depword_len, 1 );
	      }
	    }
	  } else {
	    int dup_withindep = 0;
	    int dup_withindep_withdep = 0;
	    int dup_withindep_withoutdep = 0;
	    if (do_commit_ochaire) {
	      /* ݤȳؽ */
	      commit_ochaire( head, count, &xs, 0, 0, 1, 0, 0, 1 );
	      if (tail_depword_len < 1) {
		dup_withindep = 1;
	      }
	      if (head->len <= head_depword_len) {
		dup_withindep_withdep = 1;
	      }
	    }
	    if (do_commit_ochaire_withoutdep) {
	      /* Ǹ°Ƴؽ */
	      commit_ochaire( head, count, &xs, 0, 0, !dup_withindep, 1, tail_depword_len, 1 );
	      if (head->len <= head_depword_len) {
		dup_withindep_withoutdep = 1;
	      }
	    }
	    if (1 <= head_depword_len) {
	      dup_withindep = 0;
	      if (do_commit_ochaire_withoutindep) {
		/* ƬμΩƳؽ */
		commit_ochaire( head, count, &xs, 1, head_depword_len, 1, 0, 0, !dup_withindep_withdep );
		if (tail_depword_len < 1) {
		  dup_withindep = 1;
		}
	      }
	      if (do_commit_ochaire_withoutindep_withoutdep) {
		/* ƬμΩ졦Ǹ°Ƴؽ */
		commit_ochaire( head, count, &xs, 1, head_depword_len, !dup_withindep, 1, tail_depword_len, !dup_withindep_withoutdep );
	      }
	    }
	  }
	}
      }
    }
  }
  return;
}



/** ƤϢ뤷ơOCHAIREؽԤ
 *@param[in]		sc		ʸ
 *@param[in]		sl		ʸᷲ
 *
 *@comment
 *	ʸؽΤߡ
 *
 * Patched by G-HAL
 *	Sat,25 Apr,2009
 *	Fri,26 Jun,2009
 */
static void learn_keepalive_ochaire( const struct splitter_context* const sc, const struct segment_list* const sl )
{
  if (!anthy_settings.anthy_mode.keepalive.enable_learn_ochaire) {
    return;
  }
  if ((sc->prev_commit.yomi.len <= 0) || (sc->prev_commit.cand.len <= 0)) {
    return;
  }
  if (anthy_select_section(OCHAIRE, 1)) {
    return;
  }

  { struct seg_ent* const head = anthy_get_nth_segment( sl, 0 );
    struct cand_ent* const ce = head->cands[head->committed];

    /* ؽ̵ͭȽ */
    if ((head->str.len <= 0) || (ce->str.len <= 0)) {
      return;
    }
    if ((CEF_DONTLEARN_OCHAIRE_IFHAVEIT | CEF_DONTLEARN_OCHAIRE_IFONLYITS) & ce->flag) {
      return;
    }
    if ((anthy_settings.anthy_mode.extra_flag.exception_word.ochaire)
	&& (anthy_ishit_exception_word(&(sc->prev_commit.yomi)))
    ) {
      return;
    }
    if ((anthy_settings.anthy_mode.extra_flag.exception_word.ochaire)
	&& (anthy_ishit_exception_word(&(head->str)))
    ) {
      return;
    }

    { const int enable_wo_dep
	  = anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep
	  || anthy_settings.anthy_mode.learn.enable_ochaire2_wo_indep_wo_dep;
      xstr yomi;
      int tail_depword_len = 0;

      yomi.len = 0;
      yomi.str = NULL;
      anthy_xstrcat( &yomi, &(sc->prev_commit.yomi) );
      anthy_xstrcat( &yomi, &(head->str) );
      if (enable_wo_dep) {
	tail_depword_len = get_depword_len( head );
      }

      /* ʸؽ */
      {
	int dup = 0;
	if (anthy_settings.anthy_mode.learn.enable_ochaire2) {
	  /* ݤȳؽ */
	  commit_keepalive_ochaire( &yomi, &(sc->prev_commit.yomi), &(head->str), &(sc->prev_commit.cand), &(ce->str), 1, 0, 0 );
	  dup = (0 == tail_depword_len);
	}
	if (anthy_settings.anthy_mode.learn.enable_ochaire2_wo_dep) {
	  /* Ǹ°Ƴؽ */
	  commit_keepalive_ochaire( &yomi, &(sc->prev_commit.yomi), &(head->str), &(sc->prev_commit.cand), &(ce->str), !dup, 1, tail_depword_len );
	}
      }
      anthy_free_xstr_str( &yomi );
    }
  }
  return;
}



/** ǡץ󥰤Ԥ
 *@param[in]	sc		ʸ
 *@param[in]	sl		ʸᷲ
 *
 * Patched by G-HAL
 *	Wed,11 Feb,2009 - Thu,12 Feb,2009
 *	Fri,26 Jun,2009
 */
static void data_sampling( const struct splitter_context* const sc, const struct segment_list* const sl )
{
  if (!anthy_settings.anthy_mode.learn.enable_datasampling) {
    return;
  }
  if (anthy_select_section(DATA_SAMPLING, 1)) {
    return;
  }
  {
    struct indep_dep_record_t {
      xstr	indep_yomi;
      xstr	indep_ent;
      xstr	dep;
      int	dont_learn;
    };
    struct indep_dep_record_t* const record = alloca( sizeof(struct indep_dep_record_t[sl->nr_segments]) );
    size_t count;
    size_t i;
    size_t j;
    static const xchar delimiter_xc[1] = { UINT32_C(0x0000005F) }; /* _ */
    static const xstr delimiter_xs = { .len = 1, .str = delimiter_xc };
    char header_buffer[256];

    for (i = 0; i < sl->nr_segments; ++i) {
      /* ʸʼΩˡܡ°ˤʬ򤹤 */
      struct seg_ent* const s = anthy_get_nth_segment( sl, i );
      const size_t          depword_len = get_depword_len( s );
      record[i].indep_ent .len = s->cands[s->committed]->str.len - depword_len;
      record[i].indep_ent .str = s->cands[s->committed]->str.str;
      record[i].indep_yomi.len = s->str.len - depword_len;
      record[i].indep_yomi.str = s->str.str;
      record[i].dep       .len = depword_len;
      record[i].dep       .str = s->cands[s->committed]->str.str + record[i].indep_ent.len;
      record[i].dont_learn     = 0;
      if (anthy_ishit_exception_word(&record[i].indep_yomi)) {
	record[i].dont_learn = 1;
      }
    }

    for (count = anthy_settings.limit.ochaire_mindepth; count <= sl->nr_segments && count <= anthy_settings.limit.ochaire_maxdepth; ++count) {
      for (i = 0; i <= (sl->nr_segments - count); ++i) {
	size_t d_len;
	xstr* key_i;
	xstr* key_d;
	int	dont_learn_i;
	int	dont_learn_d;

	snprintf( header_buffer, sizeof(header_buffer), "%01dI", count );
	key_i = anthy_cstr_to_xstr( header_buffer, ANTHY_COMPILED_ENCODING );
	snprintf( header_buffer, sizeof(header_buffer), "%01dD", count );
	key_d = anthy_cstr_to_xstr( header_buffer, ANTHY_COMPILED_ENCODING );

	d_len = 0;
	dont_learn_i = 0;
	dont_learn_d = 0;
	for (j = i; j < (i + count); ++j) {
	  anthy_xstrcat( key_i, &delimiter_xs );
	  anthy_xstrcat( key_i, &(record[j].indep_yomi) );
	  anthy_xstrcat( key_d, &delimiter_xs );
	  anthy_xstrcat( key_d, &(record[j].dep) );
	  d_len += record[j].dep.len;
	  dont_learn_i = dont_learn_i || record[j].dont_learn;
	  dont_learn_d = dont_learn_d || record[j].dont_learn;
	}

	if (!dont_learn_i && (record[i+count-1].dep.len < d_len)) {
	  if (!anthy_select_row_with_learn(key_i,1,1)) {
	    for (j = 0; j < count; ++j) {
	      anthy_set_nth_xstr( j, &(record[i+j].indep_ent) );
	    }
	    anthy_truncate_row( j );
	    anthy_mark_row_used();
	  }
	}
	if (!dont_learn_d) {
	  if (!anthy_select_row_with_learn(key_d,1,1)) {
	    anthy_truncate_row( 0 );
	    anthy_mark_row_used();
	  }
	}

	anthy_free_xstr( key_d );
	anthy_free_xstr( key_i );
      }
    }
    for (count = 2; count <= sl->nr_segments && count <= 2; ++count) {
      for (i = 0; i <= (sl->nr_segments - 2); ++i) {
	xstr* key_id;
	int	dont_learn;

	snprintf( header_buffer, sizeof(header_buffer), "2ID" );
	key_id = anthy_cstr_to_xstr( header_buffer, ANTHY_COMPILED_ENCODING );
	anthy_xstrcat( key_id, &delimiter_xs );
	anthy_xstrcat( key_id, &(record[i+0].indep_yomi) );
	anthy_xstrcat( key_id, &delimiter_xs );
	anthy_xstrcat( key_id, &(record[i+1].dep) );
	dont_learn = 0;
	dont_learn = dont_learn || record[i+0].dont_learn;
	dont_learn = dont_learn || record[i+1].dont_learn;

	if (!dont_learn) {
	  if (!anthy_select_row_with_learn(key_id,1,1)) {
	    anthy_set_nth_xstr( 0, &(record[i+0].indep_ent) );
	    anthy_truncate_row( 1 );
	    anthy_mark_row_used();
	  }
	}

	anthy_free_xstr( key_id );
      }
    }
  }
  return;
}
#endif

#if 0		/* Patched by G-HAL, Thu,30 Oct,2008 */
static int
learn_prediction_str(xstr *idx, xstr *xs)
{
  int nr_predictions;
  int i;
  time_t t = anthy_settings.timestamp.currentsession; /* time(NULL);*/	/* Patched by G-HAL, Wed,15 Oct,2008, Wed,22 Oct,2008, Wed,29 Sep,2010 */
  if (anthy_select_row_with_learn(idx,1,0)) {	/* Patched by G-HAL, Sat,23 Aug,2008 */
    return 0;
  }
  nr_predictions = anthy_get_nr_values();

  /* ˤϥॹפ */
  for (i = 0; i < nr_predictions; i += 2) {
    xstr *log = anthy_get_nth_xstr(i + 1);
    if (!log) {
      continue;
    }
    if (anthy_xstrcmp(log, xs) == 0) {
      anthy_set_nth_int64( i, t );		/* Patched by G-HAL, Wed,22 Oct,2008 */
      break;
    }
  }

  /* ʤɲ */
  if (i == nr_predictions) {
    anthy_set_nth_int64( nr_predictions, t );	/* Patched by G-HAL, Wed,22 Oct,2008 */
    anthy_set_nth_xstr(nr_predictions + 1, xs);
    anthy_mark_row_used();
    return 1;
  }
  anthy_mark_row_used();
  return 0;
}
#endif

static void
learn_prediction(struct segment_list *sl)
{
  int i;
  int added = 0;
 #if 0		/* Patched by G-HAL, Fri,17 Oct,2008, Thu,30 Oct,2008, Tue,03 Feb,2009 */
  if (anthy_select_section("PREDICTION", 1)) {
    return ;
  }
 #else
  if (!anthy_settings.anthy_mode.learn.enable_prediction) {
    return;
  }
  if (anthy_select_section(CAND_HISTORY, 1)) {
    return;
  }
 #endif
  for (i = 0; i < sl->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(sl, i);
    xstr *xs = &seg->cands[seg->committed]->str;

    if (seg->committed < 0) {
      continue;
    }
   #if 0		/* Patched by G-HAL, Thu,30 Oct,2008, Sat,01 Nov,2008, Fri,26 Jun,2009 */
    if (learn_prediction_str(&seg->str, xs)) {
      added = 1;
    }
   #else
    if (0 == (CEF_DONTLEARN_PREDICTION & seg->cands[seg->committed]->flag)) {
      if (!anthy_settings.anthy_mode.extra_flag.exception_word.prediction
	  || !anthy_ishit_exception_word(&(seg->str)))
      {
	if (anthy_learn_history_str(&seg->str, xs, 0)) {
	  added = 1;
	}
      }
    }
   #endif
  }
 #if 0	/* Patched by G-HAL, Sat,23 Aug,2008 */
  if (added) {
    anthy_truncate_section(MAX_PREDICTION_ENTRY);
  }
 #endif
}

static void
learn_unknown(struct segment_list *sl)
{
  int i;
  for (i = 0; i < sl->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(sl, i);
    struct cand_ent *ce = seg->cands[seg->committed];
    if (ce->nr_words == 0) {
     #if 0		/* Patched by G-HAL, Sun,10 May,2009 */
      anthy_add_unknown_word( &seg->str, &ce->str );
     #else
      if ((CEF_HIRAGANA & ce->flag) || (CEF_KATAKANA & ce->flag)) {
	anthy_add_unknown_word( &seg->str, &ce->str );
      } else if (CEF_GUESS_KATAcoreHIRAdep & ce->flag) {
	xstr yomi;
	xstr ent;
	yomi.str = seg->str.str;
	yomi.len = seg->str.len - 1;
	ent.str  = ce->str.str;
	ent.len  = ce->str.len - 1;
	anthy_add_unknown_word( &yomi, &ent );
      }
     #endif
    }
  }
}

void
anthy_do_commit_prediction(xstr *src, xstr *xs)
{
 #if 0		/* Patched by G-HAL, Fri,17 Oct,2008, Thu,30 Oct,2008, Sat,01 Nov,2008, Tue,03 Feb,2009, Fri,26 Jun,2009, Tue,10 Nov,2009 */
  if (anthy_select_section("PREDICTION", 1)) {
    return ;
  }
  learn_prediction_str(src, xs);
 #else
  if (anthy_settings.anthy_mode.anonymous || (!anthy_settings.anthy_mode.learn.enable_prediction)) {
    return;
  }
  if (!anthy_settings.anthy_mode.extra_flag.exception_word.prediction
      || !anthy_ishit_exception_word(src))
  {
    if (0 == anthy_select_section(CAND_HISTORY, 1)) {
      anthy_learn_history_str( src, xs, 0 );
    }
  }
  return;
 #endif
}

#if 0	/* Patched by G-HAL, Sat,25 Apr,2009 */
#else
/** ǸʸƤ¸
 *@param[in]	sc		¸ʸ
 *@param[in]	sl		¸
 *
 * Patched by G-HAL
 *	Sat,25 Apr,2009
 *	Thu,12 Nov,2009
 *	Tue,20 Jul,2010 - Wed,21 Jul,2010
 */
static void preserve_last_phrase( struct splitter_context* const sc, const struct segment_list* const sl )
{
  if (!anthy_settings.anthy_mode.keepalive.enable) {
    return;
  }
  {
    sc->prev_commit.seg_dep_info.seg_class     = SEG_HEAD;
    sc->prev_commit.seg_dep_info.dep_class     = DEP_NONE;
    sc->prev_commit.seg_dep_info.dep_word_hash = 0;
    anthy_free_xstr_str( &(sc->prev_commit.yomi) );
    sc->prev_commit.yomi.str = NULL;
    sc->prev_commit.yomi.len = 0;
    anthy_free_xstr_str( &(sc->prev_commit.cand) );
    sc->prev_commit.cand.str = NULL;
    sc->prev_commit.cand.len = 0;
    if (sc->prev_commit.seg_ucinfo) {
      free( sc->prev_commit.seg_ucinfo );
      sc->prev_commit.seg_ucinfo = NULL;
    }
  }
  { struct seg_ent* const tail = anthy_get_nth_segment( sl, (sl->nr_segments - 1) );
    if (NULL == tail) {
      return;
    }

    if (anthy_settings.anthy_mode.keepalive.enable_refer_corpus) {
      sc->prev_commit.seg_dep_info.seg_class = tail->best_seg_class;
      if (tail->best_mw) {
	sc->prev_commit.seg_dep_info.dep_class     = tail->best_mw->dep_class;
	sc->prev_commit.seg_dep_info.dep_word_hash = tail->best_mw->dep_word_hash;
      }
    }
    { struct cand_ent* const ce = tail->cands[tail->committed];
      sc->prev_commit.yomi.str = (xchar*) malloc( sizeof(xchar) * (tail->str.len) );
      sc->prev_commit.cand.str = (xchar*) malloc( sizeof(xchar) * (ce->str.len) );
      anthy_xstrcpy( &(sc->prev_commit.yomi), &(tail->str) );
      anthy_xstrcpy( &(sc->prev_commit.cand), &(ce->str) );

      do {
	struct ucdic_seg_info* left_seg;
	if (ce->core_elm_index < 0) {
	  break;
	}
	left_seg = malloc( sizeof(*left_seg) );
	if (NULL == left_seg) {
	  break;
	}
	sc->prev_commit.seg_ucinfo = left_seg;
	left_seg->id_base     = ce->elm[ce->core_elm_index].uc_id_tmp;
	left_seg->id_base_fin = anthy_hash_finalize( left_seg->id_base );
	if (0 == anthy_dic_search_word_relation_key(left_seg->id_base_fin)) {
	  free( sc->prev_commit.seg_ucinfo );
	  sc->prev_commit.seg_ucinfo = NULL;
	  break;
	}
	left_seg->have_dep  = (PART_DEPWORD < ce->nr_words) && (0 < ce->elm[PART_DEPWORD].str.len);
	left_seg->id_wo_dep = anthy_hash_uint32_update( left_seg->id_base, '\0' );
	left_seg->id_w_dep  = left_seg->have_dep ? anthy_hash_uint32_update( anthy_hash_xstr_update( left_seg->id_base, &(ce->elm[PART_DEPWORD].str) ), '\0') : left_seg->id_wo_dep;
	if (0 != anthy_get_ce_wtname(ce, &(left_seg->wt))) {
	  left_seg->wt = NULL;
	}
	left_seg->wt_h = anthy_depgraph_pos_class_sym( ce->mw );
	left_seg->wt_c = anthy_depgraph_ct_class_sym( ce->mw );
	left_seg->wt_s = anthy_depgraph_dep_class_sym( ce->mw );
	break;
      } while (0);
    }
  }
  return;
}
#endif

#if 0	/* Patched by G-HAL, Sat,25 Apr,2009, Tue,10 Nov,2009 */
void
anthy_proc_commit(struct segment_list *sl,
		  struct splitter_context *sc)
{
  /* ƼγؽԤ */
  learn_swapped_candidates(sl);
  learn_resized_segment(sc, sl);
  clear_resized_segment(sc, sl);
  learn_ochaire(sc, sl);
  learn_prediction(sl);
  learn_unknown(sl);
  anthy_learn_cand_history(sl);
}
#else
void anthy_proc_commit( struct segment_list* sl, struct splitter_context* sc, int learn )
{
  if ((!anthy_settings.anthy_mode.anonymous) && learn) {
    /* ƼγؽԤ */
    anthy_checkupdate_baserecord();	/* Patched by G-HAL, Tue,14 Jul,2009 */
    learn_keepalive_ochaire( sc, sl );	/* Patched by G-HAL, Sat,25 Apr,2009 */
    learn_swapped_candidates(sl);
    learn_resized_segment(sc, sl);
    clear_resized_segment(sc, sl);
    learn_ochaire(sc, sl);
    learn_prediction(sl);
    learn_unknown(sl);
    anthy_learn_cand_history(sl);
    data_sampling( sc, sl );	/* Patched by G-HAL, Wed,11 Feb,2009 */
  }
  preserve_last_phrase( sc, sl );
  return;
}
#endif
/* vim:ts=8 sw=2 nomodified:
 */
