/**@file
 *		Patches for Anthy, by G-HAL
 *@brief	ʸμ̤Ѵ
 *@date		Mon,24 Nov,2008
 *@date		Tue,19 May,2009
 *@date		Mon,25 May,2009, Sun,07 Jun,2009
 *@date		Tue,09 Jun,2009
 *@date		Wed,10 Jun,2009 - Fri,12 Jun,2009
 *@date		Sat,13 Jun,2009 - Thu,17 Jun,2009
 *@date		Sat,20 Jun,2009
 *@date		Fri,26 Jun,2009
 *@date		Thu,16 Jul,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 */
#if 0		/* Patched by G-HAL */
/*
 * ʸ(xchar)Υפʤɤ򰷤
 *
 * Copyright (C) 2001-2006 TABATA Yusuke
 */
#include <string.h>
#include "config.h"

#include <anthy/xstr.h>
#include <anthy/xchar.h>

#include "diclib_inner.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ARPA_INET_H)
# include <arpa/inet.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_NETINET_IN_H)
# include <netinet/in.h>
#endif

#include "anthy/xstr.h"
#include "anthy/xchar.h"
#include "diclib_inner.h"
#endif


#if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,25 May,2009 */
#define PAGE_SIZE 128
#define NR_PAGES 512
#include "e2u.h"
#include "u2e.h"
#else
#if defined(HAVE_ARPA_INET_H)
# include <arpa/inet.h>
#endif
#if defined(HAVE_NETINET_IN_H)
# include <netinet/in.h>
#endif

#include "anthy/settings.h"
#include "anthy/anthy.h"
#endif


#if !defined(USE_ICONV)	/* Patched by G-HAL */


/* this use UCS4 */
static struct xchar_ent {
  const xchar xc;
  const int type;
  struct xchar_ent *next;/* hash chain */
} xchar_tab[] =
{
  {UINT16_C(0xFF40), XCT_OPEN , 0}, /* , ɲ */
  {UINT16_C(0x2032), XCT_CLOSE, 0}, /* , ɲ */
  {UINT16_C(0x2018), XCT_OPEN , 0}, /* , ɲ */
  {UINT16_C(0x2019), XCT_CLOSE, 0}, /* , ɲ */
  {UINT16_C(0x201C), XCT_OPEN , 0}, /* , ɲ */
  {UINT16_C(0x201D), XCT_CLOSE, 0}, /* , ʸɤְäƤȻפΤǽ */
  {UINT16_C(0xff08), XCT_OPEN , 0}, /*  */
  {UINT16_C(0xff09), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x3014), XCT_OPEN , 0}, /*  */
  {UINT16_C(0x3015), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0xff3b), XCT_OPEN , 0}, /*  */
  {UINT16_C(0xff3d), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0xff5b), XCT_OPEN , 0}, /*  */
  {UINT16_C(0xff5d), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x3008), XCT_OPEN , 0}, /*  */
  {UINT16_C(0x3009), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x300a), XCT_OPEN , 0}, /*  */
  {UINT16_C(0x300b), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x300c), XCT_OPEN , 0}, /*  */
  {UINT16_C(0x300d), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x300e), XCT_OPEN , 0}, /*  */
  {UINT16_C(0x300f), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x3010), XCT_OPEN , 0}, /*  */
  {UINT16_C(0x3011), XCT_CLOSE, 0}, /*  */
  {UINT16_C(0x2033), XCT_CLOSE, 0}, /* , Added by G-HAL, Mon,24 Nov,2008 */
  {UINT16_C(0x3001), XCT_PUNCTUATION, 0},  /*  */
  {UINT16_C(0x3002), XCT_PUNCTUATION, 0},  /*  */
  {UINT16_C(0xff0c), XCT_PUNCTUATION, 0},  /*  */
  {UINT16_C(0xff0e), XCT_PUNCTUATION, 0},  /*  */
  {UINT16_C(0xff1f), XCT_PUNCTUATION, 0},  /*  */
  {UINT16_C(0xff01), XCT_PUNCTUATION, 0},  /*  */

  {UINT16_C(28) , XCT_OPEN, 0}, /* ( */
  {UINT16_C(133), XCT_OPEN, 0}, /* [ */
  {UINT16_C(29) , XCT_CLOSE, 0}, /* ) */
  {UINT16_C(135), XCT_CLOSE, 0}, /* ] */
  {HK_TO, XCT_DEP, 0},/*  */
  {HK_HA, XCT_DEP, 0},/*  */
  {HK_NO, XCT_DEP, 0},/*  */
  {HK_NI, XCT_DEP, 0},/*  */
  {HK_GA, XCT_DEP, 0},/*  */
  {HK_WO, XCT_DEP, 0},/*  */
  {WIDE_0, XCT_WIDENUM, 0},
  {WIDE_1, XCT_WIDENUM, 0},
  {WIDE_2, XCT_WIDENUM, 0},
  {WIDE_3, XCT_WIDENUM, 0},
  {WIDE_4, XCT_WIDENUM, 0},
  {WIDE_5, XCT_WIDENUM, 0},
  {WIDE_6, XCT_WIDENUM, 0},
  {WIDE_7, XCT_WIDENUM, 0},
  {WIDE_8, XCT_WIDENUM, 0},
  {WIDE_9, XCT_WIDENUM, 0},
  {HK_DDOT, XCT_PART, 0},
  {HK_XA, XCT_PART, 0},
  {HK_XI, XCT_PART, 0},
  {HK_XU, XCT_PART, 0},
  {HK_XE, XCT_PART, 0},
  {HK_XO, XCT_PART, 0},
  {HK_XYA, XCT_PART, 0},
  {HK_XYU, XCT_PART, 0},
  {HK_XYO, XCT_PART, 0},
  {HK_TT, XCT_PART, 0},
  {HK_XWA, XCT_PART, 0}	/* Patched by G-HAL, Tue,19 May,2009 */,
  {HK_BAR, XCT_PART, 0}	/* Patched by G-HAL, Tue,19 May,2009 */,
  {0, 0, 0},
};

#if 1		/* Patched by G-HAL, Tue,19 May,2009 */
static const struct xchar_ent xchar_tab50[] = {
  { HK_XA, XCT_KANA_A | XCT_PART | XCT_PART_A, 0},
  { HK_XI, XCT_KANA_I | XCT_PART | XCT_PART_I, 0},
  { HK_XU, XCT_KANA_U | XCT_PART | XCT_PART_U, 0},
  { HK_XE, XCT_KANA_E | XCT_PART | XCT_PART_E, 0},
  { HK_XO, XCT_KANA_O | XCT_PART | XCT_PART_O, 0},

  { HK_TT, XCT_KANA_U | XCT_PART | XCT_PART_MASK, 0},

  {HK_XYA, XCT_KANA_A | XCT_PART, 0},
  {HK_XYU, XCT_KANA_U | XCT_PART, 0},
  {HK_XYO, XCT_KANA_O | XCT_PART, 0},

  {HK_XWA, XCT_KANA_A | XCT_PART, 0},

  {HK_BAR, XCT_KANA_MASK | XCT_PART | XCT_PART_MASK, 0},


  { HK_A, XCT_KANA_A, 0},
  { HK_I, XCT_KANA_I, 0},
  { HK_U, XCT_KANA_U, 0},
  { HK_E, XCT_KANA_E, 0},
  { HK_O, XCT_KANA_O, 0},

  {HK_KA, XCT_KANA_A, 0},
  {HK_KI, XCT_KANA_I, 0},
  {HK_KU, XCT_KANA_U, 0},
  {HK_KE, XCT_KANA_E, 0},
  {HK_KO, XCT_KANA_O, 0},

  {HK_GA, XCT_KANA_A, 0},
  {HK_GI, XCT_KANA_I, 0},
  {HK_GU, XCT_KANA_U, 0},
  {HK_GE, XCT_KANA_E, 0},
  {HK_GO, XCT_KANA_O, 0},

  {HK_SA, XCT_KANA_A, 0},
  {HK_SI, XCT_KANA_I, 0},
  {HK_SU, XCT_KANA_U, 0},
  {HK_SE, XCT_KANA_E, 0},
  {HK_SO, XCT_KANA_O, 0},

  {HK_ZA, XCT_KANA_A, 0},
  {HK_ZI, XCT_KANA_I, 0},
  {HK_ZU, XCT_KANA_U, 0},
  {HK_ZE, XCT_KANA_E, 0},
  {HK_ZO, XCT_KANA_O, 0},

  {HK_TA, XCT_KANA_A, 0},
  {HK_TI, XCT_KANA_I, 0},
  {HK_TU, XCT_KANA_U, 0},
  {HK_TE, XCT_KANA_E, 0},
  {HK_TO, XCT_KANA_O, 0},

  {HK_DA, XCT_KANA_A, 0},
  {HK_DI, XCT_KANA_I, 0},
  {HK_DU, XCT_KANA_U, 0},
  {HK_DE, XCT_KANA_E, 0},
  {HK_DO, XCT_KANA_O, 0},

  {HK_NA, XCT_KANA_A, 0},
  {HK_NI, XCT_KANA_I, 0},
  {HK_NU, XCT_KANA_U, 0},
  {HK_NE, XCT_KANA_E, 0},
  {HK_NO, XCT_KANA_O, 0},

  {HK_HA, XCT_KANA_A, 0},
  {HK_HI, XCT_KANA_I, 0},
  {HK_HU, XCT_KANA_U, 0},
  {HK_HE, XCT_KANA_E, 0},
  {HK_HO, XCT_KANA_O, 0},

  {HK_BA, XCT_KANA_A, 0},
  {HK_BI, XCT_KANA_I, 0},
  {HK_BU, XCT_KANA_U, 0},
  {HK_BE, XCT_KANA_E, 0},
  {HK_BO, XCT_KANA_O, 0},

  {HK_PA, XCT_KANA_A, 0},
  {HK_PI, XCT_KANA_I, 0},
  {HK_PU, XCT_KANA_U, 0},
  {HK_PE, XCT_KANA_E, 0},
  {HK_PO, XCT_KANA_O, 0},

  {HK_MA, XCT_KANA_A, 0},
  {HK_MI, XCT_KANA_I, 0},
  {HK_MU, XCT_KANA_U, 0},
  {HK_ME, XCT_KANA_E, 0},
  {HK_MO, XCT_KANA_O, 0},

  {HK_YA, XCT_KANA_A, 0},
  {HK_YU, XCT_KANA_U, 0},
  {HK_YO, XCT_KANA_O, 0},

  {HK_RA, XCT_KANA_A, 0},
  {HK_RI, XCT_KANA_I, 0},
  {HK_RU, XCT_KANA_U, 0},
  {HK_RE, XCT_KANA_E, 0},
  {HK_RO, XCT_KANA_O, 0},

  {HK_WA, XCT_KANA_A, 0},
  {HK_WI, XCT_KANA_I, 0},
  {HK_WE, XCT_KANA_E, 0},
  {HK_WO, XCT_KANA_O, 0},

  {   HK_N, XCT_KANA_MASK, 0},
  {HK_DDOT, XCT_KANA_MASK | XCT_PART | XCT_PART_MASK, 0},

  {0, 0, 0},
};
#endif

#define DDOT UINT16_C(0x8ede)
#define CIRCLE UINT16_C(0x8edf)

static const struct half_kana_table half_kana_tab[] = {
  {HK_A,UINT16_C(0x8eb1),0},
  {HK_I,UINT16_C(0x8eb2),0},
  {HK_U,UINT16_C(0x8eb3),0},
  {HK_E,UINT16_C(0x8eb4),0},
  {HK_O,UINT16_C(0x8eb5),0},
  {HK_KA,UINT16_C(0x8eb6),0},
  {HK_KI,UINT16_C(0x8eb7),0},
  {HK_KU,UINT16_C(0x8eb8),0},
  {HK_KE,UINT16_C(0x8eb9),0},
  {HK_KO,UINT16_C(0x8eba),0},
  {HK_SA,UINT16_C(0x8ebb),0},
  {HK_SI,UINT16_C(0x8ebc),0},
  {HK_SU,UINT16_C(0x8ebd),0},
  {HK_SE,UINT16_C(0x8ebe),0},
  {HK_SO,UINT16_C(0x8ebf),0},
  {HK_TA,UINT16_C(0x8ec0),0},
  {HK_TI,UINT16_C(0x8ec1),0},
  {HK_TU,UINT16_C(0x8ec2),0},
  {HK_TE,UINT16_C(0x8ec3),0},
  {HK_TO,UINT16_C(0x8ec4),0},
  {HK_NA,UINT16_C(0x8ec5),0},
  {HK_NI,UINT16_C(0x8ec6),0},
  {HK_NU,UINT16_C(0x8ec7),0},
  {HK_NE,UINT16_C(0x8ec8),0},
  {HK_NO,UINT16_C(0x8ec9),0},
  {HK_HA,UINT16_C(0x8eca),0},
  {HK_HI,UINT16_C(0x8ecb),0},
  {HK_HU,UINT16_C(0x8ecc),0},
  {HK_HE,UINT16_C(0x8ecd),0},
  {HK_HO,UINT16_C(0x8ece),0},
  {HK_MA,UINT16_C(0x8ecf),0},
  {HK_MI,UINT16_C(0x8ed0),0},
  {HK_MU,UINT16_C(0x8ed1),0},
  {HK_ME,UINT16_C(0x8ed2),0},
  {HK_MO,UINT16_C(0x8ed3),0},
  {HK_YA,UINT16_C(0x8ed4),0},
  {HK_YU,UINT16_C(0x8ed5),0},
  {HK_YO,UINT16_C(0x8ed6),0},
  {HK_RA,UINT16_C(0x8ed7),0},
  {HK_RI,UINT16_C(0x8ed8),0},
  {HK_RU,UINT16_C(0x8ed9),0},
  {HK_RE,UINT16_C(0x8eda),0},
  {HK_RO,UINT16_C(0x8edb),0},
  {HK_WA,UINT16_C(0x8edc),0},
  {HK_WI,0,0},
  {HK_WE,0,0},
  {HK_WO,UINT16_C(0x8ea6),0},
  {HK_N ,UINT16_C(0x8edd),0},
  {HK_TT,UINT16_C(0x8eaf),0},
  {HK_XA,UINT16_C(0x8ea7),0},
  {HK_XI,UINT16_C(0x8ea8),0},
  {HK_XU,UINT16_C(0x8ea9),0},
  {HK_XE,UINT16_C(0x8eaa),0},
  {HK_XO,UINT16_C(0x8eab),0},
  {HK_GA,UINT16_C(0x8eb6),DDOT},
  {HK_GI,UINT16_C(0x8eb7),DDOT},
  {HK_GU,UINT16_C(0x8eb8),DDOT},
  {HK_GE,UINT16_C(0x8eb9),DDOT},
  {HK_GO,UINT16_C(0x8eba),DDOT},
  {HK_ZA,UINT16_C(0x8ebb),DDOT},
  {HK_ZI,UINT16_C(0x8ebc),DDOT},
  {HK_ZU,UINT16_C(0x8ebd),DDOT},
  {HK_ZE,UINT16_C(0x8ebe),DDOT},
  {HK_ZO,UINT16_C(0x8ebf),DDOT},
  {HK_DA,UINT16_C(0x8ec0),DDOT},
  {HK_DI,UINT16_C(0x8ec1),DDOT},
  {HK_DU,UINT16_C(0x8ec2),DDOT},
  {HK_DE,UINT16_C(0x8ec3),DDOT},
  {HK_DO,UINT16_C(0x8ec4),DDOT},
  {HK_BA,UINT16_C(0x8eca),DDOT},
  {HK_BI,UINT16_C(0x8ecb),DDOT},
  {HK_BU,UINT16_C(0x8ecc),DDOT},
  {HK_BE,UINT16_C(0x8ecd),DDOT},
  {HK_BO,UINT16_C(0x8ece),DDOT},
  {HK_PA,UINT16_C(0x8eca),CIRCLE},
  {HK_PI,UINT16_C(0x8ecb),CIRCLE},
  {HK_PU,UINT16_C(0x8ecc),CIRCLE},
  {HK_PE,UINT16_C(0x8ecd),CIRCLE},
  {HK_PO,UINT16_C(0x8ece),CIRCLE},
  {HK_XYA,UINT16_C(0x8eac),0},
  {HK_XYU,UINT16_C(0x8ead),0},
  {HK_XYO,UINT16_C(0x8eae),0},
  {HK_XWA,0,0},
  {HK_DDOT,DDOT,0},
  {HK_BAR,UINT16_C(0x8eb0),0},
  {0,0,0}
};

static const struct half_wide_ent {
  const xchar half;
  const xchar wide;
} half_wide_tab[] = {
  {'!', UINT16_C(0xff01)},
  {'\"', UINT16_C(0x201d)},
  {'#', UINT16_C(0xff03)},
  {'$', UINT16_C(0xff04)},
  {'%', UINT16_C(0xff05)},
  {'&', UINT16_C(0xff06)},
  {'\'', UINT16_C(0x2019)},
  {'(', UINT16_C(0xff08)},
  {')', UINT16_C(0xff09)},
  {'*', UINT16_C(0xff0a)},
  {'+', UINT16_C(0xff0b)},
  {',', UINT16_C(0xff0c)},
  {'-', UINT16_C(0xff0d)},
  {'.', UINT16_C(0xff0e)},
  {'/', UINT16_C(0xff0f)},
  {':', UINT16_C(0xff1a)},
  {';', UINT16_C(0xff1b)},
  {'<', UINT16_C(0xff1c)},
  {'=', UINT16_C(0xff1d)},
  {'>', UINT16_C(0xff1e)},
  {'?', UINT16_C(0xff1f)},
  {'@', UINT16_C(0xff20)},
  {'[', UINT16_C(0xff3b)},
  {'\\', UINT16_C(0xff3c)},
  {']', UINT16_C(0xff3d)},
  {'^', UINT16_C(0xff3e)},
  {'_', UINT16_C(0xff3f)},
  {'`', UINT16_C(0xff40)},
  {'{', UINT16_C(0xff5b)},
  {'|', UINT16_C(0xff5c)},
  {'}', UINT16_C(0xff5d)},
  {'~', UINT16_C(0xff5e)},
  {0, 0}
};

xchar
anthy_lookup_half_wide(xchar xc)
{
  const struct half_wide_ent *hw;
  for (hw = half_wide_tab; hw->half; hw ++) {
    if (hw->half == xc) {
      return hw->wide;
    }
    if (hw->wide == xc) {
      return hw->half;
    }
  }
  return 0;
}

const struct half_kana_table *
anthy_find_half_kana(xchar xc)
{
  const struct half_kana_table *tab;
  for (tab = half_kana_tab; tab->src; tab ++) {
    if (tab->src == xc && tab->dst) {
      return tab;
    }
  }
  return NULL;
}

static int
find_xchar_type(xchar xc)
{
  struct xchar_ent *xe = xchar_tab;

  for (; xe->xc; xe++) {
    if (xe->xc == xc) {
      return xe->type;
    }
  }

  return XCT_NONE;
}

#if 1		/* Patched by G-HAL, Tue,19 May,2009 */
/** 50ɽʸ
 *@param		xc		ʸʸ
 *@return				ʸ
 */
static enum XCT_t find_xchar_type50( const xchar xc )
{
  const struct xchar_ent* xe = xchar_tab50;
  for (; xe->xc; ++xe) {
    if (xe->xc == xc) {
      return xe->type;
    }
  }
  return XCT_NONE;
}
#endif


static int
is_hira(xchar xc)
{
  if (xc == HK_DDOT) {
    return 1;
  }
  if (xc == HK_BAR) {
    return 1;
  }
  xc = anthy_ucs_to_euc(xc);
  if ((xc & UINT16_C(0xff00)) == UINT16_C(0xa400)) {
    return 1;
  }
  return 0;
}

static int
is_kata(xchar xc)
{
  if (xc == HK_BAR) {
    return 1;
  }
  xc = anthy_ucs_to_euc(xc);
  if ((xc & UINT16_C(0xff00)) == UINT16_C(0xa500)) {
    return 1;
  }
  return 0;
}

static int
is_symbol(xchar xc)
{
  if (xc == UCS_GETA) {
    return 1;
  }
  xc = anthy_ucs_to_euc(xc);
  if (xc == EUC_GETA) {
    return 0;
  }
  if ((xc & UINT16_C(0xff00)) == UINT16_C(0xa100)) {
    return 1;
  }
  if ((xc & UINT16_C(0xff00)) == UINT16_C(0xa200)) {
    return 1;
  }
  return 0;
}

static int
is_kanji(xchar xc)
{
  if (xc > UINT16_C(0x4e00) && xc < UINT16_C(0xa000)) {
    return 1;
  }
  return 0;
}

#if 1	/* Patched by G-HAL, Tue,09 Jun,2009 */
xchar anthy_xchar_hira_to_kata( xchar xc )
{
  if (is_hira(xc)) {
    return anthy_euc_to_ucs( anthy_ucs_to_euc( xc ) + UINT16_C(0x0100) );
  }
  return xc;
}

xchar anthy_xchar_kata_to_hira( xchar xc )
{
  if (is_kata(xc)) {
    return anthy_euc_to_ucs( anthy_ucs_to_euc( xc ) - UINT16_C(0x0100) );
  }
  return xc;
}
#endif

#if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,25 May,2009 */
static int
search(const int *tab[], int v, int geta)
{
  int page = v / PAGE_SIZE;
  int off = v % PAGE_SIZE;
  const int *t;
  if (page >= NR_PAGES) {
    return geta;
  }
  t = tab[page];
  if (!t) {
    return geta;
  }
  if (!t[off] && v) {
    return geta;
  }
  return t[off];
}

int
anthy_euc_to_ucs(int ec)
{
  return search(e2u_index, ec, UCS_GETA);
}

int
anthy_ucs_to_euc(int uc)
{
  int r = search(u2e_index, uc, EUC_GETA);
  if (r > UINT32_C(65536)) {
    return EUC_GETA;
  }
  return r;
}
#endif

#if 0		/* Patched by G-HAL, Fri,12 Jun,2009 */
int
anthy_get_xchar_type(const xchar xc)
#else
enum XCT_t anthy_get_xchar_type( const xchar xc )
#endif
{
  int t = find_xchar_type(xc);
  if (xc > UINT8_C(47) && xc < UINT8_C(58)) {
    t |= XCT_NUM;
  }
  if (xc < UINT8_C(128)) {
    t |= XCT_ASCII;
  }
  if (is_hira(xc)) {
    t |= XCT_HIRA;
  }
  if (is_kata(xc)) {
    t |= XCT_KATA;
  }
  if (is_symbol(xc)) {
    if (!(t & XCT_OPEN) && !(t & XCT_CLOSE)) {
      t |= XCT_SYMBOL;
    }
  }
  if (is_kanji(xc)) {
    t |= XCT_KANJI;
  }
  return t;
}

#if 1		/* Patched by G-HAL, Tue,19 May,2009 */
/** 50ɽʸ
 *@param		xc		ʸʸ
 *@return				ʸ
 */
enum XCT_t anthy_get_xchar_type50( const xchar xc )
{
  enum XCT_t t = find_xchar_type( xc );
  if (xc > UINT8_C(47) && xc < UINT8_C(58)) {
    t |= XCT_NUM;
  }
  if (xc < UINT8_C(128)) {
    t |= XCT_ASCII;
  }
  if (is_hira(xc)) {
    t |= find_xchar_type50( xc );
    t |= XCT_HIRA;
  }
  if (is_kata(xc)) {
    t |= find_xchar_type50( anthy_xchar_kata_to_hira(xc) );
    t |= XCT_KATA;
  }
  if (is_symbol(xc)) {
    if (!(t & XCT_OPEN) && !(t & XCT_CLOSE)) {
      t |= XCT_SYMBOL;
    }
  }
  if (is_kanji(xc)) {
    t |= XCT_KANJI;
  }
  return t;
}
#endif


#if 0		/* Patched by G-HAL, Fri,12 Jun,2009 */
int
anthy_get_xstr_type(const xstr *xs)
{
  int i, t = XCT_ALL;
  for (i = 0; i < xs->len; i++) {
    t &= anthy_get_xchar_type(xs->str[i]);
  }
  return t;
}
#else /* xstr.c ذư */
#endif

int
anthy_xchar_to_num(xchar xc)
{
  switch (xc) {
  case WIDE_0:return 0;
  case WIDE_1:return 1;
  case WIDE_2:return 2;
  case WIDE_3:return 3;
  case WIDE_4:return 4;
  case WIDE_5:return 5;
  case WIDE_6:return 6;
  case WIDE_7:return 7;
  case WIDE_8:return 8;
  case WIDE_9:return 9;
  }
  if (xc >= '0' && xc <= '9') {
    return xc - (int)'0';
  }
  return -1;
}

xchar
anthy_xchar_wide_num_to_num(xchar c)
{
  switch (c) {
  case WIDE_0:return '0';
  case WIDE_1:return '1';
  case WIDE_2:return '2';
  case WIDE_3:return '3';
  case WIDE_4:return '4';
  case WIDE_5:return '5';
  case WIDE_6:return '6';
  case WIDE_7:return '7';
  case WIDE_8:return '8';
  case WIDE_9:return '9';
  default:return c;
  }
}

#if 0	/* Patched by G-HAL, Mon,25 May,2009 */
void
anthy_init_xchar_tab(void)
{
}
#else
int anthy_init_xchar_tab( void )
{
 #if !defined(USE_ICONV)	/* Patched by G-HAL, Tue,09 Jun,2009 */
 #else
  { struct half_kana_table* tab;
    for (tab = half_kana_tab; tab->src; ++tab) {
      tab->dst_xc = anthy_euc_to_ucs( tab->dst );
      tab->mod_xc = anthy_euc_to_ucs( tab->mod );
    }
  }
 #endif
  return;
}

int anthy_quit_xchar_tab( void )
{
  return;
}
#endif


#else /* !defined(USE_ICONV) */


/**@name ʸμ̼ѴΥå @{ */

/** ʸμ̼ѴΥå壱ʸʬ
 *@comment
 *	XCT_KANJI ̤¿Τǡ
 *	̤ΥǡǥåäƤʸꤷƤʤ
 *	is_kanji() Ѥ
 */
struct UCS_char_cache_t {
  enum XCT_t	type;		/**< ʸμ */
 #if defined(UCS_CHAR_CACHE_HAVE_NUM)
  int		num;		/**< ͤѴɾ */
 #endif
  xchar		kana_swap;	/**< ʿ̾ʤؤʪ */
  xchar		conv_dst;	/**< ʸѴη̡ʼˡHalf-Width/Full-Width ؤʪFull-Width num  ANK ѴʪHalf-Width  ѴΥʬ */
  xchar		conv_mod;	/**< ʸѴη̡ʽ°ˡHalf-Width  ѴȾʬ */
};


/** UCS-4 bit7-0
 */
typedef		struct UCS_char_cache_t		UCS_char_cache_bit7to0_t[256];

/** UCS-4 bit15-8
 */
typedef		UCS_char_cache_bit7to0_t*	(UCS_char_cache_bit15to8_t[256]);

/** UCS-4 bit23-16
 */
typedef		UCS_char_cache_bit15to8_t*	(UCS_char_cache_bit23to16_t[256]);

/** UCS-4 bit31-24
 */
typedef		UCS_char_cache_bit23to16_t*	(UCS_char_cache_bit31to24_t[256]);


/** UCS-2 Υå
 */
static UCS_char_cache_bit15to8_t	UCS2_cache;

/** UCS-4 Υå
 */
static UCS_char_cache_bit31to24_t	UCS4_cache;

/** @} */



/**@name Ѵơ֥ @{ */


/** ʸUCS4  ͤΥơ֥
 */
struct xchar_num_ent {
  const xchar xc;			/**< оݤʸ */
  const int num;			/**< ꤹ */
  const enum XCT_t type;		/**< ꤹ */
  const xchar conv_dst;			/**< ꤹ */
};

/** ʸοѴ */
static const struct xchar_num_ent xchar_num_per_char[] = {
  { ANK_0, 0, XCT_NUM, WIDE_0 },
  { ANK_1, 1, XCT_NUM, WIDE_1 },
  { ANK_2, 2, XCT_NUM, WIDE_2 },
  { ANK_3, 3, XCT_NUM, WIDE_3 },
  { ANK_4, 4, XCT_NUM, WIDE_4 },
  { ANK_5, 5, XCT_NUM, WIDE_5 },
  { ANK_6, 6, XCT_NUM, WIDE_6 },
  { ANK_7, 7, XCT_NUM, WIDE_7 },
  { ANK_8, 8, XCT_NUM, WIDE_8 },
  { ANK_9, 9, XCT_NUM, WIDE_9 },
  { WIDE_0, 0, XCT_WIDENUM, ANK_0 },
  { WIDE_1, 1, XCT_WIDENUM, ANK_1 },
  { WIDE_2, 2, XCT_WIDENUM, ANK_2 },
  { WIDE_3, 3, XCT_WIDENUM, ANK_3 },
  { WIDE_4, 4, XCT_WIDENUM, ANK_4 },
  { WIDE_5, 5, XCT_WIDENUM, ANK_5 },
  { WIDE_6, 6, XCT_WIDENUM, ANK_6 },
  { WIDE_7, 7, XCT_WIDENUM, ANK_7 },
  { WIDE_8, 8, XCT_WIDENUM, ANK_8 },
  { WIDE_9, 9, XCT_WIDENUM, ANK_9 },
  { 0, -1, XCT_NONE, '\0' },
};


/** ʸʸľܥ˵ҡ  XCT_t Υơ֥
 */
struct char_xct_ent {
  const char* const chr;		/**< оݤʸ */
  const enum XCT_t type;		/**< ꤹ */
};

/** ʸ XCT_t  */
static const struct char_xct_ent char_tab_per_char[] = {
  {"", XCT_HIRA | XCT_KATA },
  {"", XCT_HIRA | XCT_KATA },
  {"", XCT_KATA },
  {"", XCT_KATA },
  {"", XCT_HIRA },
  {"", XCT_HIRA },
  {"", XCT_HIRA | XCT_KATA | XCT_KANJI },
  {"", XCT_KANJI },
  {"", XCT_KANJI },
  {"", XCT_HIRA | XCT_KATA },


  {" ", XCT_DONTLEARN }, {"", XCT_DONTLEARN },

  {"!", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"\"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"#", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"$", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"%", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"&", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"'", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"(", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {")", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"*", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"+", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {",", XCT_DONTLEARN }, {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"-", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {".", XCT_DONTLEARN }, {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"/", XCT_DONTLEARN }, {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },

  {"0", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"1", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"2", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"3", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"4", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"5", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"6", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"7", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"8", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"9", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {":", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {";", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"<", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"=", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {">", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"?", XCT_DONTLEARN }, {"", XCT_DONTLEARN },

  {"@", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"[", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"\\", XCT_DONTLEARN }, {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"]", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"^", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"_", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"`", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"{", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"|", XCT_DONTLEARN }, {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"}", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"~", XCT_DONTLEARN }, {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },

  {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },
  {"", XCT_DONTLEARN }, {"", XCT_DONTLEARN },

  {NULL, 0},
};

#if defined(ICONV_EUCJP0213)
/** ʸEUC JIS X 0213  XCT_t Υơ֥
 */
struct eucjp0213_xct_ent {
  const unsigned char chr[MAX_BYTES_PER_XCHAR + MAX_BYTES_BASE];	/**< оݤʸ */
  const enum XCT_t type;		/**< ꤹ */
};

/** ʸ XCT_t  */
static const struct eucjp0213_xct_ent eucjp0213_tab_per_char[] = {
  {{UINT8_C(0xA3),UINT8_C(0xA1),'\x0'}, XCT_SYMBOL },	/* ȴѡ */
  {{UINT8_C(0xA3),UINT8_C(0xA2),'\x0'}, XCT_SYMBOL },	/* ɤ걦ѡ */
  {{UINT8_C(0xA3),UINT8_C(0xA3),'\x0'}, XCT_SYMBOL },	/* ȴѡ */
  {{UINT8_C(0xA3),UINT8_C(0xA4),'\x0'}, XCT_SYMBOL },	/* ɤ꺸ѡ */
  {{UINT8_C(0xA3),UINT8_C(0xA5),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xA6),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xA7),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xA8),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xA9),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xAA),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xAB),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xAC),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xAD),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xAE),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xAF),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xBA),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xBB),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xBC),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xBD),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xBE),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xBF),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xC0),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xDB),'\x0'}, XCT_SYMBOL },	/* ޥץ顩 */
  {{UINT8_C(0xA3),UINT8_C(0xDC),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xDD),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xDE),'\x0'}, XCT_SYMBOL },	/* HP */
  {{UINT8_C(0xA3),UINT8_C(0xDF),'\x0'}, XCT_SYMBOL },	/* 桼ȡ */
  {{UINT8_C(0xA3),UINT8_C(0xE0),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xFB),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xFC),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xFD),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA3),UINT8_C(0xFE),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA6),UINT8_C(0xB9),'\x0'}, XCT_SYMBOL },	/* ȴڡɡ */
  {{UINT8_C(0xA6),UINT8_C(0xBA),'\x0'}, XCT_SYMBOL },	/* ɤꥹڡɡ */
  {{UINT8_C(0xA6),UINT8_C(0xBB),'\x0'}, XCT_SYMBOL },	/* ȴ䡩 */
  {{UINT8_C(0xA6),UINT8_C(0xBC),'\x0'}, XCT_SYMBOL },	/* ɤ䡩 */
  {{UINT8_C(0xA6),UINT8_C(0xBD),'\x0'}, XCT_SYMBOL },	/* ȴϡȡ */
  {{UINT8_C(0xA6),UINT8_C(0xBE),'\x0'}, XCT_SYMBOL },	/* ɤϡȡ */
  {{UINT8_C(0xA6),UINT8_C(0xBF),'\x0'}, XCT_SYMBOL },	/* ȴ֡ */
  {{UINT8_C(0xA6),UINT8_C(0xC0),'\x0'}, XCT_SYMBOL },	/* ɤꥯ֡ */
  {{UINT8_C(0xA6),UINT8_C(0xE4),'\x0'}, XCT_SYMBOL },	/* ȴΥޡ */
  {{UINT8_C(0xA6),UINT8_C(0xE5),'\x0'}, XCT_SYMBOL },	/* ɤ꾭Υޡ */
  {{UINT8_C(0xA6),UINT8_C(0xE6),'\x0'}, XCT_SYMBOL },	/* ͹ء */
  {{UINT8_C(0xA6),UINT8_C(0xE7),'\x0'}, XCT_SYMBOL },	/* á */
  {{UINT8_C(0xA6),UINT8_C(0xE8),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA6),UINT8_C(0xE9),'\x0'}, XCT_SYMBOL },	/* ޡ */
  {{UINT8_C(0xA6),UINT8_C(0xEA),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA6),UINT8_C(0xEB),'\x0'}, XCT_SYMBOL },	/* 㡩 */
  {{UINT8_C(0xA6),UINT8_C(0xEC),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA6),UINT8_C(0xED),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA6),UINT8_C(0xEE),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xEF),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF0),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF1),'\x0'}, XCT_KATA },	/* Ȥξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF2),'\x0'}, XCT_KATA },	/* ̤ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF3),'\x0'}, XCT_KATA },	/* Ϥξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF4),'\x0'}, XCT_KATA },	/* Ҥξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF5),'\x0'}, XCT_KATA },	/* դξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF6),'\x0'}, XCT_KATA },	/* ؤξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF7),'\x0'}, XCT_KATA },	/* ۤξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF8),'\x0'}, XCT_KATA },	/* פξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xF9),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xFA),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xFB),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xFC),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xFD),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA6),UINT8_C(0xFE),'\x0'}, XCT_KATA },	/* ξʸ */
  {{UINT8_C(0xA7),UINT8_C(0xF2),'\x0'}, XCT_KATA },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF3),'\x0'}, XCT_KATA },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF4),'\x0'}, XCT_KATA },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF5),'\x0'}, XCT_KATA },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF6),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF7),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF8),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xF9),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xFA),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xFB),'\x0'}, XCT_SYMBOL },	/* åޡ */
  {{UINT8_C(0xA7),UINT8_C(0xFC),'\x0'}, XCT_SYMBOL },	/*  */
  {{UINT8_C(0xA7),UINT8_C(0xFD),'\x0'}, XCT_SYMBOL },	/* ڡ桩 */
  {{UINT8_C(0xA7),UINT8_C(0xFE),'\x0'}, XCT_SYMBOL },	/* ԡ */
  {{'\x0'}, 0},
};
#endif

/** ʸUCS4  XCT_t Υơ֥
 */
struct xchar_xct_ent {
  const xchar xc;			/**< оݤʸ */
  const enum XCT_t type;		/**< ꤹ */
};

/** ʸ XCT_t  */
static const struct xchar_xct_ent xchar_tab_per_char[] = {
  {UINT16_C(0x3013), XCT_SYMBOL },	/* , ɲ */

  {UINT16_C(0xFF40), XCT_OPEN }, /* , ɲ */
  {UINT16_C(0x2032), XCT_CLOSE}, /* , ɲ */
  {UINT16_C(0x2018), XCT_OPEN }, /* , ɲ */
  {UINT16_C(0x2019), XCT_CLOSE}, /* , ɲ */
  {UINT16_C(0x201C), XCT_OPEN }, /* , ɲ */
  {UINT16_C(0x201D), XCT_CLOSE}, /* , ʸɤְäƤȻפΤǽ */
  {UINT16_C(0xFF08), XCT_OPEN }, /*  */
  {UINT16_C(0xFF09), XCT_CLOSE}, /*  */
  {UINT16_C(0x3014), XCT_OPEN }, /*  */
  {UINT16_C(0x3015), XCT_CLOSE}, /*  */
  {UINT16_C(0xFF3B), XCT_OPEN }, /*  */
  {UINT16_C(0xFF3D), XCT_CLOSE}, /*  */
  {UINT16_C(0xFF5B), XCT_OPEN }, /*  */
  {UINT16_C(0xFF5D), XCT_CLOSE}, /*  */
  {UINT16_C(0x3008), XCT_OPEN }, /*  */
  {UINT16_C(0x3009), XCT_CLOSE}, /*  */
  {UINT16_C(0x300A), XCT_OPEN }, /*  */
  {UINT16_C(0x300B), XCT_CLOSE}, /*  */
  {UINT16_C(0x300C), XCT_OPEN }, /*  */
  {UINT16_C(0x300D), XCT_CLOSE}, /*  */
  {UINT16_C(0x300E), XCT_OPEN }, /*  */
  {UINT16_C(0x300F), XCT_CLOSE}, /*  */
  {UINT16_C(0x3010), XCT_OPEN }, /*  */
  {UINT16_C(0x3011), XCT_CLOSE}, /*  */
  {UINT16_C(0x2033), XCT_CLOSE}, /* , Added by G-HAL, Mon,24 Nov,2008 */
  {UINT16_C(0x3001), XCT_PUNCTUATION},  /*  */
  {UINT16_C(0x3002), XCT_PUNCTUATION},  /*  */
  {UINT16_C(0xFF0C), XCT_PUNCTUATION},  /*  */
  {UINT16_C(0xFF0E), XCT_PUNCTUATION},  /*  */
  {UINT16_C(0xFF1F), XCT_PUNCTUATION},  /*  */
  {UINT16_C(0xFF01), XCT_PUNCTUATION},  /*  */

  {UINT8_C(0x28), XCT_OPEN}, /* ( */
  {UINT8_C(0x5B), XCT_OPEN}, /* [ */
  {UINT8_C(0x29), XCT_CLOSE}, /* ) */
  {UINT8_C(0x5D), XCT_CLOSE}, /* ] */
  {HK_TO, XCT_DEP},/*  */
  {HK_HA, XCT_DEP},/*  */
  {HK_NO, XCT_DEP},/*  */
  {HK_NI, XCT_DEP},/*  */
  {HK_GA, XCT_DEP},/*  */
  {HK_WO, XCT_DEP},/*  */
  {HK_DDOT, XCT_PART},
  {HK_XA, XCT_PART},
  {HK_XI, XCT_PART},
  {HK_XU, XCT_PART},
  {HK_XE, XCT_PART},
  {HK_XO, XCT_PART},
  {HK_XYA, XCT_PART},
  {HK_XYU, XCT_PART},
  {HK_XYO, XCT_PART},
  {HK_TT, XCT_PART},
  {HK_XWA, XCT_PART}	/* Patched by G-HAL, Tue,19 May,2009 */,
  {HK_BAR, XCT_PART}	/* Patched by G-HAL, Tue,19 May,2009 */,

  {UINT16_C(0x3094), XCT_KANA_U },	/*  */
  {UINT16_C(0x3095), XCT_KANA_A },	/* ξʸ */
  {UINT16_C(0x3096), XCT_KANA_E },	/* ξʸ */
/*  {, XCT_KANA_A },*/	/* Ⱦ */
/*  {, XCT_KANA_I },*/	/* Ⱦ */
/*  {, XCT_KANA_U },*/	/* Ⱦ */
/*  {, XCT_KANA_E },*/	/* Ⱦ */
/*  {, XCT_KANA_O },*/	/* Ⱦ */

 {UINT16_C(0x30F4), XCT_KANA_U },	/*  */
 {UINT16_C(0x30F5), XCT_KANA_A },	/* ξʸ */
 {UINT16_C(0x30F6), XCT_KANA_E },	/* ξʸ */
 /*  {, XCT_KANA_A },*/	/* Ⱦ */
 /*  {, XCT_KANA_I },*/	/* Ⱦ */
 /*  {, XCT_KANA_U },*/	/* Ⱦ */
 /*  {, XCT_KANA_E },*/	/* Ⱦ */
 /*  {, XCT_KANA_O },*/	/* Ⱦ */
 /*  {, XCT_KANA_E },*/	/* Ⱦ */
 /*  {, XCT_KANA_U },*/	/* ĤȾ */
 /*  {, XCT_KANA_O },*/	/* ȤȾ */

  {UINT16_C(0x31F0), XCT_KATA | XCT_KANA_U },	/* ξʸ */
  {UINT16_C(0x31F1), XCT_KATA | XCT_KANA_I },	/* ξʸ */
  {UINT16_C(0x31F2), XCT_KATA | XCT_KANA_U },	/* ξʸ */
  {UINT16_C(0x31F3), XCT_KATA | XCT_KANA_O },	/* Ȥξʸ */
  {UINT16_C(0x31F4), XCT_KATA | XCT_KANA_U },	/* ̤ξʸ */
  {UINT16_C(0x31F5), XCT_KATA | XCT_KANA_A },	/* Ϥξʸ */
  {UINT16_C(0x31F6), XCT_KATA | XCT_KANA_I },	/* Ҥξʸ */
  {UINT16_C(0x31F7), XCT_KATA | XCT_KANA_U },	/* դξʸ */
  {UINT16_C(0x31F8), XCT_KATA | XCT_KANA_E },	/* ؤξʸ */
  {UINT16_C(0x31F9), XCT_KATA | XCT_KANA_O },	/* ۤξʸ */
  {UINT16_C(0x31FA), XCT_KATA | XCT_KANA_U },	/* ξʸ */
  {UINT16_C(0x31FB), XCT_KATA | XCT_KANA_A },	/* ξʸ */
  {UINT16_C(0x31FC), XCT_KATA | XCT_KANA_I },	/* ξʸ */
  {UINT16_C(0x31FD), XCT_KATA | XCT_KANA_U },	/* ξʸ */
  {UINT16_C(0x31FE), XCT_KATA | XCT_KANA_E },	/* ξʸ */
  {UINT16_C(0x31FF), XCT_KATA | XCT_KANA_O },	/* ξʸ */

  {0, 0},
};

/**  XCT_t ͡ʿ̾ξꤵ
 * Patched by G-HAL, Tue,19 May,2009 */
static const struct xchar_xct_ent xchar_tab_per_50[] = {
  { HK_XA, XCT_KANA_A | XCT_PART | XCT_PART_A},
  { HK_XI, XCT_KANA_I | XCT_PART | XCT_PART_I},
  { HK_XU, XCT_KANA_U | XCT_PART | XCT_PART_U},
  { HK_XE, XCT_KANA_E | XCT_PART | XCT_PART_E},
  { HK_XO, XCT_KANA_O | XCT_PART | XCT_PART_O},

  { HK_TT, XCT_KANA_U | XCT_PART | XCT_PART_MASK},

  {HK_XYA, XCT_KANA_A | XCT_PART},
  {HK_XYU, XCT_KANA_U | XCT_PART},
  {HK_XYO, XCT_KANA_O | XCT_PART},

  {HK_XWA, XCT_KANA_A | XCT_PART},

  {HK_BAR, XCT_KANA_MASK | XCT_PART | XCT_PART_MASK},
  {HK_DDOT, XCT_KANA_MASK | XCT_PART | XCT_PART_MASK},


  { HK_A, XCT_KANA_A},
  { HK_I, XCT_KANA_I},
  { HK_U, XCT_KANA_U},
  { HK_E, XCT_KANA_E},
  { HK_O, XCT_KANA_O},

  {HK_KA, XCT_KANA_A},
  {HK_KI, XCT_KANA_I},
  {HK_KU, XCT_KANA_U},
  {HK_KE, XCT_KANA_E},
  {HK_KO, XCT_KANA_O},

  {HK_GA, XCT_KANA_A},
  {HK_GI, XCT_KANA_I},
  {HK_GU, XCT_KANA_U},
  {HK_GE, XCT_KANA_E},
  {HK_GO, XCT_KANA_O},

  {HK_SA, XCT_KANA_A},
  {HK_SI, XCT_KANA_I},
  {HK_SU, XCT_KANA_U},
  {HK_SE, XCT_KANA_E},
  {HK_SO, XCT_KANA_O},

  {HK_ZA, XCT_KANA_A},
  {HK_ZI, XCT_KANA_I},
  {HK_ZU, XCT_KANA_U},
  {HK_ZE, XCT_KANA_E},
  {HK_ZO, XCT_KANA_O},

  {HK_TA, XCT_KANA_A},
  {HK_TI, XCT_KANA_I},
  {HK_TU, XCT_KANA_U},
  {HK_TE, XCT_KANA_E},
  {HK_TO, XCT_KANA_O},

  {HK_DA, XCT_KANA_A},
  {HK_DI, XCT_KANA_I},
  {HK_DU, XCT_KANA_U},
  {HK_DE, XCT_KANA_E},
  {HK_DO, XCT_KANA_O},

  {HK_NA, XCT_KANA_A},
  {HK_NI, XCT_KANA_I},
  {HK_NU, XCT_KANA_U},
  {HK_NE, XCT_KANA_E},
  {HK_NO, XCT_KANA_O},

  {HK_HA, XCT_KANA_A},
  {HK_HI, XCT_KANA_I},
  {HK_HU, XCT_KANA_U},
  {HK_HE, XCT_KANA_E},
  {HK_HO, XCT_KANA_O},

  {HK_BA, XCT_KANA_A},
  {HK_BI, XCT_KANA_I},
  {HK_BU, XCT_KANA_U},
  {HK_BE, XCT_KANA_E},
  {HK_BO, XCT_KANA_O},

  {HK_PA, XCT_KANA_A},
  {HK_PI, XCT_KANA_I},
  {HK_PU, XCT_KANA_U},
  {HK_PE, XCT_KANA_E},
  {HK_PO, XCT_KANA_O},

  {HK_MA, XCT_KANA_A},
  {HK_MI, XCT_KANA_I},
  {HK_MU, XCT_KANA_U},
  {HK_ME, XCT_KANA_E},
  {HK_MO, XCT_KANA_O},

  {HK_YA, XCT_KANA_A},
  {HK_YU, XCT_KANA_U},
  {HK_YO, XCT_KANA_O},

  {HK_RA, XCT_KANA_A},
  {HK_RI, XCT_KANA_I},
  {HK_RU, XCT_KANA_U},
  {HK_RE, XCT_KANA_E},
  {HK_RO, XCT_KANA_O},

  {HK_WA, XCT_KANA_A},
  {HK_WI, XCT_KANA_I},
  {HK_WE, XCT_KANA_E},
  {HK_WO, XCT_KANA_O},

  {   HK_N, XCT_KANA_MASK},

  {0, 0},
};


/** ʸUCS4  ʸUCS4
 */
struct xchar_conv_per_char {
  const xchar xc;
  const uint32_t conv_dst;
  const uint32_t conv_mod;
};

#define	DDOT	UINT16_C(0x8EDE)
#define	CIRCLE	UINT16_C(0x8EDF)
/** ʿ̾  Half-Width  */
static const struct xchar_conv_per_char half_kana_tab[] = {
  {HK_A , UINT16_C(0x8EB1),0},
  {HK_I , UINT16_C(0x8EB2),0},
  {HK_U , UINT16_C(0x8EB3),0},
  {HK_E , UINT16_C(0x8EB4),0},
  {HK_O , UINT16_C(0x8EB5),0},
  {HK_KA, UINT16_C(0x8EB6),0},
  {HK_KI, UINT16_C(0x8EB7),0},
  {HK_KU, UINT16_C(0x8EB8),0},
  {HK_KE, UINT16_C(0x8EB9),0},
  {HK_KO, UINT16_C(0x8EBA),0},
  {HK_SA, UINT16_C(0x8EBB),0},
  {HK_SI, UINT16_C(0x8EBC),0},
  {HK_SU, UINT16_C(0x8EBD),0},
  {HK_SE, UINT16_C(0x8EBE),0},
  {HK_SO, UINT16_C(0x8EBF),0},
  {HK_TA, UINT16_C(0x8EC0),0},
  {HK_TI, UINT16_C(0x8EC1),0},
  {HK_TU, UINT16_C(0x8EC2),0},
  {HK_TE, UINT16_C(0x8EC3),0},
  {HK_TO, UINT16_C(0x8EC4),0},
  {HK_NA, UINT16_C(0x8EC5),0},
  {HK_NI, UINT16_C(0x8EC6),0},
  {HK_NU, UINT16_C(0x8EC7),0},
  {HK_NE, UINT16_C(0x8EC8),0},
  {HK_NO, UINT16_C(0x8EC9),0},
  {HK_HA, UINT16_C(0x8ECA),0},
  {HK_HI, UINT16_C(0x8ECB),0},
  {HK_HU, UINT16_C(0x8ECC),0},
  {HK_HE, UINT16_C(0x8ECD),0},
  {HK_HO, UINT16_C(0x8ECE),0},
  {HK_MA, UINT16_C(0x8ECF),0},
  {HK_MI, UINT16_C(0x8ED0),0},
  {HK_MU, UINT16_C(0x8ED1),0},
  {HK_ME, UINT16_C(0x8ED2),0},
  {HK_MO, UINT16_C(0x8ED3),0},
  {HK_YA, UINT16_C(0x8ED4),0},
  {HK_YU, UINT16_C(0x8ED5),0},
  {HK_YO, UINT16_C(0x8ED6),0},
  {HK_RA, UINT16_C(0x8ED7),0},
  {HK_RI, UINT16_C(0x8ED8),0},
  {HK_RU, UINT16_C(0x8ED9),0},
  {HK_RE, UINT16_C(0x8EDA),0},
  {HK_RO, UINT16_C(0x8EDB),0},
  {HK_WA, UINT16_C(0x8EDC),0},
  {HK_WI, 0,0},
  {HK_WE, 0,0},
  {HK_WO, UINT16_C(0x8EA6),0},
  {HK_N , UINT16_C(0x8EDD),0},
  {HK_TT, UINT16_C(0x8EAF),0},
  {HK_XA, UINT16_C(0x8EA7),0},
  {HK_XI, UINT16_C(0x8EA8),0},
  {HK_XU, UINT16_C(0x8EA9),0},
  {HK_XE, UINT16_C(0x8EAA),0},
  {HK_XO, UINT16_C(0x8EAB),0},
  {HK_GA, UINT16_C(0x8EB6),DDOT},
  {HK_GI, UINT16_C(0x8EB7),DDOT},
  {HK_GU, UINT16_C(0x8EB8),DDOT},
  {HK_GE, UINT16_C(0x8EB9),DDOT},
  {HK_GO, UINT16_C(0x8EBA),DDOT},
  {HK_ZA, UINT16_C(0x8EBB),DDOT},
  {HK_ZI, UINT16_C(0x8EBC),DDOT},
  {HK_ZU, UINT16_C(0x8EBD),DDOT},
  {HK_ZE, UINT16_C(0x8EBE),DDOT},
  {HK_ZO, UINT16_C(0x8EBF),DDOT},
  {HK_DA, UINT16_C(0x8EC0),DDOT},
  {HK_DI, UINT16_C(0x8EC1),DDOT},
  {HK_DU, UINT16_C(0x8EC2),DDOT},
  {HK_DE, UINT16_C(0x8EC3),DDOT},
  {HK_DO, UINT16_C(0x8EC4),DDOT},
  {HK_BA, UINT16_C(0x8ECA),DDOT},
  {HK_BI, UINT16_C(0x8ECB),DDOT},
  {HK_BU, UINT16_C(0x8ECC),DDOT},
  {HK_BE, UINT16_C(0x8ECD),DDOT},
  {HK_BO, UINT16_C(0x8ECE),DDOT},
  {HK_PA, UINT16_C(0x8ECA),CIRCLE},
  {HK_PI, UINT16_C(0x8ECB),CIRCLE},
  {HK_PU, UINT16_C(0x8ECC),CIRCLE},
  {HK_PE, UINT16_C(0x8ECD),CIRCLE},
  {HK_PO, UINT16_C(0x8ECE),CIRCLE},
  {HK_XYA, UINT16_C(0x8EAC),0},
  {HK_XYU, UINT16_C(0x8EAD),0},
  {HK_XYO, UINT16_C(0x8EAE),0},
  {HK_XWA, 0,0},
  {HK_DDOT, DDOT,0},
  {UINT16_C(0x309C), CIRCLE,0},
  {HK_BAR, UINT16_C(0x8EB0),0},
  {UINT16_C(0x3099), DDOT,0},	/* ηʸ */
  {UINT16_C(0x309A), CIRCLE,0},	/* Ⱦηʸ */
  {0, 0x0000,0}
};


/** ʸUCS4ˤбڥ
 */
struct xchar_xchar_ent {
  const xchar xc1;
  const xchar xc2;
};

/** Half-Width / Full-Width ؤ */
static const struct xchar_xchar_ent half_wide_tab[] = {
  {'!',  UINT16_C(0xFF01)},
  {'\"', UINT16_C(0x201D)},
  {'#',  UINT16_C(0xFF03)},
  {'$',  UINT16_C(0xFF04)},
  {'%',  UINT16_C(0xFF05)},
  {'&',  UINT16_C(0xFF06)},
  {'\'', UINT16_C(0x2019)},
  {'(',  UINT16_C(0xFF08)},
  {')',  UINT16_C(0xFF09)},
  {'*',  UINT16_C(0xFF0A)},
  {'+',  UINT16_C(0xFF0B)},
  {',',  UINT16_C(0xFF0C)},
  {'-',  UINT16_C(0x2212)},	/* ǤǤ UINT16_C(0xFF0D) */
  {'.',  UINT16_C(0xFF0E)},
  {'/',  UINT16_C(0xFF0F)},
  {':',  UINT16_C(0xFF1A)},
  {';',  UINT16_C(0xFF1B)},
  {'<',  UINT16_C(0xFF1C)},
  {'=',  UINT16_C(0xFF1D)},
  {'>',  UINT16_C(0xFF1E)},
  {'?',  UINT16_C(0xFF1F)},
  {'@',  UINT16_C(0xFF20)},	/* UINT8_C(0x40) */
  {'[',  UINT16_C(0xFF3B)},
  {'\\', UINT16_C(0xFF3C)},
  {']',  UINT16_C(0xFF3D)},
  {'^',  UINT16_C(0xFF3E)},
  {'_',  UINT16_C(0xFF3F)},
  {'`',  UINT16_C(0xFF40)},	/* UINT8_C(0x60) */
  {'{',  UINT16_C(0xFF5B)},
  {'|',  UINT16_C(0xFF5C)},
  {'}',  UINT16_C(0xFF5D)},
  {'~',  UINT16_C(0xFF5E)},
  {0, 0}
};

/** ʿ̾ʤؤʸܤʿ̾ʸܤʡ */
static const struct xchar_xchar_ent hira_kata_tab[] = {
  { UINT16_C(0x3094), UINT16_C(0x30F4) },	/*  */
  { UINT16_C(0x3095), UINT16_C(0x30F5) },	/* ξʸ */
  { UINT16_C(0x3096), UINT16_C(0x30F6) },	/* ξʸ */
  { UINT16_C(0x309D), UINT16_C(0x30FD) },	/*  */
  { UINT16_C(0x309E), UINT16_C(0x30FE) },	/*  */
/*  { ,  },*/	/* Ⱦ */
/*  { ,  },*/	/* Ⱦ */
/*  { ,  },*/	/* Ⱦ */
/*  { ,  },*/	/* Ⱦ */
/*  { ,  },*/	/* Ⱦ */
  { 0, 0}
};

/** @} */



/**@name ʸμ̤Ƚ @{ */

/** ꤵ줿ʸݤȽ
 *@param		xc			Ƚꤹʸ
 *@retval		0			
 *@retval		1			
 *
 *@comment
 *	Patched by G-HAL
 *	Sun,14 Jun,2009
 *	Thu,14 Oct,2010
 */
static int is_kanji(xchar xc)
{
  if ((UINT32_C(0x3400) <= xc) && (xc <= UINT32_C(0x4DFF))) {	/* CJKĥA */
    return 1;
  }
  if ((UINT32_C(0x4E00) <= xc) && (xc <= UINT32_C(0x9FFF))) {	/* CJK */
    return 1;
  }
  if ((UINT32_C(0xF900) <= xc) && (xc <= UINT32_C(0xFAFF))) {	/* CJKߴ */
    return 1;
  }
  if ((UINT32_C(0x20000) <= xc) && (xc <= UINT32_C(0x2A6FF))) {	/* CJKĥBJIS X 0213ޤ */
    return 1;
  }
  if ((UINT32_C(0x2F800) <= xc) && (xc <= UINT32_C(0x2FA1F))) {	/* CJKߴ */
    return 1;
  }
  return 0;
}

/** @} */



/**@name å @{ */

/** åɲ
 *@param		xc			ʸ
 *@retval		NULL			顼­
 *@retval		!= NULL			
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,13 Jun,2009 - Sun,14 Jun,2009
 *	Thu,14 Oct,2010
 */
static struct UCS_char_cache_t* const add_UCS_char_cache( xchar xc )
{
  size_t    i;
  xchar     xc_tmp;

  if (xc <= UINT32_C(0xFFFF)) {
    const uint8_t o3 = (xc & UINT32_C(0xFF00)) >> 8;
    UCS_char_cache_bit7to0_t* ptr_7to0 = UCS2_cache[o3];
    if (NULL == ptr_7to0) {
      ptr_7to0 = calloc( 1, sizeof(*ptr_7to0) );
      if (NULL == ptr_7to0) {
	return NULL;
      }
      UCS2_cache[o3] = ptr_7to0;

      xc_tmp = xc & UINT32_C(0xFFFFFF00);
      for (i = 0; i < _number_(*ptr_7to0); ++i, ++xc_tmp) {
	if (is_kanji(xc_tmp)) {
	  (*ptr_7to0)[i].type |= XCT_KANJI;
	}
      }
    }
    { const uint8_t o4 = (xc & UINT32_C(0x00FF)) >> 0;
      return &((*ptr_7to0)[o4]);
    }
  } else {
    const uint8_t o1 = (xc & UINT32_C(0xFF000000)) >> 24;
    UCS_char_cache_bit23to16_t* ptr_23to16 = UCS4_cache[o1];
    if (NULL == ptr_23to16) {
      ptr_23to16 = calloc( 1, sizeof(*ptr_23to16) );
      if (NULL == ptr_23to16) {
	return NULL;
      }
      UCS4_cache[o1] = ptr_23to16;
    }
    {
      const uint8_t o2 = (xc & UINT32_C(0x00FF0000)) >> 16;
      UCS_char_cache_bit15to8_t* ptr_15to8 = (*ptr_23to16)[o2];
      if (NULL == ptr_15to8) {
	ptr_15to8 = calloc( 1, sizeof(*ptr_15to8) );
	if (NULL == ptr_15to8) {
	  return NULL;
	}
	(*ptr_23to16)[o2] = ptr_15to8;
      }
      {
	const uint8_t o3 = (xc & UINT32_C(0x0000FF00)) >> 8;
	UCS_char_cache_bit7to0_t* ptr_7to0 = (*ptr_15to8)[o3];
	if (NULL == ptr_7to0) {
	  ptr_7to0 = calloc( 1, sizeof(*ptr_7to0) );
	  if (NULL == ptr_7to0) {
	    return NULL;
	  }
	  (*ptr_15to8)[o3] = ptr_7to0;

	  xc_tmp = xc & UINT32_C(0xFFFFFF00);
	  for (i = 0; i < _number_(*ptr_7to0); ++i, ++xc_tmp) {
	    if (is_kanji(xc_tmp)) {
	      (*ptr_7to0)[i].type |= XCT_KANJI;
	    }
	  }
	}
	{
	  const uint8_t o4 = (xc & UINT32_C(0x000000FF)) >> 0;
	  return &((*ptr_7to0)[o4]);
	}
      }
    }
  }
}

/** å򸡺
 *@param		xc			ʸ
 *@retval		NULL			̵
 *@retval		!= NULL			
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,13 Jun,2009 - Sun,14 Jun,2009
 *	Thu,14 Oct,2010
 */
static const struct UCS_char_cache_t* const get_UCS_char_cache_ptr( xchar xc )
{
  if (xc <= UINT32_C(0xFFFF)) {
    const uint8_t o3 = (xc & UINT32_C(0xFF00)) >> 8;
    UCS_char_cache_bit7to0_t* const ptr_7to0 = UCS2_cache[o3];
    if (NULL == ptr_7to0) {
      return NULL;
    } else {
      const uint8_t o4 = (xc & UINT32_C(0x00FF)) >> 0;
      return &((*ptr_7to0)[o4]);
    }
  } else {
    const uint8_t o1 = (xc & UINT32_C(0xFF000000)) >> 24;
    UCS_char_cache_bit23to16_t* const ptr_23to16 = UCS4_cache[o1];
    if (NULL == ptr_23to16) {
      return NULL;
    } else {
      const uint8_t o2 = (xc & UINT32_C(0x00FF0000)) >> 16;
      UCS_char_cache_bit15to8_t* const ptr_15to8 = (*ptr_23to16)[o2];
      if (NULL == ptr_15to8) {
	return NULL;
      } else {
	const uint8_t o3 = (xc & UINT32_C(0x0000FF00)) >> 8;
	UCS_char_cache_bit7to0_t* const ptr_7to0 = (*ptr_15to8)[o3];
	if (NULL == ptr_7to0) {
	  return NULL;
	} else {
	  const uint8_t o4 = (xc & UINT32_C(0x000000FF)) >> 0;
	  return &((*ptr_7to0)[o4]);
	}
      }
    }
  }
}

/** åγ
 *@retval		0			
 *@retval		1			
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,13 Jun,2009
 */
static int clear_UCS_char_cache( void )
{
  size_t i;
  for (i = 0; i < _number_(UCS2_cache); ++i) {
    UCS2_cache[i] = NULL;
  }
  for (i = 0; i < _number_(UCS4_cache); ++i) {
    UCS4_cache[i] = NULL;
  }
  return 0;
}

/** å
 *@retval		0			
 *@retval		1			
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,13 Jun,2009
 */
static int free_UCS_char_cache( void )
{
  size_t i, j, k;
  for (i = 0; i < _number_(UCS4_cache); ++i) {
    UCS_char_cache_bit23to16_t*	UCS4_23to16 = UCS4_cache[i];
    if (UCS4_23to16) {
      for (j = 0; j < _number_(*UCS4_23to16); ++j) {
	UCS_char_cache_bit15to8_t*	UCS4_15to8 = (*UCS4_23to16)[j];
	if (UCS4_15to8) {
	  for (k = 0; k < _number_(*UCS4_15to8); ++k) {
	    UCS_char_cache_bit7to0_t*	UCS4_7to0 = (*UCS4_15to8)[k];
	    if (UCS4_7to0) {
	      free( UCS4_7to0 );
	      (*UCS4_15to8)[k] = NULL;
	    }
	  }
	  (*UCS4_23to16)[j] = NULL;
	}
      }
      UCS2_cache[i] = NULL;
    }
  }
  for (i = 0; i < _number_(UCS2_cache); ++i) {
    UCS_char_cache_bit7to0_t*	UCS2_7to0 = UCS2_cache[i];
    if (UCS2_7to0) {
      free( UCS2_7to0 );
      UCS2_cache[i] = NULL;
    }
  }
  return 0;
}

/** @} */



/**@name Ѵ @{ */

/** EUC-JP  UCS-4 Ѵ
 *@param		ec			Ѵʸ EUC-JP
 *@return					Ѵʸ UCS-4
 *@return		anthy_settings.GETA_UCS4	Ѵǽ
 *
 *@attention
 *	ޥåԥ󥰤 ANTHY_ENCODING_EUCJP_AS_* ˰¸롣
 *
 *@comment
 *	Patched by G-HAL
 *	Tue,09 Jun,2009
 *	Wed,10 Jun,2009 - Fri,12 Jun,2009, Wed,17 Jun,2009
 *	Thu,16 Jul,2009
 *	Thu,14 Oct,2010
 */
static xchar anthy_euc_to_ucs( uint32_t ec )
{
  const size_t xs_len = 2;
  xchar	xc[xs_len];
  xstr	xs = { .len = 0, .str = xc };
  unsigned char	buf[5];
  int		len;
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  if (ec < UINT32_C(0xFF)) {
    buf[0] = ((ec & UINT32_C(0x000000FF)) >>  0);	buf[1] = '\0';
  } else if (ec < UINT32_C(0x0000FFFF)) {
    ((uint16_t*)buf)[0] = htons( (uint16_t)ec );	buf[2] = '\0';
  } else if (ec < UINT32_C(0x00FFFFFF)) {
    buf[0] = ((ec & UINT32_C(0x00FF0000)) >> 16);	buf[1] = ((ec & UINT32_C(0x0000FF00)) >>  8);	buf[2] = ((ec & UINT32_C(0x000000FF)) >>  0);	buf[3] = '\0';
  } else {
    ((uint32_t*)buf)[0] = htonl( ec );		buf[4] = '\0';
  }
 #else
  if (ec < UINT32_C(0xFF)) {
    buf[0] = ((ec & UINT32_C(0x000000FF)) >>  0);	buf[1] = '\0';
  } else if (ec < UINT32_C(0x0000FFFF)) {
    buf[0] = ((ec & UINT32_C(0x0000FF00)) >>  8);	buf[1] = ((ec & UINT32_C(0x000000FF)) >>  0);	buf[2] = '\0';
  } else if (ec < UINT32_C(0x00FFFFFF)) {
    buf[0] = ((ec & UINT32_C(0x00FF0000)) >> 16);	buf[1] = ((ec & UINT32_C(0x0000FF00)) >>  8);	buf[2] = ((ec & UINT32_C(0x000000FF)) >>  0);	buf[3] = '\0';
  } else {
    buf[0] = ((ec & UINT32_C(0xFF000000)) >> 24);	buf[1] = ((ec & UINT32_C(0x00FF0000)) >> 16);	buf[2] = ((ec & UINT32_C(0x0000FF00)) >>  8);	buf[3] = ((ec & UINT32_C(0x000000FF)) >>  0);	buf[4] = '\0';
  }
 #endif
  xc[0] = anthy_settings.GETA_UCS4;
  len = anthy_snputcstr( &xs, xs_len, (char*)buf, ANTHY_EUC_JP_ENCODING );
  return (1 == len) ? xc[0] : UINT32_C(0x00000000);
}

/** UCS-4  EUC-JP Ѵ
 *@param		ec			Ѵʸ UCS-4
 *@return					Ѵʸ EUC-JP
 *
 *@attention
 *	ޥåԥ󥰤 ANTHY_ENCODING_EUCJP_AS_* ˰¸롣
 *
 *@comment
 *	Patched by G-HAL
 *	Tue,09 Jun,2009
 *	Wed,10 Jun,2009 - Thu,11 Jun,2009
 */
static uint32_t anthy_ucs_to_euc( xchar xc )
{
  const size_t	buf_size = MAX_BYTES_PER_XCHAR * 1 + MAX_BYTES_BASE + 4;	/* +4  32bitʾݾ㤹뤿 */
  char		buf[buf_size];
  const xstr	xs = { .len = 1, .str = &xc };
  const int	len = anthy_snputxstr( buf, buf_size, &xs, ANTHY_EUC_JP_ENCODING );
 #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
  switch (len) {
  case 4:	return ntohs( *((uint32_t*)buf) );
  case 3:	return (((uint32_t)(uint8_t)buf[0]) << 16) + (((uint32_t)(uint8_t)buf[1]) << 8) + (((uint32_t)(uint8_t)buf[2]));
  case 2:	return ntohs( *((uint16_t*)buf) );
  default:
  case 1:	return (uint8_t)buf[0];
  case 0:	return 0;
  }
 #else
  switch (len) {
  case 4:	return (((uint32_t)(uint8_t)buf[0]) << 24) + (((uint32_t)(uint8_t)buf[1]) << 16) + (((uint32_t)(uint8_t)buf[2]) << 8) + (((uint32_t)(uint8_t)buf[3]));
  case 3:	return (((uint32_t)(uint8_t)buf[0]) << 16) + (((uint32_t)(uint8_t)buf[1]) << 8) + (((uint32_t)(uint8_t)buf[2]));
  case 2:	return (((uint32_t)(uint8_t)buf[0]) << 8) + (((uint32_t)(uint8_t)buf[1]));
  default:
  case 1:	return (((uint32_t)(uint8_t)buf[0]));
  case 0:	return 0;
  }
 #endif
}

/** @} */



/**@name ʸμ̤˴ؤ @{ */

/**@name å @{ */

/** åꤹ
 *@retval		0			
 *@retval		1			
 *
 *@comment
 *	ɲäκݤϽν֤ա
 *	Patched by G-HAL
 *	Sat,13 Jun,2009 - Sun,14 Jun,2009, Wed,17 Jun,2009
 *	Sat,20 Jun,2009
 *	Thu,16 Jul,2009
 *	Thu,14 Oct,2010
 */
static int init_UCS_char_cache( void )
{
  { /* ʸѴ */
    const struct xchar_num_ent* xe;
    const struct xchar_conv_per_char* xconv;
    const struct xchar_xchar_ent* xcxce;

    /*   ͡ */
    for (xe = xchar_num_per_char; xe->xc; ++xe) {
      struct UCS_char_cache_t* const cache = add_UCS_char_cache( xe->xc );
      if (NULL == cache) {
	return 1;
      }
     #if defined(UCS_CHAR_CACHE_HAVE_NUM)
      cache->num       = xe->num;
     #endif
      cache->type     |= xe->type;
      cache->conv_dst  = xe->conv_dst;
    }

    /* Half-Width / Full-Width ؤ */
    for (xcxce = half_wide_tab; xcxce->xc1; ++xcxce) {
      { struct UCS_char_cache_t* const cache = add_UCS_char_cache( xcxce->xc1 );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_chgHALFFULL;
	cache->conv_dst = xcxce->xc2;
      }
      { struct UCS_char_cache_t* const cache = add_UCS_char_cache( xcxce->xc2 );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_chgHALFFULL;
	cache->conv_dst = xcxce->xc1;
      }
    }

    /* ʿ̾   */
    { uint32_t	euc_hira;
      for (euc_hira = UINT16_C(0xA4A1); euc_hira <= UINT16_C(0xA4F3); ++euc_hira) {
	const uint32_t euc_kata = euc_hira + UINT16_C(0x0100);
	const xchar xc_hira = anthy_euc_to_ucs( euc_hira );
	const xchar xc_kata = anthy_euc_to_ucs( euc_kata );
	if (anthy_settings.GETA_UCS4 == xc_hira) {
	  continue;
	}
	if (anthy_settings.GETA_UCS4 == xc_kata) {
	  continue;
	}
	{ struct UCS_char_cache_t* const cache_hira = add_UCS_char_cache( xc_hira );
	  struct UCS_char_cache_t* const cache_kata = add_UCS_char_cache( xc_kata );
	  if (NULL == cache_hira) {
	    return 1;
	  }
	  if (NULL == cache_kata) {
	    return 1;
	  }
	  cache_hira->type      |= (XCT_chgHIRAKATA | XCT_HIRA);
	  cache_hira->kana_swap  = xc_kata;
	  cache_kata->type      |= (XCT_chgHIRAKATA | XCT_KATA);
	  cache_kata->kana_swap  = xc_hira;
	}
      }
      for (xcxce = hira_kata_tab; xcxce->xc1; ++xcxce) {
	struct UCS_char_cache_t* const cache_hira = add_UCS_char_cache( xcxce->xc1 );
	struct UCS_char_cache_t* const cache_kata = add_UCS_char_cache( xcxce->xc2 );
	if (NULL == cache_hira) {
	  return 1;
	}
	if (NULL == cache_kata) {
	  return 1;
	}
	cache_hira->type      |= (XCT_chgHIRAKATA | XCT_HIRA);
	cache_hira->kana_swap  = xcxce->xc2;
	cache_kata->type      |= (XCT_chgHIRAKATA | XCT_KATA);
	cache_kata->kana_swap  = xcxce->xc1;
      }
    }

    /* ʿ̾  Half-Width  */
    for (xconv = half_kana_tab; xconv->xc; ++xconv) {
      struct UCS_char_cache_t* const cache = add_UCS_char_cache( xconv->xc );
      if (NULL == cache) {
	return 1;
      }
      cache->type |= XCT_toHALFKANA;
      cache->conv_dst = anthy_euc_to_ucs( xconv->conv_dst );
      cache->conv_mod = anthy_euc_to_ucs( xconv->conv_mod );
    }
  }

  { /* XCT_t  */

    /* ΰ */
    { uint32_t	euc_char;
      xchar	xc;
      struct UCS_char_cache_t* cache;

      for (xc = UINT8_C(0x20); xc <= UINT8_C(0x7E); ++xc) {
	cache = add_UCS_char_cache( xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_ASCII;
      }
      for (euc_char = UINT16_C(0xA100); euc_char <= UINT16_C(0xA2FF); ++euc_char) {
	xc = anthy_euc_to_ucs( euc_char );
	if (anthy_settings.GETA_UCS4 == xc) {
	  continue;
	}
	cache = add_UCS_char_cache( xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_SYMBOL;
      }
      for (euc_char = UINT16_C(0xA4A1); euc_char <= UINT16_C(0xA4FE); ++euc_char) {
	xc = anthy_euc_to_ucs( euc_char );
	if (anthy_settings.GETA_UCS4 == xc) {
	  continue;
	}
	cache = add_UCS_char_cache( xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_HIRA;
      }
      for (euc_char = UINT16_C(0xA5A1); euc_char <= UINT16_C(0xA5FE); ++euc_char) {
	xc = anthy_euc_to_ucs( euc_char );
	if (anthy_settings.GETA_UCS4 == xc) {
	  continue;
	}
	cache = add_UCS_char_cache( xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_KATA;
      }
      for (xc = UINT32_C(0x3040); xc <= UINT32_C(0x309F); ++xc) {
	cache = add_UCS_char_cache( xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_HIRA;
      }
      for (xc = UINT32_C(0x30A0); xc <= UINT32_C(0x30FF); ++xc) {
	cache = add_UCS_char_cache( xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= XCT_KATA;
      }
    }

    { const struct char_xct_ent* ce;
     #if defined(ICONV_EUCJP0213)
      const struct eucjp0213_xct_ent* ee;
     #endif
      const struct xchar_xct_ent* xe;
      const size_t	xs_maxlen = 2;
      xchar		xc[xs_maxlen];
      xstr		xs = { .len = 0, .str = xc };

      /* ʸ */
      for (ce = char_tab_per_char; ce->chr; ++ce) {
	struct UCS_char_cache_t* cache;
	const int len = anthy_snputcstr( &xs, xs_maxlen, ce->chr, ANTHY_COMPILED_ENCODING );
	if ((1 != len) || (anthy_settings.GETA_UCS4 == xc[0])) {
	  continue;
	}
	cache = add_UCS_char_cache( xc[0] );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= ce->type;
      }

     #if defined(ICONV_EUCJP0213)
      /* ʸ */
      if (anthy_isuseable_iconv(ANTHY_ENCODING_EUCJP0213)) {
	for (ee = eucjp0213_tab_per_char; ee->chr[0]; ++ee) {
	  struct UCS_char_cache_t* cache;
	  const int len = anthy_snputcstr( &xs, xs_maxlen, (const char*)ee->chr, ANTHY_ENCODING_EUCJP0213 );
	  if ((1 != len) || (anthy_settings.GETA_UCS4 == xc[0])) {
	    continue;
	  }
	  cache = add_UCS_char_cache( xc[0] );
	  if (NULL == cache) {
	    return 1;
	  }
	  cache->type |= ee->type;
	}
      }
     #endif

      /* ʸ */
      for (xe = xchar_tab_per_char; xe->xc; ++xe) {
	struct UCS_char_cache_t* const cache = add_UCS_char_cache( xe->xc );
	if (NULL == cache) {
	  return 1;
	}
	cache->type |= xe->type;
      }

      /*  */
      for (xe = xchar_tab_per_50; xe->xc; ++xe) {
	struct UCS_char_cache_t* const cache_hira = add_UCS_char_cache( xe->xc );
	if (NULL == cache_hira) {
	  return 1;
	}
	cache_hira->type |= xe->type;
	{ xchar xc_kata = cache_hira->kana_swap;
	  if (xc_kata) {
	    struct UCS_char_cache_t* const cache_kata = add_UCS_char_cache( xc_kata );
	    if (NULL == cache_kata) {
	      return 1;
	    }
	    cache_kata->type |= xe->type;
	  }
	}
      }
    }
  }

  return 0;
}

/** @} */



/**@name ʸμ̤Ƚ @{ */

/** ꤷʸʸ
 *@param		xc			Ƚꤹʸ
 *@return					ʸ
 *
 *@comment
 *	Patched by G-HAL
 *	Fri,12 Jun,2009 - Sun,14 Jun,2009
 */
enum XCT_t anthy_get_xchar_type( const xchar xc )
{
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (cache) {
    return cache->type;
  } else if (is_kanji(xc)) {
    return XCT_KANJI;
  }
  return XCT_NONE;
}

/** @} */



/**@name ʸμ̤Ѵ @{ */

/** ꤷʸͲ
 *@param		xc			Ƚꤹʸ
 *@return					ʸ
 *
 *@comment
 *	Patched by G-HAL
 *	Sun,14 Jun,2009 - Mon,15 Jun,2009
 */
int anthy_xchar_to_num( xchar xc )
{
 #if defined(UCS_CHAR_CACHE_HAVE_NUM)
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (NULL == cache) {
    return -1;
  }
  if ((XCT_NUM | XCT_WIDENUM) & cache->type) {
    return cache->num;
  }
  return -1;
 #else
  if (WIDE_0 <= xc) {
    if (xc <= WIDE_9) {
      return xc - WIDE_0;
    }
    return -1;
  } else if (xc <= ANK_9) {
    if (ANK_0 <= xc) {
      return xc - ANK_0;
    }
    return -1;
  }
  return -1;
 #endif
}

/** ꤷ Half-Width Ѵ
 *@param		xc			Ѵʸ
 *@return					Ѵ
 *
 *@comment
 *	Patched by G-HAL
 *	Sun,14 Jun,2009
 */
xchar anthy_xchar_wide_num_to_num( xchar xc )
{
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (NULL == cache) {
    return xc;
  }
  if (XCT_WIDENUM & cache->type) {
    return cache->conv_dst;
  }
  return xc;
}

/** ʿ̾饫ʤѴ
 *@param		xc			Ѵʸ
 *@return					Ѵʸ
 *
 *@comment
 *	Patched by G-HAL
 *	Tue,09 Jun,2009
 *	Sun,14 Jun,2009
 */
xchar anthy_xchar_hira_to_kata( xchar xc )
{
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (cache) {
    const enum XCT_t t = cache->type;
    if ((XCT_HIRA & t) && (XCT_chgHIRAKATA & t)) {
      return cache->kana_swap;
    }
  }
  return xc;
}

/** ʤʿ̾Ѵ
 *@param		xc			Ѵʸ
 *@return					Ѵʸ
 *
 *@comment
 *	Patched by G-HAL
 *	Tue,09 Jun,2009
 *	Sun,14 Jun,2009
 */
xchar anthy_xchar_kata_to_hira( xchar xc )
{
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (cache) {
    const enum XCT_t t = cache->type;
    if ((XCT_KATA & t) && (XCT_chgHIRAKATA & t)) {
      return cache->kana_swap;
    }
  }
  return xc;
}


/** Half-Width  Full-Width ؤѴ
 *@param		xc			Ѵʸ
 *@retval		0			Ѵơ֥Ͽ̵
 *@return					Ѵ
 *
 *@attention
 *	¾Ѵؿ֤ͤ㤦Τա
 *
 *@comment
 *	Patched by G-HAL
 *	Sun,14 Jun,2009
 *	Fri,26 Jun,2009
 */
xchar anthy_lookup_half_wide( xchar xc )
{
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (NULL == cache) {
    return 0;
  }
  if (XCT_chgHALFFULL & cache->type) {
    return cache->conv_dst;
  }
  return 0;
}


/** ʿ̾ Half-Width ʤѴ
 *@param		xc			Ѵʸ
 *@param		dst			Ѵʸ
 *@param		mod			Ѵʸ modifiermodifier ̵ʤ 0
 *@retval		0			̵
 *@retval		1			ͭ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,13 Jun,2009 - Sun,14 Jun,2009
 */
int anthy_find_half_kana( xchar xc, xchar* const dst, xchar* const mod )
{
  const struct UCS_char_cache_t* const cache = get_UCS_char_cache_ptr( xc );
  if (NULL == cache) {
    return 0;
  }
  if (XCT_toHALFKANA & cache->type) {
    *dst = cache->conv_dst;
    *mod = cache->conv_mod;
    return 1;
  }
  return 0;
}

/** @} */

/** @} */



/** xchar饹
 *@retval		0			
 *@retval		1			
 *
 *@comment
 *	Patched by G-HAL
 *	Mon,25 May,2009
 *	Tue,09 Jun,2009
 *	Sat,13 Jun,2009
 */
int anthy_init_xchar_tab( void )
{
  int ret;

 #if defined(ICONV_EUCJP0213)
  anthy_open_iconv( ANTHY_ENCODING_EUCJP0213 );
 #endif

  ret = clear_UCS_char_cache();
  if (0 != ret) {
    return 1;
  }
  ret = init_UCS_char_cache();
  if (0 != ret) {
    return 1;
  }

  return 0;
}


/** xchar饹õ
 *@retval		0			
 *@retval		1			
 *
 *@comment
 *	Patched by G-HAL
 *	Mon,25 May,2009
 *	Sat,13 Jun,2009
 */
int anthy_quit_xchar_tab( void )
{
  int	ret = 0;

  ret |= free_UCS_char_cache();

  return ret;
}


#endif /* !defined(USE_ICONV) */
/* vim:ts=8 sw=2 nomodified:
 */
