/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	Ķ
 *@date		Wed,27 Aug,2008 - Fri,29 Aug,2008
 *@date		Fri,17 Oct,2008 - Sat,18 Oct,2008
 *@date		Thu,23 Oct,2008
 *@date		Tue,28 Oct,2008
 *@date		Sat,01 Nov,2008 - Tue,04 Nov,2008
 *@date		Fri,14 Nov,2008 - Sun,16 Nov,2008
 *@date		Sat,22 Nov,2008, Thu,27 Nov,2008
 *@date		Sat,29 Nov,2008
 *@date		Sun,28 Dec,2008, Tue,30 Dec,2008
 *@date		Tue,13 Jan,2009
 *@date		Mon,19 Jan,2009
 *@date		Sat,24 Jan,2009, Sun,25 Jan,2009
 *@date		Mon,26 Jan,2009, Thu,29 Jan,2009
 *@date		Tue,03 Feb,2009, Wed,04 Feb,2009, Fri,06 Feb,2009
 *@date		Sun,08 Feb,2009 - Mon,09 Feb,2009
 *@date		Wed,11 Feb,2009
 *@date		Wed,18 Feb,2009, Sat,21 Feb,2009, Tue,24 Feb,2009, Sat,28 Feb,2009
 *@date		Sat,14 Mar,2009
 *@date		Sat,14 Mar,2009, Wed,25 Mar,2009
 *@date		Sun,19 Apr,2009 - Mon,20 Apr,2009
 *@date		Sat,22 Apr,2009
 *@date		Mon,25 May,2009 - Mon,08 Jun,2009
 *@date		Fri,12 Jun,2009
 *@date		Wed,17 Jun,2009
 *@date		Wed,24 Jun,2009 - Thu,25 Jun,2009
 *@date		Fri,26 Jun,2009
 *@date		Sat,25 Jul,2009, Tue,04 Aug,2009
 *@date		Wed,21 Oct,2009 - Thu,22 Oct,2009
 *@date		Sun,25 Oct,2009
 *@date		Wed,04 Nov,2009
 *@date		Sun,08 Nov,2009
 *@date		Tue,10 Nov,2009
 *@date		Thu,12 Nov,2009
 *@date		Sat,14 Nov,2009 - Sun,15 Nov,2009
 *@date		Wed,21 Jul,2010
 *@date		Wed,04 Jul,2010
 *@date		Mon,16 Aug,2010 - Fri,20 Aug,2010
 *@date		Fri,03 Sep,2010
 *@author	Copyright(C)2008-2010 G-HAL
 *
 *@note
 *		sample/conf ⻲Ȥ줿
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif

#include "anthy/settings.h"
#include "anthy/anthy.h"
#include "anthy/segment.h"
#include "anthy/splitter.h"
#include "anthy/cand_ent_score.h"

struct ANTHY_SETTINGS_ anthy_settings = {

	/* ܻ */
	/* ѴǽʸʸUCS-4ɽ */
	.GETA_UCS4 = UINT32_C(0x00003013),

	/* ѥ᡼ʤΤǡѹʤ */
	.timestamp = {
		.conffile = 0,
		.initial = 0,
		.currentsession = 0,
		.lastsession = 0,
	},

	.filename = {
		/* 桼Ķե */
		.user_conffile = "~/.anthy/conf",

		/* ǥ쥯ȥζڤʸ */
		.PathSeparator = "/",

		/* ʲΥե뷲֤ǥ쥯ȥꡣ ${HOME} դ */
		.user_dir = ".anthy",

		/* åե̾˸ߤѴå id̾դ */
		.lock_file = "lock-file_",

		/* Ŀɲü̾˸ߤѴå id̾ȳĥҤդ */
		.private_dic = "private_dict_",
		/* Ŀɲüγĥҡ */
		.private_dic_ext = ".tt",

		/* imported_words ǥ쥯ȥ̾˸ߤѴå id̾ȳĥҤդ */
		.imported_words = "imported_words_",
		/* imported_words ǥ쥯ȥ̾γĥҡ */
		.imported_words_ext = ".d",

		/* ؽ̤εϿ衣˸ߤѴå id̾դ */
		.record1 = "last-record1_",
		.record1_bin_ext = ".bin",
		.record2 = "last-record2_",

		/* ؽ̤ UTF-8 ǵϿγĥҡ */
		.record_ext = ".utf8",

		/* ǥХåѥ */
		.logfile = "\0",
	},

	/* ե°ޥ */
	.file_umask = (S_IRWXG | S_IRWXO),

	/*
	 * ؽǡ last-record2_* ե礭ͤۤƤ硢
	 * եå夷ơlast-record1_* إޡ롣
	 *
	 * ͤ򾮤ȡlast-record2_*  last-record1_ Ѵ٤夬롣
	 * 礭ȡ٤롣
	 * ؽǡ̤ˤϱƶʤ
	 */
	.recordfile2_limit = 131072,
	/*
	 * last-record1_* 礭ͤۤƤ硢
	 * ȥҤξͰʲȤʤͤˡȥ¹Ԥ롣
	 *
	 * ȥͰʲˤʤäƤˤ⤫餺
	 * ե륵ͤۤƤ硢
	 * եΥեåԤ˥ȥ¹Ԥ롣
	 * äơ
	 * ȥͰʲˤʤä last-record1_* Υե륵
	 * Ŭ٤礭ͤꤹ뤳ȡ
	 *
	 * λͤȾͰʲˤʤäΥե륵κϡ
	 * ȥߤ٤夬롣
	 * 礭ϡ٤롣
	 */
	.recordfile1_limit = 1572864,

	/* ƳؽΥҥȾ
	 *
	 * ܤιܤϡ̾ꤹ롣ѹʤȡ
	 * ܤιܤˤơȥξͤꤹ롣
	 * ܤιܤˤơ®ΰ٤ΡԳ̤ꤹ롣¤򤷤Ƥʤѹʤȡ
	 * ܤιܤˤơ®ΰ٤Ργ̤ꤹ롣¤򤷤Ƥʤѹʤȡ
	 *
	 * NONE_SECTION  131072 ϡǤ票ȥꡣ
	 * ѹϡ³Υȥΰ礭ͤ礭뤳ȡ
	 *
	 * ꤷƤ륨ȥϡγؽ̤׻ͤǤ롣
	 * ߤ˹碌ѹ줿
	 */
	.section = {
		[NONE_SECTION]		= { "dummy",			 131072,  0, 0 },
		[EXPANDPAIR]		= { "EXPANDPAIR",		      0,  2, 1 },	/* */
		[UNKNOWN_WORD]		= { "UNKNOWN_WORD",		    355,  1, 1 },
		[SUFFIX_HISTORY]	= { "SUFFIX_HISTORY",	    104,  3, 3 },	/* */
		[INDEPPAIR]			= { "INDEPPAIR",		      0,  1, 1 },
		[OCHAIRE]			= { "OCHAIRE",			   3805, 10, 2 },	/* */
		[CAND_HISTORY]		= { "CAND_HISTORY",		   8777,  3, 3 },	/* */
		[PREDICTION]		= { "PREDICTION",		   8777,  2, 2 },	/* */
		[INDEP_HISTORY]		= { "INDEP_HISTORY",	   5947,  3, 3 },	/* */
		[DEP_HISTORY]		= { "DEP_HISTORY",		   2531,  0, 1 },	/* */
		[PREFIX_HISTORY]	= { "PREFIX_HISTORY",	    104,  3, 3 },	/* */
		[DATA_SAMPLING]		= { "DATA_SAMPLING",	     -1,  0, 1 },	/* */
		[ERROR]				= { "ERROR",			     -1,  2, 1 },	/* */
	},
	/*
	 * ѥåǤǤ *_HISTORY ϡǾ 3ñ̤ 3̤κ礬 36
	 *
	 * EXPANDPAIR ΥϡǾ 1ʬ 1ʿѤ 1.41.523 ٤
	 * ޤ 5, 7, 13 餤ޤǤΤǺޤ
	 *
	 * UNKNOWN_WORD ϡ1 ͤǤꡢѲʤ
	 *
	 * SUFFIX_HISTORY ϡpatch13ptn13 ǻѹ١Ƽ̤¬
	 *
	 * INDEPPAIR ϡpatch13ptn13 ѻߤ1 ͤǤꡢѲʤ
	 *
	 * OCHAIRE ϡ̤κǾ 9 (1+2*2+4)߷׾κǾ 7 (1+2*1+4)ʬ 2̤κ礬 11 (1+2*3+4)
	 * ʿѤ 10.110.2
	 *
	 * ǤǤ CAND_HISTORY ϡǾ 1ñ̤ 1ʿѤ 2.1礬 8
	 * ѥåǤǤ CAND_HISTORY ϡʿѤ 3.13.2
	 *
	 * PREDICTION ϡǾ 2ñ̤ 2ʿѤ 2.1ͤ
	 * PREDICTION ϡpatch10 ѻߤ
	 *
	 * INDEP_HISTORY ϡpatch13ptn13 ǤοɲäǤ뤿ᡢƼ̤¬
	 * DEP_HISTORY ϡpatch13ptn17 ǤοɲäǤ뤿ᡢƼ̤¬
	 * PREFIX_HISTORY ϡpatch13ptn13 ǤοɲäǤ뤿ᡢƼ̤¬
	 *
	 * DATA_SAMPLING ϡpatch13ptn19 ǤοɲäǤ뤿ᡢƼ̤¬
	 */


	/** ͤ */
	.limit = {
		.ochaire_mindepth = 1,			/* OCHAIREؽκǾʸ */
		.ochaire_maxdepth = 3,			/* OCHAIREؽκʸ */
		.historyrecord_maxdepth = 12,	/* ؽƱɤ߰ۻκϿ */
	},


	/*
	 * ɲõǽ̵ͭ
	 */
	.anthy_mode = {
		/* anonymous ⡼ɡؽκϿڹԤʤ */
		.anonymous  = 0,
		/* proccorpus ⡼ɡʣ졿Ѥʤ */
		.proccorpus = 0,

		/* 顼 last-record* ˵Ͽ(1)(0) */
		.enable_error_record = 0,
	  #if defined(USE_ICONV)
		/* եȥɥեȤȤϤѤʸ */
		.encoding = ANTHY_ENCODING_EUCJP0212,
		/* եȥɥեȤȤϤѤʸɡ̾ľܻ */
		.encoding_name = NULL,
		/* ꤷƤʤ EUC-JP 򡢤ɤηȤư */
		.default_eucjp_encoding = ANTHY_ENCODING_EUCJP0212,
	  #else
		/* եȥɥեȤȤϤѤʸ(ANTHY_EUC_JP_ENCODING/ANTHY_UTF8_ENCODING) */
		.encoding = ANTHY_EUC_JP_ENCODING,
	  #endif
		/* ǥեȤεѴ⡼(ANTHY_RECONVERT_AUTO/ANTHY_RECONVERT_DISABLE/ANTHY_RECONVERT_ALWAYS) */
		.reconversion_mode = ANTHY_RECONVERT_DISABLE,

		/* β굡ǽͭ(1)̵(0)  */
		.enable_provisional_committed = 1,

		/* ľϤ줿Ƥ򻲹;Ȥݻ³뵡ǽ̵ͭ */
		.keepalive = {
			/* ݻǽ̤ͭ(1)̵(0)  */
			.enable = 1,
			/* ʣѤͭ(1)̵(0)  */
			.enable_refer_compound = 1,
			/* 㼭ʸڤѡˤѤͭ(1)̵(0)  */
			.enable_refer_ucdic_for_lattice = 1,
			/* 㼭ʸ¤ӽѡˤѤͭ(1)̵(0)  */
			.enable_refer_ucdic_for_candidate = 1,
			/* OCHAIREؽѤͭ(1)̵(0)  */
			.enable_refer_ochaire = 1,
			/* ѥѤͭ(1)̵(0)  */
			.enable_refer_corpus = 1,
			/* OCHAIREؽؤεϿͭ(1)̵(0)  */
			.enable_learn_ochaire = 0,
		},

		.learn = {
			/* uim-1.5.5 ˤɲä줿ʸ졿ʿ̾μưؽͭˤ(1)ݤ(0) */
			.enable_autolearn = 1,

			/* ؽ褦ȤƤȿ¸γؽĴ¸γؽ⤫ä硢¸γؽΥŪ˲ */
			.enable_unlearn = 1,

			/* OCHAIREˤơؽ褦ȤʸƤ򤵤˺ʬͤʴ¸γؽä硢 */
			.enable_release = 1,

			/* PREDICTIONؽͭ(1)̵(0)  */
			.enable_prediction = 1,
			/* CAND_HISTORYؽͭ(1)̵(0)  */
			.enable_candhistory = 1,
			/* INDEPPAIRؽͭ(1)̵(0)  */
			.enable_indeppair = 0,
			/* INDEP_HISTORYؽͭ(1)̵(0)  */
			.enable_indephistory = 1,
			/* DEP_HISTORYؽͭ(1)̵(0)  */
			.enable_dephistory = 1,
			/* EXPANDPAIRؽͭ(1)̵(0)  */
			.enable_expandpair = 0,
			/* PREFIXؽͭ(1)̵(0)  */
			.enable_prefix_history = 1,
			/* SUFFIXؽͭ(1)̵(0)  */
			.enable_suffix_history = 1,

			/* ñʸOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire1 = 1,
			/* °̵ñʸOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire1_wo_dep = 1,

			/* Ω졦°դʸOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire2 = 1,
			/* °̵ʸOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire2_wo_dep = 1,
			/* Ω̵ʸOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire2_wo_indep = 0,
			/* Ω졦°̵ʸOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire2_wo_indep_wo_dep = 0,

			/* Ω졦°դʸʾOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire3 = 0,
			/* °̵ʸʾOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire3_wo_dep = 1,
			/* Ω̵ʸʾOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire3_wo_indep = 0,
			/* Ω졦°̵ʸʾOCHAIREؽͭ(1)̵(0)  */
			.enable_ochaire3_wo_indep_wo_dep = 0,

			/* ץǡѥ */
			.enable_datasampling = 0,
		},

		/* ʸڤ */
		.lattice = {
			.mode = ANTHY_LATTICE_MODE_VITERBI,		/* ʸڤΥ⡼ */
			.hinting = ANTHY_LATTICE_HINTING_NONE,	/* ʸڤΥҥƥ󥰤Υ⡼ */
			.hinting_character = UINT32_C(0x0000003B),	/* ANTHY_LATTICE_HINTING_BY_CHARACTER ǻѤʸ */
			.with_ochaire_strong      = 0,		/* ʸڤ OCHAIRE ɬ⤯ɾ(1)(0) */
			.with_ochaire             = 0,		/* ʸڤ OCHAIRE ɾ⤯(1)(0) */
			.with_candhistory_strong  = 0,		/* ʸڤ CAND_HISTORY ɬ⤯ɾ(1)(0) */
			.with_candhistory         = 0,		/* ʸڤ CAND_HISTORY ɾ⤯(1)(0) */
			.with_cand_score          = 0,		/* ʸڤκݤʸδܥȤơñΥѤ(1)ñνм̥OCHAIREݤդˤѤ(0) */
			.with_candstruct_score    = 0,		/* ʸڤκݤˡ°ˤʸδܥԤ(1)(0) */
			.with_cand_corpus         = 0,		/* ʸڤκݤˡcand_info ѥˤʸδܥԤ(1)(0)false == with_candstruct_score ξ϶Ū̵ */
			.corpus_adj_by_count_numerator   = 3.0e+0,		/* ѥγΨͤʸи͡ʬҡ */
			.corpus_adj_by_count_denominator = 4.0e+0,		/* ѥγΨͤʸи͡ʬ */
			.biasprob_by_ochaire      = 6.6e-1,		/* ʸڤˤơOCHAIRE ͳʸܳΨ夲 */
			.biasscore_by_compound    = 200.0,		/* ʸڤˤơʣ˳ʸΥ˲û */
			.biasscore_by_ucdic       = 100.0,		/* ʸڤˤơ㼭˳ʸΥ˲û */
			.biasscore_by_ochaire     = 1000.0,		/* ʸڤˤơOCHAIRE ͳʸΥ˲û */
			.biasscore_by_learnedfreq = 10.0,		/* ʸڤˤơؽ줿ʸΥ˲û */
			.biasscore_by_dephistory  = 5.0,		/* ʸڤˤơ°ؽˤäʸΥ˲û */
			.autoexpand_deps        = 1,		/* °μưĥԤ(1)(0) */
			.mw_max_score = 4000,				/* mw_score κ͡ʼư׻ưԲġ */
			.viterbi = {						/* ӥӥ⡼ͭ */
				.with_poisson = 0,				/* ݥ諒ʬۤѤʸĹˤΨͭˤ(1)(0) */
				.bias_substitutes_poisson = 2.75e-06,	/**< ݥ諒ʬۤѤХ */
				.metaword_effects_sentence = 1,	/* ñɾʸΤȵڤ(1)(0) */
				.decrease_probability_phrase_with_pre_post = {	/* ӥӥ⡼ɻΡƬ⤷ʸθ */
					.sw = 1,							/* ӥӥ⡼ɻˡƬ⤷ʸ(1)(0) */
					.with_pre_and_post = 5.0e-13,		/* ƬξդƤʸܳΨΨ */
					.with_pre          = 7.0e-7,		/* ƬΤդƤʸܳΨΨ */
					.with_post         = 8.0e-7,		/* ΤդƤʸܳΨΨ */
				},
			},
			.maxlen_mode = {					/* ʸĹץ⡼ͭ */
				.phrases = 3,						/* ʸ */
				.phrase_with_pre_post_as_2 = 0,		/* ʸĹץ⡼ɻˡƬξʸ򡢣ʸȿ(1)ݤ(0) */
				.puremode = 0,						/* ΣʸĹץ르ꥺɤνˤ(1)(0) */
			},
		},

		/* ° */
		.depgraph = {
			.with_xct_symbol = 0,	/* XCT_SYMBOLʸ°ȤϢ뤹(1)(0) */
			.with_xct_part   = 1,	/* XCT_PARTʸʤäˤ°ȤϢ뤹(1)(0) */
			/* °ʸ᥹ؤαƶ */
			.score = {
			  #if 0
				.decrease_ratio = 0.01,					/* ʸṽ¤򲼤Ψ°죱 */
				.decrease_ratio_by_length = 0.001,		/* ʸṽ¤򲼤Ψ°죱ʸ */
				.decrease_biasratio = 0.10,				/* ʸṽ¤򲼤Ψʲط̵Ψ */
				.decrease_biasratio_threshold = 2,		/* decrease_biasratio ͭˤ롢°κ */
				.decrease_score = 0,					/* ʸṽ¤򲼤°죱 */
				.decrease_biasscore = 0,				/* ʸṽ¤򲼤ʲط̵Ψ */
				.decrease_biasscore_threshold = 255,	/* decrease_biasscore ͭˤ롢°κ */
			  #elif 0
				.decrease_ratio = 0.00,					/* ʸṽ¤򲼤Ψ°죱 */
				.decrease_ratio_by_length = 0.000,		/* ʸṽ¤򲼤Ψ°죱ʸ */
				.decrease_biasratio = 0.00,				/* ʸṽ¤򲼤Ψʲط̵Ψ */
				.decrease_biasratio_threshold = 255,	/* decrease_biasratio ͭˤ롢°κ */
				.decrease_score = -150,					/* ʸṽ¤˲û°죱 */
				.decrease_biasscore = -1000,			/* ʸṽ¤˲ûʲط̵ */
				.decrease_biasscore_threshold = 2,		/* decrease_biasscore ͭˤ롢°κ */
			  #else
				.decrease_ratio = 0.00,					/* ʸṽ¤򲼤Ψ°죱 */
				.decrease_ratio_by_length = 0.000,		/* ʸṽ¤򲼤Ψ°죱ʸ */
				.decrease_biasratio = 0.50,				/* ʸṽ¤򲼤Ψʲط̵Ψ */
				.decrease_biasratio_threshold = 1,		/* decrease_biasratio ͭˤ롢°κ */
				.decrease_score = -150,					/* ʸṽ¤˲û°죱 */
				.decrease_biasscore = -1000,			/* ʸṽ¤˲ûʲط̵ */
				.decrease_biasscore_threshold = 2,		/* decrease_biasscore ͭˤ롢°κ */
			  #endif
				.decrease_biasscore_xct_part = -500,	/* mw˲ûXCT_PARTʸʤäˤ°ȤƻѤˡʲط̵ */
				.increase_biasscore_by_learn = 10,		/* DEP_HISTORYؽ˥ҥåȤʸṽ¤˲ûʤ * log(1.0 + ޤǤѲ) */
			},
		},

		/* Ƭ */
		.prefix_suffix = {
			/* ʸ᥹ؤαƶ */
			.score = {
				.increase_ratio_by_learn = 0.50,		/* ʸ᥹夲 */
			},
		},

		/* Ѵ */
		.candidate = {
			.struct_prob_without_corpus = 0.30,						/* ѥ˳̵γΨ */
			.struct_prob_default        = 1.00,						/* ѥȤʤγΨ */
			.trim_kana_score = 0,		/* Ѵˤơʤθ䤬ƬǤʤкǸ˲(1)ƥ༭ɤν֤ˤ(0) */
			.disable_indepscore_with_prefix_or_postfix = 1,	/* ΩƬդƤ硢ΩؽŬѤߤ(1)(0) */
			.renyou_score = CANDIDATE_RENYOU_SCORE_GEOMETRICMEAN,	/* ϢѷʸΥη */
			.ucdict_score_ratio = UCDICT_SCORE_RATIO,				/* 㼭(udict)ɲå */
			.udict_corpus_score = UDICT_CORPUS_SCORE,				/* 㼭(corpus)Υ */
		},

		/* ʸФüɲ */
		.extra_flag = {
			/* ޤʸؽʤ(1)ؽ(0)
			 * ɤʵ椬ޤޤΤϡ
			 *	src-worddic/exception_word_list.c
			 * 򻲾Ȥ줿
			 */
			.exception_word = {
				.indep_history = 0,		/* INDEPPAIR/INDEP_HISTORY/DEP_HISTORY ˳ؽʤ */
				.ochaire       = 0,		/* OCHAIRE ˳ؽʤ */
				.cand_history  = 0,		/* CAND_HISTORY ˳ؽʤ */
				.prediction    = 0,		/* PREDICTION ˳ؽʤ */
			},
			/* ʸФüե饰ɲ
			 *
			 *	Ѵ¤ӽĴ᤹üե饰
			 *		硧	( * CEF_TUNESCORE_CLOUMN)
			 *		硧	( * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN
			 *		ͤ 0  7 ϰǤʤФʤʤ
			 *		ϰϤۤƤεưꡣ
			 *		ͤϣǤϤʤΤա
			 *
			 *	ư줿ʸؽʤüե饰
			 *		ˤ
			 *			CEF_NONE                        	̤̾ؽ롣
			 *			CEF_DONTLEARN_EXPANDPAIR        	Ǥޤ EXPANDPAIR ؽʤ
			 *			CEF_DONTLEARN_INDEP_HISTORY     	Ǥޤ INDEPPAIR/INDEP_HISTORY ؽʤ
			 *			CEF_DONTLEARN_DEP_HISTORY       	Ǥޤ DEP_HISTORY ؽʤ
			 *			CEF_DONTLEARN_PREDICTION        	Ǥޤ PREDICTION ؽʤ
			 *			CEF_DONTLEARN_CANDHISTORY       	Ǥޤ CAND_HISTORY ؽʤ
			 *			CEF_DONTLEARN_OCHAIRE_IFONLYITS 	ǤǹƤ OCHAIRE ؽʤ
			 *			CEF_DONTLEARN_OCHAIRE_IFHAVEIT  	Ǥޤ OCHAIRE ؽʤ
			 *			CEF_DONTLEARN_ALL               	Ǥޤϰڳؽʤ
			 *		Ȥʣꤹ | ǤĤʤ
			 */
			.guess             = CEF_NONE,		/* ư줿Ǹʸʳʤʸ */
			.hiragana          = CEF_NONE,		/* ư줿Ҥ餬ʤΤߤʸ */
			.katakana          = CEF_NONE,		/* ư줿ʤΤߤʸ */
			.kigou             = CEF_NONE,		/* ư줿εΤߤʸsrc-diclib/xchar.c  half_wide_tab 򻲾ȡ */
			.muhenkan          = CEF_NONE,		/* ư줿̵Ѵʸ */
			.zenhan            = CEF_NONE,		/* ư줿ѤȤȾѤؤʪ */
			.num_ank           = CEF_NONE | (4 * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN,	/* ư줿ȾѤο(ANK) */
			.num_jis           = CEF_NONE | (1 * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN,	/* ư줿Ѥο(JIS X 0208 ) */
			.num_kansuuzi      = CEF_NONE | (2 * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN,	/* ư줿 */
			.num_separated_ank = CEF_NONE | (6 * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN,	/* ư줿ڤ(ANK) */
			.num_separated_jis = CEF_NONE | (5 * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN,	/* ư줿ڤ(JIS X 0208 ) */
			.num_zipcode       = CEF_NONE | (3 * CEF_TUNESCORE_CLOUMN) | CEF_TUNESCORE_SIGN,	/* ͹ֹ漭񤫤Ѵ */
		},
	},
};

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
