/*
 * ν
 * $Id: logger.c,v 1.8 2002/05/14 13:24:47 yusuke Exp $
 */
#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <stdarg.h>

#include <anthy/anthy.h>
#include <anthy/logger.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STDARG_H)
# include <stdarg.h>
#endif
#if defined(HAVE_UNISTD_H)	/* Patched by G-HAL, Sun,25 Oct,2009 */
# include <unistd.h>
#endif
#if defined(HAVE_FCNTL_H)	/* Patched by G-HAL, Sun,25 Oct,2009 */
# include <fcntl.h>
#endif

#include "anthy/anthy.h"
#include "anthy/logger.h"
#include "anthy/conf.h"		/* Patched by G-HAL, Sun,25 Oct,2009 */
#include "anthy/settings.h"	/* Patched by G-HAL, Sun,25 Oct,2009 */
#endif

static void (*logger)(int lv, const char *str);
static int current_level = 1;
static FILE* fp = NULL;		/* Patched by G-HAL, Sun,25 Oct,2009 */

void
anthy_do_set_logger(void (*fn)(int lv, const char *str), int lv)
{
  current_level = lv;
  logger = fn;
  /* to be implemented */
}

static void
do_log(int lv, const char *str, va_list arg)
{
 #if 0	/* Patched by G-HAL, Sun,07 Jun,2009, Sun,25 Oct,2009, Tue,17 May,2011 */
  if (lv < current_level) {
    return ;
  }
  fprintf(stderr, "Anthy: ");
  vfprintf(stderr, str, arg);
 #else
  if ((NULL == fp) && ('\0' != anthy_settings.filename.logfile[0])) {
    const char* const home = anthy_conf_get_str("HOME");
    const char* const sid = anthy_conf_get_str("SESSION-ID");
    char fn[PATH_MAX];
    const int fd_flags = (O_WRONLY | O_APPEND | O_CREAT | O_TRUNC | O_EXLOCK);
    const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
    snprintf( fn, sizeof(fn),
	     "%s%s%s%s%s%s",
	     home,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.user_dir,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.logfile,
	     sid );
    const int fd = open( fn, fd_flags, fd_mode );
    if (fd < 0) {
      /* error */
    } else {
      fp = fdopen( fd, "w" );
      if (NULL == fp) {
	close( fd );
      }
    }
  }
  { FILE* const output = ((NULL != fp) ? fp : stderr);
    fprintf(output, "Anthy: " );
    vfprintf(output, str, arg );
    fflush( output );
  }
  return;
 #endif
}

void
anthy_log(int lv, const char *str, ...)
{
  va_list arg;
 #if 0	/* Patched by G-HAL, Sun,07 Jun,2009 */
  if (lv > current_level) {
    return ;
  }
 #else
  if (lv < current_level) {
    return;
  }
 #endif
  va_start(arg, str);
  do_log(lv, str, arg);
  va_end(arg);
}

void
anthy_set_logger(anthy_logger lg, int level)
{
  anthy_do_set_logger(lg, level);
}
/* vim:ts=8 sw=2 nomodified:
 */
