/*
 * AnthyΥǡ١
 * conf_initꤵѿconf_overrideꤵ
 * ѿδط
 *
 * Copyright (C) 2000-2007 TABATA Yusuke
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <unistd.h>
#include <pwd.h>
#include <time.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <anthy/alloc.h>
#include <anthy/conf.h>
#include <anthy/logger.h>

#include <config.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_SYS_PARAM_H)
# include <sys/param.h>
#endif
#if defined(HAVE_PWD_H)
# include <pwd.h>
#endif

#include "src-diclib/alternative_strlcpy.h"
#include "anthy/alloc.h"
#include "anthy/conf.h"
#include "anthy/logger.h"
#endif

/** ѿ */
struct val_ent {
  /** ѿ̾ */
  const char *var;
  /**  */
  const char *val;
  /** ꥹȤμ */
  struct val_ent *next;
};

static struct val_ent *ent_list;
/** Ѥߥե饰 */
static int confIsInit;
static allocator val_ent_ator;

static void
val_ent_dtor(void *p)
{
  struct val_ent *v = (struct val_ent*) p;
  free((void *)v->var);
  if (v->val) {
    free((void *)v->val);
  }
}

/** ѿ̾бval_ent */
static struct val_ent *
find_val_ent(const char *v)
{
  struct val_ent *e;
  for (e = ent_list; e; e = e->next) {
    if(!strcmp(v, e->var)) {
      return e;
    }
  }
  e = (struct val_ent*) malloc(sizeof(struct val_ent));
  if (!e) {
    return NULL;
  }
  e->var = strdup(v);
  e->val = 0;
  e->next = ent_list;
  ent_list = e;
  return e;
}

/** ${ѿ̾}ηѿͤ
 */
static const char *
get_subst(const char *s)
{
  if (s[0] == '$' && s[1] == '{' &&
      strchr(s, '}')) {
    struct val_ent *val;
    char *var = strdup(&s[2]);
    char *k = strchr(var, '}');
    *k = 0;
    val = find_val_ent(var);
    free(var);
    if (!val || !val->val) {
      return "";
    }
    return val->val;
  }
  return NULL;
}

struct expand_buf {
  int len;
  int size;
  char *buf;
  char *cur;
};

static void
ensure_buffer(struct expand_buf *eb, int count)
{
  int required = count - (eb->size - eb->len) + 16;
  if (required > 0) {
    eb->size += required;
    eb->buf = (char*) realloc(eb->buf, eb->size);
    eb->cur = &eb->buf[eb->len];
  }
}

static char *
expand_string(const char *s)
{
  struct expand_buf eb;
  char *res;
  eb.size = 256;
  eb.buf = (char*) malloc(eb.size);
  eb.cur = eb.buf;
  eb.len = 0;

  while (*s) {
    const char *subst = get_subst(s);
    if (subst) {
      int len = strlen(subst);
      ensure_buffer(&eb, len + 1);
      *eb.cur = 0;
      strcat(eb.buf, subst);
      eb.cur += len;
      eb.len += len;
      s = strchr(s, '}');
      s ++;
    } else {
      *eb.cur = *s;
      /**/
      eb.cur ++;
      s++;
      eb.len ++;
    }
    /**/
    ensure_buffer(&eb, 256);
  }
  *eb.cur = 0;
  /**/
  res = strdup(eb.buf);
  free(eb.buf);
  return res;
}

static void
add_val(const char *var, const char *val)
{
  struct val_ent *e;
  e = find_val_ent(var);
  if (e->val) {
    free((void *)e->val);
  }
  e->val = expand_string(val);
}

static void
read_conf_file(void)
{
  const char *fn;
  FILE *fp;
  char buf[1024];
  fn = anthy_conf_get_str("CONFFILE");
  fp = fopen(fn, "r");
  if (!fp){
    anthy_log(0, "Failed to open %s\n", fn);
    return ;
  }
  while(fgets(buf, 1024, fp)) {
    if (buf[0] != '#') {
      char var[1024], val[1024];
      if (sscanf(buf, "%s %s", var, val) == 2){
	add_val(var, val);
      }
    }
  }
  fclose(fp);
}

void
anthy_do_conf_override(const char *var, const char *val)
{
  if (!strcmp(var,"CONFFILE")) {
    add_val(var, val);
    anthy_do_conf_init();
  }else{
    anthy_do_conf_init();
    add_val(var, val);
  }
}

#if 0
/* ˡʥåIDݤ */
#define SID_FORMAT	"%s-%08x-%05d" /* HOST-TIME-PID */
#define MAX_SID_LEN  	(MAX_HOSTNAME+8+5+2)
#define MAX_HOSTNAME 	64

static void
alloc_session_id(void)
{
  time_t t;
  pid_t pid;
  char hn[MAX_HOSTNAME];
  char sid[MAX_SID_LEN];
  t = time(0);
  pid = getpid();
  gethostname(hn, MAX_HOSTNAME);
  hn[MAX_HOSTNAME-1] = '\0';
  sprintf(sid, SID_FORMAT, hn, (unsigned int)t & 0xffffffff, pid & 0xffff);
  add_val("SESSION-ID", sid);
}
#else
# if defined(_POSIX_HOST_NAME_MAX)
								/* NULʸޤޤʤ */
# elif defined(HOST_NAME_MAX)
#  define	_POSIX_HOST_NAME_MAX	    HOST_NAME_MAX	/* Legacy FreeBSD, Legacy GNU/Linux, NULʸޤޤʤ */
# elif defined(MAXHOSTNAMELEN)
#  define	_POSIX_HOST_NAME_MAX	    MAXHOSTNAMELEN	/* NetBSD, Legacy OpenBSD, Very old FreeBSD, NULʸޤ */
# else
#  error	"Maximum length of gethostname() was not determined."
# endif

# if defined(HAVE_LONG_FILE_NAMES)
#  define SID_FORMAT	"%s-%020"PRIu64"-%05"PRIu16""	/* HOST-TIME-PID */
#  define MAX_SID_LEN  	(_POSIX_HOST_NAME_MAX+1+20+1+5+1)	/* SID_FORMAT ŸĹ */

/** ˡʥåIDݤ
 *@return	"SESSION-ID"		줿ID
 *
 *	Patched by G-HAL
 *		Wed,29 Sep,2010
 */
static void alloc_session_id( void )
{
  const time_t t = time( NULL );
  const pid_t pid = getpid();
  char hn[_POSIX_HOST_NAME_MAX +1];
  char sid[MAX_SID_LEN];
  const int ret = gethostname( hn, sizeof(hn) );
  if (0 != ret) {
    strlcpy( hn, "unknown.private.", sizeof(hn) );
  }
  hn[sizeof(hn)-1] = '\0';
  snprintf( sid, sizeof(sid), SID_FORMAT, hn, ((uint64_t)(t)), ((uint16_t)(pid)) );
  add_val( "SESSION-ID", sid );
  return;
}
# else
#  define SID_FORMAT	"%05"PRIu16"%09"PRIu32"-%s-%020"PRIu64""
#  define MAX_SID_LEN  	(5+9+1+_POSIX_HOST_NAME_MAX+1+20+1)	/* SID_FORMAT ŸĹ */

/** ˡʥåIDݤ
 *@return	"SESSION-ID"		줿ID
 *
 *	Patched by G-HAL
 *		Wed,13 Oct,2010
 */
static void alloc_session_id( void )
{
  const time_t t = time( NULL );
  const pid_t pid = getpid();
  char hn[_POSIX_HOST_NAME_MAX +1];
  char sid[MAX_SID_LEN];
  const int ret = gethostname( hn, sizeof(hn) );
  if (0 != ret) {
    strlcpy( hn, "unknown.private.", sizeof(hn) );
  }
  hn[sizeof(hn)-1] = '\0';
  snprintf( sid, sizeof(sid), SID_FORMAT, ((uint16_t)(pid)), ((uint32_t)(UINT32_C(0x1FFFFFFF) & t)), hn, ((uint64_t)(t)) );
  add_val( "SESSION-ID", sid );
  return;
}
# endif
#endif

void
anthy_do_conf_init(void)
{

  if (!confIsInit) {
    const char *fn;
    struct passwd *pw;
    val_ent_ator = anthy_create_allocator(sizeof(struct val_ent), val_ent_dtor);
    /*ǥեȤͤꤹ롣*/
    add_val("VERSION", PACKAGE_VERSION);
    fn = anthy_conf_get_str("CONFFILE");
    if (!fn){
      add_val("CONFFILE", CONF_DIR"/anthy-conf");
    }
    pw = getpwuid(getuid());
    add_val("HOME", pw->pw_dir);
    alloc_session_id();
    read_conf_file();
    confIsInit = 1;
  }
}

void
anthy_conf_free(void)
{
  struct val_ent *e, *next;
  for (e = ent_list; e; e = next) {
    free((char *)e->var);
    free((char *)e->val);
    next = e->next;
    free(e);
  }
  ent_list = NULL;
  confIsInit = 0;
}

const char *
anthy_conf_get_str(const char *var)
{
  struct val_ent *e;
  e = find_val_ent(var);
  return e->val;
}
/* vim:ts=8 sw=2 nomodified:
 */
